/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.groovy.core.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.groovy.core.Activator;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.LocalVariable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectionUtils {
    private static final Object[] NO_ARGS = new Object[0];
    private static final Class<?>[] NO_TYPES = new Class[0];
    private static final Map<String, Field> FIELDS = new HashMap<String, Field>();

    public static <T> Constructor<T> getConstructor(Class<T> instanceType, Class<?> ... parameterTypes) {
        try {
            Constructor<T> ctor = instanceType.getDeclaredConstructor(parameterTypes);
            ctor.setAccessible(true);
            return ctor;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T invokeConstructor(Constructor<T> ctor, Object ... args) {
        try {
            return ctor.newInstance(args);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public static <T> T invokeConstructor(Class<T> instanceType, Class<?>[] parameterTypes, Object[] args) {
        try {
            return ReflectionUtils.invokeConstructor(ReflectionUtils.getConstructor(instanceType, parameterTypes), args);
        }
        catch (RuntimeException e) {
            ReflectionUtils.log("Error executing private constructor for '" + instanceType.getName() + "' on class " + instanceType, e);
            return null;
        }
    }

    public static Object getPrivateField(Class<?> clazz, String fieldName, Object target) {
        String key = String.valueOf(clazz.getCanonicalName()) + fieldName;
        Field field = FIELDS.get(key);
        try {
            if (field == null) {
                field = clazz.getDeclaredField(fieldName);
                field.setAccessible(true);
                FIELDS.put(key, field);
            }
            return field.get(target);
        }
        catch (Exception e) {
            ReflectionUtils.log("Error getting private field '" + fieldName + "' on class " + clazz, e);
            return null;
        }
    }

    public static void setPrivateField(Class<?> clazz, String fieldName, Object target, Object newValue) {
        String key = String.valueOf(clazz.getCanonicalName()) + fieldName;
        Field field = FIELDS.get(key);
        try {
            if (field == null) {
                field = clazz.getDeclaredField(fieldName);
                field.setAccessible(true);
                FIELDS.put(key, field);
            }
            field.set(target, newValue);
        }
        catch (Exception e) {
            ReflectionUtils.log("Error setting private field '" + fieldName + "' on class " + clazz, e);
        }
    }

    public static <T> Object executeNoArgPrivateMethod(Class<T> clazz, String methodName, Object target) {
        return ReflectionUtils.executePrivateMethod(clazz, methodName, NO_TYPES, target, NO_ARGS);
    }

    public static <T> Object executePrivateMethod(Class<T> clazz, String methodName, Class<?>[] types, Object target, Object[] args) {
        try {
            Method method = clazz.getDeclaredMethod(methodName, types);
            method.setAccessible(true);
            return method.invoke(target, args);
        }
        catch (Exception e) {
            ReflectionUtils.log("Error executing private method '" + methodName + "' on class " + clazz, e);
            return null;
        }
    }

    public static <T> Object throwableExecutePrivateMethod(Class<T> clazz, String methodName, Class<?>[] types, T target, Object[] args) throws Exception {
        Method method = clazz.getDeclaredMethod(methodName, types);
        method.setAccessible(true);
        return method.invoke(target, args);
    }

    public static <T> Object throwableGetPrivateField(Class<T> clazz, String fieldName, T target) throws Exception {
        String key = String.valueOf(clazz.getCanonicalName()) + fieldName;
        Field field = FIELDS.get(key);
        if (field == null) {
            field = clazz.getDeclaredField(fieldName);
            field.setAccessible(true);
            FIELDS.put(key, field);
        }
        return field.get(target);
    }

    public static LocalVariable createLocalVariable(IJavaElement parent, String varName, int start, String returnTypeSignature) {
        try {
            Constructor cons = LocalVariable.class.getConstructor(JavaElement.class, String.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, String.class, Annotation[].class);
            LocalVariable localVariable = (LocalVariable)cons.newInstance(parent, varName, start, start + varName.length() - 1, start, start + varName.length() - 1, returnTypeSignature, new Annotation[0]);
            return localVariable;
        }
        catch (Exception e) {
            try {
                Constructor cons = LocalVariable.class.getConstructor(JavaElement.class, String.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, String.class, Annotation[].class, Integer.TYPE, Boolean.TYPE);
                LocalVariable localVariable = (LocalVariable)cons.newInstance(parent, varName, start, start + varName.length() - 1, start, start + varName.length() - 1, returnTypeSignature, new Annotation[0], 0, false);
                return localVariable;
            }
            catch (Exception exception) {
                ReflectionUtils.log("Error creating local variable'" + varName + "' in element " + parent.getHandleIdentifier(), e);
                return null;
            }
        }
    }

    private static void log(String message, Throwable throwable) {
        Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.jdt.groovy.core", message, throwable));
    }
}

