/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.groovy.core.util;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassCodeVisitorSupport;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.GenericsType;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.control.SourceUnit;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.groovy.core.util.ReflectionUtils;
import org.eclipse.jdt.internal.core.util.Util;

public abstract class GroovyUtils {
    /*
     * Loose catch block
     */
    public static char[] readSourceRange(SourceUnit unit, int offset, int length) {
        Reader reader = null;
        reader = unit.getSource().getReader();
        reader.skip(offset);
        int n = length;
        char[] code = new char[n];
        while (n > 0) {
            n -= reader.read(code, length - n, n);
        }
        char[] cArray = code;
        try {
            if (reader != null) {
                reader.close();
            }
        }
        catch (IOException iOException) {}
        return cArray;
        catch (Exception e) {
            try {
                Util.log((Throwable)e);
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    public static int[] getSourceLineSeparatorsIn(char[] code) {
        ArrayList<Integer> lineSeparatorsCollection = new ArrayList<Integer>();
        int i = 0;
        int max = code.length;
        while (i < max) {
            if (code[i] == '\r') {
                if (i + 1 < max && code[i + 1] == '\n') {
                    lineSeparatorsCollection.add(i + 1);
                    ++i;
                } else {
                    lineSeparatorsCollection.add(i);
                }
            } else if (code[i] == '\n') {
                lineSeparatorsCollection.add(i);
            }
            ++i;
        }
        int[] lineSepPositions = new int[lineSeparatorsCollection.size()];
        int i2 = 0;
        while (i2 < lineSeparatorsCollection.size()) {
            lineSepPositions[i2] = (Integer)lineSeparatorsCollection.get(i2);
            ++i2;
        }
        return lineSepPositions;
    }

    public static ASTNode lastElement(AnnotationNode node) {
        AnnotationNode result = node;
        Iterable more = (Iterable)node.getNodeMetaData((Object)"AnnotationCollector");
        if (more != null) {
            Iterator<Object> iterator = more.iterator();
            while (iterator.hasNext()) {
                AnnotationNode an;
                result = an = (AnnotationNode)iterator.next();
            }
        }
        if (result.getMembers() != null) {
            for (Expression expr : result.getMembers().values()) {
                if ((expr = ClassCodeVisitorSupport.getNonInlinedExpression((Expression)expr)).getEnd() <= result.getEnd()) continue;
                result = expr;
            }
        }
        return result;
    }

    public static String[] splitName(ClassNode node) {
        String name = node.getName();
        int index = name.lastIndexOf(36);
        if (index == -1) {
            index = name.lastIndexOf(46);
        }
        return new String[]{name.substring(0, Math.max(0, index)), name.substring(index + 1)};
    }

    public static String getTypeSignature(ClassNode node, boolean qualified) {
        String name;
        StringBuilder builder = new StringBuilder();
        while (node.isArray()) {
            builder.append('[');
            node = node.getComponentType();
        }
        String string = name = qualified ? node.getName() : Signature.getSimpleName((String)node.getName());
        assert (!(name.startsWith("[") || name.contains("<") || name.endsWith(";")));
        builder.append(Signature.createTypeSignature((String)name, (boolean)false));
        if (node.isUsingGenerics() && node.getGenericsTypes() != null) {
            builder.setCharAt(builder.length() - 1, '<');
            GenericsType[] genericsTypeArray = node.getGenericsTypes();
            int n = genericsTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                GenericsType gen = genericsTypeArray[n2];
                if (gen.isPlaceholder()) {
                    builder.append(Signature.createTypeSignature((String)gen.getName(), (boolean)false));
                } else if (!gen.isWildcard()) {
                    builder.append(GroovyUtils.getTypeSignature(gen.getType(), qualified));
                } else if (gen.getLowerBound() != null) {
                    builder.append('-').append(GroovyUtils.getTypeSignature(gen.getLowerBound(), qualified));
                } else if (gen.getUpperBounds() != null && gen.getUpperBounds().length > 0) {
                    builder.append('+').append(GroovyUtils.getTypeSignature(gen.getUpperBounds()[0], qualified));
                } else {
                    builder.append('*');
                }
                ++n2;
            }
            builder.append(">;");
        }
        return builder.toString();
    }

    public static ClassNode getWrapperTypeIfPrimitive(ClassNode type) {
        if (ClassHelper.isPrimitiveType((ClassNode)type)) {
            return ClassHelper.getWrapper((ClassNode)type);
        }
        return type;
    }

    public static void updateClosureWithInferredTypes(ClassNode closure, ClassNode returnType, Parameter[] parameters) {
        if (!"groovy.lang.Closure".equals(closure.getName())) {
            return;
        }
        ClassNode redir = closure.redirect();
        closure.setRedirect(null);
        closure.setInterfaces(redir.getInterfaces());
        returnType = GroovyUtils.getWrapperTypeIfPrimitive(returnType);
        closure.setGenericsTypes(new GenericsType[]{new GenericsType(returnType)});
        ReflectionUtils.setPrivateField(ClassNode.class, "clazz", closure, redir.getTypeClass());
    }
}

