/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jdt.groovy.internal.compiler.ast;

import groovy.lang.GroovyRuntimeException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.groovy.GroovyBugError;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.Comment;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.GenericsType;
import org.codehaus.groovy.ast.ImportNode;
import org.codehaus.groovy.ast.ImportNodeCompatibilityWrapper;
import org.codehaus.groovy.ast.InnerClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.PackageNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.TaskEntry;
import org.codehaus.groovy.ast.expr.AnnotationConstantExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.control.ErrorCollector;
import org.codehaus.groovy.control.Janitor;
import org.codehaus.groovy.control.MultipleCompilationErrorsException;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.io.ReaderSource;
import org.codehaus.groovy.control.messages.ExceptionMessage;
import org.codehaus.groovy.control.messages.LocatedMessage;
import org.codehaus.groovy.control.messages.Message;
import org.codehaus.groovy.control.messages.SimpleMessage;
import org.codehaus.groovy.control.messages.SyntaxErrorMessage;
import org.codehaus.groovy.syntax.CSTNode;
import org.codehaus.groovy.syntax.PreciseSyntaxException;
import org.codehaus.groovy.syntax.RuntimeParserException;
import org.codehaus.groovy.syntax.SyntaxException;
import org.codehaus.groovy.syntax.Token;
import org.codehaus.groovy.tools.GroovyClass;
import org.codehaus.jdt.groovy.control.EclipseSourceUnit;
import org.codehaus.jdt.groovy.core.dom.GroovyCompilationUnit;
import org.codehaus.jdt.groovy.internal.compiler.ast.AliasImportReference;
import org.codehaus.jdt.groovy.internal.compiler.ast.GroovyClassFile;
import org.codehaus.jdt.groovy.internal.compiler.ast.GroovyCompilationUnitScope;
import org.codehaus.jdt.groovy.internal.compiler.ast.GroovyEclipseBug;
import org.codehaus.jdt.groovy.internal.compiler.ast.GroovyParser;
import org.codehaus.jdt.groovy.internal.compiler.ast.GroovyTypeDeclaration;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.groovy.core.util.GroovyUtils;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.AnnotationMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.ArrayInitializer;
import org.eclipse.jdt.internal.compiler.ast.ArrayQualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.ArrayTypeReference;
import org.eclipse.jdt.internal.compiler.ast.CharLiteral;
import org.eclipse.jdt.internal.compiler.ast.ClassLiteralAccess;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ConstructorDeclaration;
import org.eclipse.jdt.internal.compiler.ast.DoubleLiteral;
import org.eclipse.jdt.internal.compiler.ast.FalseLiteral;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.FloatLiteral;
import org.eclipse.jdt.internal.compiler.ast.ImportReference;
import org.eclipse.jdt.internal.compiler.ast.IntLiteral;
import org.eclipse.jdt.internal.compiler.ast.Javadoc;
import org.eclipse.jdt.internal.compiler.ast.Literal;
import org.eclipse.jdt.internal.compiler.ast.LongLiteral;
import org.eclipse.jdt.internal.compiler.ast.MarkerAnnotation;
import org.eclipse.jdt.internal.compiler.ast.MemberValuePair;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.NormalAnnotation;
import org.eclipse.jdt.internal.compiler.ast.NullLiteral;
import org.eclipse.jdt.internal.compiler.ast.ParameterizedQualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.ParameterizedSingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.QualifiedAllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.QualifiedNameReference;
import org.eclipse.jdt.internal.compiler.ast.QualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.SingleMemberAnnotation;
import org.eclipse.jdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.jdt.internal.compiler.ast.SingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.StringLiteral;
import org.eclipse.jdt.internal.compiler.ast.TrueLiteral;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeParameter;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.ast.Wildcard;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.impl.ReferenceContext;
import org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilation;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.jdt.internal.core.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroovyCompilationUnitDeclaration
extends CompilationUnitDeclaration {
    private org.codehaus.groovy.control.CompilationUnit groovyCompilationUnit;
    private SourceUnit groovySourceUnit;
    private CompilerOptions compilerOptions;
    public static boolean defaultCheckGenerics = false;
    public static boolean earlyTransforms = true;
    private boolean isScript = false;
    private TraitHelper traitHelper = new TraitHelper();
    private static final boolean DEBUG_TASK_TAGS = false;
    private static final boolean DEBUG = false;

    static {
        try {
            String value = System.getProperty("\tearlyTransforms");
            if (value != null) {
                if (value.equalsIgnoreCase("true")) {
                    GroovyCompilationUnitDeclaration.log("groovyeclipse.earlyTransforms = true");
                    earlyTransforms = true;
                } else if (value.equalsIgnoreCase("false")) {
                    GroovyCompilationUnitDeclaration.log("groovyeclipse.earlyTransforms = false");
                    earlyTransforms = false;
                }
            }
        }
        catch (Throwable throwable) {}
    }

    public GroovyCompilationUnitDeclaration(ProblemReporter problemReporter, CompilationResult compilationResult, int sourceLength, org.codehaus.groovy.control.CompilationUnit groovyCompilationUnit, SourceUnit groovySourceUnit, CompilerOptions compilerOptions) {
        super(problemReporter, compilationResult, sourceLength);
        this.groovyCompilationUnit = groovyCompilationUnit;
        this.groovySourceUnit = groovySourceUnit;
        this.compilerOptions = compilerOptions;
    }

    public boolean processToPhase(int phase) {
        block15: {
            if (phase == 5) {
                block6: for (ModuleNode module : this.groovyCompilationUnit.getAST().getModules()) {
                    for (ClassNode classNode : module.getClasses()) {
                        if (!this.traitHelper.isTrait(classNode)) continue;
                        GroovyParser.tidyCache();
                        continue block6;
                    }
                }
            }
            boolean alreadyHasProblems = this.compilationResult.hasProblems();
            try {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                try {
                    Thread.currentThread().setContextClassLoader((ClassLoader)this.groovyCompilationUnit.getTransformLoader());
                    this.groovyCompilationUnit.compile(phase);
                }
                finally {
                    Thread.currentThread().setContextClassLoader(cl);
                }
                if (this.groovySourceUnit.getErrorCollector().hasErrors()) {
                    this.recordProblems(this.groovySourceUnit.getErrorCollector().getErrors());
                    return false;
                }
                return true;
            }
            catch (MultipleCompilationErrorsException problems) {
                this.fixGroovyRuntimeException(problems);
                AbortCompilation abort = this.getAbortCompilation(problems);
                if (abort != null) {
                    throw abort;
                }
                problems.printStackTrace();
                this.recordProblems(problems.getErrorCollector().getErrors());
            }
            catch (GroovyBugError gbr) {
                if (alreadyHasProblems) {
                    System.err.println("Ignoring GroovyBugError since it is likely caused by earlier issues.  Ignored problem is '" + gbr.getMessage() + "'");
                }
                boolean reportit = true;
                if (gbr.getCause() instanceof AbortCompilation) {
                    AbortCompilation abort = (AbortCompilation)gbr.getCause();
                    if (abort.isSilent) {
                        reportit = false;
                    }
                }
                if (!reportit) break block15;
                System.err.println("Internal Groovy Error --- " + gbr.getBugText());
                gbr.printStackTrace();
                Util.log((Throwable)gbr, (String)"Internal groovy compiler error.");
                this.groovySourceUnit.getErrorCollector().addError((Message)new SyntaxErrorMessage(new SyntaxException("Internal groovy compiler error.\n" + gbr.getBugText(), (Throwable)gbr, 1, 0), this.groovySourceUnit));
                this.recordProblems(this.groovySourceUnit.getErrorCollector().getErrors());
            }
        }
        return false;
    }

    private void fixGroovyRuntimeException(MultipleCompilationErrorsException problems) {
        List errors = problems.getErrorCollector().getErrors();
        ArrayList<ExceptionMessage> toBeFixed = new ArrayList<ExceptionMessage>();
        for (Object o : errors) {
            GroovyRuntimeException gre;
            ExceptionMessage em;
            if (!(o instanceof ExceptionMessage) || !((em = (ExceptionMessage)o).getCause() instanceof GroovyRuntimeException) || !((gre = (GroovyRuntimeException)em.getCause()).getCause() instanceof SyntaxException)) continue;
            toBeFixed.add(em);
        }
        for (ExceptionMessage e : toBeFixed) {
            errors.remove(e);
            SyntaxException se = (SyntaxException)e.getCause().getCause();
            problems.getErrorCollector().addError(se, this.groovySourceUnit);
        }
    }

    private AbortCompilation getAbortCompilation(MultipleCompilationErrorsException problems) {
        ErrorCollector collector = problems.getErrorCollector();
        if (collector.getErrorCount() == 1 && problems.getErrorCollector().getError(0) instanceof ExceptionMessage) {
            Exception abort = ((ExceptionMessage)problems.getErrorCollector().getError(0)).getCause();
            return abort instanceof AbortCompilation ? (AbortCompilation)abort : null;
        }
        return null;
    }

    public org.codehaus.groovy.control.CompilationUnit getCompilationUnit() {
        return this.groovyCompilationUnit;
    }

    public void populateCompilationUnitDeclaration() {
        UnitPopulator populator = new UnitPopulator();
        populator.populate(this, this.groovySourceUnit);
    }

    public void generateCode() {
        block9: {
            block8: {
                boolean successful = this.processToPhase(9);
                if (!successful) break block8;
                List classes = this.groovyCompilationUnit.getClasses();
                for (GroovyClass clazz : classes) {
                    GroovyCompilationUnitScope gcuScope;
                    ClassNode classnode = clazz.getClassNode();
                    if (clazz.getSourceUnit() != this.groovySourceUnit) continue;
                    String classname = clazz.getName();
                    SourceTypeBinding binding = null;
                    if (this.types != null && this.types.length != 0) {
                        binding = GroovyCompilationUnitDeclaration.findBinding(this.types, clazz.getClassNode());
                    }
                    if (binding == null) {
                        ClassNode current = classnode;
                        while (current instanceof InnerClassNode && binding == null) {
                            current = ((InnerClassNode)current).getOuterClass();
                            binding = GroovyCompilationUnitDeclaration.findBinding(this.types, current);
                        }
                    }
                    boolean isScript = false;
                    if (binding != null && binding.scope != null && binding.scope.parent instanceof GroovyCompilationUnitScope && (gcuScope = (GroovyCompilationUnitScope)binding.scope.parent).isScript()) {
                        isScript = true;
                    }
                    if (isScript) continue;
                    byte[] classbytes = clazz.getBytes();
                    String path = clazz.getName().replace('.', '/');
                    GroovyClassFile classFile = new GroovyClassFile(classname, classbytes, binding, path);
                    char[] classNameChars = classname.toCharArray();
                    if (binding == null) {
                        Map compiledTypes = (Map)Map.class.cast(this.compilationResult.compiledTypes);
                        compiledTypes.put(classNameChars, classFile);
                        continue;
                    }
                    this.compilationResult.record(classNameChars, (ClassFile)classFile);
                }
                break block9;
            }
            if (this.types == null) break block9;
            TypeDeclaration[] typeDeclarationArray = this.types;
            int n = this.types.length;
            int n2 = 0;
            while (n2 < n) {
                TypeDeclaration type = typeDeclarationArray[n2];
                if (type.binding != null) {
                    ClassFile.createProblemType((TypeDeclaration)type, (CompilationResult)this.compilationResult);
                }
                ++n2;
            }
        }
    }

    private static void log(String message) {
        System.out.println(message);
    }

    private static SourceTypeBinding findBinding(TypeDeclaration[] typedeclarations, ClassNode cnode) {
        TypeDeclaration[] typeDeclarationArray = typedeclarations;
        int n = typedeclarations.length;
        int n2 = 0;
        while (n2 < n) {
            SourceTypeBinding binding;
            TypeDeclaration typedeclaration = typeDeclarationArray[n2];
            GroovyTypeDeclaration groovyTypeDeclaration = (GroovyTypeDeclaration)typedeclaration;
            if (groovyTypeDeclaration.getClassNode().equals((Object)cnode)) {
                return groovyTypeDeclaration.binding;
            }
            if (typedeclaration.memberTypes != null && (binding = GroovyCompilationUnitDeclaration.findBinding(typedeclaration.memberTypes, cnode)) != null) {
                return binding;
            }
            ++n2;
        }
        return null;
    }

    private void recordProblems(List<?> errors) {
        ArrayList<Message> errorsRecorded = new ArrayList<Message>();
        Iterator<?> iterator = errors.iterator();
        while (iterator.hasNext()) {
            CSTNode context;
            SyntaxException syntaxException = null;
            Message message = (Message)iterator.next();
            StringWriter sw = new StringWriter();
            message.write(new PrintWriter(sw));
            String msg = sw.toString();
            CategorizedProblem p = null;
            int line = 0;
            int sev = 0;
            int scol = 0;
            int ecol = 0;
            if (message instanceof LocatedMessage && (context = ((LocatedMessage)message).getContext()) instanceof Token) {
                line = context.getStartLine();
                scol = context.getStartColumn();
                String text = ((Token)context).getText();
                ecol = scol + (text == null ? 1 : text.length() - 1);
            }
            if (message instanceof SimpleMessage) {
                SimpleMessage simpleMessage = (SimpleMessage)message;
                sev |= 1;
                String simpleText = simpleMessage.getMessage();
                if (simpleText.length() > 1 && simpleText.charAt(0) == '\n') {
                    simpleText = simpleText.substring(1);
                }
                if ((msg = "Groovy:" + simpleText).indexOf("\n") != -1) {
                    msg = msg.substring(0, msg.indexOf("\n"));
                }
            }
            if (message instanceof SyntaxErrorMessage) {
                SyntaxErrorMessage errorMessage = (SyntaxErrorMessage)message;
                syntaxException = errorMessage.getCause();
                sev |= 1;
                String actualMessage = syntaxException.getMessage();
                if (actualMessage.length() > 1 && actualMessage.charAt(0) == '\n') {
                    actualMessage = actualMessage.substring(1);
                }
                if ((msg = "Groovy:" + actualMessage).indexOf("\n") != -1) {
                    msg = msg.substring(0, msg.indexOf("\n"));
                }
                line = syntaxException.getLine();
                scol = errorMessage.getCause().getStartColumn();
                ecol = errorMessage.getCause().getEndColumn() - 1;
            }
            int soffset = -1;
            int eoffset = -1;
            if (message instanceof ExceptionMessage) {
                ExceptionMessage em = (ExceptionMessage)message;
                sev |= 1;
                if (em.getCause() instanceof RuntimeParserException) {
                    ModuleNode thisModuleNode;
                    ModuleNode errorModuleNode;
                    RuntimeParserException rpe = (RuntimeParserException)em.getCause();
                    sev |= 1;
                    msg = "Groovy:" + rpe.getMessage();
                    if (msg.indexOf("\n") != -1) {
                        msg = msg.substring(0, msg.indexOf("\n"));
                    }
                    if (!(errorModuleNode = rpe.getModule()).equals(thisModuleNode = this.getModuleNode())) continue;
                    soffset = rpe.getNode().getStart();
                    eoffset = rpe.getNode().getEnd() - 1;
                    line = 0;
                    while (this.compilationResult.lineSeparatorPositions[line] < soffset && line < this.compilationResult.lineSeparatorPositions.length) {
                        ++line;
                    }
                    ++line;
                }
            }
            if (syntaxException instanceof PreciseSyntaxException) {
                soffset = ((PreciseSyntaxException)syntaxException).getStartOffset();
                eoffset = ((PreciseSyntaxException)syntaxException).getEndOffset();
                line = 0;
                while (line < this.compilationResult.lineSeparatorPositions.length && this.compilationResult.lineSeparatorPositions[line] < soffset) {
                    ++line;
                }
                ++line;
            } else {
                if (soffset == -1) {
                    soffset = this.getOffset(this.compilationResult.lineSeparatorPositions, line, scol);
                }
                if (eoffset == -1) {
                    eoffset = this.getOffset(this.compilationResult.lineSeparatorPositions, line, ecol);
                }
            }
            if (soffset > eoffset) {
                eoffset = soffset;
            }
            if (soffset > this.sourceEnd) {
                soffset = this.sourceEnd;
                eoffset = this.sourceEnd;
            }
            char[] filename = this.getFileName();
            p = new DefaultProblemFactory().createProblem(filename, 0, new String[]{msg}, 0, new String[]{msg}, sev, soffset, eoffset, line, scol);
            this.problemReporter.record(p, this.compilationResult, (ReferenceContext)this, false);
            errorsRecorded.add(message);
            GroovyCompilationUnitDeclaration.log(String.valueOf(String.valueOf(this.compilationResult.getFileName())) + ": " + line + " " + msg);
        }
        errors.removeAll(errorsRecorded);
    }

    private int getOffset(int[] lineSeparatorPositions, int line, int col) {
        if (lineSeparatorPositions.length > line - 2 && line > 1) {
            return lineSeparatorPositions[line - 2] + col;
        }
        return col;
    }

    public CompilationUnitScope buildCompilationUnitScope(LookupEnvironment lookupEnvironment) {
        GroovyCompilationUnitScope gcus = new GroovyCompilationUnitScope(this, lookupEnvironment);
        gcus.setIsScript(this.isScript);
        return gcus;
    }

    public ModuleNode getModuleNode() {
        return this.groovySourceUnit == null ? null : this.groovySourceUnit.getAST();
    }

    public SourceUnit getSourceUnit() {
        return this.groovySourceUnit;
    }

    public CompilationUnit getSpecialDomCompilationUnit(AST ast) {
        return new GroovyCompilationUnit(ast);
    }

    public String print() {
        return this.toString();
    }

    public GroovyCompilationUnitScope getScope() {
        return (GroovyCompilationUnitScope)this.scope;
    }

    public void resolve() {
        this.processToPhase(4);
        this.checkForTags();
        this.setComments();
    }

    private void checkForTags() {
        if (this.compilerOptions == null) {
            return;
        }
        List comments = this.groovySourceUnit.getComments();
        if (comments == null) {
            return;
        }
        char[][] taskTags = this.compilerOptions.taskTags;
        char[][] taskPriorities = this.compilerOptions.taskPriorities;
        boolean caseSensitiveTags = this.compilerOptions.isTaskCaseSensitive;
        try {
            if (taskTags != null) {
                for (Comment comment : comments) {
                    ArrayList allTasksInComment = new ArrayList();
                    int t = 0;
                    while (t < taskTags.length) {
                        String taskTag = new String(taskTags[t]);
                        String taskPriority = null;
                        if (taskPriorities != null) {
                            taskPriority = new String(taskPriorities[t]);
                        }
                        allTasksInComment.addAll(comment.getPositionsOf(taskTag, taskPriority, this.compilationResult.lineSeparatorPositions, caseSensitiveTags));
                        ++t;
                    }
                    if (allTasksInComment.isEmpty()) continue;
                    int t1 = 0;
                    while (t1 < allTasksInComment.size()) {
                        int t2 = 0;
                        while (t2 < allTasksInComment.size()) {
                            if (t1 != t2) {
                                TaskEntry taskOne = (TaskEntry)allTasksInComment.get(t1);
                                TaskEntry taskTwo = (TaskEntry)allTasksInComment.get(t2);
                                if (taskOne.start + taskOne.taskTag.length() + 1 == taskTwo.start) {
                                    taskOne.isAdjacentTo = taskTwo;
                                } else if (taskOne.getEnd() > taskTwo.start && taskOne.start < taskTwo.start) {
                                    taskOne.setEnd(taskTwo.start - 1);
                                } else if (taskTwo.getEnd() > taskOne.start && taskTwo.start < taskOne.start) {
                                    taskTwo.setEnd(taskOne.start - 1);
                                }
                            }
                            ++t2;
                        }
                        ++t1;
                    }
                    for (TaskEntry taskEntry : allTasksInComment) {
                        this.problemReporter.referenceContext = this;
                        this.problemReporter.task(taskEntry.taskTag, taskEntry.getText(), taskEntry.taskPriority, taskEntry.start, taskEntry.getEnd());
                    }
                }
            }
        }
        catch (AbortCompilation abortCompilation) {
        }
        catch (Throwable t) {
            Util.log((Throwable)t, (String)("Unexpected problem processing task tags in " + this.groovySourceUnit.getName()));
            new RuntimeException("Unexpected problem processing task tags in " + this.groovySourceUnit.getName(), t).printStackTrace();
        }
    }

    private void setComments() {
        List groovyComments = this.groovySourceUnit.getComments();
        if (groovyComments == null || groovyComments.size() == 0) {
            return;
        }
        this.comments = new int[groovyComments.size()][2];
        int c = 0;
        int max = groovyComments.size();
        while (c < max) {
            Comment groovyComment = (Comment)groovyComments.get(c);
            this.comments[c] = groovyComment.getPositions(this.compilationResult.lineSeparatorPositions);
            ++c;
        }
    }

    public void analyseCode() {
        this.processToPhase(5);
    }

    public void cleanUp() {
        super.cleanUp();
        if (this.groovySourceUnit instanceof EclipseSourceUnit) {
            ((EclipseSourceUnit)this.groovySourceUnit).resolver.cleanUp();
        }
    }

    public void tagAsScript() {
        this.isScript = true;
    }

    public static class FieldDeclarationWithInitializer
    extends FieldDeclaration {
        private Expression initializer;

        public FieldDeclarationWithInitializer(char[] name, int sourceStart, int sourceEnd) {
            super(name, sourceStart, sourceEnd);
        }

        public Expression getGroovyInitializer() {
            return this.initializer;
        }
    }

    private class TraitHelper {
        private boolean toBeInitialized = true;
        private boolean lookForTraitAlias = false;

        private TraitHelper() {
        }

        private void initialize() {
            if (GroovyCompilationUnitDeclaration.this.imports != null) {
                ImportReference[] importReferenceArray = GroovyCompilationUnitDeclaration.this.imports;
                int n = GroovyCompilationUnitDeclaration.this.imports.length;
                int n2 = 0;
                while (n2 < n) {
                    ImportReference i = importReferenceArray[n2];
                    String importedType = i.toString();
                    if ("groovy.transform.Trait".equals(importedType)) {
                        this.lookForTraitAlias = true;
                        break;
                    }
                    if (importedType.endsWith(".Trait")) {
                        this.lookForTraitAlias = false;
                        break;
                    }
                    if ("groovy.transform.*".equals(importedType)) {
                        this.lookForTraitAlias = true;
                    }
                    ++n2;
                }
                this.toBeInitialized = true;
            }
        }

        private boolean isTrait(ClassNode classNode) {
            List annotations;
            if (classNode == null) {
                return false;
            }
            if (this.toBeInitialized) {
                this.initialize();
            }
            if ((annotations = classNode.getAnnotations()).size() > 0) {
                for (AnnotationNode annotation : annotations) {
                    if ("groovy.transform.Trait".equals(annotation.getClassNode().getName())) {
                        return true;
                    }
                    if (!this.lookForTraitAlias || !"Trait".equals(annotation.getClassNode().getName())) continue;
                    return true;
                }
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class UnitPopulator {
        private Janitor janitor;
        private SourceUnit sourceUnit;
        private GroovyCompilationUnitDeclaration unitDeclaration;
        private boolean hasAnonInners;
        private boolean checkGenerics = defaultCheckGenerics;
        private Map<MethodNode, AbstractMethodDeclaration> enclosingMethodMap;
        private static final Pattern AND = Pattern.compile("^\\s*&\\s*");
        private static final Pattern EXTENDS = Pattern.compile("^\\s*extends\\s+");
        private static final Map<Character, Integer> charToTypeId = new HashMap<Character, Integer>();
        private static final Map<String, Integer> nameToPrimitiveTypeId = new HashMap<String, Integer>();
        private static long NON_EXISTENT_POSITION;

        static {
            charToTypeId.put(Character.valueOf('D'), 8);
            charToTypeId.put(Character.valueOf('I'), 10);
            charToTypeId.put(Character.valueOf('F'), 9);
            charToTypeId.put(Character.valueOf('J'), 7);
            charToTypeId.put(Character.valueOf('Z'), 5);
            charToTypeId.put(Character.valueOf('B'), 3);
            charToTypeId.put(Character.valueOf('C'), 2);
            charToTypeId.put(Character.valueOf('S'), 4);
            nameToPrimitiveTypeId.put("double", 8);
            nameToPrimitiveTypeId.put("int", 10);
            nameToPrimitiveTypeId.put("float", 9);
            nameToPrimitiveTypeId.put("long", 7);
            nameToPrimitiveTypeId.put("boolean", 5);
            nameToPrimitiveTypeId.put("byte", 3);
            nameToPrimitiveTypeId.put("char", 2);
            nameToPrimitiveTypeId.put("short", 4);
            nameToPrimitiveTypeId.put("void", 6);
            NON_EXISTENT_POSITION = -2L;
        }

        void populate(GroovyCompilationUnitDeclaration target, SourceUnit source) {
            this.unitDeclaration = target;
            this.sourceUnit = source;
            ModuleNode moduleNode = this.sourceUnit.getAST();
            try {
                this.createPackageDeclaration(moduleNode);
                this.createImportDeclarations(moduleNode);
                this.createTypeDeclarations(moduleNode);
            }
            finally {
                if (this.janitor != null) {
                    this.janitor.cleanup();
                    this.janitor = null;
                }
            }
        }

        private void createPackageDeclaration(ModuleNode moduleNode) {
            if (moduleNode.hasPackageName()) {
                String packageName = moduleNode.getPackageName();
                if (packageName.endsWith(".")) {
                    packageName = packageName.substring(0, packageName.length() - 1);
                }
                PackageNode packageNode = moduleNode.getPackage();
                char[][] splits = CharOperation.splitOn((char)'.', (char[])packageName.toCharArray());
                long[] positions = this.positionsFor(splits, this.startOffset((ASTNode)packageNode), this.endOffset((ASTNode)packageNode));
                ImportReference ref = new ImportReference(splits, positions, true, 0);
                ref.declarationEnd = ref.sourceEnd + this.trailerLength((ASTNode)packageNode);
                ref.declarationSourceStart = ref.sourceStart - 8;
                ref.declarationSourceEnd = ref.sourceEnd;
                this.unitDeclaration.currentPackage = ref;
            }
        }

        private void createImportDeclarations(ModuleNode moduleNode) {
            List importNodes = moduleNode.getImports();
            List importPackages = ImportNodeCompatibilityWrapper.getStarImports((ModuleNode)moduleNode);
            Map importStatics = ImportNodeCompatibilityWrapper.getStaticImports((ModuleNode)moduleNode);
            Map importStaticStars = ImportNodeCompatibilityWrapper.getStaticStarImports((ModuleNode)moduleNode);
            int importCount = importNodes.size() + importPackages.size() + importStatics.size() + importStaticStars.size();
            if (importCount > 0) {
                ArrayList<ImportReference> importReferences = new ArrayList<ImportReference>(importCount);
                for (ImportNode importNode : importNodes) {
                    ImportReference ref;
                    long[] positions;
                    int typeEndOffset;
                    int typeStartOffset = importNode.getTypeStart();
                    int endOffset = typeEndOffset = importNode.getTypeEnd();
                    if (typeStartOffset == 0) continue;
                    char[][] splits = CharOperation.splitOn((char)'.', (char[])importNode.getClassName().toCharArray());
                    if (importNode.getAlias() == null || importNode.getAlias().length() < 1) {
                        positions = this.positionsFor(splits, typeStartOffset, typeEndOffset);
                        ref = new ImportReference(splits, positions, false, 0);
                    } else {
                        endOffset = this.endOffset((ASTNode)importNode);
                        positions = this.positionsFor(splits, typeStartOffset, endOffset);
                        ref = new AliasImportReference(importNode.getAlias().toCharArray(), splits, positions, false, 0);
                    }
                    ref.sourceEnd = Math.max(endOffset - 1, ref.sourceStart);
                    if (ref.sourceEnd < 0) {
                        ref.declarationSourceStart = -1;
                        ref.declarationSourceEnd = -2;
                        ref.declarationEnd = -2;
                        ref.sourceEnd = -2;
                    } else {
                        ref.declarationEnd = ref.sourceEnd + this.trailerLength((ASTNode)importNode);
                        ref.declarationSourceStart = this.startOffset((ASTNode)importNode);
                        ref.declarationSourceEnd = ref.sourceEnd;
                    }
                    importReferences.add(ref);
                }
                for (ImportNode importNode : importPackages) {
                    String importText = importNode.getText();
                    int packageStartOffset = importNode.getStart() + "import ".length();
                    int packageEndOffset = packageStartOffset + importText.length() - "import ".length() - ".*".length();
                    int endOffset = this.endOffset((ASTNode)importNode);
                    char[][] splits = CharOperation.splitOn((char)'.', (char[])importNode.getPackageName().substring(0, importNode.getPackageName().length() - 1).toCharArray());
                    ImportReference ref = new ImportReference(splits, this.positionsFor(splits, packageStartOffset, packageEndOffset), true, 0);
                    ref.sourceEnd = Math.max(endOffset - 1, ref.sourceStart);
                    ref.declarationEnd = ref.sourceEnd + this.trailerLength((ASTNode)importNode);
                    ref.declarationSourceStart = importNode.getStart();
                    ref.declarationSourceEnd = ref.sourceEnd;
                    importReferences.add(ref);
                }
                for (Map.Entry entry : importStatics.entrySet()) {
                    long[] positions;
                    int typeEndOffset;
                    ImportNode importNode = (ImportNode)entry.getValue();
                    String importName = String.valueOf(importNode.getClassName()) + "." + (String)entry.getKey();
                    char[][] splits = CharOperation.splitOn((char)'.', (char[])importName.toCharArray());
                    int typeStartOffset = importNode.getTypeStart();
                    int endOffset = typeEndOffset = importNode.getTypeEnd();
                    ImportReference ref = null;
                    if (importNode.getAlias() == null || importNode.getAlias().length() < 1) {
                        positions = this.positionsFor(splits, typeStartOffset, typeEndOffset);
                        ref = new ImportReference(splits, positions, false, 8);
                    } else {
                        endOffset = this.endOffset((ASTNode)importNode);
                        positions = this.positionsFor(splits, typeStartOffset, endOffset);
                        ref = new AliasImportReference(importNode.getAlias().toCharArray(), splits, positions, false, 8);
                    }
                    ref.sourceEnd = Math.max(endOffset - 1, ref.sourceStart);
                    ref.declarationEnd = ref.sourceEnd + this.trailerLength((ASTNode)importNode);
                    ref.declarationSourceStart = this.startOffset((ASTNode)importNode);
                    ref.declarationSourceEnd = ref.sourceEnd;
                    importReferences.add(ref);
                }
                for (Map.Entry entry : importStaticStars.entrySet()) {
                    String classname = (String)entry.getKey();
                    ImportNode importNode = (ImportNode)entry.getValue();
                    int typeStartOffset = Math.max(0, importNode.getTypeStart());
                    int typeEndOffset = Math.max(0, importNode.getTypeEnd());
                    int endOffset = this.endOffset((ASTNode)importNode);
                    char[][] splits = CharOperation.splitOn((char)'.', (char[])classname.toCharArray());
                    long[] positions = this.positionsFor(splits, typeStartOffset, typeEndOffset);
                    ImportReference ref = new ImportReference(splits, positions, true, 8);
                    ref.sourceEnd = Math.max(endOffset - 1, ref.sourceStart);
                    ref.declarationEnd = ref.sourceEnd + this.trailerLength((ASTNode)importNode);
                    ref.declarationSourceStart = importNode.getStart();
                    ref.declarationSourceEnd = ref.sourceEnd;
                    importReferences.add(ref);
                }
                if (!importReferences.isEmpty()) {
                    ImportReference[] importReferenceArray = importReferences.toArray(new ImportReference[importReferences.size()]);
                    Arrays.sort(importReferenceArray, new Comparator<ImportReference>(){

                        @Override
                        public int compare(ImportReference left, ImportReference right) {
                            return left.sourceStart - right.sourceStart;
                        }
                    });
                    ImportReference[] importReferenceArray2 = importReferenceArray;
                    int n = importReferenceArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ImportReference ref = importReferenceArray2[n2];
                        if (ref.declarationSourceStart > 0 && ref.declarationEnd - ref.declarationSourceStart + 1 < 0) {
                            throw new IllegalStateException("Import reference alongside class " + moduleNode.getClasses().get(0) + " will trigger later failure: " + ref.toString() + " declSourceStart=" + ref.declarationSourceStart + " declEnd=" + ref.declarationEnd);
                        }
                        ++n2;
                    }
                    this.unitDeclaration.imports = importReferenceArray;
                }
            }
        }

        private void createTypeDeclarations(ModuleNode moduleNode) {
            ClassNode outerClass;
            List moduleClassNodes = moduleNode.getClasses();
            this.hasAnonInners = false;
            for (ClassNode classNode : moduleClassNodes) {
                if (!this.isAnon(classNode)) continue;
                this.hasAnonInners = true;
                this.enclosingMethodMap = new HashMap<MethodNode, AbstractMethodDeclaration>();
                break;
            }
            ArrayList<GroovyTypeDeclaration> typeDeclarations = new ArrayList<GroovyTypeDeclaration>();
            HashMap<ClassNode, GroovyTypeDeclaration> fromClassNodeToDecl = new HashMap<ClassNode, GroovyTypeDeclaration>();
            CompilationResult compilationResult = this.unitDeclaration.compilationResult;
            char[] mainName = this.toMainName(compilationResult.getFileName());
            boolean isInner = false;
            List classNodes = null;
            classNodes = moduleClassNodes;
            HashMap<ClassNode, ArrayList<GroovyTypeDeclaration>> innersToRecord = new HashMap<ClassNode, ArrayList<GroovyTypeDeclaration>>();
            for (ClassNode classNode : classNodes) {
                if (!classNode.isPrimaryClassNode()) continue;
                GroovyTypeDeclaration typeDeclaration = new GroovyTypeDeclaration(compilationResult, classNode);
                typeDeclaration.annotations = this.createAnnotations(classNode.getAnnotations());
                if (classNode instanceof InnerClassNode) {
                    isInner = true;
                } else {
                    typeDeclaration.name = classNode.getNameWithoutPackage().toCharArray();
                    if (!CharOperation.equals((char[])typeDeclaration.name, (char[])mainName)) {
                        typeDeclaration.bits |= 0x1000;
                    }
                    isInner = false;
                }
                boolean isInterface = classNode.isInterface();
                boolean isEnum = (classNode.getModifiers() & 0x4000) != 0;
                int mods = classNode.getModifiers();
                if (this.isTrait(classNode)) {
                    mods |= 0x200;
                }
                if ((mods & 0x4000) != 0) {
                    mods &= 0xFFFFFFEF;
                }
                if (!isInner && ((mods &= 0xFFFFFFF9) & 8) != 0) {
                    mods &= 0xFFFFFFF7;
                }
                typeDeclaration.modifiers = mods & ~(isInterface || isEnum ? 1024 : 0);
                this.fixupSourceLocationsForTypeDeclaration(typeDeclaration, classNode);
                GenericsType[] generics = classNode.getGenericsTypes();
                if (generics != null && generics.length > 0) {
                    typeDeclaration.typeParameters = this.createTypeParametersForGenerics(classNode.getGenericsTypes());
                }
                this.configureSuperClass(typeDeclaration, classNode.getSuperClass(), isEnum, this.isTrait(classNode));
                this.configureSuperInterfaces(typeDeclaration, classNode);
                typeDeclaration.methods = this.createMethodAndConstructorDeclarations(classNode, isEnum, typeDeclaration, compilationResult);
                typeDeclaration.fields = this.createFieldDeclarations(classNode, isEnum);
                typeDeclaration.properties = classNode.getProperties();
                if (classNode instanceof InnerClassNode) {
                    InnerClassNode innerClassNode = (InnerClassNode)classNode;
                    outerClass = innerClassNode.getOuterClass();
                    String outername = outerClass.getNameWithoutPackage();
                    String newInner = innerClassNode.getNameWithoutPackage().substring(outername.length() + 1);
                    typeDeclaration.name = newInner.toCharArray();
                    ArrayList<GroovyTypeDeclaration> inners = (ArrayList<GroovyTypeDeclaration>)innersToRecord.get(outerClass);
                    if (inners == null) {
                        inners = new ArrayList<GroovyTypeDeclaration>();
                        innersToRecord.put(outerClass, inners);
                    }
                    inners.add(typeDeclaration);
                    if (this.isAnon(classNode)) {
                        typeDeclaration.bits |= 0x300;
                        typeDeclaration.allocation = new QualifiedAllocationExpression((TypeDeclaration)typeDeclaration);
                        typeDeclaration.allocation.type = typeDeclaration.superclass;
                        typeDeclaration.allocation.enclosingInstance = new NullLiteral(typeDeclaration.sourceStart, typeDeclaration.sourceEnd);
                        typeDeclaration.allocation.sourceStart = typeDeclaration.sourceStart;
                        typeDeclaration.allocation.sourceEnd = typeDeclaration.bodyEnd;
                        typeDeclaration.name = CharOperation.NO_CHAR;
                    }
                } else {
                    typeDeclarations.add(typeDeclaration);
                }
                fromClassNodeToDecl.put(classNode, typeDeclaration);
            }
            for (Map.Entry entry : innersToRecord.entrySet()) {
                ClassNode outer = (ClassNode)entry.getKey();
                TypeDeclaration outerTypeDeclaration = (TypeDeclaration)fromClassNodeToDecl.get(outer);
                if (outerTypeDeclaration == null) {
                    throw new GroovyEclipseBug("Failed to find the type declaration for " + outer.getText());
                }
                List newInnersList = (List)entry.getValue();
                Iterator iterator = newInnersList.iterator();
                while (iterator.hasNext()) {
                    GroovyTypeDeclaration inner = (GroovyTypeDeclaration)((Object)iterator.next());
                    if ((inner.bits & 0x200) <= 0) continue;
                    iterator.remove();
                    MethodNode enclosingMethodGroovy = inner.getClassNode().getEnclosingMethod();
                    if (enclosingMethodGroovy == null && (enclosingMethodGroovy = (outerClass = inner.getClassNode().getOuterClass()).getMethod("run", new Parameter[0])) == null) {
                        throw new GroovyEclipseBug("Failed to find the enclosing method for anonymous type " + inner.getClassNode().getName());
                    }
                    AbstractMethodDeclaration enclosingMethodJDT = this.enclosingMethodMap.get(enclosingMethodGroovy);
                    enclosingMethodJDT.bits |= 2;
                    inner.enclosingMethod = enclosingMethodJDT;
                    enclosingMethodJDT.scope = new MethodScope((Scope)outerTypeDeclaration.scope, (ReferenceContext)enclosingMethodJDT, enclosingMethodJDT.isStatic());
                    if (inner.enclosingMethod.statements == null || inner.enclosingMethod.statements.length == 0) {
                        inner.enclosingMethod.statements = new Statement[]{inner.allocation};
                    } else {
                        Statement[] newStatements = new Statement[inner.enclosingMethod.statements.length + 1];
                        System.arraycopy(inner.enclosingMethod.statements, 0, newStatements, 0, inner.enclosingMethod.statements.length);
                        newStatements[inner.enclosingMethod.statements.length] = inner.allocation;
                        inner.enclosingMethod.statements = newStatements;
                    }
                    ((GroovyTypeDeclaration)outerTypeDeclaration).addAnonymousType(inner);
                }
                outerTypeDeclaration.memberTypes = newInnersList.toArray(new TypeDeclaration[newInnersList.size()]);
            }
            this.enclosingMethodMap = null;
            this.unitDeclaration.types = typeDeclarations.toArray(new TypeDeclaration[typeDeclarations.size()]);
        }

        private FieldDeclaration[] createFieldDeclarations(ClassNode classNode, boolean isEnum) {
            ArrayList<FieldDeclarationWithInitializer> fieldDeclarations = new ArrayList<FieldDeclarationWithInitializer>();
            List fieldNodes = classNode.getFields();
            boolean isTrait = this.isTrait(classNode);
            if (fieldNodes != null) {
                for (FieldNode fieldNode : fieldNodes) {
                    boolean isSynthetic;
                    if (isTrait && (!fieldNode.isPublic() || !fieldNode.isStatic() || !fieldNode.isFinal()) || isEnum && (fieldNode.getName().equals("MAX_VALUE") || fieldNode.getName().equals("MIN_VALUE"))) continue;
                    boolean isEnumField = (fieldNode.getModifiers() & 0x4000) != 0;
                    boolean bl = isSynthetic = (fieldNode.getModifiers() & 0x1000) != 0;
                    if (isSynthetic) continue;
                    FieldDeclarationWithInitializer fieldDeclaration = new FieldDeclarationWithInitializer(fieldNode.getName().toCharArray(), 0, 0);
                    fieldDeclaration.annotations = this.createAnnotations(fieldNode.getAnnotations());
                    if (!isEnumField) {
                        fieldDeclaration.modifiers = fieldNode.getModifiers() & 0xFFFFBFFF;
                        fieldDeclaration.type = this.createTypeReferenceForClassNode(fieldNode.getType());
                        if (fieldNode.isStatic() && fieldNode.isFinal() && fieldNode.getInitialExpression() instanceof ConstantExpression) {
                            fieldDeclaration.initialization = this.createConstantExpression((ConstantExpression)fieldNode.getInitialExpression());
                        }
                    }
                    fieldDeclaration.initializer = fieldNode.getInitialExpression();
                    this.fixupSourceLocationsForFieldDeclaration(fieldDeclaration, fieldNode, isEnumField);
                    fieldDeclarations.add(fieldDeclaration);
                }
            }
            return fieldDeclarations.toArray(new FieldDeclaration[fieldDeclarations.size()]);
        }

        private AbstractMethodDeclaration[] createMethodAndConstructorDeclarations(ClassNode classNode, boolean isEnum, GroovyTypeDeclaration typeDeclaration, CompilationResult compilationResult) {
            ArrayList<AbstractMethodDeclaration> accumulatedDeclarations = new ArrayList<AbstractMethodDeclaration>();
            this.createConstructorDeclarations(classNode, isEnum, accumulatedDeclarations);
            this.createMethodDeclarations(classNode, isEnum, typeDeclaration, accumulatedDeclarations);
            return accumulatedDeclarations.toArray(new AbstractMethodDeclaration[accumulatedDeclarations.size()]);
        }

        private void createConstructorDeclarations(ClassNode classNode, boolean isEnum, List<AbstractMethodDeclaration> accumulatedMethodDeclarations) {
            boolean needsDefaultCtor;
            if (this.isTrait(classNode)) {
                return;
            }
            List constructorNodes = classNode.getDeclaredConstructors();
            char[] ctorName = null;
            if (classNode instanceof InnerClassNode) {
                InnerClassNode innerClassNode = (InnerClassNode)classNode;
                ClassNode outerClass = innerClassNode.getOuterClass();
                String outername = outerClass.getNameWithoutPackage();
                String newInner = innerClassNode.getNameWithoutPackage().substring(outername.length() + 1);
                ctorName = newInner.toCharArray();
            } else {
                ctorName = classNode.getNameWithoutPackage().toCharArray();
            }
            boolean bl = needsDefaultCtor = constructorNodes.size() == 0 && !classNode.isInterface();
            if (needsDefaultCtor) {
                ConstructorDeclaration constructor = new ConstructorDeclaration(this.unitDeclaration.compilationResult);
                constructor.bits |= 0x80;
                constructor.modifiers = isEnum ? 2 : 1;
                constructor.selector = ctorName;
                accumulatedMethodDeclarations.add((AbstractMethodDeclaration)constructor);
            }
            for (ConstructorNode constructorNode : constructorNodes) {
                ConstructorDeclaration constructorDeclaration = new ConstructorDeclaration(this.unitDeclaration.compilationResult);
                this.fixupSourceLocationsForConstructorDeclaration(constructorDeclaration, constructorNode);
                constructorDeclaration.annotations = this.createAnnotations(constructorNode.getAnnotations());
                constructorDeclaration.modifiers = isEnum ? 2 : 1;
                constructorDeclaration.selector = ctorName;
                constructorDeclaration.arguments = this.createArguments(constructorNode.getParameters(), false);
                constructorDeclaration.thrownExceptions = this.createTypeReferencesForClassNodes(constructorNode.getExceptions());
                if (constructorNode.hasDefaultValue()) {
                    this.createConstructorVariants(constructorNode, constructorDeclaration, accumulatedMethodDeclarations, this.unitDeclaration.compilationResult, isEnum);
                } else {
                    accumulatedMethodDeclarations.add((AbstractMethodDeclaration)constructorDeclaration);
                }
                if (!this.hasAnonInners) continue;
                this.enclosingMethodMap.put((MethodNode)constructorNode, (AbstractMethodDeclaration)constructorDeclaration);
            }
            if (earlyTransforms) {
                this.executeEarlyTransforms_ConstructorRelated(ctorName, classNode, accumulatedMethodDeclarations);
            }
        }

        private void createMethodDeclarations(ClassNode classNode, boolean isEnum, GroovyTypeDeclaration typeDeclaration, List<AbstractMethodDeclaration> accumulatedDeclarations) {
            boolean isTrait = this.isTrait(classNode);
            List methods = classNode.getMethods();
            for (MethodNode methodNode : methods) {
                if (isTrait && (methodNode.isPrivate() || methodNode.isStatic()) || isEnum && methodNode.isSynthetic()) continue;
                MethodDeclaration methodDeclaration = this.createMethodDeclaration(classNode, isEnum, methodNode, this.unitDeclaration.compilationResult);
                if (methodNode.isAbstract()) {
                    typeDeclaration.bits |= 0x800;
                }
                if (methodNode.hasDefaultValue()) {
                    this.createMethodVariants(classNode, methodNode, isEnum, methodDeclaration, accumulatedDeclarations, this.unitDeclaration.compilationResult);
                } else {
                    accumulatedDeclarations.add((AbstractMethodDeclaration)methodDeclaration);
                }
                if (!this.hasAnonInners) continue;
                this.enclosingMethodMap.put(methodNode, (AbstractMethodDeclaration)methodDeclaration);
            }
        }

        private MethodDeclaration createMethodDeclaration(ClassNode classNode, boolean isEnum, MethodNode methodNode, CompilationResult compilationResult) {
            Parameter p;
            if (classNode.isAnnotationDefinition()) {
                AnnotationMethodDeclaration methodDeclaration = new AnnotationMethodDeclaration(compilationResult);
                int modifiers = methodNode.getModifiers();
                methodDeclaration.annotations = this.createAnnotations(methodNode.getAnnotations());
                methodDeclaration.modifiers = modifiers &= 0xFFFFEF7F;
                if (methodNode.hasAnnotationDefault()) {
                    methodDeclaration.modifiers |= 0x20000;
                }
                methodDeclaration.selector = methodNode.getName().toCharArray();
                this.fixupSourceLocationsForMethodDeclaration((MethodDeclaration)methodDeclaration, methodNode);
                ClassNode returnType = methodNode.getReturnType();
                methodDeclaration.returnType = this.createTypeReferenceForClassNode(returnType);
                return methodDeclaration;
            }
            MethodDeclaration methodDeclaration = new MethodDeclaration(compilationResult);
            GenericsType[] generics = methodNode.getGenericsTypes();
            if (generics != null && generics.length > 0) {
                methodDeclaration.typeParameters = this.createTypeParametersForGenerics(generics);
            }
            boolean isMain = false;
            int modifiers = methodNode.getModifiers();
            methodDeclaration.annotations = this.createAnnotations(methodNode.getAnnotations());
            methodDeclaration.modifiers = modifiers &= 0xFFFFEF7F;
            methodDeclaration.selector = methodNode.getName().toCharArray();
            Parameter[] params = methodNode.getParameters();
            ClassNode returnType = methodNode.getReturnType();
            if ((modifiers & 8) != 0 && params != null && params.length == 1 && methodNode.getName().equals("main") && ((p = params[0]).getType() == null || p.getType().getName().equals("java.lang.Object"))) {
                String name = p.getName();
                params = new Parameter[]{new Parameter(ClassHelper.STRING_TYPE.makeArray(), name)};
                if (returnType.getName().equals("java.lang.Object")) {
                    returnType = ClassHelper.VOID_TYPE;
                }
            }
            methodDeclaration.arguments = this.createArguments(params, isMain);
            methodDeclaration.returnType = this.createTypeReferenceForClassNode(returnType);
            methodDeclaration.thrownExceptions = this.createTypeReferencesForClassNodes(methodNode.getExceptions());
            this.fixupSourceLocationsForMethodDeclaration(methodDeclaration, methodNode);
            return methodDeclaration;
        }

        private void createConstructorVariants(ConstructorNode constructorNode, ConstructorDeclaration constructorDecl, List<AbstractMethodDeclaration> accumulatedDeclarations, CompilationResult compilationResult, boolean isEnum) {
            List<Argument[]> variants = this.getVariantsAllowingForDefaulting(constructorNode.getParameters(), constructorDecl.arguments);
            for (Argument[] variant : variants) {
                ConstructorDeclaration constructorDeclaration = new ConstructorDeclaration(compilationResult);
                constructorDeclaration.annotations = this.createAnnotations(constructorNode.getAnnotations());
                constructorDeclaration.modifiers = isEnum ? 2 : 1;
                constructorDeclaration.selector = constructorDecl.selector;
                constructorDeclaration.arguments = variant;
                this.fixupSourceLocationsForConstructorDeclaration(constructorDeclaration, constructorNode);
                this.addUnlessDuplicate(accumulatedDeclarations, (AbstractMethodDeclaration)constructorDeclaration);
            }
        }

        private void createMethodVariants(ClassNode classNode, MethodNode method, boolean isEnum, MethodDeclaration methodDecl, List<AbstractMethodDeclaration> accumulatedDeclarations, CompilationResult compilationResult) {
            List<Argument[]> variants = this.getVariantsAllowingForDefaulting(method.getParameters(), methodDecl.arguments);
            for (Argument[] variant : variants) {
                MethodDeclaration variantMethodDeclaration = this.genMethodDeclarationVariant(classNode, method, isEnum, variant, methodDecl.returnType, compilationResult);
                this.addUnlessDuplicate(accumulatedDeclarations, (AbstractMethodDeclaration)variantMethodDeclaration);
            }
        }

        private void configureSuperClass(TypeDeclaration typeDeclaration, ClassNode superclass, boolean isEnum, boolean isTrait) {
            if (isEnum && superclass.getName().equals("java.lang.Enum") || isTrait) {
                typeDeclaration.superclass = null;
            } else if (superclass.getStart() != 0 || !superclass.equals((Object)ClassHelper.OBJECT_TYPE)) {
                typeDeclaration.superclass = this.createTypeReferenceForClassNode(superclass);
            }
        }

        private void configureSuperInterfaces(TypeDeclaration typeDeclaration, ClassNode classNode) {
            ClassNode[] interfaces = classNode.getInterfaces();
            if (interfaces != null && interfaces.length > 0) {
                typeDeclaration.superInterfaces = new TypeReference[interfaces.length];
                int i = 0;
                while (i < interfaces.length) {
                    typeDeclaration.superInterfaces[i] = this.createTypeReferenceForClassNode(interfaces[i]);
                    ++i;
                }
            } else {
                typeDeclaration.superInterfaces = new TypeReference[0];
            }
        }

        private Annotation[] createAnnotations(List<AnnotationNode> groovyAnnotations) {
            if (groovyAnnotations != null && !groovyAnnotations.isEmpty()) {
                ArrayList<Object> annotations = new ArrayList<Object>(groovyAnnotations.size());
                for (AnnotationNode annotationNode : groovyAnnotations) {
                    MarkerAnnotation annotation;
                    ClassNode annoType = annotationNode.getClassNode();
                    TypeReference annotationReference = this.createTypeReferenceForClassNode(annoType);
                    annotationReference.sourceStart = annotationNode.getStart();
                    annotationReference.sourceEnd = annotationNode.getEnd();
                    Map memberValuePairs = annotationNode.getMembers();
                    if (memberValuePairs == null || memberValuePairs.isEmpty()) {
                        annotation = new MarkerAnnotation(annotationReference, annotationNode.getStart());
                        annotation.declarationSourceEnd = annotation.sourceEnd;
                        annotations.add(annotation);
                        continue;
                    }
                    if (memberValuePairs.size() == 1 && memberValuePairs.containsKey("value")) {
                        Map.Entry memberValuePair = memberValuePairs.entrySet().iterator().next();
                        Expression value = (Expression)memberValuePair.getValue();
                        SingleMemberAnnotation annotation2 = new SingleMemberAnnotation(annotationReference, annotationNode.getStart());
                        annotation2.declarationSourceEnd = annotation2.sourceStart + annoType.getNameWithoutPackage().length() - 1;
                        annotation2.memberValue = this.createAnnotationMemberExpression(value);
                        annotations.add(annotation2);
                        continue;
                    }
                    annotation = new NormalAnnotation(annotationReference, annotationNode.getStart());
                    annotation.declarationSourceEnd = annotation.sourceStart + annoType.getNameWithoutPackage().length() - 1;
                    annotation.memberValuePairs = this.createAnnotationMemberValuePairs(memberValuePairs);
                    annotations.add(annotation);
                }
                return annotations.toArray(new Annotation[annotations.size()]);
            }
            return null;
        }

        private org.eclipse.jdt.internal.compiler.ast.Expression createAnnotationMemberExpression(Expression expr) {
            if (expr instanceof ListExpression) {
                ListExpression list = (ListExpression)expr;
                ArrayInitializer arrayInitializer = new ArrayInitializer();
                arrayInitializer.sourceStart = expr.getStart();
                arrayInitializer.sourceEnd = expr.getEnd();
                int n = list.getExpressions().size();
                arrayInitializer.expressions = new org.eclipse.jdt.internal.compiler.ast.Expression[n];
                int i = 0;
                while (i < n) {
                    arrayInitializer.expressions[i] = this.createAnnotationMemberExpression(list.getExpression(i));
                    ++i;
                }
                return arrayInitializer;
            }
            if (expr instanceof AnnotationConstantExpression) {
                Annotation[] annos = this.createAnnotations(Collections.singletonList((AnnotationNode)((AnnotationConstantExpression)expr).getValue()));
                assert (annos != null && annos.length == 1);
                return annos[0];
            }
            if (expr instanceof ConstantExpression) {
                Literal literal = this.createConstantExpression((ConstantExpression)expr);
                if (literal != null) {
                    return literal;
                }
            } else {
                if (expr instanceof PropertyExpression) {
                    PropertyExpression prop = (PropertyExpression)expr;
                    assert (prop.getProperty() instanceof ConstantExpression);
                    if (prop.getPropertyAsString().equals("class")) {
                        return new ClassLiteralAccess(expr.getEnd(), this.createTypeReferenceForClassLiteral(prop));
                    }
                    char[][] tokens = CharOperation.splitOn((char)'.', (char[])prop.getText().toCharArray());
                    int n = tokens.length;
                    int s = prop.getObjectExpression().getStart();
                    long[] positions = new long[n];
                    int i = 0;
                    while (i < n) {
                        positions[i] = UnitPopulator.toPos(s, s + tokens[i].length - 1);
                        s += tokens[i].length;
                        ++i;
                    }
                    assert (s <= expr.getEnd());
                    return new QualifiedNameReference(tokens, positions, expr.getStart(), expr.getEnd());
                }
                if (expr instanceof VariableExpression) {
                    String name = ((VariableExpression)expr).getName();
                    if (name.matches("[a-z_]\\w*|[A-Z][A-Z_0-9]*")) {
                        return new SingleNameReference(name.toCharArray(), UnitPopulator.toPos(expr.getStart(), expr.getEnd() - 1));
                    }
                    return new ClassLiteralAccess(expr.getEnd(), (TypeReference)new SingleTypeReference(name.toCharArray(), UnitPopulator.toPos(expr.getStart(), expr.getEnd() - 1)));
                }
                if (expr instanceof ClosureExpression) {
                    return new ClassLiteralAccess(expr.getEnd(), (TypeReference)new SingleTypeReference("Closure".toCharArray(), UnitPopulator.toPos(expr.getStart(), expr.getEnd())));
                }
                Util.log((int)2, (String)("Unhandled annotation value type: " + expr.getClass().getSimpleName()));
            }
            return new NullLiteral(expr.getStart(), expr.getEnd());
        }

        private MemberValuePair[] createAnnotationMemberValuePairs(Map<String, Expression> memberValuePairs) {
            ArrayList<MemberValuePair> mvps = new ArrayList<MemberValuePair>(memberValuePairs.size());
            for (Map.Entry<String, Expression> memberValuePair : memberValuePairs.entrySet()) {
                char[] name = memberValuePair.getKey().toCharArray();
                int start = memberValuePair.getValue().getStart() - name.length - 1;
                int until = memberValuePair.getValue().getEnd();
                org.eclipse.jdt.internal.compiler.ast.Expression value = this.createAnnotationMemberExpression(memberValuePair.getValue());
                mvps.add(new MemberValuePair(name, start, until, value));
            }
            return mvps.toArray(new MemberValuePair[mvps.size()]);
        }

        private Literal createConstantExpression(ConstantExpression expr) {
            int start = expr.getStart();
            int until = expr.getEnd();
            String type = expr.getType().getName();
            Object value = expr.getValue();
            if (type.equals("java.lang.Object")) {
                assert (value == null);
                return new NullLiteral(start, until);
            }
            if (type.equals("java.lang.String")) {
                return new StringLiteral(((String)value).toCharArray(), start, until - 1, expr.getLineNumber());
            }
            if (type.equals("boolean") || type.equals("java.lang.Boolean")) {
                if (value.toString().equals("true")) {
                    return new TrueLiteral(start, until);
                }
                return new FalseLiteral(start, until);
            }
            if (type.equals("int") || type.equals("java.lang.Integer")) {
                char[] chars = value.toString().toCharArray();
                return IntLiteral.buildIntLiteral((char[])chars, (int)start, (int)(start + chars.length));
            }
            if (type.equals("long") || type.equals("java.lang.Long")) {
                char[] chars = (String.valueOf(value.toString()) + 'L').toCharArray();
                return LongLiteral.buildLongLiteral((char[])chars, (int)start, (int)(start + chars.length));
            }
            if (type.equals("double") || type.equals("java.lang.Double")) {
                return new DoubleLiteral(value.toString().toCharArray(), start, until);
            }
            if (type.equals("float") || type.equals("java.lang.Float")) {
                return new FloatLiteral(value.toString().toCharArray(), start, until);
            }
            if (type.equals("byte") || type.equals("java.lang.Byte") || type.equals("short") || type.equals("java.lang.Short")) {
                char[] chars = value.toString().toCharArray();
                return IntLiteral.buildIntLiteral((char[])chars, (int)start, (int)(start + chars.length));
            }
            if (type.equals("char") || type.equals("java.lang.Character")) {
                return new CharLiteral(value.toString().toCharArray(), start, until);
            }
            if (type.equals("java.math.BigDecimal")) {
                return new DoubleLiteral(value.toString().toCharArray(), start, until);
            }
            Util.log((int)2, (String)("Unhandled annotation constant type: " + expr.getType().getName()));
            return null;
        }

        private Argument[] createArguments(Parameter[] ps, boolean isMain) {
            if (ps == null || ps.length == 0) {
                return null;
            }
            Argument[] arguments = new Argument[ps.length];
            int i = 0;
            while (i < ps.length) {
                long pos;
                Parameter parameter = ps[i];
                TypeReference parameterTypeReference = this.createTypeReferenceForClassNode(parameter.getType());
                int pstart = parameter.getStart();
                if (parameter.getStart() == 0 && parameter.getEnd() == 0) {
                    pos = UnitPopulator.toPos(-1L, -2L);
                    pstart = -1;
                } else {
                    pos = UnitPopulator.toPos(parameter.getStart(), parameter.getEnd() - 1);
                }
                arguments[i] = new Argument(parameter.getName().toCharArray(), pos, parameterTypeReference, 1);
                arguments[i].declarationSourceStart = pstart;
                ++i;
            }
            if (this.isVargs(ps)) {
                arguments[ps.length - 1].type.bits |= 0x4000;
            }
            return arguments;
        }

        private TypeReference createTypeReferenceForArrayNameTrailingBrackets(ClassNode node, int start, int end) {
            String name = node.getName();
            int dim = 0;
            int pos = name.length() - 2;
            ClassNode componentType = node;
            while (pos > 0 && name.charAt(pos) == '[') {
                ++dim;
                pos -= 2;
                componentType = componentType.getComponentType();
            }
            if (componentType.isPrimitive()) {
                Integer ii = charToTypeId.get(Character.valueOf(name.charAt(dim)));
                if (ii == null) {
                    throw new IllegalStateException("node " + node + " reported it had a primitive component type, but it does not...");
                }
                TypeReference baseTypeReference = TypeReference.baseTypeReference((int)ii, (int)dim);
                baseTypeReference.sourceStart = start;
                baseTypeReference.sourceEnd = start + componentType.getName().length();
                return baseTypeReference;
            }
            if (dim == 0) {
                throw new IllegalStateException("Array classnode with dimensions 0?? node:" + node.getName());
            }
            String arrayComponentTypename = name.substring(0, pos + 2);
            if (arrayComponentTypename.indexOf(".") == -1) {
                return this.createJDTArrayTypeReference(arrayComponentTypename, dim, start, end);
            }
            return this.createJDTArrayQualifiedTypeReference(arrayComponentTypename, dim, start, end);
        }

        private TypeReference createTypeReferenceForArrayNameLeadingBrackets(ClassNode node, int start, int end) {
            String name = node.getName();
            int dim = 0;
            ClassNode componentType = node;
            while (name.charAt(dim) == '[') {
                ++dim;
                componentType = componentType.getComponentType();
            }
            if (componentType.isPrimitive()) {
                Integer ii = charToTypeId.get(Character.valueOf(name.charAt(dim)));
                if (ii == null) {
                    throw new IllegalStateException("node " + node + " reported it had a primitive component type, but it does not...");
                }
                TypeReference baseTypeReference = TypeReference.baseTypeReference((int)ii, (int)dim);
                baseTypeReference.sourceStart = start;
                baseTypeReference.sourceEnd = start + componentType.getName().length();
                return baseTypeReference;
            }
            String arrayComponentTypename = name.substring(dim);
            if (arrayComponentTypename.charAt(arrayComponentTypename.length() - 1) == ';') {
                arrayComponentTypename = name.substring(dim + 1, name.length() - 1);
            }
            if (arrayComponentTypename.indexOf(".") == -1) {
                return this.createJDTArrayTypeReference(arrayComponentTypename, dim, start, end);
            }
            return this.createJDTArrayQualifiedTypeReference(arrayComponentTypename, dim, start, end);
        }

        private TypeReference createTypeReferenceForClassLiteral(PropertyExpression expression) {
            assert (expression.getPropertyAsString().equals("class"));
            Expression candidate = expression.getObjectExpression();
            LinkedList<char[]> nameParts = new LinkedList<char[]>();
            while (candidate instanceof PropertyExpression) {
                nameParts.add(0, ((PropertyExpression)candidate).getPropertyAsString().toCharArray());
                candidate = ((PropertyExpression)candidate).getObjectExpression();
            }
            if (candidate instanceof VariableExpression) {
                nameParts.add(0, ((VariableExpression)candidate).getName().toCharArray());
            }
            char[][] namePartsArr = (char[][])nameParts.toArray((T[])new char[nameParts.size()][]);
            long[] poss = this.positionsFor(namePartsArr, expression.getObjectExpression().getStart(), expression.getObjectExpression().getEnd());
            Object ref = namePartsArr.length > 1 ? new QualifiedTypeReference(namePartsArr, poss) : (namePartsArr.length == 1 ? new SingleTypeReference(namePartsArr[0], poss[0]) : TypeReference.baseTypeReference((int)nameToPrimitiveTypeId.get("void"), (int)0));
            return ref;
        }

        private TypeReference[] createTypeReferencesForClassNodes(ClassNode[] classNodes) {
            if (classNodes == null) {
                return null;
            }
            int n = classNodes.length;
            if (n == 0) {
                return null;
            }
            TypeReference[] refs = new TypeReference[n];
            int i = 0;
            while (i < n) {
                refs[i] = this.createTypeReferenceForClassNode(classNodes[i]);
                ++i;
            }
            return refs;
        }

        private TypeReference createTypeReferenceForClassNode(ClassNode classNode) {
            return this.createTypeReferenceForClassNode(classNode, this.startOffset((ASTNode)classNode), this.endOffset((ASTNode)classNode));
        }

        private TypeReference createTypeReferenceForClassNode(ClassNode classNode, int start, int end) {
            String name;
            TypeReference tr;
            GenericsType[] genericsInfo;
            ArrayList<TypeReference> typeArguments = null;
            if (classNode.isUsingGenerics() && (genericsInfo = classNode.getGenericsTypes()) != null) {
                int g = 0;
                while (g < genericsInfo.length) {
                    tr = this.createTypeReferenceForGenerics(genericsInfo[g]);
                    if (tr != null) {
                        if (typeArguments == null) {
                            typeArguments = new ArrayList<TypeReference>();
                        }
                        typeArguments.add(tr);
                    }
                    ++g;
                }
            }
            if ((name = classNode.getName()).length() == 1 && name.charAt(0) == '?') {
                return new Wildcard(0);
            }
            int arrayLoc = name.indexOf("[");
            if (arrayLoc == 0) {
                return this.createTypeReferenceForArrayNameLeadingBrackets(classNode, start, end);
            }
            if (arrayLoc > 0) {
                return this.createTypeReferenceForArrayNameTrailingBrackets(classNode, start, end);
            }
            if (nameToPrimitiveTypeId.containsKey(name)) {
                return TypeReference.baseTypeReference((int)nameToPrimitiveTypeId.get(name), (int)0);
            }
            if (name.indexOf(".") == -1) {
                if (typeArguments == null) {
                    tr = this.verify((TypeReference)new SingleTypeReference(name.toCharArray(), UnitPopulator.toPos(start, end - 1)));
                    if (!this.checkGenerics) {
                        tr.bits |= 0x40000000;
                    }
                    return tr;
                }
                long l = UnitPopulator.toPos(start, end - 1);
                return new ParameterizedSingleTypeReference(name.toCharArray(), typeArguments.toArray(new TypeReference[typeArguments.size()]), 0, l);
            }
            char[][] compoundName = CharOperation.splitOn((char)'.', (char[])name.toCharArray());
            if (typeArguments == null) {
                QualifiedTypeReference tr2 = new QualifiedTypeReference(compoundName, this.positionsFor(compoundName, start, end));
                if (!this.checkGenerics) {
                    tr2.bits |= 0x40000000;
                }
                return tr2;
            }
            TypeReference[][] typeReferences = new TypeReference[compoundName.length][];
            typeReferences[compoundName.length - 1] = typeArguments.toArray(new TypeReference[typeArguments.size()]);
            return new ParameterizedQualifiedTypeReference(compoundName, (TypeReference[][])typeReferences, 0, this.positionsFor(compoundName, start, end));
        }

        private TypeReference createTypeReferenceForGenerics(GenericsType genericsType) {
            if (genericsType.isWildcard()) {
                ClassNode[] bounds = genericsType.getUpperBounds();
                if (bounds != null) {
                    TypeReference boundReference = this.createTypeReferenceForClassNode(bounds[0]);
                    Wildcard wildcard = new Wildcard(1);
                    wildcard.sourceStart = genericsType.getStart();
                    wildcard.sourceEnd = boundReference.sourceEnd();
                    wildcard.bound = boundReference;
                    return wildcard;
                }
                if (genericsType.getLowerBound() != null) {
                    TypeReference boundReference = this.createTypeReferenceForClassNode(genericsType.getLowerBound());
                    Wildcard wildcard = new Wildcard(2);
                    wildcard.sourceStart = genericsType.getStart();
                    wildcard.sourceEnd = boundReference.sourceEnd();
                    wildcard.bound = boundReference;
                    return wildcard;
                }
                Wildcard w = new Wildcard(0);
                w.sourceStart = genericsType.getStart();
                w.sourceEnd = genericsType.getStart();
                return w;
            }
            if (!genericsType.getType().isGenericsPlaceHolder()) {
                TypeReference typeReference = this.createTypeReferenceForClassNode(genericsType.getType());
                return typeReference;
            }
            return null;
        }

        private TypeParameter[] createTypeParametersForGenerics(GenericsType[] generics) {
            int n = generics.length;
            TypeParameter[] typeParameters = new TypeParameter[n];
            int i = 0;
            while (i < n) {
                TypeParameter typeParameter;
                typeParameters[i] = typeParameter = new TypeParameter();
                typeParameter.name = generics[i].getName().toCharArray();
                int offset = generics[i].getStart();
                int length = typeParameter.name.length;
                typeParameter.sourceStart = offset;
                typeParameter.sourceEnd = offset + length;
                ClassNode[] upperBounds = generics[i].getUpperBounds();
                if (upperBounds != null && upperBounds.length > 0) {
                    String source = String.valueOf(GroovyUtils.readSourceRange(this.sourceUnit, generics[i].getStart(), generics[i].getLength()));
                    int _start = this.startOffset((ASTNode)upperBounds[0]);
                    int _until = this.endOffset((ASTNode)upperBounds[0]);
                    if (_until > 0) {
                        source = source.substring(_start - offset);
                        length = _until - _start;
                        offset = _start;
                    } else {
                        offset += length;
                        Matcher m = EXTENDS.matcher(source = source.substring(length));
                        if (m.find()) {
                            length = m.group().length();
                            offset += length;
                            source = source.substring(length);
                        }
                        length = upperBounds[0].getName().length();
                        String name = GroovyUtils.splitName(upperBounds[0])[1];
                        assert (length == source.indexOf(name) + name.length());
                        assert (source.length() == length || source.charAt(length) != '<');
                    }
                    typeParameter.type = this.createTypeReferenceForClassNode(upperBounds[0], offset, offset + length);
                    int j = 1;
                    int k = upperBounds.length;
                    while (j < k) {
                        if (j == 1) {
                            typeParameter.bounds = new TypeReference[k - 1];
                        }
                        _start = this.startOffset((ASTNode)upperBounds[j]);
                        _until = this.endOffset((ASTNode)upperBounds[j]);
                        if (_until > 0) {
                            source = source.substring(_start - offset);
                            length = _until - _start;
                            offset = _start;
                        } else {
                            offset += length;
                            Matcher m = AND.matcher(source = source.substring(length));
                            if (m.find()) {
                                length = m.group().length();
                                offset += length;
                                source = source.substring(length);
                            }
                            length = upperBounds[0].getName().length();
                        }
                        typeParameter.bounds[j - 1] = this.createTypeReferenceForClassNode(upperBounds[j], offset, offset + length);
                        typeParameter.bounds[j - 1].bits |= 0x10;
                        ++j;
                    }
                }
                ++i;
            }
            return typeParameters;
        }

        private ArrayTypeReference createJDTArrayTypeReference(String arrayComponentTypename, int dimensions, int start, int end) {
            ArrayTypeReference atr = new ArrayTypeReference(arrayComponentTypename.toCharArray(), dimensions, UnitPopulator.toPos(start, end - 1));
            atr.originalSourceEnd = atr.sourceStart + arrayComponentTypename.length() - 1;
            return atr;
        }

        private ArrayQualifiedTypeReference createJDTArrayQualifiedTypeReference(String arrayComponentTypename, int dimensions, int start, int end) {
            char[][] compoundName = CharOperation.splitOn((char)'.', (char[])arrayComponentTypename.toCharArray());
            ArrayQualifiedTypeReference aqtr = new ArrayQualifiedTypeReference(compoundName, dimensions, this.positionsFor(compoundName, start, end == -2 ? -2 : end - dimensions * 2));
            aqtr.sourceEnd = end == -2 ? -2 : end - 1;
            return aqtr;
        }

        private long[] positionsFor(char[][] reference, long start, long end) {
            long[] result = new long[reference.length];
            if (start == -1L && end == -2L) {
                int i = 0;
                int max = result.length;
                while (i < max) {
                    result[i] = -2L;
                    ++i;
                }
                return result;
            }
            if (start < end) {
                long pos = start;
                int i = 0;
                int max = result.length;
                while (i < max) {
                    long s = pos;
                    pos = pos + (long)reference[i].length - 1L;
                    result[i] = s << 32 | pos;
                    pos += 2L;
                    ++i;
                }
            } else {
                long pos = start << 32 | start;
                int i = 0;
                int max = result.length;
                while (i < max) {
                    result[i] = pos;
                    ++i;
                }
            }
            return result;
        }

        private int trailerLength(ASTNode node) {
            int length = 0;
            if (this.sourceUnit != null && node.getLastLineNumber() > 0) {
                if (this.janitor == null) {
                    this.janitor = new Janitor();
                }
                ReaderSource source = this.sourceUnit.getSource();
                String line = source.getLine(node.getLastLineNumber(), this.janitor);
                StringBuilder sb = null;
                char c = '\u0000';
                int endPos = node.getLastColumnNumber() - 1;
                while (endPos < line.length() && ((c = line.charAt(endPos++)) == ';' || c == ' ' || c == '\t')) {
                    (sb != null ? sb : new StringBuilder()).appendCodePoint(c);
                }
                if (sb != null) {
                    length += sb.length();
                }
            }
            return length;
        }

        private int startOffset(ASTNode node) {
            int s = node.getStart();
            int e = node.getEnd();
            if (s == 0 && e == 0) {
                return -1;
            }
            return s;
        }

        private int endOffset(ASTNode node) {
            int s = node.getStart();
            int e = node.getEnd();
            if (s == 0 && e == 0) {
                return -2;
            }
            return e;
        }

        private boolean isAnon(ClassNode classNode) {
            return classNode.getEnclosingMethod() != null || classNode.getOuterClass() != null && classNode.getOuterClass().isScript();
        }

        private boolean isTrait(ClassNode classNode) {
            return this.unitDeclaration.traitHelper.isTrait(classNode);
        }

        private boolean isVargs(Parameter[] parameters) {
            if (parameters.length == 0) {
                return false;
            }
            ClassNode clazz = parameters[parameters.length - 1].getType();
            return clazz.isArray();
        }

        private char[] toMainName(char[] fileName) {
            int end;
            if (fileName == null) {
                return new char[0];
            }
            int start = CharOperation.lastIndexOf((char)'/', (char[])fileName) + 1;
            if (start == 0 || start < CharOperation.lastIndexOf((char)'\\', (char[])fileName)) {
                start = CharOperation.lastIndexOf((char)'\\', (char[])fileName) + 1;
            }
            if ((end = CharOperation.lastIndexOf((char)'.', (char[])fileName)) == -1) {
                end = fileName.length;
            }
            return CharOperation.subarray((char[])fileName, (int)start, (int)end);
        }

        private static long toPos(long start, long end) {
            if (start == 0L && end <= 0L) {
                return NON_EXISTENT_POSITION;
            }
            if (start < 0L || end < 0L) {
                return NON_EXISTENT_POSITION;
            }
            return start << 32 | end;
        }

        private Javadoc findJavadoc(int line) {
            for (Comment comment : this.sourceUnit.getComments()) {
                if (!comment.isJavadoc() || comment.getLastLine() + 1 != line && (comment.getLastLine() + 2 != line || comment.usedUp)) continue;
                int[] pos = comment.getPositions(this.unitDeclaration.compilationResult.lineSeparatorPositions);
                comment.usedUp = true;
                return new Javadoc(pos[0], pos[1]);
            }
            return null;
        }

        private void fixupSourceLocationsForTypeDeclaration(GroovyTypeDeclaration typeDeclaration, ClassNode classNode) {
            if (classNode instanceof InnerClassNode) {
                typeDeclaration.sourceStart = classNode.getNameStart();
                typeDeclaration.sourceEnd = classNode.getNameEnd();
            } else {
                typeDeclaration.sourceStart = Math.max(classNode.getNameStart(), classNode.getStart());
                typeDeclaration.sourceEnd = Math.max(classNode.getNameEnd(), classNode.getStart());
            }
            int line = classNode.getLineNumber();
            Javadoc doc = this.findJavadoc(line);
            if (doc != null) {
                if (this.unitDeclaration.imports != null && this.unitDeclaration.imports.length > 0) {
                    if (doc.sourceStart < this.unitDeclaration.imports[this.unitDeclaration.imports.length - 1].sourceStart) {
                        doc = null;
                    }
                } else if (this.unitDeclaration.currentPackage != null && doc.sourceStart < this.unitDeclaration.currentPackage.sourceStart) {
                    doc = null;
                }
            }
            typeDeclaration.javadoc = doc;
            typeDeclaration.declarationSourceStart = doc == null ? classNode.getStart() : doc.sourceStart;
            typeDeclaration.declarationSourceEnd = classNode.getEnd() - 1;
            typeDeclaration.bodyStart = Math.max(classNode.getNameEnd(), classNode.getStart());
            typeDeclaration.bodyEnd = classNode.getEnd() - 1;
            typeDeclaration.modifiersSourceStart = classNode.getStart();
        }

        private void fixupSourceLocationsForConstructorDeclaration(ConstructorDeclaration ctorDeclaration, ConstructorNode ctorNode) {
            Javadoc doc;
            ctorDeclaration.sourceStart = ctorNode.getNameStart();
            ctorDeclaration.sourceEnd = ctorNode.getNameEnd();
            int line = ctorNode.getLineNumber();
            ctorDeclaration.javadoc = doc = this.findJavadoc(line);
            ctorDeclaration.declarationSourceStart = doc == null ? ctorNode.getStart() : doc.sourceStart;
            ctorDeclaration.declarationSourceEnd = ctorNode.getEnd() - 1;
            ctorDeclaration.modifiersSourceStart = ctorNode.getStart();
            ctorDeclaration.bodyStart = ctorNode.getCode() != null ? ctorNode.getCode().getStart() : ctorNode.getNameEnd();
            ctorDeclaration.bodyEnd = ctorNode.getEnd() - 1;
        }

        private void fixupSourceLocationsForMethodDeclaration(MethodDeclaration methodDeclaration, MethodNode methodNode) {
            Javadoc doc;
            methodDeclaration.sourceStart = Math.max(methodNode.getNameStart(), methodNode.getStart());
            methodDeclaration.sourceEnd = Math.max(methodNode.getNameEnd(), methodNode.getStart());
            int line = methodNode.getLineNumber();
            methodDeclaration.javadoc = doc = this.findJavadoc(line);
            methodDeclaration.declarationSourceStart = doc == null ? methodNode.getStart() : doc.sourceStart;
            methodDeclaration.declarationSourceEnd = methodNode.getEnd() - 1;
            methodDeclaration.modifiersSourceStart = methodNode.getStart();
            methodDeclaration.bodyStart = methodNode.getCode() != null ? methodNode.getCode().getStart() : Math.max(methodNode.getNameEnd(), methodNode.getStart());
            methodDeclaration.bodyEnd = methodNode.getEnd() - 1;
        }

        private void fixupSourceLocationsForFieldDeclaration(FieldDeclaration fieldDeclaration, FieldNode fieldNode, boolean isEnumField) {
            Javadoc doc;
            fieldDeclaration.sourceStart = fieldNode.getNameStart();
            fieldDeclaration.sourceEnd = fieldNode.getNameEnd();
            int line = fieldNode.getLineNumber();
            fieldDeclaration.javadoc = doc = this.findJavadoc(line);
            if (isEnumField) {
                fieldDeclaration.declarationSourceStart = doc == null ? fieldNode.getNameStart() : doc.sourceStart;
                fieldDeclaration.declarationSourceEnd = fieldNode.getNameEnd() - 1;
            } else {
                fieldDeclaration.declarationSourceStart = doc == null ? fieldNode.getStart() : doc.sourceStart;
                fieldDeclaration.declarationSourceEnd = fieldNode.getEnd() - 1;
            }
            fieldDeclaration.modifiersSourceStart = fieldNode.getStart();
            fieldDeclaration.declarationEnd = fieldNode.getEnd();
            fieldDeclaration.endPart1Position = fieldNode.getNameStart();
            fieldDeclaration.endPart2Position = fieldNode.getEnd() - 1;
        }

        private MethodDeclaration genMethodDeclarationVariant(ClassNode classNode, MethodNode methodNode, boolean isEnum, Argument[] alternativeArguments, TypeReference returnType, CompilationResult compilationResult) {
            MethodDeclaration methodDeclaration = this.createMethodDeclaration(classNode, isEnum, methodNode, compilationResult);
            methodDeclaration.arguments = alternativeArguments;
            this.fixupSourceLocationsForMethodDeclaration(methodDeclaration, methodNode);
            return methodDeclaration;
        }

        private List<Argument[]> getVariantsAllowingForDefaulting(Parameter[] groovyParams, Argument[] jdtArguments) {
            ArrayList<Argument[]> variants = new ArrayList<Argument[]>();
            int psCount = groovyParams.length;
            Parameter[] wipableParameters = new Parameter[psCount];
            System.arraycopy(groovyParams, 0, wipableParameters, 0, psCount);
            ArrayList<Argument> oneVariation = new ArrayList<Argument>();
            int nextToLetDefault = -1;
            do {
                oneVariation.clear();
                nextToLetDefault = -1;
                int p = 0;
                while (p < psCount) {
                    if (wipableParameters[p] != null) {
                        oneVariation.add(jdtArguments[p]);
                        if (wipableParameters[p].hasInitialExpression()) {
                            nextToLetDefault = p;
                        }
                    }
                    ++p;
                }
                if (nextToLetDefault != -1) {
                    wipableParameters[nextToLetDefault] = null;
                }
                Argument[] argumentsVariant = oneVariation.size() == 0 ? null : oneVariation.toArray(new Argument[oneVariation.size()]);
                variants.add(argumentsVariant);
            } while (nextToLetDefault != -1);
            return variants;
        }

        private void addUnlessDuplicate(List<AbstractMethodDeclaration> accumulatedDeclarations, AbstractMethodDeclaration newDeclaration) {
            boolean isDuplicate = false;
            for (AbstractMethodDeclaration aMethodDecl : accumulatedDeclarations) {
                int vmdArgsLen;
                if (!CharOperation.equals((char[])aMethodDecl.selector, (char[])newDeclaration.selector)) continue;
                Argument[] mdArgs = aMethodDecl.arguments;
                Argument[] vmdArgs = newDeclaration.arguments;
                int mdArgsLen = mdArgs == null ? 0 : mdArgs.length;
                int n = vmdArgsLen = vmdArgs == null ? 0 : vmdArgs.length;
                if (mdArgsLen != vmdArgsLen) continue;
                boolean argsTheSame = true;
                int i = 0;
                while (i < mdArgsLen) {
                    if (!CharOperation.equals((char[][])mdArgs[i].type.getTypeName(), (char[][])vmdArgs[i].type.getTypeName())) {
                        argsTheSame = false;
                        break;
                    }
                    ++i;
                }
                if (!argsTheSame) continue;
                isDuplicate = true;
                break;
            }
            if (!isDuplicate) {
                accumulatedDeclarations.add(newDeclaration);
            }
        }

        private void executeEarlyTransforms_ConstructorRelated(char[] ctorName, ClassNode classNode, List<AbstractMethodDeclaration> accumulatedMethodDeclarations) {
            List fields;
            List annos = classNode.getAnnotations();
            boolean hasImmutableAnnotation = false;
            if (annos != null) {
                for (AnnotationNode anno : annos) {
                    ClassNode imp;
                    ModuleNode module;
                    if (anno.getClassNode() == null) continue;
                    String annoName = anno.getClassNode().getName();
                    if (annoName.equals("groovy.transform.Immutable")) {
                        hasImmutableAnnotation = true;
                        continue;
                    }
                    if (!annoName.equals("Immutable") || (module = classNode.getModule()) == null || (imp = module.getImportType("Immutable")) != null && !imp.getName().equals("groovy.transform.Immutable")) continue;
                    hasImmutableAnnotation = true;
                }
            }
            if (hasImmutableAnnotation && (fields = classNode.getFields()).size() > 0) {
                Argument[] arguments = new Argument[fields.size()];
                int i = 0;
                while (i < fields.size()) {
                    FieldNode field = (FieldNode)fields.get(i);
                    TypeReference parameterTypeReference = this.createTypeReferenceForClassNode(field.getType());
                    arguments[i] = new Argument(((FieldNode)fields.get(i)).getName().toCharArray(), UnitPopulator.toPos(field.getStart(), field.getEnd() - 1), parameterTypeReference, 1);
                    arguments[i].declarationSourceStart = ((FieldNode)fields.get(i)).getStart();
                    ++i;
                }
                ConstructorDeclaration constructor = new ConstructorDeclaration(this.unitDeclaration.compilationResult);
                constructor.selector = ctorName;
                constructor.modifiers = 1;
                constructor.arguments = arguments;
                accumulatedMethodDeclarations.add((AbstractMethodDeclaration)constructor);
            }
        }

        private TypeReference verify(TypeReference toVerify) {
            if (toVerify.getClass().equals(SingleTypeReference.class)) {
                SingleTypeReference str = (SingleTypeReference)toVerify;
                if (str.sourceStart == -1) {
                    if (str.sourceEnd != -2) {
                        throw new IllegalStateException("TypeReference '" + new String(str.token) + " should end at -2");
                    }
                } else if (str.sourceEnd < str.sourceStart) {
                    throw new IllegalStateException("TypeReference '" + new String(str.token) + " should end at " + str.sourceStart + " or later");
                }
            } else {
                throw new IllegalStateException("Cannot verify type reference of this class " + toVerify.getClass());
            }
            return toVerify;
        }
    }
}

