/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jdt.groovy.internal.compiler.ast;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.runtime.MetaClassHelper;
import org.codehaus.jdt.groovy.internal.compiler.ast.EventListener;
import org.codehaus.jdt.groovy.internal.compiler.ast.GroovyTypeDeclaration;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.BinaryTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.ImportBinding;
import org.eclipse.jdt.internal.compiler.lookup.LazilyResolvedMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MissingTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroovyClassScope
extends ClassScope {
    public static EventListener debugListener = null;
    private TraitHelper traitHelper = new TraitHelper();
    char[] GROOVY = "groovy".toCharArray();
    char[][] GROOVY_LANG_METACLASS = new char[][]{this.GROOVY, TypeConstants.LANG, "MetaClass".toCharArray()};
    char[][] GROOVY_LANG_GROOVYOBJECT = new char[][]{this.GROOVY, TypeConstants.LANG, "GroovyObject".toCharArray()};

    public GroovyClassScope(Scope parent, TypeDeclaration typeDecl) {
        super(parent, typeDecl);
    }

    protected boolean connectSuperInterfaces() {
        boolean noProblems = super.connectSuperInterfaces();
        return noProblems;
    }

    public final ReferenceBinding getGroovyLangMetaClassBinding() {
        CompilationUnitScope unitScope = this.compilationUnitScope();
        unitScope.recordQualifiedReference(this.GROOVY_LANG_METACLASS);
        return unitScope.environment.getResolvedType(this.GROOVY_LANG_METACLASS, (Scope)this);
    }

    protected MethodBinding[] augmentMethodBindings(MethodBinding[] methodBindings) {
        SourceTypeBinding binding = this.referenceContext.binding;
        if (binding != null && (binding.isAnnotationType() || binding.isInterface())) {
            return methodBindings;
        }
        boolean implementsGroovyLangObject = false;
        ReferenceBinding[] superInterfaces = binding.superInterfaces;
        if (superInterfaces != null) {
            int i = 0;
            int max = superInterfaces.length;
            while (i < max) {
                char[][] interfaceName = superInterfaces[i].compoundName;
                if (CharOperation.equals((char[][])interfaceName, (char[][])this.GROOVY_LANG_GROOVYOBJECT)) {
                    implementsGroovyLangObject = true;
                    break;
                }
                ++i;
            }
        }
        ArrayList<MethodBinding> groovyMethods = new ArrayList<MethodBinding>();
        if (implementsGroovyLangObject) {
            if (debugListener != null) {
                debugListener.record("augment: type " + new String(this.referenceContext.name) + " having GroovyObject methods added");
            }
            ReferenceBinding bindingJLO = this.getJavaLangObject();
            ReferenceBinding bindingJLS = this.getJavaLangString();
            ReferenceBinding bindingGLM = this.getGroovyLangMetaClassBinding();
            this.createMethod("invokeMethod", false, "", new TypeBinding[]{bindingJLS, bindingJLO}, (TypeBinding)bindingJLO, groovyMethods, methodBindings, null);
            this.createMethod("getProperty", false, "", new TypeBinding[]{bindingJLS}, (TypeBinding)bindingJLO, groovyMethods, methodBindings, null);
            this.createMethod("setProperty", false, "", new TypeBinding[]{bindingJLS, bindingJLO}, (TypeBinding)TypeBinding.VOID, groovyMethods, methodBindings, null);
            this.createMethod("getMetaClass", false, "", null, (TypeBinding)bindingGLM, groovyMethods, methodBindings, null);
            this.createMethod("setMetaClass", false, "", new TypeBinding[]{bindingGLM}, (TypeBinding)TypeBinding.VOID, groovyMethods, methodBindings, null);
        }
        if (this.referenceContext instanceof GroovyTypeDeclaration) {
            String name;
            List<PropertyNode> properties;
            GroovyTypeDeclaration typeDeclaration = (GroovyTypeDeclaration)this.referenceContext;
            boolean useOldWay = false;
            if (useOldWay) {
                properties = typeDeclaration.properties;
                for (PropertyNode property : properties) {
                    name = property.getName();
                    FieldBinding fBinding = typeDeclaration.binding.getField(name.toCharArray(), false);
                    if (fBinding == null || fBinding.type instanceof MissingTypeBinding) continue;
                    String getterName = "get" + MetaClassHelper.capitalize((String)name);
                    this.createMethod(getterName, property.isStatic(), "", null, fBinding.type, groovyMethods, methodBindings, typeDeclaration);
                    if (!fBinding.isFinal()) {
                        String setterName = "set" + MetaClassHelper.capitalize((String)name);
                        this.createMethod(setterName, property.isStatic(), "", new TypeBinding[]{fBinding.type}, (TypeBinding)TypeBinding.VOID, groovyMethods, methodBindings, typeDeclaration);
                    }
                    if (fBinding.type != TypeBinding.BOOLEAN) continue;
                    this.createMethod("is" + MetaClassHelper.capitalize((String)name), property.isStatic(), "", null, fBinding.type, groovyMethods, methodBindings, typeDeclaration);
                }
            } else {
                properties = typeDeclaration.properties;
                for (PropertyNode property : properties) {
                    String propertyType;
                    name = property.getName();
                    String capitalizedName = MetaClassHelper.capitalize((String)name);
                    this.createGetterMethod(name, "get" + capitalizedName, property.isStatic(), groovyMethods, methodBindings, typeDeclaration);
                    if (!Modifier.isFinal(property.getModifiers())) {
                        this.createSetterMethod(name, "set" + capitalizedName, property.isStatic(), groovyMethods, methodBindings, typeDeclaration, property.getType().getName());
                    }
                    if (!(propertyType = property.getType().getName()).equals("boolean")) continue;
                    this.createGetterMethod(name, "is" + capitalizedName, property.isStatic(), groovyMethods, methodBindings, typeDeclaration);
                }
            }
        }
        HashMap<String, MethodBinding> methodsMap = new HashMap<String, MethodBinding>();
        ReferenceBinding[] referenceBindingArray = superInterfaces;
        int property = superInterfaces.length;
        int properties = 0;
        while (properties < property) {
            Object i = referenceBindingArray[properties];
            if (this.traitHelper.isTrait((ReferenceBinding)i)) {
                ReferenceBinding helperBinding = this.getHelperBinding((ReferenceBinding)i);
                MethodBinding[] methodBindingArray = i.availableMethods();
                int n = methodBindingArray.length;
                int n2 = 0;
                while (n2 < n) {
                    MethodBinding method = methodBindingArray[n2];
                    if (!method.isPrivate() && !method.isStatic() && this.isNotActuallyAbstract(method, helperBinding)) {
                        methodsMap.put(this.getMethodAsString(method), method);
                    }
                    ++n2;
                }
            }
            ++properties;
        }
        if (!methodsMap.isEmpty()) {
            MethodBinding[] methodBindingArray;
            HashSet<String> canBeOverridden = new HashSet<String>();
            ReferenceBinding superclass = binding.superclass();
            while (superclass != null) {
                methodBindingArray = superclass.availableMethods();
                int helperBinding = methodBindingArray.length;
                int n = 0;
                while (n < helperBinding) {
                    MethodBinding method = methodBindingArray[n];
                    if (!(method.isPrivate() || method.isPublic() || method.isStatic())) {
                        canBeOverridden.add(this.getMethodAsString(method));
                    }
                    ++n;
                }
                superclass = superclass.superclass();
            }
            methodBindingArray = methodBindings;
            int helperBinding = methodBindings.length;
            int n = 0;
            while (n < helperBinding) {
                MethodBinding method = methodBindingArray[n];
                canBeOverridden.remove(this.getMethodAsString(method));
                ++n;
            }
            for (String key : canBeOverridden) {
                MethodBinding method = (MethodBinding)methodsMap.get(key);
                if (method == null) continue;
                method = new MethodBinding(method, (ReferenceBinding)binding);
                method.modifiers &= 0xFFFFFBFF;
                groovyMethods.add(method);
            }
        }
        MethodBinding[] newMethodBindings = groovyMethods.toArray(new MethodBinding[methodBindings.length + groovyMethods.size()]);
        System.arraycopy(methodBindings, 0, newMethodBindings, groovyMethods.size(), methodBindings.length);
        return newMethodBindings;
    }

    private String getMethodAsString(MethodBinding method) {
        StringBuilder key = new StringBuilder(new String(method.selector));
        key.append(" ");
        TypeBinding[] typeBindingArray = method.parameters;
        int n = method.parameters.length;
        int n2 = 0;
        while (n2 < n) {
            TypeBinding param = typeBindingArray[n2];
            char[] type = param.readableName();
            if (type != null) {
                key.append(type);
                key.append(" ");
            } else {
                key.append("null ");
            }
            ++n2;
        }
        return key.toString();
    }

    private ReferenceBinding getHelperBinding(ReferenceBinding interfaceBinding) {
        if (interfaceBinding instanceof BinaryTypeBinding) {
            StringBuilder nameBuilder = new StringBuilder();
            nameBuilder.append(interfaceBinding.sourceName);
            nameBuilder.append("$Trait$Helper");
            ReferenceBinding helperBinding = this.compilationUnitScope().findType(nameBuilder.toString().toCharArray(), interfaceBinding.fPackage, interfaceBinding.fPackage);
            if (helperBinding != null && helperBinding instanceof ProblemReferenceBinding) {
                helperBinding = ((ProblemReferenceBinding)helperBinding).closestReferenceMatch();
            }
            return helperBinding;
        }
        return null;
    }

    private boolean isNotActuallyAbstract(MethodBinding methodBinding, ReferenceBinding helperBinding) {
        AbstractMethodDeclaration methodDeclaration;
        if (methodBinding.declaringClass instanceof SourceTypeBinding && (methodDeclaration = ((SourceTypeBinding)methodBinding.declaringClass).scope.referenceContext.declarationOf(methodBinding)) != null) {
            return (methodDeclaration.modifiers & 0x400) == 0;
        }
        if (methodBinding.declaringClass instanceof BinaryTypeBinding && helperBinding != null) {
            MethodBinding[] methodBindingArray = helperBinding.methods();
            int n = methodBindingArray.length;
            int n2 = 0;
            while (n2 < n) {
                TypeBinding[] expectedParameters;
                TypeBinding[] actualParameters;
                MethodBinding m = methodBindingArray[n2];
                if (Arrays.equals(methodBinding.selector, m.selector) && (actualParameters = m.parameters).length == (expectedParameters = methodBinding.parameters).length + 1 && actualParameters[0].equals(methodBinding.declaringClass)) {
                    boolean same = true;
                    int i = 0;
                    while (i < expectedParameters.length) {
                        if (!actualParameters[i + 1].equals(expectedParameters[i])) {
                            same = false;
                            break;
                        }
                        ++i;
                    }
                    return same && !m.isAbstract();
                }
                ++n2;
            }
        }
        return true;
    }

    private void createMethod(String name, boolean isStatic, String signature, TypeBinding[] parameterTypes, TypeBinding returnType, List<MethodBinding> groovyMethods, MethodBinding[] existingMethods, GroovyTypeDeclaration typeDeclaration) {
        boolean found = false;
        MethodBinding[] methodBindingArray = existingMethods;
        int n = existingMethods.length;
        int n2 = 0;
        while (n2 < n) {
            MethodBinding existingMethod = methodBindingArray[n2];
            if (new String(existingMethod.selector).equals(name)) {
                ((SourceTypeBinding)existingMethod.declaringClass).resolveTypesFor(existingMethod);
                boolean equalParameters = true;
                if (parameterTypes == null) {
                    if (existingMethod.parameters.length != 0) {
                        equalParameters = false;
                    }
                } else if (existingMethod.parameters.length == parameterTypes.length) {
                    TypeBinding[] existingParams = existingMethod.parameters;
                    int p = 0;
                    int max = parameterTypes.length;
                    while (p < max) {
                        if (!CharOperation.equals((char[])parameterTypes[p].signature(), (char[])existingParams[p].signature())) {
                            equalParameters = false;
                            break;
                        }
                        ++p;
                    }
                }
                if (equalParameters) {
                    found = true;
                    break;
                }
            }
            ++n2;
        }
        if (!found) {
            int modifiers = 1;
            if (isStatic) {
                modifiers |= 8;
            }
            if (this.referenceContext.binding.isInterface()) {
                modifiers |= 0x400;
            }
            char[] methodName = name.toCharArray();
            MethodBinding mb = new MethodBinding(modifiers, methodName, returnType, parameterTypes, null, (ReferenceBinding)this.referenceContext.binding);
            groovyMethods.add(mb);
        }
    }

    private void createGetterMethod(String propertyName, String name, boolean isStatic, List<MethodBinding> groovyMethods, MethodBinding[] existingMethods, GroovyTypeDeclaration typeDeclaration) {
        boolean found = false;
        char[] nameAsCharArray = name.toCharArray();
        MethodBinding[] methodBindingArray = existingMethods;
        int n = existingMethods.length;
        int n2 = 0;
        while (n2 < n) {
            MethodBinding existingMethod = methodBindingArray[n2];
            if (CharOperation.equals((char[])nameAsCharArray, (char[])existingMethod.selector)) {
                if ((existingMethod.modifiers & 0x2000000) != 0) {
                    Argument[] arguments;
                    AbstractMethodDeclaration methodDecl = existingMethod.sourceMethod();
                    if (methodDecl != null && ((arguments = methodDecl.arguments) == null || arguments.length == 0)) {
                        found = true;
                    }
                } else {
                    TypeBinding[] existingParams = existingMethod.parameters;
                    if (existingParams == null || existingParams.length == 0) {
                        found = true;
                    }
                }
            }
            ++n2;
        }
        if (!found) {
            int modifiers = 1;
            if (isStatic) {
                modifiers |= 8;
            }
            if (this.referenceContext.binding.isInterface()) {
                modifiers |= 0x400;
            }
            LazilyResolvedMethodBinding mb = new LazilyResolvedMethodBinding(true, propertyName, modifiers, nameAsCharArray, null, (ReferenceBinding)this.referenceContext.binding);
            groovyMethods.add((MethodBinding)mb);
        }
    }

    private void createSetterMethod(String propertyName, String name, boolean isStatic, List<MethodBinding> groovyMethods, MethodBinding[] existingMethods, GroovyTypeDeclaration typeDeclaration, String propertyType) {
        boolean found = false;
        char[] nameAsCharArray = name.toCharArray();
        MethodBinding[] methodBindingArray = existingMethods;
        int n = existingMethods.length;
        int n2 = 0;
        while (n2 < n) {
            MethodBinding existingMethod = methodBindingArray[n2];
            if (CharOperation.equals((char[])nameAsCharArray, (char[])existingMethod.selector)) {
                if ((existingMethod.modifiers & 0x2000000) != 0) {
                    Argument[] arguments;
                    AbstractMethodDeclaration methodDecl = existingMethod.sourceMethod();
                    if (methodDecl != null && (arguments = methodDecl.arguments) != null && arguments.length == 1) {
                        found = true;
                    }
                } else {
                    TypeBinding[] existingParams = existingMethod.parameters;
                    if (existingParams != null && existingParams.length == 1) {
                        found = true;
                    }
                }
            }
            ++n2;
        }
        if (!found) {
            int modifiers = 1;
            if (isStatic) {
                modifiers |= 8;
            }
            if (this.referenceContext.binding.isInterface()) {
                modifiers |= 0x400;
            }
            char[] methodName = name.toCharArray();
            LazilyResolvedMethodBinding mb = new LazilyResolvedMethodBinding(false, propertyName, modifiers, methodName, null, (ReferenceBinding)this.referenceContext.binding);
            groovyMethods.add((MethodBinding)mb);
        }
    }

    public boolean shouldReport(int problem) {
        if (problem == 16777528) {
            return false;
        }
        if (problem == 67109268) {
            return false;
        }
        if (problem == 67109264) {
            return false;
        }
        if (problem == 67109424) {
            return false;
        }
        return problem != 67109667;
    }

    public MethodBinding[] getAnyExtraMethods(char[] selector) {
        return null;
    }

    protected ClassScope buildClassScope(Scope parent, TypeDeclaration typeDecl) {
        return new GroovyClassScope(parent, typeDecl);
    }

    public void buildFieldsAndMethods() {
        int n;
        int n2;
        GroovyTypeDeclaration[] groovyTypeDeclarationArray;
        super.buildFieldsAndMethods();
        GroovyTypeDeclaration context = (GroovyTypeDeclaration)this.referenceContext;
        GroovyTypeDeclaration[] anonymousTypes = context.getAnonymousTypes();
        if (anonymousTypes != null) {
            groovyTypeDeclarationArray = anonymousTypes;
            n2 = anonymousTypes.length;
            n = 0;
            while (n < n2) {
                GroovyTypeDeclaration anonType = groovyTypeDeclarationArray[n];
                GroovyClassScope anonScope = new GroovyClassScope((Scope)this, anonType);
                anonType.scope = anonScope;
                anonType.resolve((BlockScope)anonType.enclosingMethod.scope);
                ++n;
            }
        }
        groovyTypeDeclarationArray = this.referenceContext.binding.methods();
        n2 = groovyTypeDeclarationArray.length;
        n = 0;
        while (n < n2) {
            GroovyTypeDeclaration method = groovyTypeDeclarationArray[n];
            this.fixupTypeParameters((MethodBinding)method);
            ++n;
        }
    }

    private void fixupTypeParameters(MethodBinding method) {
        if (method.typeVariables == null || method.typeVariables.length == 0) {
            return;
        }
        if (method.parameters == null || method.parameters.length == 0) {
            return;
        }
        HashMap<String, TypeVariableBinding> bindings = new HashMap<String, TypeVariableBinding>();
        TypeVariableBinding[] typeVariableBindingArray = method.typeVariables;
        int n = method.typeVariables.length;
        int n2 = 0;
        while (n2 < n) {
            TypeVariableBinding v = typeVariableBindingArray[n2];
            bindings.put(new String(v.sourceName), v);
            ++n2;
        }
        typeVariableBindingArray = method.parameters;
        n = method.parameters.length;
        n2 = 0;
        while (n2 < n) {
            TypeBinding[] arguments;
            TypeVariableBinding parameter = typeVariableBindingArray[n2];
            if (parameter instanceof ParameterizedTypeBinding && (arguments = ((ParameterizedTypeBinding)parameter).arguments) != null) {
                int i = 0;
                int n3 = arguments.length;
                while (i < n3) {
                    String name;
                    TypeBinding argument;
                    if (arguments[i] instanceof TypeVariableBinding && (argument = (TypeBinding)bindings.get(name = new String(arguments[i].sourceName()))) != null && arguments[i].id != argument.id) {
                        arguments[i] = argument;
                    }
                    ++i;
                }
            }
            ++n2;
        }
    }

    private class TraitHelper {
        private boolean toBeInitialized = true;
        private boolean lookForTraitAlias = false;

        private TraitHelper() {
        }

        private void initialize() {
            ImportBinding[] imports = GroovyClassScope.this.referenceContext.scope.compilationUnitScope().imports;
            if (imports != null) {
                ImportBinding[] importBindingArray = imports;
                int n = imports.length;
                int n2 = 0;
                while (n2 < n) {
                    ImportBinding i = importBindingArray[n2];
                    String importedType = new String(i.readableName());
                    if ("groovy.transform.Trait".equals(importedType)) {
                        this.lookForTraitAlias = true;
                        break;
                    }
                    if (importedType.endsWith(".Trait")) {
                        this.lookForTraitAlias = false;
                        break;
                    }
                    if ("groovy.transform.*".equals(importedType)) {
                        this.lookForTraitAlias = true;
                    }
                    ++n2;
                }
                this.toBeInitialized = true;
            }
        }

        private boolean isTrait(ReferenceBinding referenceBinding) {
            AnnotationBinding[] annotations;
            if (referenceBinding == null) {
                return false;
            }
            if (this.toBeInitialized) {
                this.initialize();
            }
            if ((annotations = referenceBinding.getAnnotations()) != null) {
                AnnotationBinding[] annotationBindingArray = annotations;
                int n = annotations.length;
                int n2 = 0;
                while (n2 < n) {
                    AnnotationBinding annotation = annotationBindingArray[n2];
                    String annotationName = CharOperation.toString((char[][])annotation.getAnnotationType().compoundName);
                    if ("groovy.transform.Trait".equals(annotationName)) {
                        return true;
                    }
                    if (this.lookForTraitAlias && "Trait".equals(annotationName)) {
                        return true;
                    }
                    ++n2;
                }
            }
            return false;
        }
    }
}

