/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jdt.groovy.internal.compiler.ast;

import groovy.lang.GroovyClassLoader;
import java.util.List;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.classgen.GeneratorContext;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.jdt.groovy.control.EclipseSourceUnit;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;

public class GrailsGlobalPluginAwareEntityInjector
extends CompilationUnit.PrimaryClassNodeOperation {
    private static final boolean DEBUG = false;
    private GroovyClassLoader groovyClassLoader;
    private boolean broken = false;

    private static void debug(String msg) {
        System.out.println(msg);
    }

    public GrailsGlobalPluginAwareEntityInjector(GroovyClassLoader groovyClassLoader) {
        this.groovyClassLoader = groovyClassLoader;
    }

    public void call(SourceUnit _sourceUnit, GeneratorContext context, ClassNode classNode) throws CompilationFailedException {
        if (this.broken) {
            return;
        }
        if (_sourceUnit instanceof EclipseSourceUnit) {
            EclipseSourceUnit sourceUnit = (EclipseSourceUnit)_sourceUnit;
            try {
                if (classNode.isAnnotationDefinition()) {
                    return;
                }
                if (!this.isFirstClassInModule(classNode)) {
                    return;
                }
                IFile file = sourceUnit.getEclipseFile();
                PluginInfo info = GrailsGlobalPluginAwareEntityInjector.getInfo(file);
                if (info != null) {
                    Class<?> GrailsPlugin_class = Class.forName("org.codehaus.groovy.grails.plugins.metadata.GrailsPlugin", false, (ClassLoader)this.groovyClassLoader);
                    ClassNode annotation = new ClassNode(GrailsPlugin_class);
                    List list = classNode.getAnnotations(annotation);
                    if (!list.isEmpty()) {
                        return;
                    }
                    AnnotationNode annotationNode = new AnnotationNode(annotation);
                    annotationNode.addMember("name", (Expression)new ConstantExpression((Object)info.name));
                    annotationNode.addMember("version", (Expression)new ConstantExpression((Object)info.version));
                    annotationNode.setRuntimeRetention(true);
                    annotationNode.setClassRetention(true);
                    classNode.addAnnotation(annotationNode);
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                this.broken = true;
            }
        }
    }

    private boolean isFirstClassInModule(ClassNode classNode) {
        List classes;
        ModuleNode module = classNode.getModule();
        if (module != null && (classes = module.getClasses()) != null && classes.size() > 0) {
            return classes.get(0) == classNode;
        }
        return false;
    }

    public static PluginInfo getInfo(IFile file) {
        String pluginNameAndVersion;
        int split;
        String link;
        if (file == null) {
            return null;
        }
        IPath path = file.getFullPath();
        if (path != null && path.segmentCount() > 3 && (link = path.segment(1)).equals(".link_to_grails_plugins") && (split = GrailsGlobalPluginAwareEntityInjector.findVersionDash(pluginNameAndVersion = path.segment(2))) >= 0) {
            if ("test".equals(path.segment(3))) {
                return null;
            }
            return new PluginInfo(pluginNameAndVersion.substring(0, split), pluginNameAndVersion.substring(split + 1));
        }
        return null;
    }

    private static int findVersionDash(String pluginNameAndVersion) {
        int split = pluginNameAndVersion.lastIndexOf(45);
        if (pluginNameAndVersion.endsWith("-SNAPSHOT")) {
            split = pluginNameAndVersion.lastIndexOf(45, split - 1);
        }
        return split;
    }

    private static class PluginInfo {
        final String name;
        final String version;

        public PluginInfo(String name, String version) {
            this.name = name;
            this.version = version;
        }

        public String toString() {
            return "Plugin(name=" + this.name + ", version=" + this.version + ")";
        }
    }
}

