/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jdt.groovy.integration.internal;

import java.util.Collections;
import org.codehaus.jdt.groovy.internal.compiler.ast.GroovyParser;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.groovy.core.util.ContentTypeUtils;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.ISourceElementRequestor;
import org.eclipse.jdt.internal.compiler.SourceElementNotifier;
import org.eclipse.jdt.internal.compiler.SourceElementParser;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.QualifiedAllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.jdt.internal.compiler.util.HashtableOfObjectToInt;

public class MultiplexingSourceElementRequestorParser
extends SourceElementParser {
    ISourceElementRequestor groovyRequestor;
    SourceElementNotifier notifier;
    boolean groovyReportReferenceInfo;
    private GroovyParser parser;

    public MultiplexingSourceElementRequestorParser(ProblemReporter problemReporter, ISourceElementRequestor requestor, IProblemFactory problemFactory, CompilerOptions options, boolean reportLocalDeclarations, boolean optimizeStringLiterals) {
        super(requestor, problemFactory, options, reportLocalDeclarations, optimizeStringLiterals);
        this.groovyRequestor = requestor;
        this.notifier = new SourceElementNotifier(requestor, reportLocalDeclarations);
        this.parser = new GroovyParser(requestor, this.options, problemReporter, false, true);
    }

    public CompilationUnitDeclaration parseCompilationUnit(ICompilationUnit unit, boolean fullParse, IProgressMonitor pm) {
        if (ContentTypeUtils.isGroovyLikeFileName(unit.getFileName())) {
            CompilationResult compilationResult = new CompilationResult(unit, 0, 0, this.options.maxProblemsPerUnit);
            CompilationUnitDeclaration cud = new GroovyParser(this.parser.requestor, this.options, this.problemReporter, false, true).dietParse(unit, compilationResult);
            HashtableOfObjectToInt sourceEnds = this.createSourceEnds(cud);
            this.notifier.notifySourceElementRequestor(cud, 0, unit.getContents().length, this.groovyReportReferenceInfo, sourceEnds, Collections.EMPTY_MAP);
            return cud;
        }
        return super.parseCompilationUnit(unit, fullParse, pm);
    }

    public CompilationUnitDeclaration dietParse(ICompilationUnit sourceUnit, CompilationResult compilationResult) {
        if (ContentTypeUtils.isGroovyLikeFileName(sourceUnit.getFileName())) {
            return this.parser.dietParse(sourceUnit, compilationResult);
        }
        return super.dietParse(sourceUnit, compilationResult);
    }

    private HashtableOfObjectToInt createSourceEnds(CompilationUnitDeclaration cDecl) {
        HashtableOfObjectToInt table = new HashtableOfObjectToInt();
        if (cDecl.types != null) {
            TypeDeclaration[] typeDeclarationArray = cDecl.types;
            int n = cDecl.types.length;
            int n2 = 0;
            while (n2 < n) {
                TypeDeclaration tDecl = typeDeclarationArray[n2];
                this.createSourceEndsForType(tDecl, table);
                ++n2;
            }
        }
        return table;
    }

    public void reset() {
        this.parser.reset();
    }

    private void createSourceEndsForType(TypeDeclaration tDecl, HashtableOfObjectToInt table) {
        int n;
        int n2;
        FieldDeclaration[] fieldDeclarationArray;
        table.put((Object)tDecl, tDecl.sourceEnd);
        if (tDecl.fields != null) {
            fieldDeclarationArray = tDecl.fields;
            n2 = tDecl.fields.length;
            n = 0;
            while (n < n2) {
                FieldDeclaration fDecl = fieldDeclarationArray[n];
                table.put((Object)fDecl, fDecl.sourceEnd);
                ++n;
            }
        }
        if (tDecl.methods != null) {
            fieldDeclarationArray = tDecl.methods;
            n2 = tDecl.methods.length;
            n = 0;
            while (n < n2) {
                FieldDeclaration mDecl = fieldDeclarationArray[n];
                table.put((Object)mDecl, mDecl.sourceEnd);
                if (mDecl.statements != null && mDecl.statements.length > 0) {
                    Statement[] statementArray = mDecl.statements;
                    int n3 = mDecl.statements.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Statement expr = statementArray[n4];
                        if (expr instanceof QualifiedAllocationExpression) {
                            this.createSourceEndsForType(((QualifiedAllocationExpression)expr).anonymousType, table);
                        }
                        ++n4;
                    }
                }
                ++n;
            }
        }
        if (tDecl.memberTypes != null) {
            fieldDeclarationArray = tDecl.memberTypes;
            n2 = tDecl.memberTypes.length;
            n = 0;
            while (n < n2) {
                FieldDeclaration innerTDecl = fieldDeclarationArray[n];
                this.createSourceEndsForType((TypeDeclaration)innerTDecl, table);
                ++n;
            }
        }
    }
}

