/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jdt.groovy.integration.internal;

import java.util.Collections;
import org.codehaus.jdt.groovy.integration.internal.GroovyIndexingVisitor;
import org.codehaus.jdt.groovy.internal.compiler.ast.GroovyCompilationUnitDeclaration;
import org.codehaus.jdt.groovy.internal.compiler.ast.GroovyParser;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.groovy.core.util.ContentTypeUtils;
import org.eclipse.jdt.groovy.core.util.ReflectionUtils;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.ISourceElementRequestor;
import org.eclipse.jdt.internal.compiler.SourceElementNotifier;
import org.eclipse.jdt.internal.compiler.SourceElementParser;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.util.HashtableOfObjectToInt;
import org.eclipse.jdt.internal.core.search.indexing.IndexingParser;

public class MultiplexingIndexingParser
extends IndexingParser {
    SourceElementNotifier notifier = (SourceElementNotifier)ReflectionUtils.getPrivateField(SourceElementParser.class, "notifier", (Object)this);
    boolean groovyReportReferenceInfo;
    ISourceElementRequestor requestor;

    public MultiplexingIndexingParser(ISourceElementRequestor requestor, IProblemFactory problemFactory, CompilerOptions options, boolean reportLocalDeclarations, boolean optimizeStringLiterals, boolean useSourceJavadocParser) {
        super(requestor, problemFactory, options, reportLocalDeclarations, optimizeStringLiterals, useSourceJavadocParser);
        this.groovyReportReferenceInfo = reportLocalDeclarations;
        this.requestor = requestor;
    }

    public void setRequestor(ISourceElementRequestor requestor) {
        super.setRequestor(requestor);
        this.requestor = requestor;
    }

    public CompilationUnitDeclaration parseCompilationUnit(ICompilationUnit unit, boolean fullParse, IProgressMonitor pm) {
        if (ContentTypeUtils.isGroovyLikeFileName(unit.getFileName())) {
            CompilationResult compilationResult = new CompilationResult(unit, 0, 0, this.options.maxProblemsPerUnit);
            GroovyCompilationUnitDeclaration cud = (GroovyCompilationUnitDeclaration)new GroovyParser(this.options, this.problemReporter, false, true).dietParse(unit, compilationResult);
            HashtableOfObjectToInt sourceEnds = this.createSourceEnds(cud);
            GroovyIndexingVisitor visitor = new GroovyIndexingVisitor(this.requestor);
            visitor.doVisit(cud.getModuleNode(), cud.currentPackage);
            this.notifier.notifySourceElementRequestor((CompilationUnitDeclaration)cud, 0, unit.getContents().length, this.groovyReportReferenceInfo, sourceEnds, Collections.EMPTY_MAP);
            return cud;
        }
        return super.parseCompilationUnit(unit, fullParse, pm);
    }

    private HashtableOfObjectToInt createSourceEnds(CompilationUnitDeclaration cDecl) {
        HashtableOfObjectToInt table = new HashtableOfObjectToInt();
        if (cDecl.types != null) {
            TypeDeclaration[] typeDeclarationArray = cDecl.types;
            int n = cDecl.types.length;
            int n2 = 0;
            while (n2 < n) {
                TypeDeclaration tDecl = typeDeclarationArray[n2];
                this.createSourceEndsForType(tDecl, table);
                ++n2;
            }
        }
        return table;
    }

    private void createSourceEndsForType(TypeDeclaration tDecl, HashtableOfObjectToInt table) {
        int n;
        int n2;
        FieldDeclaration[] fieldDeclarationArray;
        table.put((Object)tDecl, tDecl.sourceEnd);
        if (tDecl.fields != null) {
            fieldDeclarationArray = tDecl.fields;
            n2 = tDecl.fields.length;
            n = 0;
            while (n < n2) {
                FieldDeclaration fDecl = fieldDeclarationArray[n];
                table.put((Object)fDecl, fDecl.sourceEnd);
                ++n;
            }
        }
        if (tDecl.methods != null) {
            fieldDeclarationArray = tDecl.methods;
            n2 = tDecl.methods.length;
            n = 0;
            while (n < n2) {
                FieldDeclaration mDecl = fieldDeclarationArray[n];
                table.put((Object)mDecl, mDecl.sourceEnd);
                ++n;
            }
        }
        if (tDecl.memberTypes != null) {
            fieldDeclarationArray = tDecl.memberTypes;
            n2 = tDecl.memberTypes.length;
            n = 0;
            while (n < n2) {
                FieldDeclaration innerTDecl = fieldDeclarationArray[n];
                this.createSourceEndsForType((TypeDeclaration)innerTDecl, table);
                ++n;
            }
        }
    }
}

