/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.custom.parser;

import groovyjarjarasm.asm.Label;
import groovyjarjarasm.asm.MethodVisitor;
import groovyjarjarasm.asm.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

class ParameterNameMethodVisitor
extends MethodVisitor {
    private final boolean isStatic;
    private final List<Type> parameterTypes;
    private final String[] slotNames;

    ParameterNameMethodVisitor(boolean isStatic, List<Type> parameterTypes) {
        super(327680);
        this.isStatic = isStatic;
        this.parameterTypes = parameterTypes;
        int parameterSlots = 0;
        if (!isStatic) {
            ++parameterSlots;
        }
        for (Type parameterType : parameterTypes) {
            parameterSlots += parameterType.getSize();
        }
        this.slotNames = new String[parameterSlots];
    }

    public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
        if (index < this.slotNames.length) {
            this.slotNames[index] = name;
        }
    }

    List<String> getParamterNames() {
        int slot = 0;
        if (!this.isStatic) {
            ++slot;
        }
        ArrayList<String> result = new ArrayList<String>();
        for (Type parameterType : this.parameterTypes) {
            String slotName = this.slotNames[slot];
            if (slotName == null) {
                return Collections.unmodifiableList(result);
            }
            result.add(slotName);
            slot += parameterType.getSize();
        }
        return Collections.unmodifiableList(result);
    }
}

