/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.explorer.providers;

import com.kms.katalon.composer.components.impl.tree.CheckpointTreeEntity;
import com.kms.katalon.composer.components.impl.tree.FolderTreeEntity;
import com.kms.katalon.composer.components.impl.tree.SystemFileTreeEntity;
import com.kms.katalon.composer.components.impl.tree.TestCaseTreeEntity;
import com.kms.katalon.composer.components.impl.tree.TestDataTreeEntity;
import com.kms.katalon.composer.components.impl.tree.TestSuiteCollectionTreeEntity;
import com.kms.katalon.composer.components.impl.tree.TestSuiteTreeEntity;
import com.kms.katalon.composer.components.impl.tree.WebElementTreeEntity;
import com.kms.katalon.composer.components.impl.util.EntityProcessingUtil;
import com.kms.katalon.composer.components.impl.util.TreeEntityUtil;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.composer.explorer.constants.StringConstants;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.SystemFileController;
import com.kms.katalon.entity.checkpoint.CheckpointEntity;
import com.kms.katalon.entity.file.SystemFileEntity;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.repository.WebElementEntity;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.entity.testdata.DataFileEntity;
import com.kms.katalon.entity.testsuite.TestSuiteCollectionEntity;
import com.kms.katalon.entity.testsuite.TestSuiteEntity;
import java.text.MessageFormat;
import org.apache.commons.lang.StringUtils;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.TreeDropTargetEffect;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class TreeEntityDropListener
extends TreeDropTargetEffect {
    private IEventBroker eventBroker;
    private ITreeEntity lastMovedTreeEntity;

    public TreeEntityDropListener(TreeViewer treeViewer, IEventBroker eventBroker) {
        super(treeViewer.getTree());
        this.eventBroker = eventBroker;
    }

    public void drop(DropTargetEvent event) {
        try {
            if (event.data instanceof ITreeEntity[]) {
                ITreeEntity[] treeEntities = (ITreeEntity[])event.data;
                FolderTreeEntity targetTreeEntity = this.getDropDestinationFolder(event);
                FolderEntity target = targetTreeEntity.getObject();
                this.move(treeEntities, target, targetTreeEntity);
                this.eventBroker.send("EXPLORER/REFRESH_TREE_ENTITY", (Object)targetTreeEntity);
                this.eventBroker.send("EXPLORER/SET_SELECTED_ITEM", (Object)this.lastMovedTreeEntity);
            }
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)StringConstants.ERROR, (String)MessageFormat.format(StringConstants.LIS_ERROR_MSG_CANNOT_MOVE_THE_SELECTION, e.getMessage()));
        }
    }

    private FolderTreeEntity getDropDestinationFolder(DropTargetEvent event) throws Exception {
        Object dest = event.item.getData();
        if (dest instanceof FolderTreeEntity) {
            return (FolderTreeEntity)dest;
        }
        return (FolderTreeEntity)((ITreeEntity)dest).getParent();
    }

    private void move(ITreeEntity[] treeEntities, FolderEntity targetFolder, FolderTreeEntity targetTreeEntity) throws Exception {
        FolderEntity rootTargetFolder = null;
        if (targetFolder.getFolderType().equals((Object)FolderEntity.FolderType.TESTCASE)) {
            rootTargetFolder = FolderController.getInstance().getTestCaseRoot(targetFolder.getProject());
        } else if (targetFolder.getFolderType().equals((Object)FolderEntity.FolderType.TESTSUITE)) {
            rootTargetFolder = FolderController.getInstance().getTestSuiteRoot(targetFolder.getProject());
        } else if (targetFolder.getFolderType().equals((Object)FolderEntity.FolderType.WEBELEMENT)) {
            rootTargetFolder = FolderController.getInstance().getObjectRepositoryRoot(targetFolder.getProject());
        } else if (targetFolder.getFolderType().equals((Object)FolderEntity.FolderType.DATAFILE)) {
            rootTargetFolder = FolderController.getInstance().getTestDataRoot(targetFolder.getProject());
        } else if (targetFolder.getFolderType().equals((Object)FolderEntity.FolderType.CHECKPOINT)) {
            rootTargetFolder = FolderController.getInstance().getCheckpointRoot(targetFolder.getProject());
        }
        ITreeEntity[] iTreeEntityArray = treeEntities;
        int n = treeEntities.length;
        int n2 = 0;
        while (n2 < n) {
            ITreeEntity treeEntity = iTreeEntityArray[n2];
            if (treeEntity.isRemoveable()) {
                this.validateMovingAcrossArea(treeEntity, targetFolder);
                if (treeEntity instanceof FolderTreeEntity) {
                    this.validateMovingToSubFolder((FolderEntity)treeEntity.getObject(), targetFolder);
                }
                if (!targetFolder.equals(treeEntity.getObject())) {
                    if (treeEntity.getParent() == null || targetFolder.equals(treeEntity.getParent().getObject())) {
                        this.lastMovedTreeEntity = treeEntity;
                    } else {
                        WebElementEntity movedTo;
                        if (treeEntity instanceof TestCaseTreeEntity) {
                            TestCaseEntity movedTc = EntityProcessingUtil.moveTestCase((TestCaseEntity)((TestCaseTreeEntity)treeEntity).getObject(), (FolderEntity)targetFolder);
                            this.lastMovedTreeEntity = TreeEntityUtil.getTestCaseTreeEntity((TestCaseEntity)movedTc, (ProjectEntity)targetFolder.getProject());
                        } else if (treeEntity instanceof FolderTreeEntity) {
                            FolderEntity movedFolder = EntityProcessingUtil.moveFolder((FolderEntity)((FolderTreeEntity)treeEntity).getObject(), (FolderEntity)targetFolder);
                            this.lastMovedTreeEntity = TreeEntityUtil.createSelectedTreeEntityHierachy((FolderEntity)movedFolder, (FolderEntity)rootTargetFolder);
                        } else if (treeEntity instanceof TestSuiteTreeEntity) {
                            TestSuiteEntity movedTs = EntityProcessingUtil.moveTestSuite((TestSuiteEntity)((TestSuiteTreeEntity)treeEntity).getObject(), (FolderEntity)targetFolder);
                            this.lastMovedTreeEntity = TreeEntityUtil.getTestSuiteTreeEntity((TestSuiteEntity)movedTs, (ProjectEntity)targetFolder.getProject());
                        } else if (treeEntity instanceof TestDataTreeEntity) {
                            DataFileEntity movedTd = EntityProcessingUtil.moveTestData((DataFileEntity)((TestDataTreeEntity)treeEntity).getObject(), (FolderEntity)targetFolder);
                            this.lastMovedTreeEntity = TreeEntityUtil.getTestDataTreeEntity((DataFileEntity)movedTd, (ProjectEntity)targetFolder.getProject());
                        } else if (treeEntity instanceof WebElementTreeEntity) {
                            movedTo = EntityProcessingUtil.moveTestObject((WebElementEntity)((WebElementEntity)((WebElementTreeEntity)treeEntity).getObject()), (FolderEntity)targetFolder);
                            this.lastMovedTreeEntity = TreeEntityUtil.getWebElementTreeEntity((WebElementEntity)movedTo, (ProjectEntity)targetFolder.getProject());
                        } else if (treeEntity instanceof TestSuiteCollectionTreeEntity) {
                            movedTo = EntityProcessingUtil.moveTestSuiteCollection((TestSuiteCollectionEntity)((TestSuiteCollectionEntity)((TestSuiteCollectionTreeEntity)treeEntity).getObject()), (FolderEntity)targetFolder);
                            this.lastMovedTreeEntity = TreeEntityUtil.getTestSuiteCollectionTreeEntity((TestSuiteCollectionEntity)movedTo, (ProjectEntity)targetFolder.getProject());
                        } else if (treeEntity instanceof CheckpointTreeEntity) {
                            CheckpointEntity movedCheckpoint = EntityProcessingUtil.moveCheckpoint((CheckpointEntity)((CheckpointTreeEntity)treeEntity).getObject(), (FolderEntity)targetFolder);
                            this.lastMovedTreeEntity = TreeEntityUtil.getCheckpointTreeEntity((CheckpointEntity)movedCheckpoint);
                        } else if (treeEntity instanceof SystemFileTreeEntity) {
                            SystemFileTreeEntity systemFileTreeEntity = (SystemFileTreeEntity)treeEntity;
                            SystemFileEntity newSystemFile = SystemFileController.getInstance().moveSystemFile(systemFileTreeEntity.getObject(), targetFolder);
                            if (newSystemFile != null) {
                                this.lastMovedTreeEntity = new SystemFileTreeEntity(newSystemFile, targetTreeEntity);
                            }
                        }
                        this.eventBroker.send("EXPLORER/REFRESH_TREE_ENTITY", (Object)treeEntity.getParent());
                    }
                }
            }
            ++n2;
        }
    }

    private void validateMovingAcrossArea(ITreeEntity treeEntity, FolderEntity targetFolder) throws Exception {
        FolderTreeEntity temp;
        FolderTreeEntity folderTreeEntity = temp = treeEntity instanceof FolderTreeEntity ? (FolderTreeEntity)treeEntity : (FolderTreeEntity)treeEntity.getParent();
        if (!StringUtils.equals((String)temp.getCopyTag(), (String)targetFolder.getFolderType().toString())) {
            throw new Exception(MessageFormat.format(StringConstants.LIS_ERROR_MSG_CANNOT_MOVE_INTO_DIFF_REGION, treeEntity.getCopyTag(), targetFolder.getFolderType().toString()));
        }
    }

    private void validateMovingToSubFolder(FolderEntity folderEntity, FolderEntity targetFolder) throws Exception {
        FolderEntity parent = targetFolder.getParentFolder();
        while (parent != null) {
            if (parent.equals((Object)folderEntity)) {
                throw new Exception(MessageFormat.format(StringConstants.LIS_ERROR_MSG_CANNOT_MOVE_TO_SUBFOLDER, folderEntity.getName(), targetFolder.getName()));
            }
            parent = parent.getParentFolder();
        }
    }

    public void dragOver(DropTargetEvent event) {
        event.feedback = 17;
        super.dragOver(event);
    }
}

