/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.explorer.providers;

import com.kms.katalon.composer.components.impl.providers.CellLayoutInfo;
import com.kms.katalon.composer.components.impl.providers.DefaultCellLayoutInfo;
import com.kms.katalon.composer.components.impl.providers.IEntityLabelProvider;
import com.kms.katalon.composer.components.impl.providers.TypeCheckedStyleTreeCellLabelProvider;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.explorer.integration.IntegrationLabelDecorator;
import com.kms.katalon.composer.explorer.integration.LabelDecoratorManager;
import com.kms.katalon.composer.explorer.providers.EntityViewerFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Event;

public class EntityLabelProvider
extends TypeCheckedStyleTreeCellLabelProvider<ITreeEntity>
implements IEntityLabelProvider {
    private static final int FIRST_COLUMN_IDX = 0;
    private static final String COLON = ":";
    private static final String NAME_TAG = "name";
    private List<IntegrationLabelDecorator> decorators = LabelDecoratorManager.getInstance().getSortedDecorator();
    private String searchString;
    private CellLayoutInfo cellLayoutInfo = new DefaultCellLayoutInfo(){

        public int getSpace() {
            return 5;
        }

        public int getLeftMargin() {
            return "win32".equals(Platform.getOS()) ? 0 : 2;
        }
    };

    public EntityLabelProvider() {
        super(0);
    }

    public void setSearchString(String searchString) {
        this.searchString = searchString;
    }

    protected StyleRange[] getStyleRanges(ViewerCell cell, ITreeEntity element) {
        if (StringUtils.isEmpty((String)this.searchString)) {
            return null;
        }
        String highlightString = this.findNameValueInSearchString(element);
        if (StringUtils.isEmpty((String)highlightString)) {
            return null;
        }
        String lowerCaseCellText = StringUtils.defaultString((String)cell.getText()).toLowerCase();
        if (!lowerCaseCellText.contains(highlightString)) {
            return null;
        }
        ArrayList<StyleRange> range = new ArrayList<StyleRange>();
        Matcher m = Pattern.compile(Pattern.quote(highlightString)).matcher(lowerCaseCellText);
        while (m.find()) {
            StyleRange highlightStyledRange = new StyleRange(m.start(), highlightString.length(), null, ColorUtil.getHighlightBackgroundColor());
            range.add(highlightStyledRange);
        }
        return range.toArray(new StyleRange[range.size()]);
    }

    private String findNameValueInSearchString(ITreeEntity entity) {
        try {
            String contentString = this.getContentString("all:");
            if (contentString == null) {
                contentString = this.getContentString(String.valueOf(entity.getKeyWord()) + COLON);
            }
            if (contentString == null) {
                return this.trimAndLowerCase(this.searchString);
            }
            Map<String, String> tagMap = EntityViewerFilter.parseSearchedString(entity.getSearchTags(), contentString);
            if (tagMap == null || tagMap.isEmpty()) {
                return contentString;
            }
            String nameValue = tagMap.get(NAME_TAG);
            return nameValue != null ? nameValue : contentString;
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
            return "";
        }
    }

    private String getContentString(String keyword) {
        String contentString = this.trimAndLowerCase(this.searchString);
        if (this.searchString.matches(this.getRegexForKeyword(keyword))) {
            return contentString.substring(keyword.length()).trim();
        }
        return null;
    }

    private String trimAndLowerCase(String searchString) {
        return StringUtils.trimToEmpty((String)searchString).toLowerCase();
    }

    private String getRegexForKeyword(String keyword) {
        return "^" + StringUtils.defaultString((String)keyword) + ".*$";
    }

    protected Class<ITreeEntity> getElementType() {
        return ITreeEntity.class;
    }

    protected Image getImage(ITreeEntity element) {
        try {
            return element.getImage();
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
            return null;
        }
    }

    protected String getText(ITreeEntity element) {
        try {
            return element.getText();
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
            return "";
        }
    }

    protected void measure(Event event, Object element) {
        super.measure(event, element);
        if ("win32".equals(Platform.getOS())) {
            ++event.width;
        }
        if (this.canNotDrawSafely(element)) {
            return;
        }
        ViewerCell cell = this.getOwnedViewerCell(event);
        if (this.isCellNotExisted(cell)) {
            return;
        }
        Image image = cell.getImage();
        if (image == null) {
            return;
        }
        event.height = Math.max(event.height, image.getBounds().height + 6);
    }

    public CellLayoutInfo getCellLayoutInfo() {
        return this.cellLayoutInfo;
    }

    protected int drawImage(Event event, ViewerCell cell, GC gc, Image image) {
        List<Image> overlayImages = this.getIntegrationImages((ITreeEntity)cell.getElement());
        Image drawnImage = image;
        if (!overlayImages.isEmpty()) {
            drawnImage = overlayImages.get(0);
        }
        return super.drawImage(event, cell, gc, drawnImage);
    }

    private List<Image> getIntegrationImages(ITreeEntity treeEntity) {
        return this.decorators.stream().filter(decorator -> decorator.getOverlayImage(treeEntity) != null).map(decorator -> decorator.getOverlayImage(treeEntity)).collect(Collectors.toList());
    }
}

