/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.explorer.parts;

import com.kms.katalon.composer.components.impl.control.CTreeViewer;
import com.kms.katalon.composer.components.impl.tree.FolderTreeEntity;
import com.kms.katalon.composer.components.impl.tree.KeywordTreeEntity;
import com.kms.katalon.composer.components.impl.tree.PackageTreeEntity;
import com.kms.katalon.composer.components.impl.tree.ReportTreeEntity;
import com.kms.katalon.composer.components.impl.util.TreeEntityUtil;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.explorer.constants.ImageConstants;
import com.kms.katalon.composer.explorer.constants.StringConstants;
import com.kms.katalon.composer.explorer.custom.AdvancedSearchDialog;
import com.kms.katalon.composer.explorer.custom.SearchDropDownBox;
import com.kms.katalon.composer.explorer.handlers.CopyHandler;
import com.kms.katalon.composer.explorer.handlers.CutHandler;
import com.kms.katalon.composer.explorer.handlers.DeleteHandler;
import com.kms.katalon.composer.explorer.handlers.PasteHandler;
import com.kms.katalon.composer.explorer.handlers.RefreshHandler;
import com.kms.katalon.composer.explorer.providers.EntityLabelProvider;
import com.kms.katalon.composer.explorer.providers.EntityProvider;
import com.kms.katalon.composer.explorer.providers.EntityViewerFilter;
import com.kms.katalon.composer.explorer.providers.TreeEntityDropListener;
import com.kms.katalon.composer.explorer.util.TransferTypeCollection;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.preferences.internal.PreferenceStoreManager;
import com.kms.katalon.preferences.internal.ScopedPreferenceStore;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.menu.MHandledToolItem;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBarElement;
import org.eclipse.e4.ui.services.EMenuService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class ExplorerPart {
    private static final String SEARCH_TEXT_DEFAULT_VALUE = StringConstants.PA_SEARCH_TEXT_DEFAULT_VALUE;
    private static final String EXPLORER_POPUPMENU_ID = "com.kms.katalon.composer.explorer.popupmenu";
    private static final String IMAGE_SEARCH_TOOLTIP = StringConstants.PA_IMAGE_TIP_SEARCH;
    private static final String IMAGE_CLOSE_SEARCH_TOOLTIP = StringConstants.PA_IMAGE_TIP_CLOSE_SEARCH;
    private static final String IMAGE_ADVANCED_SEARCH_TOOLTIP = StringConstants.PA_IMAGE_TIP_ADVANCED_SEARCH;
    private static final int KEYWORD_SEARCH_ALL_INDEX = 0;
    public static final String KEYWORD_SEARCH_ALL = "all";
    private DragSource dragSource;
    private Text txtInput;
    private CTreeViewer treeViewer;
    private CLabel lblSearch;
    private CLabel lblFilter;
    private SearchDropDownBox searchDropDownBox;
    private List<ITreeEntity> treeEntities;
    private boolean isSearching;
    private Object[] expandedTreeElements;
    @Inject
    private MApplication application;
    @Inject
    private ESelectionService selectionService;
    @Inject
    private EMenuService menuService;
    private EntityLabelProvider entityLabelProvider;
    private EntityViewerFilter entityViewerFilter;
    private Composite parent;
    private Composite searchComposite;
    @Inject
    private IEventBroker eventBroker;
    @Inject
    private EHandlerService handlerService;
    @Inject
    private EPartService partService;
    private MPart part;

    private TreeViewer getViewer() {
        return this.treeViewer;
    }

    private void setViewer(CTreeViewer viewer) {
        this.treeViewer = viewer;
    }

    @PostConstruct
    public void createPartControl(Composite parent, MPart mpart) {
        this.parent = parent;
        this.part = mpart;
        this.updateToolItemStatus();
        parent.setLayoutData((Object)new GridData(1808));
        parent.setLayout((Layout)new GridLayout(1, false));
        this.searchComposite = new Composite(parent, 2048);
        this.searchComposite.setBackground(ColorUtil.getWhiteBackgroundColor());
        GridLayout glSearchComposite = new GridLayout(6, false);
        glSearchComposite.verticalSpacing = 0;
        glSearchComposite.horizontalSpacing = 0;
        glSearchComposite.marginWidth = 0;
        glSearchComposite.marginHeight = 0;
        this.searchComposite.setLayout((Layout)glSearchComposite);
        GridData grSearchComposite = new GridData(768);
        grSearchComposite.heightHint = 24;
        this.searchComposite.setLayoutData((Object)grSearchComposite);
        this.searchDropDownBox = new SearchDropDownBox(this.searchComposite, 0, this);
        Label seperator = new Label(this.searchComposite, 514);
        GridData gdSeperator = new GridData(0x1000000, 0x1000000, false, false, 1, 1);
        gdSeperator.heightHint = 22;
        seperator.setLayoutData((Object)gdSeperator);
        this.txtInput = new Text(this.searchComposite, 0);
        this.txtInput.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        this.txtInput.setMessage(SEARCH_TEXT_DEFAULT_VALUE);
        GridData gdTxtInput = new GridData(768);
        gdTxtInput.grabExcessVerticalSpace = true;
        gdTxtInput.verticalAlignment = 0x1000000;
        this.txtInput.setLayoutData((Object)gdTxtInput);
        this.txtInput.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 13 || e.keyCode == 0x1000050) {
                    ExplorerPart.this.filterTreeEntitiesBySearchedText();
                }
            }
        });
        this.application.getContext().set(ExplorerPart.class.getName(), (Object)this);
        this.createExplorerTreeViewer();
        Canvas canvasSearch = new Canvas(this.searchComposite, 0);
        canvasSearch.setLayout((Layout)new FillLayout(256));
        this.isSearching = false;
        this.lblSearch = new CLabel((Composite)canvasSearch, 0);
        this.updateStatusSearchLabel();
        this.lblSearch.setCursor(new Cursor((Device)Display.getCurrent(), 21));
        this.lblSearch.addListener(4, new Listener(){

            public void handleEvent(Event event) {
                if (ExplorerPart.this.isSearching) {
                    ExplorerPart.this.isSearching = false;
                    ExplorerPart.this.txtInput.setText("");
                    ExplorerPart.this.filterTreeEntitiesBySearchedText();
                } else {
                    ExplorerPart.this.isSearching = true;
                    ExplorerPart.this.filterTreeEntitiesBySearchedText();
                }
            }
        });
        Label seperator1 = new Label(this.searchComposite, 514);
        GridData gdSeperator1 = new GridData(0x1000000, 0x1000000, false, false, 1, 1);
        gdSeperator1.heightHint = 22;
        seperator1.setLayoutData((Object)gdSeperator1);
        this.lblFilter = new CLabel(this.searchComposite, 0);
        this.lblFilter.setImage(ImageConstants.IMG_16_ADVANCED_SEARCH);
        this.lblFilter.setToolTipText(IMAGE_ADVANCED_SEARCH_TOOLTIP);
        this.lblFilter.setCursor(new Cursor((Device)Display.getCurrent(), 21));
        this.lblFilter.addListener(4, new Listener(){

            public void handleEvent(Event event) {
                ExplorerPart.this.openAdvancedSearchDialog();
            }
        });
        this.activateHandler();
    }

    private void createExplorerTreeViewerIfDisposed() {
        if (this.treeViewer != null && !this.treeViewer.getTree().isDisposed()) {
            return;
        }
        this.createExplorerTreeViewer();
        if (this.treeEntities == null || this.treeEntities.isEmpty()) {
            this.reloadTreeEventHandler(true);
        } else {
            this.getViewer().setInput(this.treeEntities);
        }
    }

    private void createExplorerTreeViewer() {
        this.setViewer(new CTreeViewer(this.parent, 268437506));
        Tree explorer = this.treeViewer.getTree();
        this.treeViewer.setUseHashlookup(true);
        explorer.setLayoutData((Object)new GridData(1808));
        explorer.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if ((e.stateMask & 0x40000) == 262144 && e.keyCode == 99) {
                    CopyHandler.getInstance().execute();
                }
            }
        });
        explorer.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                MPart activePart = ExplorerPart.this.partService.getActivePart();
                if (activePart == null || !"com.kms.katalon.composer.part.explorer".equals(activePart.getElementId())) {
                    ExplorerPart.this.partService.activate(ExplorerPart.this.partService.findPart("com.kms.katalon.composer.part.explorer"));
                }
                ExplorerPart.this.selectionService.setSelection((Object)ExplorerPart.this.treeViewer.getStructuredSelection().toArray());
            }
        });
        EntityProvider contentProvider = new EntityProvider();
        this.getViewer().setContentProvider((IContentProvider)contentProvider);
        this.entityLabelProvider = new EntityLabelProvider();
        this.getViewer().setLabelProvider((IBaseLabelProvider)this.entityLabelProvider);
        this.getViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (ExplorerPart.this.selectionService != null) {
                    ExplorerPart.this.selectionService.setSelection((Object)((IStructuredSelection)event.getSelection()).toArray());
                }
            }
        });
        this.entityViewerFilter = new EntityViewerFilter(contentProvider);
        this.getViewer().addFilter((ViewerFilter)this.entityViewerFilter);
        explorer.setToolTipText("");
        this.hookDoubleClickEvent();
        this.hookDragEvent();
        this.hookDropEvent();
        this.menuService.registerContextMenu((Object)this.getViewer().getControl(), EXPLORER_POPUPMENU_ID);
    }

    private void activateHandler() {
        this.handlerService.activateHandler("org.eclipse.ui.edit.delete", (Object)new DeleteHandler());
        this.handlerService.activateHandler("org.eclipse.ui.edit.copy", (Object)new CopyHandler());
        this.handlerService.activateHandler("org.eclipse.ui.edit.cut", (Object)new CutHandler());
        this.handlerService.activateHandler("org.eclipse.ui.edit.paste", (Object)new PasteHandler());
        this.handlerService.activateHandler("org.eclipse.ui.file.refresh", (Object)new RefreshHandler());
    }

    private void updateToolItemStatus() {
        ScopedPreferenceStore store = PreferenceStoreManager.getPreferenceStore(ExplorerPart.class);
        for (MToolBarElement toolbarElement : this.part.getToolbar().getChildren()) {
            if (!(toolbarElement instanceof MHandledToolItem)) continue;
            MHandledToolItem toolItem = (MHandledToolItem)toolbarElement;
            switch (toolItem.getElementId()) {
                case "com.kms.katalon.composer.explorer.handledtoolitem.linkPart": {
                    toolItem.setSelected(store.getBoolean("explorer.linkPart"));
                }
            }
        }
    }

    private String getMessage() {
        try {
            int index = this.searchDropDownBox.getSelectionIndex();
            if (index == 0) {
                return "all:" + this.txtInput.getText();
            }
            return String.valueOf(this.treeEntities.get(index - 1).getKeyWord()) + ":" + this.txtInput.getText();
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
            return "";
        }
    }

    public void filterTreeEntitiesByType() {
        this.fitlterTreeEntities(false, false);
        this.txtInput.setFocus();
    }

    private void filterTreeEntitiesBySearchedText() {
        this.fitlterTreeEntities(true, true);
    }

    private void fitlterTreeEntities(final boolean updateLabel, boolean keepExpandedState) {
        if (this.treeViewer.getTree().isDisposed()) {
            return;
        }
        final String searchString = this.txtInput.getText();
        while (this.treeViewer.isBusy()) {
        }
        if (!searchString.equals(this.txtInput.getText()) || this.treeViewer.getInput() == null) {
            return;
        }
        if (keepExpandedState && StringUtils.isNotBlank((String)searchString) && !this.isSearching) {
            this.expandedTreeElements = this.treeViewer.getExpandedElements();
        }
        Job job = new Job("Indexing..."){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    monitor.beginTask("Indexing...", ExplorerPart.this.treeEntities.size());
                    for (ITreeEntity folderEntity : ExplorerPart.this.treeEntities) {
                        try {
                            ((FolderTreeEntity)folderEntity).loadAllDescentdantEntities();
                            monitor.worked(1);
                        }
                        catch (Exception e) {
                            LoggerSingleton.logError((Throwable)e);
                        }
                    }
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                finally {
                    monitor.done();
                }
            }
        };
        job.setUser(true);
        job.schedule();
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                UISynchronizeService.syncExec((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        try {
                            try {
                                String broadcastMessage = ExplorerPart.this.getMessage();
                                ExplorerPart.this.entityLabelProvider.setSearchString(broadcastMessage);
                                ExplorerPart.this.entityViewerFilter.setSearchString(broadcastMessage);
                                ExplorerPart.this.treeViewer.getTree().setRedraw(false);
                                ExplorerPart.this.treeViewer.refresh(true);
                                if (StringUtils.isNotBlank((String)searchString)) {
                                    ExplorerPart.this.treeViewer.expandAll();
                                } else {
                                    ExplorerPart.this.treeViewer.collapseAll();
                                    if (ExplorerPart.this.expandedTreeElements != null) {
                                        Object[] objectArray = ExplorerPart.this.expandedTreeElements;
                                        int n = objectArray.length;
                                        int n2 = 0;
                                        while (n2 < n) {
                                            Object treePath = objectArray[n2];
                                            ExplorerPart.this.treeViewer.setExpandedState(treePath, true);
                                            ++n2;
                                        }
                                    }
                                }
                                if (updateLabel) {
                                    ExplorerPart.this.isSearching = StringUtils.isNotBlank((String)searchString);
                                    ExplorerPart.this.updateStatusSearchLabel();
                                }
                            }
                            catch (Exception e) {
                                LoggerSingleton.logError((Throwable)e);
                                ExplorerPart.this.treeViewer.getTree().setRedraw(true);
                            }
                        }
                        finally {
                            ExplorerPart.this.treeViewer.getTree().setRedraw(true);
                        }
                    }
                });
            }
        });
    }

    private void openAdvancedSearchDialog() {
        try {
            if (!this.getSearchDropBoxElements().isEmpty()) {
                AdvancedSearchDialog dialog;
                int selectionIndex = this.searchDropDownBox.getSelectionIndex();
                Shell shell = new Shell(this.parent.getShell());
                shell.setSize(0, 0);
                ArrayList<String> searchTags = new ArrayList<String>();
                Point pt = this.searchComposite.toDisplay(1, 1);
                Point location = new Point(pt.x + this.searchComposite.getBounds().width, pt.y);
                if (selectionIndex > 0) {
                    dialog = new AdvancedSearchDialog(shell, this.txtInput.getText(), location);
                } else {
                    for (ITreeEntity treeEntity : this.treeEntities) {
                        if (treeEntity.getSearchTags() == null) continue;
                        String[] stringArray = treeEntity.getSearchTags();
                        int n = stringArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String tag = stringArray[n2];
                            if (!searchTags.contains(tag)) {
                                searchTags.add(tag);
                            }
                            ++n2;
                        }
                    }
                    dialog = new AdvancedSearchDialog(shell, this.txtInput.getText(), location);
                }
                if (dialog.open() == 0) {
                    this.txtInput.setText(dialog.getOutput());
                    this.filterTreeEntitiesBySearchedText();
                }
                shell.getSize();
                shell.dispose();
            }
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    private void updateStatusSearchLabel() {
        if (this.lblSearch == null) {
            return;
        }
        if (this.isSearching) {
            this.lblSearch.setImage(ImageConstants.IMG_16_CLOSE_SEARCH);
            this.lblSearch.setToolTipText(IMAGE_CLOSE_SEARCH_TOOLTIP);
        } else {
            this.lblSearch.setImage(ImageConstants.IMG_16_SEARCH);
            this.lblSearch.setToolTipText(IMAGE_SEARCH_TOOLTIP);
        }
    }

    @Focus
    public void setFocus() {
        this.getViewer().getControl().setFocus();
        this.partService.activate(this.part, true);
    }

    @Inject
    @Optional
    private void reloadTreeEventHandler(@UIEventTopic(value="EXPLORER/RELOAD_DATA") Object isForcingReload) {
        try {
            if (!(isForcingReload instanceof Boolean) || ((Boolean)isForcingReload).booleanValue() || !((Boolean)isForcingReload).booleanValue() && (this.treeEntities == null || this.treeEntities.isEmpty())) {
                List treeEntities = TreeEntityUtil.getAllTreeEntity((ProjectEntity)ProjectController.getInstance().getCurrentProject());
                this.eventBroker.post("EXPLORER/RELOAD_INPUT", (Object)treeEntities);
            }
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    @Inject
    @Optional
    private void reloadTreeInputEventHandler(@UIEventTopic(value="EXPLORER/RELOAD_INPUT") List<Object> treeEntities) {
        try {
            if (this.treeViewer.getTree().isDisposed()) {
                return;
            }
            while (this.treeViewer.isBusy()) {
            }
            this.resetSearchField();
            this.searchDropDownBox.clearInput();
            this.treeViewer.getTree().clearAll(true);
            this.treeViewer.setInput(treeEntities);
            this.updateTreeEntities(treeEntities);
            this.treeViewer.refresh();
            this.reloadTreeEntityTransfers();
            EntityProvider dataProvider = (EntityProvider)this.treeViewer.getContentProvider();
            if (treeEntities != null && !treeEntities.isEmpty()) {
                this.getViewer().setSelection((ISelection)new TreeSelection(dataProvider.getTreePath(treeEntities.get(0))), true);
                this.getViewer().collapseAll();
            }
            this.part.getTransientData().put(CTreeViewer.class.getSimpleName(), this.treeViewer);
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    private void reloadTreeEntityTransfers() {
        List<Transfer> treeEntityTransfers = TransferTypeCollection.getInstance().getTreeEntityTransfer();
        this.dragSource.setTransfer(treeEntityTransfers.toArray(new Transfer[treeEntityTransfers.size()]));
    }

    private void resetSearchField() {
        this.txtInput.setText("");
        this.isSearching = false;
        this.updateStatusSearchLabel();
        this.entityLabelProvider.setSearchString("");
        this.entityViewerFilter.setSearchString("");
    }

    @Inject
    @Optional
    private void refreshTree(@UIEventTopic(value="EXPLORER/REFRESH") Object object) {
        this.refresh(null);
    }

    @Inject
    @Optional
    private void refreshTreeEntity(@UIEventTopic(value="EXPLORER/REFRESH_TREE_ENTITY") Object object) {
        this.refresh(object);
    }

    @Inject
    @Optional
    private void expandTreeEntity(@UIEventTopic(value="EXPLORER/EXPAND_TREE_ENTITY") Object object) {
        if (object == null) {
            return;
        }
        this.treeViewer.expandToLevel(object, 1);
    }

    private void refresh(Object object) {
        this.createExplorerTreeViewerIfDisposed();
        this.getViewer().getControl().setRedraw(false);
        try {
            ISelection selection = this.getViewer().getSelection();
            if (object == null) {
                Object[] visibleExpandedElements = this.getViewer().getVisibleExpandedElements();
                this.getViewer().collapseAll();
                this.getViewer().refresh();
                this.createExplorerTreeViewerIfDisposed();
                this.getViewer().setExpandedElements(visibleExpandedElements);
            } else {
                this.getViewer().refresh(object);
            }
            this.createExplorerTreeViewerIfDisposed();
            if (selection != null && TreeSelection.EMPTY.equals((Object)selection)) {
                this.getViewer().setSelection(selection);
            }
        }
        catch (SWTException e) {
            LoggerSingleton.logError((Throwable)e);
            this.createExplorerTreeViewerIfDisposed();
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
        this.getViewer().getControl().setRedraw(true);
    }

    @Inject
    @Optional
    private void setSelectedItem(@UIEventTopic(value="EXPLORER/SET_SELECTED_ITEM") Object object) {
        if (object == null || !(object instanceof ITreeEntity)) {
            return;
        }
        TreePath[] expandedTreePaths = this.getViewer().getExpandedTreePaths();
        this.getViewer().getControl().setRedraw(false);
        this.getViewer().setInput(this.getViewer().getInput());
        this.getViewer().setExpandedTreePaths(expandedTreePaths);
        this.getViewer().getControl().setRedraw(true);
        this.getViewer().setSelection((ISelection)new StructuredSelection(object));
        this.getViewer().setExpandedState(object, true);
        this.setSelectedPart();
    }

    @Inject
    @Optional
    private void setSelectedItems(@UIEventTopic(value="EXPLORER/SET_SELECTED_ITEMS") Object[] objects) {
        if (objects == null) {
            return;
        }
        TreePath[] expandedTreePaths = this.getViewer().getExpandedTreePaths();
        this.getViewer().getControl().setRedraw(false);
        this.getViewer().setInput(this.getViewer().getInput());
        this.getViewer().setExpandedTreePaths(expandedTreePaths);
        this.getViewer().getControl().setRedraw(true);
        this.getViewer().setSelection((ISelection)new StructuredSelection(objects));
        this.setSelectedPart();
    }

    private void setSelectedPart() {
        MElementContainer parentStack = this.part.getParent();
        if (parentStack != null && parentStack.getSelectedElement() != null && !parentStack.getSelectedElement().getElementId().equals(this.part.getElementId())) {
            parentStack.setSelectedElement((MUIElement)this.part);
        }
    }

    @Inject
    @Optional
    private void showItem(@UIEventTopic(value="EXPLORER/SHOW_ITEM") Object object) {
        if (object == null || !(object instanceof ITreeEntity)) {
            return;
        }
        this.getViewer().setExpandedState(object, true);
        this.getViewer().setSelection((ISelection)new StructuredSelection(object));
    }

    @Inject
    @Optional
    private void refreshAllItems(@UIEventTopic(value="EXPLORER/REFRESH_ALL_ITEMS") Object object) {
        for (ITreeEntity treeRootEntity : this.treeEntities) {
            this.eventBroker.post("EXPLORER/REFRESH_SELECTED_ITEM", (Object)treeRootEntity);
        }
    }

    @Inject
    @Optional
    private void collapseAllItems(@UIEventTopic(value="EXPLORER/COLLAPSE_ALL_ITEMS") Object object) {
        if (this.treeViewer != null) {
            this.treeViewer.collapseAll();
        }
    }

    private void hookDoubleClickEvent() {
        this.getViewer().addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (ExplorerPart.this.selectionService == null || event.getSelection() == null) {
                    return;
                }
                Object selectedElement = ((IStructuredSelection)event.getSelection()).getFirstElement();
                if (selectedElement == null || !(selectedElement instanceof ITreeEntity)) {
                    return;
                }
                EntityProvider contentProvider = (EntityProvider)ExplorerPart.this.treeViewer.getContentProvider();
                if (contentProvider.hasChildren(selectedElement)) {
                    ExplorerPart.this.treeViewer.setExpandedState(selectedElement, !ExplorerPart.this.treeViewer.getExpandedState(selectedElement));
                } else {
                    try {
                        ExplorerPart.this.eventBroker.send("EXPLORER/OPEN_SELECTED_ITEM", ((ITreeEntity)selectedElement).getObject());
                    }
                    catch (Exception e) {
                        LoggerSingleton.logError((Throwable)e);
                    }
                }
            }
        });
    }

    private void hookDragEvent() {
        int operations = 7;
        this.dragSource = new DragSource((Control)this.getViewer().getTree(), operations);
        List<Transfer> treeEntityTransfers = TransferTypeCollection.getInstance().getTreeEntityTransfer();
        this.dragSource.setTransfer(treeEntityTransfers.toArray(new Transfer[treeEntityTransfers.size()]));
        this.dragSource.addDragListener(new DragSourceListener(){

            public void dragStart(DragSourceEvent event) {
                TreeItem[] selection = ExplorerPart.this.getViewer().getTree().getSelection();
                event.doit = selection.length > 0;
                try {
                    TreeItem[] treeItemArray = selection;
                    int n = selection.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ITreeEntity treeEntity;
                        TreeItem item = treeItemArray[n2];
                        if (item.getData() instanceof ReportTreeEntity || item.getData() instanceof KeywordTreeEntity || item.getData() instanceof PackageTreeEntity) {
                            event.doit = false;
                        } else if (item.getData() instanceof FolderTreeEntity && ((FolderTreeEntity)item.getData()).getCopyTag().equals(FolderEntity.FolderType.REPORT.toString())) {
                            event.doit = false;
                        }
                        if (item.getData() instanceof ITreeEntity && !(treeEntity = (ITreeEntity)item.getData()).isRemoveable()) {
                            event.doit = false;
                        }
                        ++n2;
                    }
                }
                catch (Exception e) {
                    LoggerSingleton.logError((Throwable)e);
                }
            }

            public void dragSetData(DragSourceEvent event) {
                TreeItem[] selection = ExplorerPart.this.getViewer().getTree().getSelection();
                ArrayList<ITreeEntity> treeEntity = new ArrayList<ITreeEntity>();
                TreeItem[] treeItemArray = selection;
                int n = selection.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeItem item = treeItemArray[n2];
                    treeEntity.add((ITreeEntity)item.getData());
                    ++n2;
                }
                event.data = treeEntity.toArray(new ITreeEntity[treeEntity.size()]);
            }

            public void dragFinished(DragSourceEvent event) {
            }
        });
    }

    private void hookDropEvent() {
        DropTarget dt = new DropTarget((Control)this.treeViewer.getTree(), 2);
        List<Transfer> treeEntityTransfers = TransferTypeCollection.getInstance().getTreeEntityTransfer();
        dt.setTransfer(treeEntityTransfers.toArray(new Transfer[treeEntityTransfers.size()]));
        dt.addDropListener((DropTargetListener)new TreeEntityDropListener((TreeViewer)this.treeViewer, this.eventBroker));
    }

    public List<ITreeEntity> getSearchDropBoxElements() {
        if (this.treeEntities == null) {
            this.treeEntities = new ArrayList<ITreeEntity>();
        }
        return this.treeEntities;
    }

    private void updateTreeEntities(List<Object> input) {
        if (this.treeEntities == null) {
            this.treeEntities = new ArrayList<ITreeEntity>();
        } else {
            this.treeEntities.clear();
        }
        if (input == null) {
            return;
        }
        this.treeEntities.addAll(input.parallelStream().map(item -> (ITreeEntity)item).collect(Collectors.toList()));
    }

    @PreDestroy
    public void dispose() {
        this.treeViewer.getTree().dispose();
    }
}

