/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.explorer.handlers;

import com.kms.katalon.composer.components.impl.handler.CommonExplorerHandler;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.composer.explorer.constants.StringConstants;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.services.log.Logger;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.jface.dialogs.MessageDialog;

public class RenameHandler
extends CommonExplorerHandler {
    @Inject
    private Logger logger;
    @Inject
    private ESelectionService selectionService;
    @Inject
    EPartService partService;

    @CanExecute
    public boolean canExecute() {
        if (!this.isExplorerPartActive()) {
            return false;
        }
        Object[] selectedObjects = (Object[])this.selectionService.getSelection("com.kms.katalon.composer.part.explorer");
        if (selectedObjects == null || selectedObjects.length != 1) {
            return false;
        }
        if (selectedObjects[0] instanceof ITreeEntity) {
            try {
                return ((ITreeEntity)selectedObjects[0]).isRenamable();
            }
            catch (Exception e) {
                this.logger.error((Throwable)e);
            }
        }
        return true;
    }

    @Execute
    public void execute() {
        if (this.selectionService != null) {
            Object[] selectedObjects;
            if (this.partService.getDirtyParts().size() > 0 && !MessageDialog.openConfirm(null, (String)StringConstants.HAND_CONFIRM_TITLE, (String)StringConstants.HAND_CONFIRM_MSG_REQUIRE_SAVE_ALL_B4_CONTINUE)) {
                return;
            }
            Object selection = this.selectionService.getSelection("com.kms.katalon.composer.part.explorer");
            if (this.partService.saveAll(true) && selection instanceof Object[] && (selectedObjects = (Object[])selection).length > 0 && selectedObjects[0] instanceof ITreeEntity) {
                try {
                    this.eventBroker.post("EXPLORER/RENAME_SELECTED_ITEM", (Object)((ITreeEntity)selectedObjects[0]));
                }
                catch (Exception e) {
                    this.logger.error((Throwable)e);
                }
            }
        }
    }
}

