/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.explorer.handlers;

import com.kms.katalon.composer.components.impl.handler.CommonExplorerHandler;
import com.kms.katalon.composer.components.impl.tree.KeywordTreeEntity;
import com.kms.katalon.composer.components.impl.tree.PackageTreeEntity;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.composer.explorer.constants.ComposerExplorerMessageConstants;
import com.kms.katalon.constants.GlobalMessageConstants;
import com.kms.katalon.entity.file.FileEntity;
import java.io.File;
import java.util.List;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class OpenContainingFolderHandler
extends CommonExplorerHandler {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @CanExecute
    public boolean canExecute() {
        if (!this.isExplorerPartActive()) {
            return false;
        }
        Object[] selectedObjects = this.getExplorerSelection();
        if (selectedObjects.length == 0) {
            return false;
        }
        try {
            ITreeEntity firstTreeEntity = (ITreeEntity)selectedObjects[0];
            String firstParent = this.getParentFolderLocation(firstTreeEntity);
            Object[] objectArray = selectedObjects;
            int n = selectedObjects.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return true;
                }
                Object selectedItem = objectArray[n2];
                ITreeEntity treeEntity = (ITreeEntity)selectedItem;
                String parent = this.getParentFolderLocation(treeEntity);
                if (parent == null) return false;
                if (!parent.equals(firstParent)) {
                    return false;
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Execute
    public void execute() {
        try {
            List treeEntities = this.getElementSelection(ITreeEntity.class);
            if (treeEntities.isEmpty()) {
                return;
            }
            ITreeEntity treeEntity = (ITreeEntity)treeEntities.get(0);
            String parent = this.getParentFolderLocation(treeEntity);
            Program.launch((String)new File(parent).toURI().toString());
        }
        catch (Exception exception) {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)GlobalMessageConstants.ERROR, (String)ComposerExplorerMessageConstants.ERROR_CANNOT_FIND_CONTAINING_FOLDER);
        }
    }

    private String getParentFolderLocation(ITreeEntity treeEntity) throws Exception {
        ITreeEntity treeParent = treeEntity.getParent();
        if (treeEntity instanceof KeywordTreeEntity) {
            FileEntity keywordFolder = (FileEntity)treeParent.getParent().getObject();
            String packageName = ((PackageTreeEntity)treeParent).getPackageName();
            if (packageName.equals(PackageTreeEntity.DEFAULT_PACKAGE_LABEL)) {
                return keywordFolder.getLocation();
            }
            return String.valueOf(keywordFolder.getLocation()) + File.separator + this.getPathToPackage(packageName, true);
        }
        if (treeEntity instanceof PackageTreeEntity) {
            String packageName = ((PackageTreeEntity)treeEntity).getPackageName();
            return String.valueOf(((FileEntity)treeParent.getObject()).getLocation()) + this.getPathToPackage(packageName, false);
        }
        FileEntity fileEntity = (FileEntity)treeEntity.getObject();
        return fileEntity.getParentFolder() != null ? fileEntity.getParentFolder().getLocation() : null;
    }

    private String getPathToPackage(String packageName, boolean insidePackage) {
        StringBuilder builder = new StringBuilder();
        String[] packages = packageName.split("\\.");
        int chainLength = packages.length;
        if (!insidePackage) {
            --chainLength;
        }
        int i = 0;
        while (i < chainLength) {
            builder.append(String.valueOf(File.separator) + packages[i]);
            ++i;
        }
        return builder.toString();
    }
}

