/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.explorer.handlers;

import com.kms.katalon.composer.components.impl.tree.FolderTreeEntity;
import com.kms.katalon.composer.components.impl.tree.KeywordTreeEntity;
import com.kms.katalon.composer.components.impl.tree.PackageTreeEntity;
import com.kms.katalon.composer.components.impl.util.EntityPartUtil;
import com.kms.katalon.composer.components.impl.util.TreeEntityUtil;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.composer.util.groovy.editor;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.entity.IEntity;
import com.kms.katalon.entity.checkpoint.CheckpointEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.report.ReportCollectionEntity;
import com.kms.katalon.entity.report.ReportEntity;
import com.kms.katalon.entity.repository.WebElementEntity;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.entity.testdata.DataFileEntity;
import com.kms.katalon.entity.testsuite.TestSuiteCollectionEntity;
import com.kms.katalon.entity.testsuite.TestSuiteEntity;
import com.kms.katalon.preferences.internal.PreferenceStoreManager;
import com.kms.katalon.preferences.internal.ScopedPreferenceStore;
import java.io.IOException;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.codehaus.jdt.groovy.model.GroovyCompilationUnit;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.menu.MHandledToolItem;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class LinkEditorHandler
implements EventHandler {
    @Inject
    private EPartService partService;
    @Inject
    private IEventBroker eventBroker;
    private ScopedPreferenceStore store;

    @PostConstruct
    public void initListener() {
        this.store = PreferenceStoreManager.getPreferenceStore(LinkEditorHandler.class);
        this.eventBroker.subscribe("org/eclipse/e4/ui/LifeCycle/bringToTop", (EventHandler)this);
    }

    private void setActive(boolean isActive) {
        try {
            this.store.setValue("explorer.linkPart", isActive);
            this.store.save();
        }
        catch (IOException e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    private boolean getActive() {
        return this.store.getBoolean("explorer.linkPart");
    }

    @CanExecute
    public boolean canExecute(MHandledToolItem item) {
        return ProjectController.getInstance().getCurrentProject() != null;
    }

    @Execute
    public void execute(MHandledToolItem item) {
        if (item.isSelected()) {
            this.setActive(true);
            if (this.partService.getActivePart() != null) {
                this.performLinkWithPart(this.partService.getActivePart());
            }
        } else {
            this.setActive(false);
        }
    }

    public void handleEvent(Event event) {
        Object object = event.getProperty("ChangedElement");
        if (this.getActive() && "org/eclipse/e4/ui/LifeCycle/bringToTop".equals(event.getTopic()) && object != null && object instanceof MPart) {
            MPart mpart = (MPart)object;
            this.performLinkWithPart(mpart);
        }
    }

    private void performLinkWithPart(MPart mpart) {
        try {
            IEntity entity = EntityPartUtil.getEntityByPartId((String)mpart.getElementId());
            KeywordTreeEntity treeEntity = null;
            if (entity != null) {
                ProjectEntity projectEntity = ProjectController.getInstance().getCurrentProject();
                if (entity instanceof TestCaseEntity) {
                    treeEntity = TreeEntityUtil.getTestCaseTreeEntity((TestCaseEntity)((TestCaseEntity)entity), (ProjectEntity)projectEntity);
                } else if (entity instanceof WebElementEntity) {
                    treeEntity = TreeEntityUtil.getWebElementTreeEntity((WebElementEntity)((WebElementEntity)entity), (ProjectEntity)projectEntity);
                } else if (entity instanceof TestSuiteEntity) {
                    treeEntity = TreeEntityUtil.getTestSuiteTreeEntity((TestSuiteEntity)((TestSuiteEntity)entity), (ProjectEntity)projectEntity);
                } else if (entity instanceof DataFileEntity) {
                    treeEntity = TreeEntityUtil.getTestDataTreeEntity((DataFileEntity)((DataFileEntity)entity), (ProjectEntity)projectEntity);
                } else if (entity instanceof ReportCollectionEntity) {
                    treeEntity = TreeEntityUtil.getReportCollectionTreeEntity((ReportCollectionEntity)((ReportCollectionEntity)entity), (ProjectEntity)projectEntity);
                } else if (entity instanceof ReportEntity) {
                    treeEntity = TreeEntityUtil.getReportTreeEntity((ReportEntity)((ReportEntity)entity), (ProjectEntity)projectEntity);
                } else if (entity instanceof TestSuiteCollectionEntity) {
                    treeEntity = TreeEntityUtil.getTestSuiteCollectionTreeEntity((TestSuiteCollectionEntity)((TestSuiteCollectionEntity)entity), (ProjectEntity)projectEntity);
                } else if (entity instanceof CheckpointEntity) {
                    treeEntity = TreeEntityUtil.getCheckpointTreeEntity((CheckpointEntity)((CheckpointEntity)entity));
                }
            } else {
                treeEntity = this.getKeywordTreeEntity(mpart);
            }
            if (treeEntity == null) {
                return;
            }
            this.eventBroker.post("EXPLORER/SHOW_ITEM", (Object)treeEntity);
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    private KeywordTreeEntity getKeywordTreeEntity(MPart mpart) throws Exception {
        IJavaElement elem;
        IEditorPart editorPart = editor.getEditor((MPart)mpart);
        if (editorPart != null && (elem = JavaUI.getEditorInputJavaElement((IEditorInput)editorPart.getEditorInput())) instanceof GroovyCompilationUnit && elem.getParent() instanceof IPackageFragment) {
            FolderTreeEntity keywordRootFolder = new FolderTreeEntity(FolderController.getInstance().getKeywordRoot(ProjectController.getInstance().getCurrentProject()), null);
            PackageTreeEntity newPackageTreeEntity = new PackageTreeEntity((IPackageFragment)elem.getParent(), (ITreeEntity)keywordRootFolder);
            return new KeywordTreeEntity((ICompilationUnit)elem, (ITreeEntity)newPackageTreeEntity);
        }
        return null;
    }
}

