/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.explorer.handlers;

import com.kms.katalon.composer.components.impl.handler.CommonExplorerHandler;
import com.kms.katalon.composer.components.impl.transfer.TreeEntityTransfer;
import com.kms.katalon.composer.components.impl.tree.KeywordTreeEntity;
import com.kms.katalon.composer.components.impl.tree.PackageTreeEntity;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.transfer.TransferMoveFlag;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.entity.folder.FolderEntity;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;

public class CopyHandler
extends CommonExplorerHandler {
    private static CopyHandler _instance;

    public static CopyHandler getInstance() {
        if (_instance == null) {
            _instance = new CopyHandler();
        }
        return _instance;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean canExecute() {
        if (!this.isExplorerPartActive()) {
            return false;
        }
        Object[] selectedObjects = this.getExplorerSelection();
        if (selectedObjects.length == 0) {
            return false;
        }
        try {
            String entityTag = null;
            Object[] objectArray = selectedObjects;
            int n = selectedObjects.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return true;
                }
                Object entity = objectArray[n2];
                if (!(entity instanceof ITreeEntity)) {
                    return false;
                }
                ITreeEntity treeEntity = (ITreeEntity)entity;
                if (treeEntity.getParent() == null) return false;
                if (treeEntity instanceof PackageTreeEntity) return false;
                if (StringUtils.isEmpty((String)treeEntity.getCopyTag())) {
                    return false;
                }
                String copyTag = treeEntity.getCopyTag();
                if (StringUtils.equals((String)copyTag, (String)FolderEntity.FolderType.REPORT.toString())) {
                    return false;
                }
                if (entityTag == null) {
                    entityTag = copyTag;
                } else if (!StringUtils.equalsIgnoreCase((String)copyTag, (String)entityTag)) {
                    return false;
                }
                ++n2;
            }
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
            return false;
        }
    }

    public void execute() {
        if (!this.isExplorerPartActive()) {
            return;
        }
        Object[] selectedObjects = this.getExplorerSelection();
        if (selectedObjects.length == 0) {
            return;
        }
        int numberOfSelectedObject = selectedObjects.length;
        Clipboard cb = new Clipboard(Display.getCurrent());
        TransferMoveFlag.setMove((boolean)false);
        try {
            String[] keywordData = new String[numberOfSelectedObject];
            ITreeEntity[] entityData = new ITreeEntity[numberOfSelectedObject];
            boolean isKeyword = selectedObjects[0] instanceof KeywordTreeEntity;
            int i = 0;
            while (i < numberOfSelectedObject) {
                ITreeEntity treeEntity = (ITreeEntity)selectedObjects[i];
                treeEntity.loadAllDescentdantEntities();
                if (isKeyword) {
                    keywordData[i] = ((ICompilationUnit)((KeywordTreeEntity)treeEntity).getObject()).getPath().toString();
                } else {
                    entityData[i] = treeEntity;
                }
                ++i;
            }
            Transfer[] transferType = new Transfer[]{TreeEntityTransfer.getInstance()};
            Object[] transferData = new Object[]{entityData};
            if (isKeyword) {
                transferType[0] = FileTransfer.getInstance();
                transferData[0] = keywordData;
            }
            cb.setContents(transferData, transferType);
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }
}

