/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.integration.slack.util;

import com.google.gson.stream.JsonReader;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.integration.slack.constants.StringConstants;
import com.kms.katalon.preferences.internal.PreferenceStoreManager;
import com.kms.katalon.preferences.internal.ScopedPreferenceStore;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;

public class SlackUtil {
    public static final String RES_IS_OK = "isOk";
    public static final String RES_ERROR_MSG = "errorMsg";
    private ScopedPreferenceStore PREFERENCE = PreferenceStoreManager.getPreferenceStore(SlackUtil.class);
    private boolean isSlackEnabled = this.PREFERENCE.getBoolean("slackConfig.enabled");
    private String token = this.PREFERENCE.getString("slackConfig.token");
    private String channel = this.PREFERENCE.getString("slackConfig.channel");
    private String username = this.PREFERENCE.getString("slackConfig.username");
    private boolean asIssuedTokenUser = this.PREFERENCE.getBoolean("slackConfig.asUser");
    private static SlackUtil _instance;

    public static SlackUtil getInstance() {
        if (_instance == null) {
            _instance = new SlackUtil();
        }
        return _instance;
    }

    public URI buildSlackUri(String token, String channel, String username, boolean asIssuedTokenUser, String msg) throws Exception {
        URIBuilder uriBuilder = new URIBuilder().setScheme("https").setHost("slack.com").setPath("/api/chat.postMessage").addParameter("token", token).addParameter("channel", channel);
        if (username != null && !username.trim().isEmpty()) {
            uriBuilder.addParameter("username", username);
        }
        if (asIssuedTokenUser) {
            uriBuilder.addParameter("as_user", "true");
        }
        uriBuilder.addParameter("text", msg);
        return uriBuilder.build();
    }

    private URI buildSlackUri(String msg) throws Exception {
        return this.buildSlackUri(this.token, this.channel, this.username, this.asIssuedTokenUser, msg);
    }

    public void sendMessage(String msg) {
        if (this.isSlackEnabled) {
            try {
                Map<String, Object> response = this.getResponseFromSendingMsg(this.buildSlackUri(msg));
                boolean isOk = (Boolean)response.get(RES_IS_OK);
                String errorMsg = (String)response.get(RES_ERROR_MSG);
                LoggerSingleton.logDebug((String)(String.valueOf(StringConstants.UTIL_SENDING_MSG_PREFIX) + msg));
                if (isOk && errorMsg == null) {
                    LoggerSingleton.logDebug((String)(String.valueOf(StringConstants.UTIL_SUCCESS_MSG_PREFIX) + msg));
                } else if (!isOk && errorMsg != null) {
                    LoggerSingleton.logWarn((String)(String.valueOf(StringConstants.UTIL_ERROR_MSG_PREFIX) + SlackMsgStatus.getInstance().getMsgDescription(errorMsg)));
                } else {
                    LoggerSingleton.logWarn((String)StringConstants.UTIL_ERROR_MSG_PLS_CHK_INTERNET_CONNECTION);
                }
            }
            catch (Exception e) {
                LoggerSingleton.logError((Throwable)e);
            }
        }
    }

    public Map<String, Object> getResponseFromSendingMsg(URI uri) throws ClientProtocolException, IOException {
        String errorMsg;
        boolean isOk;
        block9: {
            isOk = false;
            errorMsg = null;
            CloseableHttpClient httpclient = HttpClients.createDefault();
            HttpGet httpget = new HttpGet(uri);
            try (CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpget);){
                HttpEntity entity = response.getEntity();
                if (entity == null) break block9;
                try (InputStreamReader in = new InputStreamReader(entity.getContent());){
                    JsonReader reader = new JsonReader((Reader)in);
                    reader.beginObject();
                    while (reader.hasNext()) {
                        String name = reader.nextName();
                        if (StringUtils.equals((String)name, (String)"ok")) {
                            isOk = reader.nextBoolean();
                            continue;
                        }
                        if (StringUtils.equals((String)name, (String)"error")) {
                            errorMsg = reader.nextString();
                            continue;
                        }
                        reader.skipValue();
                    }
                    reader.endObject();
                    reader.close();
                }
            }
        }
        HashMap<String, Object> res = new HashMap<String, Object>();
        res.put(RES_IS_OK, isOk);
        res.put(RES_ERROR_MSG, errorMsg);
        return res;
    }

    public String fmtBold(String msg) {
        return "*" + msg + "*";
    }

    public String fmtItalic(String msg) {
        return "_" + msg + "_";
    }

    public boolean isSlackEnabled() {
        return this.PREFERENCE.getBoolean("slackConfig.enabled");
    }

    public static class SlackMsgStatus {
        private static SlackMsgStatus _instance;
        private static Map<String, String> msgMap;

        public static SlackMsgStatus getInstance() {
            if (_instance == null) {
                _instance = new SlackMsgStatus();
            }
            return _instance;
        }

        public SlackMsgStatus() {
            msgMap = new HashMap<String, String>();
            msgMap.put("channel_not_found", StringConstants.SLACK_ERROR_MSG_CHANNEL_NOT_FOUND);
            msgMap.put("not_in_channel", StringConstants.SLACK_ERROR_MSG_NOT_IN_CHANNEL);
            msgMap.put("is_archived", StringConstants.SLACK_ERROR_MSG_IS_ARCHIVED);
            msgMap.put("msg_too_long", StringConstants.SLACK_ERROR_MSG_MSG_TOO_LONG);
            msgMap.put("no_text", StringConstants.SLACK_ERROR_MSG_NO_TEXT);
            msgMap.put("rate_limited", StringConstants.SLACK_ERROR_MSG_RATE_LIMITED);
            msgMap.put("not_authed", StringConstants.SLACK_ERROR_MSG_NOT_AUTHED);
            msgMap.put("invalid_auth", StringConstants.SLACK_ERROR_MSG_INVALID_AUTH);
            msgMap.put("account_inactive", StringConstants.SLACK_ERROR_MSG_ACCOUNT_INACTIVE);
        }

        public Map<String, String> getMsgMap() {
            return msgMap;
        }

        public String getMsgDescription(String msgCode) {
            if (this.getMsgMap().get(msgCode) == null) {
                return msgCode;
            }
            return this.getMsgMap().get(msgCode);
        }
    }
}

