/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.integration.slack.preferences;

import com.kms.katalon.composer.components.dialogs.FieldEditorPreferencePageWithHelp;
import com.kms.katalon.composer.components.impl.control.GifCLabel;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.integration.slack.constants.ComposerIntegrationSlackMessageConstants;
import com.kms.katalon.composer.integration.slack.constants.ImageConstants;
import com.kms.katalon.composer.integration.slack.constants.StringConstants;
import com.kms.katalon.composer.integration.slack.util.SlackUtil;
import com.kms.katalon.constants.DocumentationMessageConstants;
import com.kms.katalon.tracking.service.Trackings;
import java.net.URI;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class SlackPreferencePage
extends FieldEditorPreferencePageWithHelp {
    private Composite fieldEditorParent;
    private BooleanFieldEditor enabled;
    private Group fieldsetSlack;
    private Group fieldsetSend;
    private StringFieldEditor token;
    private StringFieldEditor channel;
    private StringFieldEditor username;
    private BooleanFieldEditor asUser;
    private GifCLabel lblConnectionStatus;
    private Button btnTestConnection;
    private BooleanFieldEditor sendOpenProject;
    private BooleanFieldEditor sendCloseProject;
    private BooleanFieldEditor sendCreateTestCase;
    private BooleanFieldEditor sendUpdateTestCase;
    private BooleanFieldEditor sendCreateTestSuite;
    private BooleanFieldEditor sendUpdateTestSuite;
    private BooleanFieldEditor sendCreateTestData;
    private BooleanFieldEditor sendUpdateTestData;
    private BooleanFieldEditor sendCreateTestObject;
    private BooleanFieldEditor sendUpdateTestObject;
    private BooleanFieldEditor sendCreateFolder;
    private BooleanFieldEditor sendCreateKeyword;
    private BooleanFieldEditor sendCreatePackage;
    private BooleanFieldEditor sendPasteFromCopy;
    private BooleanFieldEditor sendPasteFromCut;
    private BooleanFieldEditor sendRenameItem;
    private BooleanFieldEditor sendDeleteItem;
    Button btnGetSlackPlugin;
    private boolean isValid = this.isValid();
    private boolean loaded = false;
    private boolean isSlackEnabled;
    private boolean asUserValue;
    private String tokenValue = "";
    private String channelValue = "";
    private String usernameValue = "";

    public SlackPreferencePage() {
        super(1);
        this.setMessage(StringConstants.PREF_LBL_TEAM_COLLABORATION);
    }

    protected void createFieldEditors() {
        this.fieldEditorParent = new Composite(this.getFieldEditorParent(), 0);
        this.fieldEditorParent.setLayoutData((Object)new GridData(4, 128, true, true, 1, 1));
        this.createSlackPlugin(this.fieldEditorParent);
        this.enabled = new BooleanFieldEditor("slackConfig.enabled", StringConstants.PREF_LBL_SLACK_ENABLED, this.fieldEditorParent);
        this.enabled.getDescriptionControl(this.fieldEditorParent).setToolTipText(StringConstants.PREF_LBL_TIP_SLACK_ENABLED);
        this.fieldsetSlack = new Group(this.fieldEditorParent, 1);
        this.fieldsetSlack.setText(StringConstants.PREF_LBL_SLACK);
        this.fieldsetSlack.setLayoutData((Object)new GridData(4, 128, true, true, 1, 1));
        this.token = new StringFieldEditor("slackConfig.token", StringConstants.PREF_LBL_SLACK_AUTH_TOKEN, (Composite)this.fieldsetSlack);
        this.token.getTextControl((Composite)this.fieldsetSlack).setToolTipText(StringConstants.PREF_LBL_SLACK_AUTH_TOKEN);
        this.channel = new StringFieldEditor("slackConfig.channel", StringConstants.PREF_LBL_SLACK_CHANNEL, (Composite)this.fieldsetSlack);
        this.channel.getTextControl((Composite)this.fieldsetSlack).setToolTipText(StringConstants.PREF_LBL_SLACK_CHANNEL_DESC);
        this.asUser = new BooleanFieldEditor("slackConfig.asUser", StringConstants.PREF_LBL_SLACK_AS_USER, (Composite)this.fieldsetSlack);
        this.asUser.getDescriptionControl((Composite)this.fieldsetSlack).setToolTipText(StringConstants.PREF_LBL_SLACK_AS_USER_DESC);
        this.asUser.fillIntoGrid((Composite)this.fieldsetSlack, 2);
        this.username = new StringFieldEditor("slackConfig.username", StringConstants.PREF_LBL_SLACK_USERNAME, (Composite)this.fieldsetSlack);
        this.username.getTextControl((Composite)this.fieldsetSlack).setToolTipText(StringConstants.PREF_LBL_SLACK_USERNAME_DESC);
        this.btnTestConnection = new Button((Composite)this.fieldsetSlack, 1);
        this.btnTestConnection.setText(StringConstants.PREF_LBL_TEST_CONNECTION);
        this.btnTestConnection.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SlackPreferencePage.this.testSlackConnection();
            }
        });
        this.btnGetSlackPlugin.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Program.launch((String)"https://store.katalon.com/product/4/Slack-Integration");
                Trackings.trackQuickDiscussion();
            }
        });
        this.lblConnectionStatus = new GifCLabel((Composite)this.fieldsetSlack, 1);
        this.lblConnectionStatus.setText(StringConstants.EMPTY);
        this.lblConnectionStatus.setLayoutData((Object)new GridData(4, 128, true, true, 1, 1));
        this.addField((FieldEditor)this.enabled);
        this.addField((FieldEditor)this.token);
        this.addField((FieldEditor)this.channel);
        this.addField((FieldEditor)this.asUser);
        this.addField((FieldEditor)this.username);
        this.fieldsetSend = new Group(this.fieldEditorParent, 1);
        this.fieldsetSend.setText(StringConstants.PREF_LBL_SEND_MSG_TO_SLACK_WHEN);
        this.fieldsetSend.setLayoutData((Object)new GridData(4, 128, true, true, 1, 1));
        this.sendOpenProject = new BooleanFieldEditor("slackConfig.sendOpenProject", StringConstants.PREF_SEND_OPEN_PROJECT, (Composite)this.fieldsetSend);
        this.sendCloseProject = new BooleanFieldEditor("slackConfig.sendCloseProject", StringConstants.PREF_SEND_CLOSE_PROJECT, (Composite)this.fieldsetSend);
        this.sendCreateTestCase = new BooleanFieldEditor("slackConfig.sendCreateTestCase", StringConstants.PREF_SEND_CREATE_TEST_CASE, (Composite)this.fieldsetSend);
        this.sendUpdateTestCase = new BooleanFieldEditor("slackConfig.sendUpdateTestCase", StringConstants.PREF_SEND_UPDATE_TEST_CASE, (Composite)this.fieldsetSend);
        this.sendCreateTestSuite = new BooleanFieldEditor("slackConfig.sendCreateTestSuite", StringConstants.PREF_SEND_CREATE_TEST_SUITE, (Composite)this.fieldsetSend);
        this.sendUpdateTestSuite = new BooleanFieldEditor("slackConfig.sendUpdateTestSuite", StringConstants.PREF_SEND_UPDATE_TEST_SUITE, (Composite)this.fieldsetSend);
        this.sendCreateTestData = new BooleanFieldEditor("slackConfig.sendCreateTestData", StringConstants.PREF_SEND_CREATE_TEST_DATA, (Composite)this.fieldsetSend);
        this.sendUpdateTestData = new BooleanFieldEditor("slackConfig.sendUpdateTestData", StringConstants.PREF_SEND_UPDATE_TEST_DATA, (Composite)this.fieldsetSend);
        this.sendCreateTestObject = new BooleanFieldEditor("slackConfig.sendCreateTestObject", StringConstants.PREF_SEND_CREATE_TEST_OBJECT, (Composite)this.fieldsetSend);
        this.sendUpdateTestObject = new BooleanFieldEditor("slackConfig.sendUpdateTestObject", StringConstants.PREF_SEND_UPDATE_TEST_OBJECT, (Composite)this.fieldsetSend);
        this.sendCreateFolder = new BooleanFieldEditor("slackConfig.sendCreateFolder", StringConstants.PREF_SEND_CREATE_FOLDER, (Composite)this.fieldsetSend);
        this.sendCreateKeyword = new BooleanFieldEditor("slackConfig.sendCreateKeyword", StringConstants.PREF_SEND_CREATE_KEYWORD, (Composite)this.fieldsetSend);
        this.sendCreatePackage = new BooleanFieldEditor("slackConfig.sendCreatePackage", StringConstants.PREF_SEND_CREATE_PACKAGE, (Composite)this.fieldsetSend);
        this.sendPasteFromCopy = new BooleanFieldEditor("slackConfig.sendPasteFromCopy", StringConstants.PREF_SEND_PASTE_FROM_COPY, (Composite)this.fieldsetSend);
        this.sendPasteFromCut = new BooleanFieldEditor("slackConfig.sendPasteFromCut", StringConstants.PREF_SEND_PASTE_FROM_CUT, (Composite)this.fieldsetSend);
        this.sendRenameItem = new BooleanFieldEditor("slackConfig.sendRenameItem", StringConstants.PREF_SEND_RENAME_ITEM, (Composite)this.fieldsetSend);
        this.sendDeleteItem = new BooleanFieldEditor("slackConfig.sendDeleteItem", StringConstants.PREF_SEND_DELETE_ITEM, (Composite)this.fieldsetSend);
        this.addField((FieldEditor)this.sendOpenProject);
        this.addField((FieldEditor)this.sendCloseProject);
        this.addField((FieldEditor)this.sendCreateTestCase);
        this.addField((FieldEditor)this.sendUpdateTestCase);
        this.addField((FieldEditor)this.sendCreateTestSuite);
        this.addField((FieldEditor)this.sendUpdateTestSuite);
        this.addField((FieldEditor)this.sendCreateTestData);
        this.addField((FieldEditor)this.sendUpdateTestData);
        this.addField((FieldEditor)this.sendCreateTestObject);
        this.addField((FieldEditor)this.sendUpdateTestObject);
        this.addField((FieldEditor)this.sendCreateFolder);
        this.addField((FieldEditor)this.sendCreateKeyword);
        this.addField((FieldEditor)this.sendCreatePackage);
        this.addField((FieldEditor)this.sendPasteFromCopy);
        this.addField((FieldEditor)this.sendPasteFromCut);
        this.addField((FieldEditor)this.sendRenameItem);
        this.addField((FieldEditor)this.sendDeleteItem);
        this.loaded = true;
    }

    private GridLayout noneMarginGridLayout() {
        GridLayout gl = new GridLayout();
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        return gl;
    }

    private void createSlackPlugin(Composite parent) {
        Composite deprecatedComposite = new Composite(parent, 0);
        deprecatedComposite.setLayout((Layout)this.noneMarginGridLayout());
        deprecatedComposite.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        deprecatedComposite.setLayout((Layout)new GridLayout());
        Group grpSlackPlugin = new Group(deprecatedComposite, 0);
        grpSlackPlugin.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        GridLayout glGrpSlackPlugin = new GridLayout(1, false);
        glGrpSlackPlugin.horizontalSpacing = 10;
        glGrpSlackPlugin.marginWidth = 10;
        GridData layoutData = new GridData(4, 128, true, false);
        layoutData.widthHint = 300;
        grpSlackPlugin.setLayout((Layout)glGrpSlackPlugin);
        grpSlackPlugin.setText("");
        Label deprecatedMessage = new Label((Composite)grpSlackPlugin, 64);
        deprecatedMessage.setLayoutData((Object)layoutData);
        deprecatedMessage.setText(ComposerIntegrationSlackMessageConstants.SlackSettingsComposite_MSG_DEPRECATED);
        deprecatedMessage.setBackground(ColorUtil.getWarningLogBackgroundColor());
        new Label((Composite)grpSlackPlugin, 0);
        this.btnGetSlackPlugin = new Button((Composite)grpSlackPlugin, 0);
        this.btnGetSlackPlugin.setLayoutData((Object)new GridData(131072, 0x1000000, true, true, 1, 1));
        this.btnGetSlackPlugin.setText(ComposerIntegrationSlackMessageConstants.PREF_LBL_GETSLACKPLUGIN);
    }

    protected void initialize() {
        super.initialize();
        this.isSlackEnabled = this.enabled.getBooleanValue();
        this.asUserValue = this.asUser.getBooleanValue();
        this.tokenValue = this.token.getStringValue().trim();
        this.channelValue = this.channel.getStringValue().trim();
        this.usernameValue = this.username.getStringValue().trim();
        this.enableFields(this.isSlackEnabled);
    }

    public void propertyChange(PropertyChangeEvent event) {
        this.lblConnectionStatus.setText(StringConstants.EMPTY);
        if (event.getSource() == this.enabled) {
            this.isSlackEnabled = (Boolean)event.getNewValue();
            this.enableFields(this.isSlackEnabled);
        } else if (event.getSource() == this.asUser) {
            this.asUserValue = (Boolean)event.getNewValue();
            this.username.setEnabled(!this.asUserValue, (Composite)this.fieldsetSlack);
        } else if (event.getSource() == this.token) {
            this.tokenValue = ((String)event.getNewValue()).trim();
        } else if (event.getSource() == this.channel) {
            this.channelValue = ((String)event.getNewValue()).trim();
        } else if (event.getSource() == this.username) {
            this.usernameValue = ((String)event.getNewValue()).trim();
        }
    }

    private void validate() {
        if (!this.isValid) {
            if (this.isSlackEnabled && StringUtils.isBlank((String)this.tokenValue)) {
                MessageDialog.openWarning((Shell)this.getShell(), (String)this.getTitle(), (String)(String.valueOf(StringConstants.PREF_LBL_SLACK_AUTH_TOKEN) + StringConstants.PREF_ERROR_MSG_X_CANNOT_BE_EMPTY_OR_BLANK));
            } else if (this.isSlackEnabled && StringUtils.isBlank((String)this.channelValue)) {
                MessageDialog.openWarning((Shell)this.getShell(), (String)this.getTitle(), (String)(String.valueOf(StringConstants.PREF_LBL_SLACK_CHANNEL) + StringConstants.PREF_ERROR_MSG_X_CANNOT_BE_EMPTY_OR_BLANK));
            }
            return;
        }
        if (this.isSlackEnabled && StringUtils.isBlank((String)this.tokenValue)) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)this.getTitle(), (String)(String.valueOf(StringConstants.PREF_LBL_SLACK_AUTH_TOKEN) + StringConstants.PREF_ERROR_MSG_X_CANNOT_BE_EMPTY_OR_BLANK));
            this.isValid = false;
        } else if (this.isSlackEnabled && StringUtils.isBlank((String)this.channelValue)) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)this.getTitle(), (String)(String.valueOf(StringConstants.PREF_LBL_SLACK_CHANNEL) + StringConstants.PREF_ERROR_MSG_X_CANNOT_BE_EMPTY_OR_BLANK));
            this.isValid = false;
        } else {
            this.isValid = true;
        }
    }

    private void enableFields(boolean isEnabled) {
        this.token.setEnabled(isEnabled, (Composite)this.fieldsetSlack);
        this.channel.setEnabled(isEnabled, (Composite)this.fieldsetSlack);
        this.asUser.setEnabled(isEnabled, (Composite)this.fieldsetSlack);
        this.username.setEnabled(isEnabled && !this.asUserValue, (Composite)this.fieldsetSlack);
        this.sendOpenProject.setEnabled(isEnabled, (Composite)this.fieldsetSend);
        this.sendCloseProject.setEnabled(isEnabled, (Composite)this.fieldsetSend);
        this.sendCreateTestCase.setEnabled(isEnabled, (Composite)this.fieldsetSend);
        this.sendUpdateTestCase.setEnabled(isEnabled, (Composite)this.fieldsetSend);
        this.sendCreateTestSuite.setEnabled(isEnabled, (Composite)this.fieldsetSend);
        this.sendUpdateTestSuite.setEnabled(isEnabled, (Composite)this.fieldsetSend);
        this.sendCreateTestData.setEnabled(isEnabled, (Composite)this.fieldsetSend);
        this.sendUpdateTestData.setEnabled(isEnabled, (Composite)this.fieldsetSend);
        this.sendCreateTestObject.setEnabled(isEnabled, (Composite)this.fieldsetSend);
        this.sendUpdateTestObject.setEnabled(isEnabled, (Composite)this.fieldsetSend);
        this.sendCreateFolder.setEnabled(isEnabled, (Composite)this.fieldsetSend);
        this.sendCreateKeyword.setEnabled(isEnabled, (Composite)this.fieldsetSend);
        this.sendCreatePackage.setEnabled(isEnabled, (Composite)this.fieldsetSend);
        this.sendPasteFromCopy.setEnabled(isEnabled, (Composite)this.fieldsetSend);
        this.sendPasteFromCut.setEnabled(isEnabled, (Composite)this.fieldsetSend);
        this.sendRenameItem.setEnabled(isEnabled, (Composite)this.fieldsetSend);
        this.sendDeleteItem.setEnabled(isEnabled, (Composite)this.fieldsetSend);
        this.btnTestConnection.setEnabled(isEnabled);
        this.lblConnectionStatus.setText(StringConstants.EMPTY);
        if (!this.isValid) {
            this.isValid = true;
        }
    }

    public boolean okToLeave() {
        boolean ignoreChanges = false;
        if (this.isSlackEnabled && (StringUtils.isBlank((String)this.tokenValue) || StringUtils.isBlank((String)this.channelValue))) {
            ignoreChanges = MessageDialog.openQuestion((Shell)this.getShell(), (String)this.getTitle(), (String)StringConstants.PREF_QUESTION_MSG_DO_YOU_WANT_TO_DISABLE_SLACK);
        }
        if (ignoreChanges) {
            this.enabled.loadDefault();
            this.isSlackEnabled = this.enabled.getBooleanValue();
            this.enableFields(this.isSlackEnabled);
        }
        return super.okToLeave();
    }

    protected void performDefaults() {
        super.performDefaults();
        this.isSlackEnabled = this.enabled.getBooleanValue();
        this.enableFields(this.isSlackEnabled);
    }

    public boolean performOk() {
        if (this.loaded) {
            this.validate();
            if (this.isValid) {
                this.trimFields();
                return super.performOk();
            }
            return this.isValid;
        }
        return super.performOk();
    }

    protected void performApply() {
        if (this.loaded) {
            this.validate();
            if (this.isValid) {
                this.trimFields();
                super.performApply();
            }
        }
    }

    private void trimFields() {
        this.token.setStringValue(this.token.getStringValue().trim());
        this.channel.setStringValue(this.channel.getStringValue().trim());
        this.username.setStringValue(this.username.getStringValue().trim());
    }

    private void testSlackConnection() {
        try {
            this.lblConnectionStatus.setText(StringConstants.EMPTY);
            this.lblConnectionStatus.setGifImage(ImageConstants.URL_16_LOADING.openStream());
            this.lblConnectionStatus.update();
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
        Job job = new Job("Test Slack connection"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    URI uri = SlackUtil.getInstance().buildSlackUri(SlackPreferencePage.this.tokenValue, SlackPreferencePage.this.channelValue, SlackPreferencePage.this.usernameValue, SlackPreferencePage.this.asUserValue, StringConstants.PREF_MSG_TEST_CONNECTION);
                    Map<String, Object> response = SlackUtil.getInstance().getResponseFromSendingMsg(uri);
                    boolean isOk = (Boolean)response.get("isOk");
                    String errorMsg = (String)response.get("errorMsg");
                    String statusMessage = StringConstants.EMPTY;
                    statusMessage = isOk && errorMsg == null ? StringConstants.PREF_SUCCESS_MSG_STATUS : (!isOk && errorMsg != null ? SlackUtil.SlackMsgStatus.getInstance().getMsgDescription(errorMsg) : StringConstants.PREF_ERROR_MSG_PLS_CHK_INTERNET_CONNECTION);
                    Status status = new Status(0, "com.kms.katalon.composer.integration.slack", statusMessage);
                    return status;
                }
                catch (Exception e) {
                    LoggerSingleton.logError((Throwable)e);
                    Status status = new Status(4, "com.kms.katalon.composer.integration.slack", e.getMessage());
                    return status;
                }
                finally {
                    monitor.done();
                }
            }
        };
        job.setUser(true);
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                final String message = event.getResult().getMessage();
                UISynchronizeService.getInstance().getSync().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        SlackPreferencePage.this.lblConnectionStatus.setText(message);
                        SlackPreferencePage.this.lblConnectionStatus.setImage(null);
                    }
                });
            }
        });
        job.schedule();
    }

    public boolean hasDocumentation() {
        return true;
    }

    public String getDocumentationUrl() {
        return DocumentationMessageConstants.PREFERENCE_SLACK;
    }
}

