/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.integration.slack.handlers;

import com.kms.katalon.composer.components.impl.tree.FolderTreeEntity;
import com.kms.katalon.composer.components.impl.tree.KeywordTreeEntity;
import com.kms.katalon.composer.components.impl.tree.PackageTreeEntity;
import com.kms.katalon.composer.components.impl.tree.TestCaseTreeEntity;
import com.kms.katalon.composer.components.impl.tree.TestDataTreeEntity;
import com.kms.katalon.composer.components.impl.tree.TestSuiteTreeEntity;
import com.kms.katalon.composer.components.impl.tree.WebElementTreeEntity;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.integration.slack.constants.StringConstants;
import com.kms.katalon.composer.integration.slack.util.SlackUtil;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.repository.WebElementEntity;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.entity.testdata.DataFileEntity;
import com.kms.katalon.entity.testsuite.TestSuiteEntity;
import com.kms.katalon.preferences.internal.PreferenceStoreManager;
import com.kms.katalon.preferences.internal.ScopedPreferenceStore;
import java.text.MessageFormat;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IPackageFragment;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class SlackSendMsgHandler
implements EventHandler {
    @Inject
    private IEventBroker eventBroker;
    private SlackUtil slackUtil;
    private ScopedPreferenceStore PREFERENCE;
    private boolean OPEN_PROJECT;
    private boolean CLOSE_PROJECT;
    private boolean CREATE_TC;
    private boolean UPDATE_TC;
    private boolean CREATE_TS;
    private boolean UPDATE_TS;
    private boolean CREATE_TD;
    private boolean UPDATE_TD;
    private boolean CREATE_TO;
    private boolean UPDATE_TO;
    private boolean CREATE_KW;
    private boolean CREATE_FD;
    private boolean CREATE_PK;
    private boolean COPY_PASTE;
    private boolean CUT_PASTE;
    private boolean RENAME_ITEM;
    private boolean DELETE_ITEM;

    @Inject
    public void subscribeEventBrokerListeners() {
        this.eventBroker.subscribe("PROJECT/OPENED", (EventHandler)this);
        this.eventBroker.subscribe("PROJECT/CLOSED", (EventHandler)this);
        this.eventBroker.subscribe("EXPLORER/SET_SELECTED_ITEM", (EventHandler)this);
        this.eventBroker.subscribe("EXPLORER/DELETED_SELECTED_ITEM", (EventHandler)this);
        this.eventBroker.subscribe("TESTCASE/UPDATED", (EventHandler)this);
        this.eventBroker.subscribe("TESTSUITE/UPDATED", (EventHandler)this);
        this.eventBroker.subscribe("TESTDATA/UPDATE", (EventHandler)this);
        this.eventBroker.subscribe("TESTOBJECT/UPDATED", (EventHandler)this);
        this.eventBroker.subscribe("EXPLORER/RENAMED_SELECTED_ITEM", (EventHandler)this);
        this.eventBroker.subscribe("EXPLORER/COPY_PASTED_SELECTED_ITEM", (EventHandler)this);
        this.eventBroker.subscribe("EXPLORER/CUT_PASTED_SELECTED_ITEM", (EventHandler)this);
    }

    public void handleEvent(Event event) {
        this.getSlackPreferences();
        this.slackUtil = new SlackUtil();
        if (!this.slackUtil.isSlackEnabled()) {
            return;
        }
        try {
            Object object = event.getProperty("org.eclipse.e4.data");
            ProjectEntity currentProject = ProjectController.getInstance().getCurrentProject();
            switch (event.getTopic()) {
                case "PROJECT/OPENED": {
                    if (currentProject == null) {
                        return;
                    }
                    if (this.OPEN_PROJECT) {
                        this.slackUtil.sendMessage(MessageFormat.format(StringConstants.EMOJI_MSG_OPEN_PROJECT, this.slackUtil.fmtBold(currentProject.getName())));
                    }
                    break;
                }
                case "PROJECT/CLOSED": {
                    if (currentProject == null) {
                        return;
                    }
                    if (this.CLOSE_PROJECT) {
                        this.slackUtil.sendMessage(MessageFormat.format(StringConstants.EMOJI_MSG_CLOSE_PROJECT, this.slackUtil.fmtBold(currentProject.getName())));
                    }
                    break;
                }
                case "TESTCASE/UPDATED": {
                    if (this.UPDATE_TC) {
                        this.slackUtil.sendMessage(MessageFormat.format(StringConstants.EMOJI_MSG_UPDATE, this.slackUtil.fmtBold(((TestCaseEntity)((Object[])object)[1]).getIdForDisplay())));
                    }
                    break;
                }
                case "TESTSUITE/UPDATED": {
                    if (this.UPDATE_TS) {
                        this.slackUtil.sendMessage(MessageFormat.format(StringConstants.EMOJI_MSG_UPDATE, this.slackUtil.fmtBold(((TestSuiteEntity)((Object[])object)[1]).getIdForDisplay())));
                    }
                    break;
                }
                case "TESTDATA/UPDATE": {
                    if (this.UPDATE_TD) {
                        this.slackUtil.sendMessage(MessageFormat.format(StringConstants.EMOJI_MSG_UPDATE, this.slackUtil.fmtBold(((DataFileEntity)((Object[])object)[1]).getIdForDisplay())));
                    }
                    break;
                }
                case "TESTOBJECT/UPDATED": {
                    if (this.UPDATE_TO) {
                        this.slackUtil.sendMessage(MessageFormat.format(StringConstants.EMOJI_MSG_UPDATE, this.slackUtil.fmtBold(((WebElementEntity)((Object[])object)[1]).getIdForDisplay())));
                    }
                    break;
                }
                case "EXPLORER/RENAMED_SELECTED_ITEM": {
                    if (this.RENAME_ITEM) {
                        Object[] names = (Object[])object;
                        this.slackUtil.sendMessage(MessageFormat.format(StringConstants.EMOJI_MSG_RENAME, this.slackUtil.fmtBold((String)names[0]), this.slackUtil.fmtBold((String)names[1])));
                    }
                    break;
                }
                case "EXPLORER/SET_SELECTED_ITEM": {
                    this.sendMsgForCreateNewEntity(object);
                    break;
                }
                case "EXPLORER/DELETED_SELECTED_ITEM": {
                    if (this.DELETE_ITEM) {
                        boolean isFolderPkg = StringUtils.endsWith((String)((String)object), (String)"/") || StringUtils.startsWith((String)((String)object), (String)FolderEntity.FolderType.KEYWORD.toString()) && !StringUtils.endsWith((String)((String)object), (String)".groovy");
                        this.slackUtil.sendMessage(MessageFormat.format(isFolderPkg ? StringConstants.EMOJI_MSG_DELETE_FOLDER : StringConstants.EMOJI_MSG_DELETE, this.slackUtil.fmtBold((String)object)));
                    }
                    break;
                }
                case "EXPLORER/COPY_PASTED_SELECTED_ITEM": {
                    if (this.COPY_PASTE) {
                        Object[] names = (Object[])object;
                        this.slackUtil.sendMessage(MessageFormat.format(StringConstants.EMOJI_MSG_COPY, this.slackUtil.fmtBold((String)names[0]), this.slackUtil.fmtBold((String)names[1])));
                    }
                    break;
                }
                case "EXPLORER/CUT_PASTED_SELECTED_ITEM": {
                    if (this.CUT_PASTE) {
                        Object[] names = (Object[])object;
                        this.slackUtil.sendMessage(MessageFormat.format(String.valueOf(StringConstants.EMOJI_MSG_MOVE) + this.slackUtil.fmtBold((String)names[0]), this.slackUtil.fmtBold((String)names[1])));
                    }
                    break;
                }
            }
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    private void sendMsgForCreateNewEntity(Object object) throws Exception {
        if (this.CREATE_TC && object != null && object instanceof TestCaseTreeEntity) {
            this.slackUtil.sendMessage(MessageFormat.format(StringConstants.EMOJI_MSG_NEW, this.slackUtil.fmtBold(((TestCaseTreeEntity)object).getObject().getIdForDisplay())));
        } else if (this.CREATE_TS && object != null && object instanceof TestSuiteTreeEntity) {
            this.slackUtil.sendMessage(MessageFormat.format(StringConstants.EMOJI_MSG_NEW, this.slackUtil.fmtBold(((TestSuiteTreeEntity)object).getObject().getIdForDisplay())));
        } else if (this.CREATE_TD && object != null && object instanceof TestDataTreeEntity) {
            this.slackUtil.sendMessage(MessageFormat.format(StringConstants.EMOJI_MSG_NEW, this.slackUtil.fmtBold(((TestDataTreeEntity)object).getObject().getIdForDisplay())));
        } else if (this.CREATE_TO && object != null && object instanceof WebElementTreeEntity) {
            this.slackUtil.sendMessage(MessageFormat.format(StringConstants.EMOJI_MSG_NEW, this.slackUtil.fmtBold(((WebElementEntity)((WebElementTreeEntity)object).getObject()).getIdForDisplay())));
        } else if (this.CREATE_KW && object != null && object instanceof KeywordTreeEntity) {
            this.slackUtil.sendMessage(MessageFormat.format(StringConstants.EMOJI_MSG_NEW, this.slackUtil.fmtBold(((IFile)((ICompilationUnit)((KeywordTreeEntity)object).getObject()).getResource()).getProjectRelativePath().toString())));
        } else if (this.CREATE_FD && object != null && object instanceof FolderTreeEntity) {
            this.slackUtil.sendMessage(MessageFormat.format(StringConstants.EMOJI_MSG_NEW, this.slackUtil.fmtBold(String.valueOf(((FolderTreeEntity)object).getObject().getRelativePathForUI().replace('\\', '/')) + '/')));
        } else if (this.CREATE_PK && object != null && object instanceof PackageTreeEntity) {
            String packageName = ((PackageTreeEntity)object).getText();
            String packageParent = String.valueOf(((IPackageFragment)((PackageTreeEntity)object).getObject()).getParent().getElementName()) + '/';
            this.slackUtil.sendMessage(MessageFormat.format(StringConstants.EMOJI_MSG_NEW, this.slackUtil.fmtBold(String.valueOf(packageParent) + packageName)));
        }
    }

    public void getSlackPreferences() {
        this.PREFERENCE = PreferenceStoreManager.getPreferenceStore(SlackSendMsgHandler.class);
        this.OPEN_PROJECT = this.PREFERENCE.getBoolean("slackConfig.sendOpenProject");
        this.CLOSE_PROJECT = this.PREFERENCE.getBoolean("slackConfig.sendCloseProject");
        this.CREATE_TC = this.PREFERENCE.getBoolean("slackConfig.sendCreateTestCase");
        this.UPDATE_TC = this.PREFERENCE.getBoolean("slackConfig.sendUpdateTestCase");
        this.CREATE_TS = this.PREFERENCE.getBoolean("slackConfig.sendCreateTestSuite");
        this.UPDATE_TS = this.PREFERENCE.getBoolean("slackConfig.sendUpdateTestSuite");
        this.CREATE_TD = this.PREFERENCE.getBoolean("slackConfig.sendCreateTestData");
        this.UPDATE_TD = this.PREFERENCE.getBoolean("slackConfig.sendUpdateTestData");
        this.CREATE_TO = this.PREFERENCE.getBoolean("slackConfig.sendCreateTestObject");
        this.UPDATE_TO = this.PREFERENCE.getBoolean("slackConfig.sendUpdateTestObject");
        this.CREATE_KW = this.PREFERENCE.getBoolean("slackConfig.sendCreateKeyword");
        this.CREATE_FD = this.PREFERENCE.getBoolean("slackConfig.sendCreateFolder");
        this.CREATE_PK = this.PREFERENCE.getBoolean("slackConfig.sendCreatePackage");
        this.COPY_PASTE = this.PREFERENCE.getBoolean("slackConfig.sendPasteFromCopy");
        this.CUT_PASTE = this.PREFERENCE.getBoolean("slackConfig.sendPasteFromCut");
        this.RENAME_ITEM = this.PREFERENCE.getBoolean("slackConfig.sendRenameItem");
        this.DELETE_ITEM = this.PREFERENCE.getBoolean("slackConfig.sendDeleteItem");
    }
}

