/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.webui.setting;

import com.kms.katalon.composer.components.dialogs.PreferencePageWithHelp;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.webui.constants.ComposerWebuiMessageConstants;
import com.kms.katalon.composer.webui.constants.ImageConstants;
import com.kms.katalon.composer.webui.constants.StringConstants;
import com.kms.katalon.constants.DocumentationMessageConstants;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.core.testobject.SelectorMethod;
import com.kms.katalon.execution.webui.setting.WebUiExecutionSettingStore;
import com.kms.katalon.util.collections.Pair;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

public class WebLocatorsPerferencePage
extends PreferencePageWithHelp {
    private static final String MSG_PROPERTY_NAME_IS_EXISTED = ComposerWebuiMessageConstants.MSG_PROPERTY_NAME_IS_EXISTED;
    private static final String GRP_LBL_DEFAULT_SELECTED_PROPERTIES_FOR_CAPTURED_TEST_OBJECT = ComposerWebuiMessageConstants.GRP_LBL_DEFAULT_SELECTED_PROPERTIES_FOR_CAPTURED_TEST_OBJECT;
    private static final String GRP_LBL_DEFAULT_XPATHS_USAGE_TIPS = ComposerWebuiMessageConstants.GRP_LBL_DEFAULT_XPATHS_USAGE_TIPS;
    private static final String COL_LBL_DETECT_OBJECT_BY = ComposerWebuiMessageConstants.COL_LBL_DETECT_OBJECT_BY;
    private static final String LBL_XPATH_SELECTION_METHOD = ComposerWebuiMessageConstants.LBL_XPATH_SELECTION_METHOD;
    private static final String LBL_ATTRIBUTE_SELECTION_METHOD = ComposerWebuiMessageConstants.LBL_ATTRIBUTE_SELECTION_METHOD;
    private WebUiExecutionSettingStore store = new WebUiExecutionSettingStore(ProjectController.getInstance().getCurrentProject());
    private Group locatorGroup;
    private Composite container;
    private Composite tablePropertyComposite;
    private Composite tableXpathComposite;
    ToolItem tiPropertyAdd;
    ToolItem tiPropertyDelete;
    ToolItem tiPropertyClear;
    private Button radioXpath;
    private Button radioAttribute;
    private Button resetDefault;
    private Table tProperty;
    private Table tXpath;
    private TableViewer tvProperty;
    private TableViewer tvXpath;
    private TableViewerColumn cvPropertyName;
    private TableViewerColumn cvPropertySelected;
    private TableViewerColumn cvXpathName;
    private Composite compositeAttributeTableToolBar;
    private Composite compositeXpathTableToolBar;
    private TableColumn cName;
    private TableColumn cSelected;
    private List<Pair<String, Boolean>> defaultSelectingCapturedObjectProperties = Collections.emptyList();
    private List<Pair<String, Boolean>> defaultSelectingCapturedObjectXpaths = Collections.emptyList();
    private SelectorMethod defaultSelectingCapturedObjecSelectionMethods = SelectorMethod.XPATH;

    public WebLocatorsPerferencePage() {
        this.noDefaultAndApplyButton();
    }

    protected Control createContents(Composite parent) {
        this.container = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.verticalSpacing = 10;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.container.setLayout((Layout)layout);
        this.createTestObjectLocatorSettings(this.container);
        try {
            this.initialize();
        }
        catch (IOException e) {
            LoggerSingleton.logError((Throwable)e);
        }
        this.registerListeners();
        return this.container;
    }

    private void createSelectionMethodComposite(Composite parent) {
        Composite selectionMethodComposite = new Composite(parent, 0);
        selectionMethodComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        GridLayout glSelectionMethodComp = new GridLayout(3, false);
        glSelectionMethodComp.marginHeight = 0;
        glSelectionMethodComp.marginWidth = 0;
        selectionMethodComposite.setLayout((Layout)glSelectionMethodComp);
        Label lblSelectionMethod = new Label(selectionMethodComposite, 0);
        lblSelectionMethod.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        Composite radioSelectionComposite = new Composite(selectionMethodComposite, 0);
        radioSelectionComposite.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        GridLayout glRadioSelection = new GridLayout(3, false);
        glRadioSelection.marginHeight = 0;
        glRadioSelection.marginWidth = 0;
        glRadioSelection.marginLeft = 10;
        radioSelectionComposite.setLayout((Layout)glRadioSelection);
        this.radioXpath = new Button(radioSelectionComposite, 16);
        this.radioXpath.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        this.radioXpath.setText(LBL_XPATH_SELECTION_METHOD);
        this.radioAttribute = new Button(radioSelectionComposite, 16);
        this.radioAttribute.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        this.radioAttribute.setText(LBL_ATTRIBUTE_SELECTION_METHOD);
    }

    private void createTestObjectLocatorSettings(Composite container) {
        this.locatorGroup = new Group(container, 0);
        this.locatorGroup.setLayout((Layout)new GridLayout());
        this.locatorGroup.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        Composite locatorContainer = new Composite((Composite)this.locatorGroup, 0);
        locatorContainer.setLayout((Layout)new GridLayout());
        locatorContainer.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createSelectionMethodComposite(locatorContainer);
        this.createAttributeTableToolbar(locatorContainer);
        this.createXpathTableToolbar(locatorContainer);
        this.createPropertyTable(locatorContainer);
        this.createXpathTable(locatorContainer);
    }

    private void createAttributeTableToolbar(Composite parent) {
        this.compositeAttributeTableToolBar = new Composite(parent, 0);
        this.compositeAttributeTableToolBar.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.compositeAttributeTableToolBar.setLayout((Layout)new FillLayout(256));
        ToolBar tb = new ToolBar(this.compositeAttributeTableToolBar, 0x820000);
        this.tiPropertyAdd = new ToolItem(tb, 8);
        this.tiPropertyAdd.setText(StringConstants.ADD);
        this.tiPropertyAdd.setImage(ImageConstants.IMG_16_ADD);
        this.tiPropertyDelete = new ToolItem(tb, 8);
        this.tiPropertyDelete.setText(StringConstants.DELETE);
        this.tiPropertyDelete.setImage(ImageConstants.IMG_16_DELETE);
        this.tiPropertyDelete.setEnabled(false);
        this.tiPropertyClear = new ToolItem(tb, 8);
        this.tiPropertyClear.setText(StringConstants.CLEAR);
        this.tiPropertyClear.setImage(ImageConstants.IMG_16_CLEAR);
    }

    private void createXpathTableToolbar(Composite parent) {
        this.compositeXpathTableToolBar = new Composite(parent, 0);
        this.compositeXpathTableToolBar.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.compositeXpathTableToolBar.setLayout((Layout)new GridLayout(1, false));
        this.resetDefault = new Button(this.compositeXpathTableToolBar, 64);
        this.resetDefault.setLayoutData((Object)new GridData(4, 4, false, false));
        this.resetDefault.setText(StringConstants.RESET_DEFAULT);
    }

    private void createPropertyTable(Composite parent) {
        this.tablePropertyComposite = new Composite(parent, 0);
        GridData ldTableComposite = new GridData(4, 4, true, true);
        ldTableComposite.minimumHeight = 70;
        ldTableComposite.heightHint = 380;
        this.tablePropertyComposite.setLayoutData((Object)ldTableComposite);
        TableColumnLayout tableColumnLayout = new TableColumnLayout();
        this.tablePropertyComposite.setLayout((Layout)tableColumnLayout);
        this.tvProperty = new TableViewer(this.tablePropertyComposite, 68354);
        this.tvProperty.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.tProperty = this.tvProperty.getTable();
        this.tProperty.setHeaderVisible(true);
        this.tProperty.setLinesVisible(true);
        this.cvPropertyName = new TableViewerColumn(this.tvProperty, 16384);
        this.cName = this.cvPropertyName.getColumn();
        this.cName.setText(StringConstants.NAME);
        this.cvPropertyName.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return (String)((Pair)element).getLeft();
            }
        });
        this.cvPropertyName.setEditingSupport(new EditingSupport(this.cvPropertyName.getViewer()){

            protected void setValue(Object element, Object value) {
                boolean isExisted;
                String newName = String.valueOf(value);
                if (StringUtils.isBlank((CharSequence)newName)) {
                    WebLocatorsPerferencePage.this.defaultSelectingCapturedObjectProperties.remove(element);
                    WebLocatorsPerferencePage.this.tvProperty.refresh();
                    return;
                }
                if (StringUtils.equals((CharSequence)((CharSequence)((Pair)element).getLeft()), (CharSequence)newName)) {
                    return;
                }
                boolean bl = isExisted = WebLocatorsPerferencePage.this.defaultSelectingCapturedObjectProperties.stream().filter(i -> ((String)i.getLeft()).equals(newName)).count() > 0L;
                if (isExisted) {
                    MessageDialog.openWarning((Shell)WebLocatorsPerferencePage.this.getShell(), (String)StringConstants.WARN, (String)MSG_PROPERTY_NAME_IS_EXISTED);
                    WebLocatorsPerferencePage.this.tvProperty.refresh();
                    return;
                }
                ((Pair)element).setLeft((Object)newName);
                WebLocatorsPerferencePage.this.tvProperty.update(element, null);
            }

            protected Object getValue(Object element) {
                return ((Pair)element).getLeft();
            }

            protected CellEditor getCellEditor(Object element) {
                return new TextCellEditor((Composite)WebLocatorsPerferencePage.this.tProperty);
            }

            protected boolean canEdit(Object element) {
                return true;
            }
        });
        this.cvPropertySelected = new TableViewerColumn(this.tvProperty, 0x1000000);
        this.cSelected = this.cvPropertySelected.getColumn();
        this.cSelected.setText(COL_LBL_DETECT_OBJECT_BY);
        this.cvPropertySelected.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                Object property = cell.getElement();
                if (!(property instanceof Pair)) {
                    return;
                }
                Boolean isSelected = (Boolean)((Pair)property).getRight();
                FontDescriptor fontDescriptor = FontDescriptor.createFrom((Font)cell.getFont());
                Font font = fontDescriptor.setStyle(0).setHeight(13).createFont((Device)WebLocatorsPerferencePage.this.tProperty.getDisplay());
                cell.setFont(font);
                cell.setText(WebLocatorsPerferencePage.this.getCheckboxSymbol(isSelected));
            }
        });
        this.cvPropertySelected.setEditingSupport(new EditingSupport(this.cvPropertySelected.getViewer()){

            protected void setValue(Object element, Object value) {
                ((Pair)element).setRight((Object)((Boolean)value));
                WebLocatorsPerferencePage.this.tvProperty.update(element, null);
            }

            protected Object getValue(Object element) {
                return ((Pair)element).getRight();
            }

            protected CellEditor getCellEditor(Object element) {
                return new CheckboxCellEditor();
            }

            protected boolean canEdit(Object element) {
                return true;
            }
        });
        tableColumnLayout.setColumnData((Widget)this.cName, (ColumnLayoutData)new ColumnWeightData(80, 100));
        tableColumnLayout.setColumnData((Widget)this.cSelected, (ColumnLayoutData)new ColumnWeightData(20, 100));
    }

    private void createXpathTable(Composite parent) {
        this.tableXpathComposite = new Composite(parent, 0);
        GridData ldTableComposite = new GridData(4, 4, true, true);
        ldTableComposite.minimumHeight = 70;
        ldTableComposite.heightHint = 380;
        this.tableXpathComposite.setLayoutData((Object)ldTableComposite);
        TableColumnLayout tableColumnLayout = new TableColumnLayout();
        this.tableXpathComposite.setLayout((Layout)tableColumnLayout);
        this.tvXpath = new TableViewer(this.tableXpathComposite, 68354);
        this.tvXpath.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.tvXpath.addDragSupport(2, new Transfer[]{TextTransfer.getInstance()}, (DragSourceListener)new DragSourceAdapter(){

            public void dragSetData(DragSourceEvent event) {
                StructuredSelection selection = (StructuredSelection)WebLocatorsPerferencePage.this.tvXpath.getSelection();
                Pair xpath = (Pair)selection.getFirstElement();
                event.data = String.valueOf(WebLocatorsPerferencePage.this.defaultSelectingCapturedObjectXpaths.indexOf(xpath));
            }
        });
        this.tvXpath.addDropSupport(2, new Transfer[]{TextTransfer.getInstance()}, (DropTargetListener)new DropTargetAdapter(){

            public void drop(DropTargetEvent event) {
                Pair item = (Pair)((TableItem)event.item).getData();
                int newIndex = WebLocatorsPerferencePage.this.defaultSelectingCapturedObjectXpaths.indexOf(item);
                String index = (String)event.data;
                if (index != null && newIndex >= 0) {
                    int indexVal = Integer.parseInt(index);
                    Pair xpath = (Pair)WebLocatorsPerferencePage.this.defaultSelectingCapturedObjectXpaths.get(indexVal);
                    WebLocatorsPerferencePage.this.defaultSelectingCapturedObjectXpaths.remove(indexVal);
                    WebLocatorsPerferencePage.this.defaultSelectingCapturedObjectXpaths.add(newIndex, xpath);
                    WebLocatorsPerferencePage.this.tvXpath.setSelection((ISelection)new StructuredSelection((Object)xpath));
                    WebLocatorsPerferencePage.this.tvXpath.refresh();
                }
            }
        });
        this.tXpath = this.tvXpath.getTable();
        this.tXpath.setHeaderVisible(true);
        this.tXpath.setLinesVisible(true);
        this.cvXpathName = new TableViewerColumn(this.tvXpath, 16384);
        this.cName = this.cvXpathName.getColumn();
        this.cName.setText(StringConstants.NAME);
        this.cvXpathName.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return (String)((Pair)element).getLeft();
            }
        });
        tableColumnLayout.setColumnData((Widget)this.cName, (ColumnLayoutData)new ColumnWeightData(80, 100));
    }

    private String getCheckboxSymbol(boolean isChecked) {
        return isChecked ? "\u2611" : "\u2610";
    }

    protected void registerListeners() {
        this.tiPropertyAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Pair element = Pair.of((Object)StringConstants.EMPTY, (Object)false);
                WebLocatorsPerferencePage.this.defaultSelectingCapturedObjectProperties.add(element);
                WebLocatorsPerferencePage.this.tvProperty.refresh();
                WebLocatorsPerferencePage.this.tvProperty.editElement((Object)element, 0);
            }
        });
        this.tiPropertyDelete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int[] selectedPropertyIndices = WebLocatorsPerferencePage.this.tProperty.getSelectionIndices();
                if (selectedPropertyIndices.length == 0) {
                    return;
                }
                List selectedProperties = Arrays.stream(selectedPropertyIndices).boxed().map(i -> (Pair)WebLocatorsPerferencePage.this.defaultSelectingCapturedObjectProperties.get((int)i)).collect(Collectors.toList());
                WebLocatorsPerferencePage.this.defaultSelectingCapturedObjectProperties.removeAll(selectedProperties);
                WebLocatorsPerferencePage.this.tvProperty.refresh();
            }
        });
        this.tiPropertyClear.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WebLocatorsPerferencePage.this.defaultSelectingCapturedObjectProperties.clear();
                WebLocatorsPerferencePage.this.tvProperty.refresh();
            }
        });
        this.tvProperty.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StructuredSelection selection = (StructuredSelection)WebLocatorsPerferencePage.this.tvProperty.getSelection();
                WebLocatorsPerferencePage.this.tiPropertyDelete.setEnabled(selection != null && selection.getFirstElement() != null);
            }
        });
        this.radioAttribute.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WebLocatorsPerferencePage.this.defaultSelectingCapturedObjecSelectionMethods = SelectorMethod.BASIC;
                WebLocatorsPerferencePage.this.locatorGroup.setText(GRP_LBL_DEFAULT_SELECTED_PROPERTIES_FOR_CAPTURED_TEST_OBJECT);
                WebLocatorsPerferencePage.this.showComposite(WebLocatorsPerferencePage.this.compositeAttributeTableToolBar, true);
                WebLocatorsPerferencePage.this.showComposite(WebLocatorsPerferencePage.this.compositeXpathTableToolBar, false);
                WebLocatorsPerferencePage.this.showComposite(WebLocatorsPerferencePage.this.tablePropertyComposite, true);
                WebLocatorsPerferencePage.this.showComposite(WebLocatorsPerferencePage.this.tableXpathComposite, false);
                WebLocatorsPerferencePage.this.resetDefault.setVisible(false);
            }
        });
        this.radioXpath.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WebLocatorsPerferencePage.this.defaultSelectingCapturedObjecSelectionMethods = SelectorMethod.XPATH;
                WebLocatorsPerferencePage.this.locatorGroup.setText(GRP_LBL_DEFAULT_XPATHS_USAGE_TIPS);
                WebLocatorsPerferencePage.this.showComposite(WebLocatorsPerferencePage.this.compositeAttributeTableToolBar, false);
                WebLocatorsPerferencePage.this.showComposite(WebLocatorsPerferencePage.this.compositeXpathTableToolBar, true);
                WebLocatorsPerferencePage.this.showComposite(WebLocatorsPerferencePage.this.tablePropertyComposite, false);
                WebLocatorsPerferencePage.this.showComposite(WebLocatorsPerferencePage.this.tableXpathComposite, true);
                WebLocatorsPerferencePage.this.resetDefault.setVisible(true);
            }
        });
        this.resetDefault.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    WebLocatorsPerferencePage.this.setInputForCapturedObjectXpathSetting(WebLocatorsPerferencePage.this.store.getDefaultCapturedObjectXpathLocators());
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        });
    }

    private void initialize() throws IOException {
        if (this.store.getCapturedTestObjectSelectorMethod() != null) {
            if (this.store.getCapturedTestObjectSelectorMethod() == SelectorMethod.BASIC) {
                this.locatorGroup.setText(GRP_LBL_DEFAULT_SELECTED_PROPERTIES_FOR_CAPTURED_TEST_OBJECT);
                this.resetDefault.setVisible(false);
            } else if (this.store.getCapturedTestObjectSelectorMethod() == SelectorMethod.XPATH) {
                this.locatorGroup.setText(GRP_LBL_DEFAULT_XPATHS_USAGE_TIPS);
                this.resetDefault.setVisible(true);
            }
        }
        this.setInputForCapturedObjectPropertySetting(this.store.getCapturedTestObjectAttributeLocators());
        this.setSelectionForCapturedObjectSelectionSetting(this.store.getCapturedTestObjectSelectorMethod());
        this.setInputForCapturedObjectXpathSetting(this.store.getCapturedTestObjectXpathLocators());
        this.showComposite(this.tablePropertyComposite, this.store.getCapturedTestObjectSelectorMethod() != null && this.store.getCapturedTestObjectSelectorMethod() == SelectorMethod.BASIC);
        this.showComposite(this.tableXpathComposite, this.store.getCapturedTestObjectSelectorMethod() != null && this.store.getCapturedTestObjectSelectorMethod() == SelectorMethod.XPATH);
        this.showComposite(this.compositeAttributeTableToolBar, this.store.getCapturedTestObjectSelectorMethod() != null && this.store.getCapturedTestObjectSelectorMethod() == SelectorMethod.BASIC);
        this.showComposite(this.compositeXpathTableToolBar, this.store.getCapturedTestObjectSelectorMethod() != null && this.store.getCapturedTestObjectSelectorMethod() == SelectorMethod.XPATH);
        this.radioXpath.setSelection(this.store.getCapturedTestObjectSelectorMethod() == SelectorMethod.XPATH);
        this.radioAttribute.setSelection(this.store.getCapturedTestObjectSelectorMethod() == SelectorMethod.BASIC);
    }

    private void setInputForCapturedObjectPropertySetting(List<Pair<String, Boolean>> input) {
        this.defaultSelectingCapturedObjectProperties = input;
        this.tvProperty.setInput(this.defaultSelectingCapturedObjectProperties);
    }

    private void setInputForCapturedObjectXpathSetting(List<Pair<String, Boolean>> input) {
        this.defaultSelectingCapturedObjectXpaths = input;
        this.tvXpath.setInput(this.defaultSelectingCapturedObjectXpaths);
    }

    private void setSelectionForCapturedObjectSelectionSetting(SelectorMethod defaultSelectionMethod) {
        this.defaultSelectingCapturedObjecSelectionMethods = defaultSelectionMethod;
        switch (defaultSelectionMethod) {
            case XPATH: {
                this.radioXpath.setSelection(true);
                this.radioAttribute.setSelection(false);
                break;
            }
            case BASIC: {
                this.radioXpath.setSelection(false);
                this.radioAttribute.setSelection(true);
                break;
            }
        }
    }

    protected void performDefaults() {
        if (this.container == null) {
            return;
        }
        try {
            this.store.setDefaultCapturedTestObjectAttributeLocators();
            this.store.setDefaultCapturedTestObjectXpathLocators();
            this.store.setDefaultCapturedTestObjectSelectorMethods();
            this.setInputForCapturedObjectPropertySetting(this.store.getCapturedTestObjectAttributeLocators());
            this.setInputForCapturedObjectXpathSetting(this.store.getCapturedTestObjectXpathLocators());
        }
        catch (IOException e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    public boolean performOk() {
        if (super.performOk() && this.isValid() && this.tvProperty != null) {
            try {
                List emptyPropertyItems = this.defaultSelectingCapturedObjectProperties.stream().filter(i -> ((String)i.getLeft()).isEmpty()).collect(Collectors.toList());
                this.defaultSelectingCapturedObjectProperties.removeAll(emptyPropertyItems);
                List emptyXpathItems = this.defaultSelectingCapturedObjectXpaths.stream().filter(i -> ((String)i.getLeft()).isEmpty()).collect(Collectors.toList());
                this.defaultSelectingCapturedObjectXpaths.removeAll(emptyXpathItems);
                this.store.setCapturedTestObjectAttributeLocators(this.defaultSelectingCapturedObjectProperties);
                this.store.setCapturedTestObjectXpathLocators(this.defaultSelectingCapturedObjectXpaths);
                this.store.setCapturedTestObjectSelectorMethod(this.defaultSelectingCapturedObjecSelectionMethods);
            }
            catch (IOException e) {
                LoggerSingleton.logError((Throwable)e);
            }
        }
        return true;
    }

    private void showComposite(Composite composite, boolean isVisible) {
        composite.setVisible(isVisible);
        ((GridData)composite.getLayoutData()).exclude = !isVisible;
        composite.getParent().layout();
    }

    public boolean hasDocumentation() {
        return true;
    }

    public String getDocumentationUrl() {
        return DocumentationMessageConstants.SETTINGS_WEBLOCATORS;
    }
}

