/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.webui.setting;

import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.webui.setting.RemoteDebugPreferencePage;
import com.kms.katalon.execution.webui.driver.RemoteDebugDriverConnector;
import com.kms.katalon.execution.webui.driver.RemoteFirefoxDriverConnector;
import com.kms.katalon.execution.webui.driver.WebUiDriverConnector;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.openqa.selenium.firefox.internal.ClasspathExtension;
import org.openqa.selenium.firefox.internal.Extension;

public class RemoteFirefoxPreferencePage
extends RemoteDebugPreferencePage {
    @Override
    public WebUiDriverConnector createDriverConnector(String configurationFolderPath) {
        try {
            if (this.remoteDebugDriverConnector == null) {
                this.remoteDebugDriverConnector = new RemoteFirefoxDriverConnector(configurationFolderPath);
            }
            return this.remoteDebugDriverConnector;
        }
        catch (IOException e) {
            LoggerSingleton.logError((Throwable)e);
            return null;
        }
    }

    @Override
    public void doInstallDebuger() {
        if (!System.getProperty("os.name").toLowerCase().contains("windows")) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)"This platform has not been supported");
            return;
        }
        String profileLocation = this.getProfileLocation();
        ConfigurationDialog dlg = new ConfigurationDialog(this.getShell(), profileLocation);
        dlg.open();
    }

    private String getProfileLocation() {
        File iniFile = new File(String.valueOf(System.getenv("APPDATA")) + "/Mozilla/Firefox/profiles.ini");
        if (iniFile.exists()) {
            for (Map<String, String> map : this.readProfilesIni(iniFile)) {
                if (!"1".equals(map.get("Default")) || map.get("Path") == null) continue;
                return String.valueOf(iniFile.getParentFile().getAbsolutePath()) + File.separator + map.get("Path").replace("/", File.separator);
            }
        }
        return "";
    }

    private List<Map<String, String>> readProfilesIni(File iniFile) {
        ArrayList<Map<String, String>> profilesIni;
        block8: {
            profilesIni = new ArrayList<Map<String, String>>();
            if (!iniFile.isFile()) {
                return profilesIni;
            }
            BufferedReader br = null;
            try {
                try {
                    String line;
                    br = new BufferedReader(new FileReader(iniFile));
                    while ((line = br.readLine()) != null) {
                        if (line.matches("\\[Profile\\d+\\]")) {
                            profilesIni.add(new LinkedHashMap());
                            continue;
                        }
                        if (profilesIni.size() <= 0 || line.indexOf("=") <= 0) continue;
                        ((Map)profilesIni.get(profilesIni.size() - 1)).put(line.substring(0, line.indexOf("=")), line.substring(line.indexOf("=") + 1));
                    }
                    br.close();
                }
                catch (IOException iOException) {
                    IOUtils.closeQuietly(br);
                    break block8;
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(br);
                throw throwable;
            }
            IOUtils.closeQuietly((Reader)br);
        }
        return profilesIni;
    }

    private void updatePreference(String profileFolder, String prefKey, String newVal) throws IOException {
        File oldPrefsFile = new File(profileFolder, "prefs.js");
        if (oldPrefsFile.isFile()) {
            List lines = FileUtils.readLines((File)oldPrefsFile);
            boolean found = false;
            int i = 0;
            while (i < lines.size()) {
                if (lines.get(i) != null && ((String)lines.get(i)).startsWith("user_pref(\"" + prefKey + "\"")) {
                    lines.set(i, "user_pref(\"webdriver_firefox_port\", " + newVal + ");");
                    found = true;
                    break;
                }
                ++i;
            }
            if (!found) {
                lines.add("user_pref(\"webdriver_firefox_port\", " + newVal + ");");
            }
            FileUtils.writeLines((File)oldPrefsFile, (Collection)lines, (boolean)false);
        }
    }

    private class ConfigurationDialog
    extends TitleAreaDialog {
        private Text txtProfileLocation;
        private String profileLocation;
        private Button btnFolderChooser;

        public ConfigurationDialog(Shell parentShell, String profileLocation) {
            super(parentShell);
            this.profileLocation = profileLocation;
        }

        protected Control createDialogArea(Composite parent) {
            Composite area = (Composite)super.createDialogArea(parent);
            this.getShell().setText("Configuration");
            this.setTitle("Configure Firefox Remote Accessibilty");
            this.setMessage("Katalon will install an add-on into your Firefox profile");
            Composite container = new Composite(area, 0);
            container.setLayoutData((Object)new GridData(1808));
            container.setLayout((Layout)new GridLayout(2, false));
            Label lbl = new Label(container, 0);
            lbl.setText("Profile location");
            this.createFileChooserComposite(container);
            Label separator = new Label(parent, 258);
            separator.setLayoutData((Object)new GridData(768));
            return area;
        }

        private Composite createFileChooserComposite(Composite parent) {
            Composite container = new Composite(parent, 0);
            container.setLayoutData((Object)new GridData(768));
            GridLayout theLayout = new GridLayout(2, false);
            theLayout.marginWidth = 0;
            container.setLayout((Layout)theLayout);
            this.txtProfileLocation = new Text(container, 2048);
            this.txtProfileLocation.setLayoutData((Object)new GridData(768));
            this.txtProfileLocation.setText(this.profileLocation);
            this.btnFolderChooser = new Button(container, 8);
            this.btnFolderChooser.setText("Change folder");
            this.btnFolderChooser.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DirectoryDialog dialog = new DirectoryDialog(ConfigurationDialog.this.btnFolderChooser.getShell());
                    String path = dialog.open();
                    if (path != null) {
                        ConfigurationDialog.this.txtProfileLocation.setText(path);
                    }
                }
            });
            return container;
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.createButton(parent, 0, "Install add-on", true);
            this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        }

        protected void okPressed() {
            this.profileLocation = this.txtProfileLocation == null ? "" : this.txtProfileLocation.getText();
            String debugPort = ((RemoteDebugDriverConnector)RemoteFirefoxPreferencePage.this.remoteDebugDriverConnector).getDebugPort();
            File profileFolder = new File(this.profileLocation);
            try {
                RemoteFirefoxPreferencePage.this.updatePreference(this.profileLocation, "webdriver_firefox_port", debugPort);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            FirefoxProfile ffProfile = new FirefoxProfile();
            ffProfile.addExtension("webdriver", (Extension)new ClasspathExtension(FirefoxProfile.class, "/" + FirefoxProfile.class.getPackage().getName().replace(".", "/") + "/webdriver.xpi"));
            ffProfile.setPreference("webdriver_firefox_port", Integer.parseInt(debugPort));
            File tmpProfileFolder = ffProfile.layoutOnDisk();
            try {
                File[] fileArray = tmpProfileFolder.listFiles();
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    if (file.isFile()) {
                        FileUtils.copyFileToDirectory((File)file, (File)profileFolder);
                    } else if (file.isDirectory()) {
                        FileUtils.copyDirectoryToDirectory((File)file, (File)profileFolder);
                    }
                    ++n2;
                }
            }
            catch (Exception ex) {
                MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)ex.getMessage());
            }
            try {
                FileUtils.forceDelete((File)tmpProfileFolder);
            }
            catch (IOException iOException) {}
            super.okPressed();
        }
    }
}

