/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.http;

import com.google.common.base.Charsets;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.net.MediaType;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.openqa.selenium.UnsupportedCommandException;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.net.Urls;
import org.openqa.selenium.remote.Command;
import org.openqa.selenium.remote.CommandCodec;
import org.openqa.selenium.remote.SessionId;
import org.openqa.selenium.remote.http.HttpMethod;
import org.openqa.selenium.remote.http.HttpRequest;

public abstract class AbstractHttpCommandCodec
implements CommandCodec<HttpRequest> {
    private static final Splitter PATH_SPLITTER = Splitter.on('/').omitEmptyStrings();
    private static final String SESSION_ID_PARAM = "sessionId";
    private final ConcurrentHashMap<String, CommandSpec> nameToSpec = new ConcurrentHashMap();
    private final Map<String, String> aliases = new HashMap<String, String>();
    private final Json json = new Json();

    public AbstractHttpCommandCodec() {
        this.defineCommand("status", AbstractHttpCommandCodec.get("/status"));
        this.defineCommand("getAllSessions", AbstractHttpCommandCodec.get("/sessions"));
        this.defineCommand("newSession", AbstractHttpCommandCodec.post("/session"));
        this.defineCommand("getCapabilities", AbstractHttpCommandCodec.get("/session/:sessionId"));
        this.defineCommand("quit", AbstractHttpCommandCodec.delete("/session/:sessionId"));
        this.defineCommand("getSessionLogs", AbstractHttpCommandCodec.post("/logs"));
        this.defineCommand("getLog", AbstractHttpCommandCodec.post("/session/:sessionId/log"));
        this.defineCommand("getAvailableLogTypes", AbstractHttpCommandCodec.get("/session/:sessionId/log/types"));
        this.defineCommand("switchToFrame", AbstractHttpCommandCodec.post("/session/:sessionId/frame"));
        this.defineCommand("switchToParentFrame", AbstractHttpCommandCodec.post("/session/:sessionId/frame/parent"));
        this.defineCommand("close", AbstractHttpCommandCodec.delete("/session/:sessionId/window"));
        this.defineCommand("switchToWindow", AbstractHttpCommandCodec.post("/session/:sessionId/window"));
        this.defineCommand("fullscreenCurrentWindow", AbstractHttpCommandCodec.post("/session/:sessionId/window/fullscreen"));
        this.defineCommand("getCurrentUrl", AbstractHttpCommandCodec.get("/session/:sessionId/url"));
        this.defineCommand("get", AbstractHttpCommandCodec.post("/session/:sessionId/url"));
        this.defineCommand("goBack", AbstractHttpCommandCodec.post("/session/:sessionId/back"));
        this.defineCommand("goForward", AbstractHttpCommandCodec.post("/session/:sessionId/forward"));
        this.defineCommand("refresh", AbstractHttpCommandCodec.post("/session/:sessionId/refresh"));
        this.defineCommand("setAlertCredentials", AbstractHttpCommandCodec.post("/session/:sessionId/alert/credentials"));
        this.defineCommand("uploadFile", AbstractHttpCommandCodec.post("/session/:sessionId/file"));
        this.defineCommand("screenshot", AbstractHttpCommandCodec.get("/session/:sessionId/screenshot"));
        this.defineCommand("elementScreenshot", AbstractHttpCommandCodec.get("/session/:sessionId/screenshot/:id"));
        this.defineCommand("getTitle", AbstractHttpCommandCodec.get("/session/:sessionId/title"));
        this.defineCommand("findElement", AbstractHttpCommandCodec.post("/session/:sessionId/element"));
        this.defineCommand("findElements", AbstractHttpCommandCodec.post("/session/:sessionId/elements"));
        this.defineCommand("getElementProperty", AbstractHttpCommandCodec.get("/session/:sessionId/element/:id/property/:name"));
        this.defineCommand("clickElement", AbstractHttpCommandCodec.post("/session/:sessionId/element/:id/click"));
        this.defineCommand("clearElement", AbstractHttpCommandCodec.post("/session/:sessionId/element/:id/clear"));
        this.defineCommand("getElementValueOfCssProperty", AbstractHttpCommandCodec.get("/session/:sessionId/element/:id/css/:propertyName"));
        this.defineCommand("findChildElement", AbstractHttpCommandCodec.post("/session/:sessionId/element/:id/element"));
        this.defineCommand("findChildElements", AbstractHttpCommandCodec.post("/session/:sessionId/element/:id/elements"));
        this.defineCommand("isElementEnabled", AbstractHttpCommandCodec.get("/session/:sessionId/element/:id/enabled"));
        this.defineCommand("elementEquals", AbstractHttpCommandCodec.get("/session/:sessionId/element/:id/equals/:other"));
        this.defineCommand("getElementRect", AbstractHttpCommandCodec.get("/session/:sessionId/element/:id/rect"));
        this.defineCommand("getElementLocation", AbstractHttpCommandCodec.get("/session/:sessionId/element/:id/location"));
        this.defineCommand("getElementTagName", AbstractHttpCommandCodec.get("/session/:sessionId/element/:id/name"));
        this.defineCommand("isElementSelected", AbstractHttpCommandCodec.get("/session/:sessionId/element/:id/selected"));
        this.defineCommand("getElementSize", AbstractHttpCommandCodec.get("/session/:sessionId/element/:id/size"));
        this.defineCommand("getElementText", AbstractHttpCommandCodec.get("/session/:sessionId/element/:id/text"));
        this.defineCommand("sendKeysToElement", AbstractHttpCommandCodec.post("/session/:sessionId/element/:id/value"));
        this.defineCommand("getCookies", AbstractHttpCommandCodec.get("/session/:sessionId/cookie"));
        this.defineCommand("getCookie", AbstractHttpCommandCodec.get("/session/:sessionId/cookie/:name"));
        this.defineCommand("addCookie", AbstractHttpCommandCodec.post("/session/:sessionId/cookie"));
        this.defineCommand("deleteAllCookies", AbstractHttpCommandCodec.delete("/session/:sessionId/cookie"));
        this.defineCommand("deleteCookie", AbstractHttpCommandCodec.delete("/session/:sessionId/cookie/:name"));
        this.defineCommand("setTimeout", AbstractHttpCommandCodec.post("/session/:sessionId/timeouts"));
        this.defineCommand("setScriptTimeout", AbstractHttpCommandCodec.post("/session/:sessionId/timeouts/async_script"));
        this.defineCommand("implicitlyWait", AbstractHttpCommandCodec.post("/session/:sessionId/timeouts/implicit_wait"));
        this.defineCommand("getStatus", AbstractHttpCommandCodec.get("/session/:sessionId/application_cache/status"));
        this.defineCommand("isBrowserOnline", AbstractHttpCommandCodec.get("/session/:sessionId/browser_connection"));
        this.defineCommand("setBrowserOnline", AbstractHttpCommandCodec.post("/session/:sessionId/browser_connection"));
        this.defineCommand("getLocation", AbstractHttpCommandCodec.get("/session/:sessionId/location"));
        this.defineCommand("setLocation", AbstractHttpCommandCodec.post("/session/:sessionId/location"));
        this.defineCommand("getScreenOrientation", AbstractHttpCommandCodec.get("/session/:sessionId/orientation"));
        this.defineCommand("setScreenOrientation", AbstractHttpCommandCodec.post("/session/:sessionId/orientation"));
        this.defineCommand("getScreenRotation", AbstractHttpCommandCodec.get("/session/:sessionId/rotation"));
        this.defineCommand("setScreenRotation", AbstractHttpCommandCodec.post("/session/:sessionId/rotation"));
        this.defineCommand("imeGetAvailableEngines", AbstractHttpCommandCodec.get("/session/:sessionId/ime/available_engines"));
        this.defineCommand("imeGetActiveEngine", AbstractHttpCommandCodec.get("/session/:sessionId/ime/active_engine"));
        this.defineCommand("imeIsActivated", AbstractHttpCommandCodec.get("/session/:sessionId/ime/activated"));
        this.defineCommand("imeDeactivate", AbstractHttpCommandCodec.post("/session/:sessionId/ime/deactivate"));
        this.defineCommand("imeActivateEngine", AbstractHttpCommandCodec.post("/session/:sessionId/ime/activate"));
        this.defineCommand("getNetworkConnection", AbstractHttpCommandCodec.get("/session/:sessionId/network_connection"));
        this.defineCommand("setNetworkConnection", AbstractHttpCommandCodec.post("/session/:sessionId/network_connection"));
        this.defineCommand("switchToContext", AbstractHttpCommandCodec.post("/session/:sessionId/context"));
        this.defineCommand("getCurrentContextHandle", AbstractHttpCommandCodec.get("/session/:sessionId/context"));
        this.defineCommand("getContextHandles", AbstractHttpCommandCodec.get("/session/:sessionId/contexts"));
    }

    @Override
    public HttpRequest encode(Command command) {
        String name = this.aliases.getOrDefault(command.getName(), command.getName());
        CommandSpec spec = this.nameToSpec.get(name);
        if (spec == null) {
            throw new UnsupportedCommandException(command.getName());
        }
        Map<String, ?> parameters = this.amendParameters(command.getName(), command.getParameters());
        String uri = this.buildUri(name, command.getSessionId(), parameters, spec);
        HttpRequest request = new HttpRequest(spec.method, uri);
        if (HttpMethod.POST == spec.method) {
            String content = this.json.toJson(parameters);
            byte[] data = content.getBytes(Charsets.UTF_8);
            request.setHeader("Content-Length", String.valueOf(data.length));
            request.setHeader("Content-Type", MediaType.JSON_UTF_8.toString());
            request.setContent(data);
        }
        if (HttpMethod.GET == spec.method) {
            request.setHeader("Cache-Control", "no-cache");
        }
        return request;
    }

    protected abstract Map<String, ?> amendParameters(String var1, Map<String, ?> var2);

    @Override
    public Command decode(HttpRequest encodedCommand) {
        String id;
        String path = Strings.isNullOrEmpty(encodedCommand.getUri()) ? "/" : encodedCommand.getUri();
        ImmutableList<String> parts = ImmutableList.copyOf(PATH_SPLITTER.split(path));
        int minPathLength = Integer.MAX_VALUE;
        CommandSpec spec = null;
        String name = null;
        for (Map.Entry<String, CommandSpec> nameValue : this.nameToSpec.entrySet()) {
            if (nameValue.getValue().pathSegments.size() >= minPathLength || !nameValue.getValue().isFor(encodedCommand.getMethod(), parts)) continue;
            name = nameValue.getKey();
            spec = nameValue.getValue();
        }
        if (name == null) {
            throw new UnsupportedCommandException((Object)((Object)encodedCommand.getMethod()) + " " + encodedCommand.getUri());
        }
        HashMap<String, Object> parameters = Maps.newHashMap();
        spec.parsePathParameters(parts, parameters);
        String content = encodedCommand.getContentString();
        if (!content.isEmpty()) {
            Map tmp = (Map)this.json.toType((Object)content, Json.MAP_TYPE);
            parameters.putAll(tmp);
        }
        SessionId sessionId = null;
        if (parameters.containsKey(SESSION_ID_PARAM) && (id = (String)parameters.remove(SESSION_ID_PARAM)) != null) {
            sessionId = new SessionId(id);
        }
        return new Command(sessionId, name, parameters);
    }

    @Override
    public void defineCommand(String name, HttpMethod method, String pathPattern) {
        this.defineCommand(name, new CommandSpec(method, pathPattern));
    }

    @Override
    public void alias(String commandName, String isAnAliasFor) {
        this.aliases.put(commandName, isAnAliasFor);
    }

    protected void defineCommand(String name, CommandSpec spec) {
        Preconditions.checkNotNull(name, "null name");
        this.nameToSpec.put(name, spec);
    }

    protected static CommandSpec delete(String path) {
        return new CommandSpec(HttpMethod.DELETE, path);
    }

    protected static CommandSpec get(String path) {
        return new CommandSpec(HttpMethod.GET, path);
    }

    protected static CommandSpec post(String path) {
        return new CommandSpec(HttpMethod.POST, path);
    }

    private String buildUri(String commandName, SessionId sessionId, Map<String, ?> parameters, CommandSpec spec) {
        StringBuilder builder = new StringBuilder();
        for (String part : spec.pathSegments) {
            if (part.isEmpty()) continue;
            builder.append("/");
            if (part.startsWith(":")) {
                builder.append(this.getParameter(part.substring(1), commandName, sessionId, parameters));
                continue;
            }
            builder.append(part);
        }
        return builder.toString();
    }

    private String getParameter(String parameterName, String commandName, SessionId sessionId, Map<String, ?> parameters) {
        if (SESSION_ID_PARAM.equals(parameterName)) {
            SessionId id = sessionId;
            Preconditions.checkArgument(id != null, "Session ID may not be null for command %s", (Object)commandName);
            return id.toString();
        }
        Object value = parameters.get(parameterName);
        Preconditions.checkArgument(value != null, "Missing required parameter \"%s\" for command %s", (Object)parameterName, (Object)commandName);
        return Urls.urlEncode(String.valueOf(value));
    }

    protected static class CommandSpec {
        private final HttpMethod method;
        private final String path;
        private final ImmutableList<String> pathSegments;

        private CommandSpec(HttpMethod method, String path) {
            this.method = Preconditions.checkNotNull(method, "null method");
            this.path = path;
            this.pathSegments = ImmutableList.copyOf(PATH_SPLITTER.split(path));
        }

        public boolean equals(Object o) {
            if (o instanceof CommandSpec) {
                CommandSpec that = (CommandSpec)o;
                return this.method.equals((Object)that.method) && this.path.equals(that.path);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hashCode(new Object[]{this.method, this.path});
        }

        boolean isFor(HttpMethod method, ImmutableList<String> parts) {
            if (!this.method.equals((Object)method)) {
                return false;
            }
            if (parts.size() != this.pathSegments.size()) {
                return false;
            }
            for (int i = 0; i < parts.size(); ++i) {
                String reqPart = (String)parts.get(i);
                String specPart = (String)this.pathSegments.get(i);
                if (specPart.startsWith(":") || specPart.equals(reqPart)) continue;
                return false;
            }
            return true;
        }

        void parsePathParameters(ImmutableList<String> parts, Map<String, Object> parameters) {
            for (int i = 0; i < parts.size(); ++i) {
                if (!((String)this.pathSegments.get(i)).startsWith(":")) continue;
                parameters.put(((String)this.pathSegments.get(i)).substring(1), parts.get(i));
            }
        }
    }
}

