/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.firefox;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.io.CharStreams;
import com.google.common.io.Closeables;
import com.google.common.io.LineReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.openqa.selenium.json.Json;

class Preferences {
    private static final String MAX_SCRIPT_RUN_TIME_KEY = "dom.max_script_run_time";
    private static final int DEFAULT_MAX_SCRIPT_RUN_TIME = 30;
    private static final Pattern PREFERENCE_PATTERN = Pattern.compile("user_pref\\(\"([^\"]+)\", (\"?.+?\"?)\\);");
    private Map<String, Object> immutablePrefs = Maps.newHashMap();
    private Map<String, Object> allPrefs = Maps.newHashMap();

    public Preferences(Reader defaults) {
        this.readDefaultPreferences(defaults);
    }

    public Preferences(Reader defaults, File userPrefs) {
        this.readDefaultPreferences(defaults);
        try (FileReader reader = new FileReader(userPrefs);){
            this.readPreferences(reader);
        }
        catch (IOException e) {
            throw new WebDriverException(e);
        }
    }

    @VisibleForTesting
    public Preferences(Reader defaults, Reader reader) {
        this.readDefaultPreferences(defaults);
        try {
            this.readPreferences(reader);
        }
        catch (IOException e) {
            throw new WebDriverException(e);
        }
        finally {
            try {
                Closeables.close(reader, true);
            }
            catch (IOException iOException) {}
        }
    }

    private void readDefaultPreferences(Reader defaultsReader) {
        try {
            Object value;
            String rawJson = CharStreams.toString(defaultsReader);
            Map map = new Json().toType((Object)rawJson, Map.class);
            Map frozen = (Map)map.get("frozen");
            for (Map.Entry entry : frozen.entrySet()) {
                String key = (String)entry.getKey();
                value = entry.getValue();
                if (value instanceof Long) {
                    value = new Integer(((Long)value).intValue());
                }
                this.setPreference(key, value);
                this.immutablePrefs.put(key, value);
            }
            Map mutable = (Map)map.get("mutable");
            for (Map.Entry entry : mutable.entrySet()) {
                value = entry.getValue();
                if (value instanceof Long) {
                    value = new Integer(((Long)value).intValue());
                }
                this.setPreference((String)entry.getKey(), value);
            }
        }
        catch (IOException e) {
            throw new WebDriverException(e);
        }
    }

    private void setPreference(String key, Object value) {
        if (value instanceof String) {
            this.setPreference(key, (String)value);
        } else if (value instanceof Boolean) {
            this.setPreference(key, (Boolean)value);
        } else {
            this.setPreference(key, ((Number)value).intValue());
        }
    }

    private void readPreferences(Reader reader) throws IOException {
        LineReader allLines = new LineReader(reader);
        String line = allLines.readLine();
        while (line != null) {
            Matcher matcher = PREFERENCE_PATTERN.matcher(line);
            if (matcher.matches()) {
                this.allPrefs.put(matcher.group(1), this.preferenceAsValue(matcher.group(2)));
            }
            line = allLines.readLine();
        }
    }

    public void setPreference(String key, String value) {
        this.checkPreference(key, value);
        if (this.isStringified(value)) {
            throw new IllegalArgumentException(String.format("Preference values must be plain strings: %s: %s", key, value));
        }
        this.allPrefs.put(key, value);
    }

    public void setPreference(String key, boolean value) {
        this.checkPreference(key, value);
        this.allPrefs.put(key, value);
    }

    public void setPreference(String key, int value) {
        this.checkPreference(key, value);
        this.allPrefs.put(key, value);
    }

    public void addTo(Preferences prefs) {
        prefs.allPrefs.putAll(this.allPrefs);
    }

    public void addTo(FirefoxProfile profile) {
        profile.getAdditionalPreferences().allPrefs.putAll(this.allPrefs);
    }

    public void writeTo(Writer writer) throws IOException {
        for (Map.Entry<String, Object> pref : this.allPrefs.entrySet()) {
            writer.append("user_pref(\"").append(pref.getKey()).append("\", ");
            writer.append(this.valueAsPreference(pref.getValue()));
            writer.append(");\n");
        }
    }

    private String valueAsPreference(Object value) {
        if (value instanceof String) {
            return "\"" + this.escapeValueAsPreference((String)value) + "\"";
        }
        return this.escapeValueAsPreference(String.valueOf(value));
    }

    private String escapeValueAsPreference(String value) {
        return value.replaceAll("\\\\", "\\\\\\\\").replaceAll("\"", "\\\\\"");
    }

    private Object preferenceAsValue(String toConvert) {
        if (toConvert.startsWith("\"") && toConvert.endsWith("\"")) {
            return toConvert.substring(1, toConvert.length() - 1).replaceAll("\\\\\\\\", "\\\\");
        }
        if ("false".equals(toConvert) || "true".equals(toConvert)) {
            return Boolean.parseBoolean(toConvert);
        }
        try {
            return Integer.parseInt(toConvert);
        }
        catch (NumberFormatException e) {
            throw new WebDriverException(e);
        }
    }

    @VisibleForTesting
    protected Object getPreference(String key) {
        return this.allPrefs.get(key);
    }

    private boolean isStringified(String value) {
        return value.startsWith("\"") && value.endsWith("\"");
    }

    public void putAll(Map<String, Object> frozenPreferences) {
        this.allPrefs.putAll(frozenPreferences);
    }

    private void checkPreference(String key, Object value) {
        Preconditions.checkNotNull(value);
        Preconditions.checkArgument(!this.immutablePrefs.containsKey(key) || this.immutablePrefs.containsKey(key) && value.equals(this.immutablePrefs.get(key)), "Preference %s may not be overridden: frozen value=%s, requested value=%s", (Object)key, this.immutablePrefs.get(key), value);
        if (MAX_SCRIPT_RUN_TIME_KEY.equals(key)) {
            int n;
            if (value instanceof String) {
                n = Integer.parseInt((String)value);
            } else if (value instanceof Integer) {
                n = (Integer)value;
            } else {
                throw new IllegalArgumentException(String.format("%s value must be a number: %s", MAX_SCRIPT_RUN_TIME_KEY, value.getClass().getName()));
            }
            Preconditions.checkArgument(n == 0 || n >= 30, "%s must be == 0 || >= %s", (Object)MAX_SCRIPT_RUN_TIME_KEY, 30);
        }
    }
}

