/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.edge;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.Platform;
import org.openqa.selenium.Proxy;

public class EdgeOptions
extends MutableCapabilities {
    public static final String CAPABILITY = "edgeOptions";

    public EdgeOptions() {
        this.setCapability("browserName", "MicrosoftEdge");
        this.setCapability("platform", Platform.WINDOWS);
    }

    @Override
    public EdgeOptions merge(Capabilities extraCapabilities) {
        super.merge(extraCapabilities);
        return this;
    }

    public void setPageLoadStrategy(String strategy) {
        this.setCapability("pageLoadStrategy", Objects.requireNonNull(strategy));
    }

    public EdgeOptions setProxy(Proxy proxy) {
        this.setCapability("proxy", proxy);
        return this;
    }

    MutableCapabilities toCapabilities() {
        return this;
    }

    @Override
    public Map<String, Object> asMap() {
        return ImmutableMap.of(CAPABILITY, super.asMap());
    }
}

