/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.grid.web.servlet;

import com.google.common.collect.ImmutableMap;
import com.google.common.net.MediaType;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.openqa.grid.internal.GridRegistry;
import org.openqa.grid.internal.RemoteProxy;
import org.openqa.selenium.internal.BuildInfo;
import org.openqa.selenium.json.Json;

public class HubW3CStatusServlet
extends HttpServlet {
    private final GridRegistry registry;

    public HubW3CStatusServlet(GridRegistry registry) {
        this.registry = Objects.requireNonNull(registry);
    }

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        List<RemoteProxy> allProxies = this.registry.getAllProxies().getSorted();
        List busyProxies = allProxies.parallelStream().filter(proxy -> proxy.getMaxNumberOfConcurrentTestSessions() - proxy.getTotalUsed() <= 0).collect(Collectors.toList());
        ImmutableMap.Builder<String, Object> value = ImmutableMap.builder();
        boolean availableProxies = allProxies.size() > busyProxies.size();
        value.put("ready", availableProxies);
        value.put("message", availableProxies ? "Hub has capacity" : "No spare hub capacity");
        BuildInfo buildInfo = new BuildInfo();
        value.put("build", ImmutableMap.of("revision", buildInfo.getBuildRevision(), "time", buildInfo.getBuildTime(), "version", buildInfo.getReleaseLabel()));
        value.put("os", ImmutableMap.of("arch", System.getProperty("os.arch"), "name", System.getProperty("os.name"), "version", System.getProperty("os.version")));
        value.put("java", ImmutableMap.of("version", System.getProperty("java.version")));
        ImmutableMap payloadObj = ImmutableMap.of("status", 0, "value", value.build());
        byte[] payload = new Json().toJson(payloadObj).getBytes(StandardCharsets.UTF_8);
        resp.setStatus(200);
        resp.setHeader("Content-Type", MediaType.JSON_UTF_8.toString());
        resp.setHeader("Content-Length", String.valueOf(payload.length));
        try (ServletOutputStream out = resp.getOutputStream();){
            out.write(payload);
        }
    }
}

