/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.grid.selenium.node;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.ImmutableCapabilities;

public class FirefoxMutator
implements Function<ImmutableCapabilities, ImmutableCapabilities> {
    private final Object binary;
    private final Object marionette;

    public FirefoxMutator(Capabilities config) {
        if ("firefox".equals(config.getBrowserName())) {
            this.binary = config.getCapability("firefox_binary");
            this.marionette = config.getCapability("marionette");
        } else {
            this.binary = null;
            this.marionette = null;
        }
    }

    @Override
    public ImmutableCapabilities apply(ImmutableCapabilities capabilities) {
        if (this.binary == null && this.marionette == null || !"firefox".equals(capabilities.getBrowserName())) {
            return capabilities;
        }
        HashMap<String, Object> options = new HashMap<String, Object>();
        if (capabilities.getCapability("moz:firefoxOptions") instanceof Map) {
            Map originalOptions = (Map)capabilities.getCapability("moz:firefoxOptions");
            options.putAll(originalOptions);
        }
        HashMap<String, Object> toReturn = new HashMap<String, Object>();
        toReturn.putAll(capabilities.asMap());
        if (this.binary != null) {
            if (!(capabilities.getCapability("firefox_binary") instanceof String)) {
                toReturn.put("firefox_binary", this.binary);
            }
            if (!(options.get("binary") instanceof String)) {
                options.put("binary", this.binary);
            }
        }
        if (this.marionette != null) {
            toReturn.put("marionette", this.marionette);
        }
        if (!options.isEmpty()) {
            toReturn.put("moz:firefoxOptions", options);
        }
        return new ImmutableCapabilities(toReturn);
    }
}

