/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.util.internal;

import com.kms.katalon.core.configuration.RunConfiguration;
import com.kms.katalon.core.util.ConsoleCommandExecutor;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinNT;
import java.io.IOException;
import java.lang.reflect.Field;

public class ProcessUtil {
    private static int getPidOfUnixProcess(Process p) throws NoSuchFieldException, IllegalAccessException {
        Field f = p.getClass().getDeclaredField("pid");
        f.setAccessible(true);
        return (Integer)f.get(p);
    }

    private static WinNT.HANDLE getHandle(Process p) throws ReflectiveOperationException {
        Field f = p.getClass().getDeclaredField("handle");
        f.setAccessible(true);
        long hndl = f.getLong(p);
        WinNT.HANDLE handle = new WinNT.HANDLE();
        handle.setPointer(Pointer.createConstant((long)hndl));
        return handle;
    }

    public static void terminateProcess(Process p) throws ReflectiveOperationException, IOException {
        if (Platform.isWindows()) {
            ProcessUtil.terminateWindowsProcess(p);
        } else if (Platform.isLinux() || Platform.isMac()) {
            int pid = ProcessUtil.getPidOfUnixProcess(p);
            try {
                ConsoleCommandExecutor.runConsoleCommandAndCollectFirstResult(new String[]{"kill", "-9", String.valueOf(pid)});
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private static void terminateWindowsProcess(Process p) throws ReflectiveOperationException {
        WinNT.HANDLE handle = null;
        try {
            handle = ProcessUtil.getHandle(p);
            Kernel32.INSTANCE.TerminateProcess(handle, 0);
            Kernel32.INSTANCE.WaitForSingleObject(handle, RunConfiguration.getTimeOut() * 1000);
        }
        finally {
            if (handle != null) {
                Kernel32.INSTANCE.CloseHandle(handle);
            }
        }
    }

    public static void killProcessOnWindows(String processName) throws InterruptedException, IOException {
        ProcessBuilder pb = new ProcessBuilder("taskkill", "/f", "/im", processName, "/t");
        pb.start().waitFor();
    }

    public static void killProcessOnUnix(String processName) throws InterruptedException, IOException {
        ProcessBuilder pb = new ProcessBuilder("killall", processName);
        pb.start().waitFor();
    }
}

