/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.util.internal;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.regex.Pattern;

public class PathUtil {
    private static final String relativeSeparator = "/";
    private static final String windowSeparator = "\\";

    private PathUtil() {
    }

    public static String absoluteToRelativePath(String absolutePath, String projectFolderPath) {
        return PathUtil.getRelativePath(absolutePath, projectFolderPath);
    }

    public static String relativeToAbsolutePath(String relativePath, String projectFolderPath) {
        Path path = new File(relativePath).toPath();
        if (path.isAbsolute()) {
            return path.toAbsolutePath().toString();
        }
        Path projectPath = new File(projectFolderPath).toPath();
        return projectPath.resolve(path).normalize().toString();
    }

    private static String getRelativePath(String targetPath, String basePath) {
        String[] base = basePath.replace(windowSeparator, relativeSeparator).split(Pattern.quote(relativeSeparator), -1);
        String[] target = targetPath.replace(windowSeparator, relativeSeparator).split(Pattern.quote(relativeSeparator), 0);
        String common = "";
        int commonIndex = 0;
        int i = 0;
        while (i < target.length && i < base.length) {
            if (!target[i].equals(base[i])) break;
            common = String.valueOf(common) + target[i] + relativeSeparator;
            ++commonIndex;
            ++i;
        }
        if (commonIndex == 0) {
            return targetPath;
        }
        String relative = "";
        if (base.length != commonIndex) {
            int numDirsUp = base.length - commonIndex;
            int i2 = 1;
            while (i2 <= numDirsUp) {
                relative = String.valueOf(relative) + "../";
                ++i2;
            }
        }
        relative = String.valueOf(relative) + targetPath.replace(windowSeparator, relativeSeparator).substring(common.length());
        return relative;
    }

    public static URL getUrl(String rawUrl, String defaultProtocol) throws MalformedURLException, URISyntaxException {
        URL url = null;
        try {
            url = new URL(rawUrl);
        }
        catch (MalformedURLException malformedURLException) {
            try {
                url = new URI(rawUrl).toURL();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                url = new URI(String.valueOf(defaultProtocol) + "://" + rawUrl).toURL();
            }
            catch (URISyntaxException uRISyntaxException) {
                url = Paths.get(rawUrl, new String[0]).toUri().toURL();
            }
        }
        return url;
    }
}

