/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.testobject.internal.impl;

import com.google.gson.reflect.TypeToken;
import com.kms.katalon.core.exception.KatalonRuntimeException;
import com.kms.katalon.core.testobject.FormDataBodyParameter;
import com.kms.katalon.core.testobject.HttpBodyContent;
import com.kms.katalon.core.testobject.UrlEncodedBodyParameter;
import com.kms.katalon.core.testobject.impl.HttpBodyType;
import com.kms.katalon.core.testobject.impl.HttpFileBodyContent;
import com.kms.katalon.core.testobject.impl.HttpFormDataBodyContent;
import com.kms.katalon.core.testobject.impl.HttpTextBodyContent;
import com.kms.katalon.core.testobject.impl.HttpUrlEncodedBodyContent;
import com.kms.katalon.core.util.internal.JsonUtil;
import com.kms.katalon.core.util.internal.PathUtil;
import java.io.FileNotFoundException;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.text.StrSubstitutor;

public class HttpBodyContentReader {
    private HttpBodyContentReader() {
    }

    public static HttpBodyContent fromSource(String httpBodyType, String httpBodyContent, String projectDir, StrSubstitutor substitutor) throws KatalonRuntimeException {
        switch (HttpBodyType.fromType(httpBodyType)) {
            case TEXT: {
                InternalTextBodyContent textBodyContent = JsonUtil.fromJson(httpBodyContent, InternalTextBodyContent.class);
                return new HttpTextBodyContent(substitutor.replace(textBodyContent.getText()), textBodyContent.getCharset(), textBodyContent.getContentType());
            }
            case FILE: {
                InternalFileBodyContent fileBodyContent = JsonUtil.fromJson(httpBodyContent, InternalFileBodyContent.class);
                try {
                    String filePath;
                    String absoluteFilePath = filePath = substitutor.replace(fileBodyContent.getFilePath());
                    if (StringUtils.isNotEmpty((String)filePath)) {
                        absoluteFilePath = PathUtil.relativeToAbsolutePath(filePath, projectDir);
                    }
                    return new HttpFileBodyContent(absoluteFilePath);
                }
                catch (FileNotFoundException | IllegalArgumentException e) {
                    throw new KatalonRuntimeException(e);
                }
            }
            case FORM_DATA: {
                InternalParameterizedBodyContent formDataBodyContent = (InternalParameterizedBodyContent)JsonUtil.fromJson(httpBodyContent, new TypeToken<InternalParameterizedBodyContent<FormDataBodyParameter>>(){}.getType());
                try {
                    List<FormDataBodyParameter> bindedFormDataParameters = formDataBodyContent.getParameters().stream().map(p -> {
                        String value = substitutor.replace(p.getValue());
                        if (p.getType().equals("File") && StringUtils.isNotEmpty((String)value)) {
                            value = PathUtil.relativeToAbsolutePath(value, projectDir);
                        }
                        return new FormDataBodyParameter(substitutor.replace(p.getName()), value, p.getType());
                    }).collect(Collectors.toList());
                    return new HttpFormDataBodyContent(bindedFormDataParameters);
                }
                catch (FileNotFoundException e) {
                    throw new KatalonRuntimeException(e);
                }
            }
            case URL_ENCODED: {
                InternalParameterizedBodyContent urlEncodedBodyContent = (InternalParameterizedBodyContent)JsonUtil.fromJson(httpBodyContent, new TypeToken<InternalParameterizedBodyContent<UrlEncodedBodyParameter>>(){}.getType());
                try {
                    List<UrlEncodedBodyParameter> bindedUrlEncodedParameters = urlEncodedBodyContent.getParameters().stream().map(u -> new UrlEncodedBodyParameter(substitutor.replace(u.getName()), substitutor.replace(u.getValue()))).collect(Collectors.toList());
                    return new HttpUrlEncodedBodyContent(bindedUrlEncodedParameters);
                }
                catch (UnsupportedEncodingException e) {
                    throw new KatalonRuntimeException(e);
                }
            }
        }
        throw new KatalonRuntimeException(MessageFormat.format("There is no implementation for {0}", httpBodyType));
    }

    private class InternalFileBodyContent
    implements InternalHttpBodyContent {
        private String filePath;
        private long fileSize;
        private String contentType = "";

        private InternalFileBodyContent() {
        }

        @Override
        public String getContentType() {
            return this.contentType;
        }

        @Override
        public long getContentLength() {
            return this.fileSize;
        }

        @Override
        public String getCharset() {
            return null;
        }

        public String getFilePath() {
            return this.filePath;
        }
    }

    private static interface InternalHttpBodyContent {
        public String getContentType();

        public long getContentLength();

        public String getCharset();
    }

    private class InternalParameterizedBodyContent<P>
    implements InternalHttpBodyContent {
        private String contentType;
        private String charset;
        private List<P> parameters = new ArrayList<P>();

        private InternalParameterizedBodyContent() {
        }

        @Override
        public String getContentType() {
            return this.contentType;
        }

        @Override
        public long getContentLength() {
            return 0L;
        }

        @Override
        public String getCharset() {
            return this.charset;
        }

        public List<P> getParameters() {
            return this.parameters;
        }
    }

    private class InternalTextBodyContent
    implements InternalHttpBodyContent {
        private String text;
        private String contentType = "text/plain";
        private String charset = "UTF-8";

        private InternalTextBodyContent() {
        }

        @Override
        public String getContentType() {
            return this.contentType;
        }

        @Override
        public long getContentLength() {
            if (this.text == null) {
                return -1L;
            }
            return this.text.length();
        }

        @Override
        public String getCharset() {
            return this.charset;
        }

        public String getText() {
            if (this.text == null) {
                this.text = "";
            }
            return this.text;
        }
    }
}

