/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.testobject.impl;

import com.kms.katalon.core.testobject.HttpBodyContent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import org.apache.commons.io.IOUtils;

public class HttpFileBodyContent
implements HttpBodyContent {
    private static final int BUFFER_SIZE = 1024;
    private File file;

    public HttpFileBodyContent(String filePath) throws IllegalArgumentException, FileNotFoundException {
        if (filePath == null) {
            throw new IllegalArgumentException("filePath cannot be null");
        }
        this.file = new File(filePath);
        if (!this.file.exists()) {
            throw new FileNotFoundException(MessageFormat.format("File {0} not found", filePath));
        }
        if (!this.file.isFile()) {
            throw new FileNotFoundException(MessageFormat.format("File {0} is not a file", filePath));
        }
    }

    @Override
    public String getContentType() {
        return null;
    }

    @Override
    public long getContentLength() {
        return -1L;
    }

    @Override
    public String getContentEncoding() {
        return null;
    }

    @Override
    public InputStream getInputStream() throws IOException, UnsupportedOperationException {
        return new FileInputStream(this.file.getAbsolutePath());
    }

    @Override
    public void writeTo(OutputStream outstream) throws IOException {
        InputStream inputStream = null;
        try {
            int nRead;
            inputStream = this.getInputStream();
            byte[] data = new byte[1024];
            while ((nRead = inputStream.read(data, 0, data.length)) != -1) {
                outstream.write(data, 0, nRead);
            }
            outstream.flush();
        }
        finally {
            if (inputStream != null) {
                IOUtils.closeQuietly((InputStream)inputStream);
            }
        }
    }
}

