/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.testobject;

import com.kms.katalon.core.testobject.ConditionType;
import com.kms.katalon.core.testobject.SelectorCollector;
import com.kms.katalon.core.testobject.SelectorMethod;
import com.kms.katalon.core.testobject.TestObjectProperty;
import com.kms.katalon.core.testobject.TestObjectXpath;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TestObject
implements SelectorCollector {
    private TestObject parentObject;
    private boolean isParentObjectShadowRoot;
    private List<TestObjectProperty> properties;
    private List<TestObjectXpath> xpaths;
    private String objectId;
    private String imagePath;
    private boolean useRelativeImagePath;
    private SelectorMethod selectorMethod = SelectorMethod.BASIC;
    private Map<SelectorMethod, String> selectorCollection;

    public TestObject(String objectId) {
        this.properties = new ArrayList<TestObjectProperty>();
        this.xpaths = new ArrayList<TestObjectXpath>();
        this.selectorCollection = new HashMap<SelectorMethod, String>();
        this.objectId = objectId;
    }

    public TestObject() {
        this("");
    }

    public List<TestObjectProperty> getProperties() {
        return this.properties;
    }

    public List<TestObjectProperty> getActiveProperties() {
        ArrayList<TestObjectProperty> activeProperties = new ArrayList<TestObjectProperty>();
        for (TestObjectProperty property : this.properties) {
            if (!property.isActive()) continue;
            activeProperties.add(property);
        }
        return activeProperties;
    }

    public void setProperties(List<TestObjectProperty> properties) {
        this.properties = properties;
    }

    public TestObject addProperty(TestObjectProperty property) {
        this.properties.add(property);
        return this;
    }

    public TestObject addProperty(String name, ConditionType condition, String value) {
        this.properties.add(new TestObjectProperty(name, condition, value));
        return this;
    }

    public TestObject addProperty(String name, ConditionType condition, String value, boolean isActive) {
        this.properties.add(new TestObjectProperty(name, condition, value, isActive));
        return this;
    }

    public String findPropertyValue(String name) {
        for (TestObjectProperty property : this.properties) {
            if (!property.getName().equals(name)) continue;
            return property.getValue();
        }
        return "";
    }

    public String findPropertyValue(String name, boolean caseSensitive) {
        if (caseSensitive) {
            return this.findPropertyValue(name);
        }
        for (TestObjectProperty property : this.properties) {
            if (!property.getName().equalsIgnoreCase(name)) continue;
            return property.getValue();
        }
        return "";
    }

    public TestObjectProperty findProperty(String name) {
        for (TestObjectProperty property : this.properties) {
            if (!property.getName().equals(name)) continue;
            return property;
        }
        return null;
    }

    public List<TestObjectXpath> getXpaths() {
        return this.xpaths;
    }

    public List<TestObjectXpath> getActiveXpaths() {
        ArrayList<TestObjectXpath> activeXpaths = new ArrayList<TestObjectXpath>();
        for (TestObjectXpath xpath : this.xpaths) {
            if (!xpath.isActive()) continue;
            activeXpaths.add(xpath);
        }
        return activeXpaths;
    }

    public void setXpaths(List<TestObjectXpath> xpaths) {
        this.xpaths = xpaths;
    }

    public TestObject addXpath(TestObjectXpath xpath) {
        this.xpaths.add(xpath);
        return this;
    }

    public TestObject addXpath(String name, ConditionType condition, String value) {
        this.xpaths.add(new TestObjectXpath(name, condition, value));
        return this;
    }

    public TestObject addXpath(String name, ConditionType condition, String value, boolean isActive) {
        this.xpaths.add(new TestObjectXpath(name, condition, value, isActive));
        return this;
    }

    public String findXpathValue(String name) {
        for (TestObjectXpath xpaths : this.xpaths) {
            if (!xpaths.getName().equals(name)) continue;
            return xpaths.getValue();
        }
        return "";
    }

    public String findXpathValue(String name, boolean caseSensitive) {
        if (caseSensitive) {
            return this.findXpathValue(name);
        }
        for (TestObjectXpath xpath : this.xpaths) {
            if (!xpath.getName().equalsIgnoreCase(name)) continue;
            return xpath.getValue();
        }
        return "";
    }

    public TestObjectXpath findXpath(String name) {
        for (TestObjectXpath xpath : this.xpaths) {
            if (!xpath.getName().equals(name)) continue;
            return xpath;
        }
        return null;
    }

    public String getObjectId() {
        return this.objectId;
    }

    public TestObject getParentObject() {
        return this.parentObject;
    }

    public void setParentObject(TestObject parentObject) {
        this.parentObject = parentObject;
    }

    public boolean isParentObjectShadowRoot() {
        return this.isParentObjectShadowRoot;
    }

    public void setParentObjectShadowRoot(boolean isParentObjectShadowRoot) {
        this.isParentObjectShadowRoot = isParentObjectShadowRoot;
    }

    public String getImagePath() {
        return this.imagePath;
    }

    public void setImagePath(String imagePath) {
        this.imagePath = imagePath;
    }

    public boolean getUseRelativeImagePath() {
        return this.useRelativeImagePath;
    }

    public void setUseRelativeImagePath(boolean useRelativeImagePath) {
        this.useRelativeImagePath = useRelativeImagePath;
    }

    public String toString() {
        return "TestObject - '" + this.getObjectId() + "'";
    }

    @Override
    public SelectorMethod getSelectorMethod() {
        return this.selectorMethod;
    }

    @Override
    public void setSelectorMethod(SelectorMethod selectorMethod) {
        this.selectorMethod = selectorMethod;
    }

    @Override
    public void setSelectorValue(SelectorMethod selectorMethod, String selectorValue) {
        this.selectorCollection.put(selectorMethod, selectorValue);
    }

    @Override
    public Map<SelectorMethod, String> getSelectorCollection() {
        return this.selectorCollection;
    }
}

