/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.testobject;

import com.kms.katalon.core.testobject.FormDataBodyParameter;
import com.kms.katalon.core.testobject.RequestObject;
import com.kms.katalon.core.testobject.TestObjectProperty;
import com.kms.katalon.core.testobject.UrlEncodedBodyParameter;
import com.kms.katalon.core.testobject.impl.HttpFileBodyContent;
import com.kms.katalon.core.testobject.impl.HttpFormDataBodyContent;
import com.kms.katalon.core.testobject.impl.HttpTextBodyContent;
import com.kms.katalon.core.testobject.impl.HttpUrlEncodedBodyContent;
import java.io.FileNotFoundException;
import java.io.UnsupportedEncodingException;
import java.util.List;

public class RestRequestObjectBuilder {
    private RequestObject requestObject = new RequestObject(null);

    public RestRequestObjectBuilder withRestRequestMethod(String requestMethod) {
        this.requestObject.setRestRequestMethod(requestMethod);
        return this;
    }

    public RestRequestObjectBuilder withRestUrl(String url) {
        this.requestObject.setRestUrl(url);
        return this;
    }

    public RestRequestObjectBuilder withRestParameters(List<TestObjectProperty> restParameters) {
        this.requestObject.setRestParameters(restParameters);
        return this;
    }

    public RestRequestObjectBuilder withHttpHeaders(List<TestObjectProperty> httpHeaderProperties) {
        this.requestObject.setHttpHeaderProperties(httpHeaderProperties);
        return this;
    }

    public RestRequestObjectBuilder withTextBodyContent(String text) {
        HttpTextBodyContent textBodyContent = new HttpTextBodyContent(text);
        this.requestObject.setBodyContent(textBodyContent);
        return this;
    }

    public RestRequestObjectBuilder withTextBodyContent(String text, String charset) {
        HttpTextBodyContent textBodyContent = new HttpTextBodyContent(text, charset);
        this.requestObject.setBodyContent(textBodyContent);
        return this;
    }

    public RestRequestObjectBuilder withFileBodyContent(String filePath) throws IllegalArgumentException, FileNotFoundException {
        HttpFileBodyContent fileBodyContent = new HttpFileBodyContent(filePath);
        this.requestObject.setBodyContent(fileBodyContent);
        return this;
    }

    public RestRequestObjectBuilder withUrlEncodedBodyContent(List<UrlEncodedBodyParameter> parameters) throws UnsupportedEncodingException {
        HttpUrlEncodedBodyContent urlEncodedBodyContent = new HttpUrlEncodedBodyContent(parameters);
        this.requestObject.setBodyContent(urlEncodedBodyContent);
        return this;
    }

    public RestRequestObjectBuilder withUrlEncodedBodyContent(List<UrlEncodedBodyParameter> parameters, String charset) throws UnsupportedEncodingException {
        HttpUrlEncodedBodyContent urlEncodedBodyContent = new HttpUrlEncodedBodyContent(parameters, charset);
        this.requestObject.setBodyContent(urlEncodedBodyContent);
        return this;
    }

    public RestRequestObjectBuilder withMultipartFormDataBodyContent(List<FormDataBodyParameter> parameters) throws FileNotFoundException {
        HttpFormDataBodyContent formDataBodyContent = new HttpFormDataBodyContent(parameters);
        this.requestObject.setBodyContent(formDataBodyContent);
        return this;
    }

    public RequestObject build() {
        return this.requestObject;
    }
}

