/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.testobject;

import com.kms.katalon.core.testobject.HttpBodyContent;
import com.kms.katalon.core.testobject.HttpMessage;
import com.kms.katalon.core.testobject.PerformanceResourceTiming;
import com.kms.katalon.core.testobject.impl.HttpTextBodyContent;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class ResponseObject
implements PerformanceResourceTiming,
HttpMessage {
    private static final String DF_CHARSET = "UTF-8";
    private String contentType = "text/plain";
    @Deprecated
    private String responseText;
    private int statusCode;
    private Map<String, List<String>> headerFields;
    private long responseHeaderSize;
    private long responseBodySize;
    private long waitingTime;
    private long contentDownloadTime;
    private String contentCharset;
    private HttpBodyContent responseBodyContent;

    public ResponseObject() {
    }

    public ResponseObject(String responseText) {
        this.responseText = responseText;
    }

    public String getResponseBodyContent() throws Exception {
        if (this.responseText != null) {
            if (this.contentType != null && this.contentType.startsWith("application/xml")) {
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                Document doc = dbf.newDocumentBuilder().parse(new InputSource(new StringReader(this.responseText)));
                XPath xPath = XPathFactory.newInstance().newXPath();
                Node node = (Node)xPath.evaluate("//*//*//*", doc, XPathConstants.NODE);
                return this.nodeToString(node);
            }
            if (this.contentType != null && this.contentType.startsWith("application/json")) {
                return this.responseText;
            }
            return this.responseText;
        }
        return "";
    }

    public String getResponseText() throws IOException {
        ByteArrayOutputStream outstream = new ByteArrayOutputStream();
        this.responseBodyContent.writeTo(outstream);
        return outstream.toString(this.getContentCharset());
    }

    public void setResponseText(String responseText) {
        this.responseBodyContent = new HttpTextBodyContent(responseText);
        this.responseText = responseText;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    private String nodeToString(Node node) throws TransformerException {
        StringWriter writer = new StringWriter();
        Transformer xform = TransformerFactory.newInstance().newTransformer();
        xform.setOutputProperty("omit-xml-declaration", "yes");
        xform.transform(new DOMSource(node), new StreamResult(writer));
        return writer.toString();
    }

    public boolean isJsonContentType() {
        return this.contentType != null && this.contentType.toLowerCase().startsWith("application/json");
    }

    public boolean isXmlContentType() {
        String contentTypeString = this.contentType.toLowerCase();
        return this.contentType != null && (contentTypeString.startsWith("application/xml") || contentTypeString.equals("application/soap+xml") || contentTypeString.equals("text/xml"));
    }

    public boolean isTextContentType() {
        return !this.isJsonContentType() && !this.isXmlContentType();
    }

    public Map<String, List<String>> getHeaderFields() {
        if (this.headerFields == null) {
            this.headerFields = Collections.emptyMap();
        }
        return this.headerFields;
    }

    public void setHeaderFields(Map<String, List<String>> headerFields) {
        this.headerFields = headerFields;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    public long getResponseSize() {
        return this.getResponseHeaderSize() + this.getResponseBodySize();
    }

    public long getResponseHeaderSize() {
        return this.responseHeaderSize;
    }

    public void setResponseHeaderSize(long reponseHeaderSize) {
        this.responseHeaderSize = reponseHeaderSize;
    }

    public long getResponseBodySize() {
        return this.responseBodySize;
    }

    public void setResponseBodySize(long reponseBodySize) {
        this.responseBodySize = reponseBodySize;
    }

    @Override
    public long getElapsedTime() {
        return this.getWaitingTime() + this.getContentDownloadTime();
    }

    @Override
    public long getWaitingTime() {
        return this.waitingTime;
    }

    public void setWaitingTime(long waitingTime) {
        this.waitingTime = waitingTime;
    }

    @Override
    public long getContentDownloadTime() {
        return this.contentDownloadTime;
    }

    public void setContentDownloadTime(long contentDownloadTime) {
        this.contentDownloadTime = contentDownloadTime;
    }

    @Override
    public HttpBodyContent getBodyContent() {
        return this.responseBodyContent;
    }

    public void setBodyContent(HttpBodyContent bodyContent) {
        this.responseBodyContent = bodyContent;
    }

    public String getContentCharset() {
        if (StringUtils.isEmpty((String)this.contentCharset)) {
            return DF_CHARSET;
        }
        return this.contentCharset;
    }

    public void setContentCharset(String contentCharset) {
        this.contentCharset = contentCharset;
    }

    public String toString() {
        return String.valueOf(this.getStatusCode()) + " " + FileUtils.byteCountToDisplaySize((long)this.getResponseSize());
    }
}

