/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.testobject;

import com.google.common.reflect.TypeToken;
import com.kms.katalon.core.configuration.RunConfiguration;
import com.kms.katalon.core.constants.StringConstants;
import com.kms.katalon.core.logging.KeywordLogger;
import com.kms.katalon.core.main.ScriptEngine;
import com.kms.katalon.core.testobject.ConditionType;
import com.kms.katalon.core.testobject.HttpBodyContent;
import com.kms.katalon.core.testobject.RequestObject;
import com.kms.katalon.core.testobject.SelectorMethod;
import com.kms.katalon.core.testobject.TestObject;
import com.kms.katalon.core.testobject.TestObjectProperty;
import com.kms.katalon.core.testobject.TestObjectXpath;
import com.kms.katalon.core.testobject.impl.HttpTextBodyContent;
import com.kms.katalon.core.testobject.internal.impl.HttpBodyContentReader;
import com.kms.katalon.core.util.internal.ExceptionsUtil;
import com.kms.katalon.core.util.internal.JsonUtil;
import groovy.lang.Binding;
import groovy.util.ResourceException;
import groovy.util.ScriptException;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.text.StrSubstitutor;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class ObjectRepository {
    private static final KeywordLogger logger = KeywordLogger.getInstance(ObjectRepository.class);
    private static final String TEST_OBJECT_ROOT_FOLDER_NAME = "Object Repository";
    private static final String TEST_OBJECT_ID_PREFIX = "Object Repository/";
    private static final String WEB_SERVICES_TYPE_NAME = "WebServiceRequestEntity";
    private static final String WEB_ELEMENT_TYPE_NAME = "WebElementEntity";
    private static final String WEBELEMENT_FILE_EXTENSION = ".rs";
    private static final String WEB_ELEMENT_PROPERTY_NODE_NAME = "webElementProperties";
    private static final String WEB_ELEMENT_XPATH_NODE_NAME = "webElementXpaths";
    private static final String PROPERTY_NAME = "name";
    private static final String PROPERTY_CONDITION = "matchCondition";
    private static final String PROPERTY_VALUE = "value";
    private static final String PROPERTY_IS_SELECTED = "isSelected";
    private static final String[] PARENT_FRAME_ATTRS = new String[]{"ref_element", "parent_frame"};
    private static final String PARENT_SHADOW_ROOT_ATTRIBUTE = "ref_element_is_shadow_root";
    private static final String PROPERTY_SELECTOR_METHOD = "selectorMethod";
    private static final String PROPERTY_SELECTOR_COLLECTION = "selectorCollection";
    private static final String PROPERTY_ENTRY = "entry";
    private static final String PROPERTY_KEY = "key";
    private static Map<String, TestObject> recordedTestObjects;

    public static String getTestObjectId(String testObjectRelativeId) {
        if (testObjectRelativeId == null) {
            return null;
        }
        if (testObjectRelativeId.startsWith(TEST_OBJECT_ID_PREFIX)) {
            return testObjectRelativeId;
        }
        return TEST_OBJECT_ID_PREFIX + testObjectRelativeId;
    }

    public static String getTestObjectRelativeId(String testObjectId) {
        if (testObjectId == null) {
            return null;
        }
        return testObjectId.replaceFirst(TEST_OBJECT_ID_PREFIX, "");
    }

    public static TestObject findTestObject(String testObjectRelativeId) {
        return ObjectRepository.findTestObject(testObjectRelativeId, new HashMap<String, Object>());
    }

    public static TestObject findTestObject(String testObjectRelativeId, Map<String, Object> variables) {
        if (testObjectRelativeId == null) {
            logger.logWarning(StringConstants.TO_LOG_WARNING_TEST_OBJ_NULL);
            return null;
        }
        String testObjectId = ObjectRepository.getTestObjectId(testObjectRelativeId);
        logger.logDebug(MessageFormat.format(StringConstants.TO_LOG_INFO_FINDING_TEST_OBJ_W_ID, testObjectId));
        Map<String, TestObject> testObjectsCached = ObjectRepository.getCapturedTestObjects();
        if (testObjectRelativeId != null && testObjectsCached.containsKey(testObjectRelativeId)) {
            return testObjectsCached.get(testObjectRelativeId);
        }
        File objectFile = new File(RunConfiguration.getProjectDir(), String.valueOf(testObjectId) + WEBELEMENT_FILE_EXTENSION);
        if (!objectFile.exists()) {
            logger.logWarning(MessageFormat.format(StringConstants.TO_LOG_WARNING_TEST_OBJ_DOES_NOT_EXIST, testObjectId));
            return null;
        }
        return ObjectRepository.readTestObjectFile(testObjectId, objectFile, RunConfiguration.getProjectDir(), variables);
    }

    private static Map<String, TestObject> getCapturedTestObjects() {
        if (recordedTestObjects != null) {
            return recordedTestObjects;
        }
        try {
            String capturedObjectCacheFilePath = StringUtils.defaultString((String)RunConfiguration.getCapturedObjectsCacheFile());
            if (!capturedObjectCacheFilePath.isEmpty()) {
                File capturedObjectCacheFile = new File(capturedObjectCacheFilePath);
                recordedTestObjects = (Map)JsonUtil.fromJson(FileUtils.readFileToString((File)capturedObjectCacheFile, (String)"UTF-8"), new TypeToken<Map<String, TestObject>>(){}.getType());
            }
        }
        catch (IOException iOException) {
            recordedTestObjects = Collections.emptyMap();
        }
        return recordedTestObjects;
    }

    public static TestObject readTestObjectFile(String testObjectId, File objectFile, String projectDir) {
        return ObjectRepository.readTestObjectFile(testObjectId, objectFile, projectDir, Collections.emptyMap());
    }

    public static TestObject readTestObjectFile(String testObjectId, File objectFile, String projectDir, Map<String, Object> variables) {
        try {
            Element rootElement = new SAXReader().read(objectFile).getRootElement();
            String elementName = rootElement.getName();
            if (WEB_ELEMENT_TYPE_NAME.equals(elementName)) {
                return ObjectRepository.findWebUIObject(testObjectId, rootElement, variables);
            }
            if (WEB_SERVICES_TYPE_NAME.equals(elementName)) {
                return ObjectRepository.findRequestObject(testObjectId, rootElement, projectDir, variables);
            }
            return null;
        }
        catch (DocumentException e) {
            logger.logWarning(MessageFormat.format(StringConstants.TO_LOG_WARNING_CANNOT_GET_TEST_OBJECT_X_BECAUSE_OF_Y, testObjectId, ExceptionsUtil.getMessageForThrowable(e)));
            return null;
        }
    }

    private static TestObject findWebUIObject(String testObjectId, Element element, Map<String, Object> variables) {
        TestObject parentObject;
        boolean isPropertySelected;
        String propertyValue;
        ConditionType propertyCondition;
        String propertyName;
        List selectorEntry;
        Element propertySelectorCollection;
        Element dfSelectorMethodElement;
        Element relativeImagePathElement;
        TestObject testObject = new TestObject(testObjectId);
        Element imagePathElement = element.element("imagePath");
        if (imagePathElement != null) {
            String imagePath = imagePathElement.getText();
            testObject.setImagePath(imagePath);
        }
        if ((relativeImagePathElement = element.element("useRalativeImagePath")) != null) {
            String useRelavitePathString = relativeImagePathElement.getText();
            testObject.setUseRelativeImagePath(Boolean.parseBoolean(useRelavitePathString));
        }
        if ((dfSelectorMethodElement = element.element(PROPERTY_SELECTOR_METHOD)) != null) {
            testObject.setSelectorMethod(SelectorMethod.valueOf(dfSelectorMethodElement.getText()));
        }
        if ((propertySelectorCollection = element.element(PROPERTY_SELECTOR_COLLECTION)) != null && (selectorEntry = propertySelectorCollection.elements(PROPERTY_ENTRY)) != null) {
            selectorEntry.forEach(entry -> {
                Element selectorMethodElement = (Element)entry;
                SelectorMethod entryKey = SelectorMethod.valueOf(selectorMethodElement.elementText(PROPERTY_KEY));
                String entryValue = selectorMethodElement.elementText(PROPERTY_VALUE);
                testObject.setSelectorValue(entryKey, entryValue);
            });
        }
        for (Object propertyElementObject : element.elements(WEB_ELEMENT_PROPERTY_NODE_NAME)) {
            TestObjectProperty objectProperty = new TestObjectProperty();
            Element propertyElement = (Element)propertyElementObject;
            propertyName = StringEscapeUtils.unescapeXml((String)propertyElement.elementText(PROPERTY_NAME));
            propertyCondition = ConditionType.fromValue(StringEscapeUtils.unescapeXml((String)propertyElement.elementText(PROPERTY_CONDITION)));
            propertyValue = StringEscapeUtils.unescapeXml((String)propertyElement.elementText(PROPERTY_VALUE));
            isPropertySelected = Boolean.valueOf(StringEscapeUtils.unescapeXml((String)propertyElement.elementText(PROPERTY_IS_SELECTED)));
            objectProperty.setName(propertyName);
            objectProperty.setCondition(propertyCondition);
            objectProperty.setValue(propertyValue);
            objectProperty.setActive(isPropertySelected);
            if (Arrays.asList(PARENT_FRAME_ATTRS).contains(propertyName) && isPropertySelected) {
                parentObject = ObjectRepository.findTestObject(propertyValue);
                testObject.setParentObject(parentObject);
                continue;
            }
            if (PARENT_SHADOW_ROOT_ATTRIBUTE.equals(propertyName)) {
                testObject.setParentObjectShadowRoot(true);
                continue;
            }
            testObject.addProperty(objectProperty);
        }
        for (Object xpathElementObject : element.elements(WEB_ELEMENT_XPATH_NODE_NAME)) {
            TestObjectXpath objectXpath = new TestObjectXpath();
            Element xpathElement = (Element)xpathElementObject;
            propertyName = StringEscapeUtils.unescapeXml((String)xpathElement.elementText(PROPERTY_NAME));
            propertyCondition = ConditionType.fromValue(StringEscapeUtils.unescapeXml((String)xpathElement.elementText(PROPERTY_CONDITION)));
            propertyValue = StringEscapeUtils.unescapeXml((String)xpathElement.elementText(PROPERTY_VALUE));
            isPropertySelected = Boolean.valueOf(StringEscapeUtils.unescapeXml((String)xpathElement.elementText(PROPERTY_IS_SELECTED)));
            objectXpath.setName(propertyName);
            objectXpath.setCondition(propertyCondition);
            objectXpath.setValue(propertyValue);
            objectXpath.setActive(isPropertySelected);
            if (Arrays.asList(PARENT_FRAME_ATTRS).contains(propertyName) && isPropertySelected) {
                parentObject = ObjectRepository.findTestObject(propertyValue);
                testObject.setParentObject(parentObject);
                continue;
            }
            if (PARENT_SHADOW_ROOT_ATTRIBUTE.equals(propertyName)) {
                testObject.setParentObjectShadowRoot(true);
                continue;
            }
            testObject.addXpath(objectXpath);
        }
        if (testObject == null || variables == null || variables.isEmpty()) {
            return testObject;
        }
        HashMap variablesStringMap = new HashMap();
        for (Map.Entry entry2 : variables.entrySet()) {
            variablesStringMap.put(String.valueOf(entry2.getKey()), entry2.getValue());
        }
        StrSubstitutor strSubstitutor = new StrSubstitutor(variablesStringMap);
        for (TestObjectProperty objectProperty : testObject.getProperties()) {
            objectProperty.setValue(strSubstitutor.replace(objectProperty.getValue()));
        }
        return testObject;
    }

    private static RequestObject findRequestObject(String requestObjectId, Element reqElement, String projectDir, Map<String, Object> variables) {
        String serviceType;
        RequestObject requestObject;
        block17: {
            requestObject = new RequestObject(requestObjectId);
            requestObject.setName(reqElement.elementText(PROPERTY_NAME));
            serviceType = reqElement.elementText("serviceType");
            requestObject.setServiceType(serviceType);
            HashMap<String, String> rawVariables = new HashMap<String, String>();
            if (variables == null || variables.size() == 0) {
                List variableElements = reqElement.elements("variables");
                if (variableElements != null && variableElements.size() > 0) {
                    for (Element variableElement : variableElements) {
                        if (variableElement == null) continue;
                        Element defaultValue = variableElement.element("defaultValue");
                        Element name = variableElement.element(PROPERTY_NAME);
                        if (defaultValue.equals("")) continue;
                        rawVariables.put(name.getData().toString(), defaultValue.getData().toString());
                    }
                }
                boolean exception = false;
                try {
                    try {
                        variables = ObjectRepository.evaluateVariables(rawVariables);
                    }
                    catch (Exception exception2) {
                        exception = true;
                        if (exception) {
                            variables = new HashMap<String, Object>();
                        }
                        break block17;
                    }
                }
                catch (Throwable throwable) {
                    if (exception) {
                        variables = new HashMap<String, Object>();
                    }
                    throw throwable;
                }
                if (exception) {
                    variables = new HashMap<String, Object>();
                }
            }
        }
        StrSubstitutor substitutor = new StrSubstitutor(variables);
        if ("SOAP".equals(serviceType)) {
            requestObject.setWsdlAddress(substitutor.replace(reqElement.elementText("wsdlAddress")));
            requestObject.setSoapRequestMethod(reqElement.elementText("soapRequestMethod"));
            requestObject.setSoapServiceFunction(reqElement.elementText("soapServiceFunction"));
            requestObject.setHttpHeaderProperties(ObjectRepository.parseProperties(reqElement.elements("httpHeaderProperties"), substitutor));
            requestObject.setSoapBody(substitutor.replace(reqElement.elementText("soapBody")));
        } else if ("RESTful".equals(serviceType)) {
            requestObject.setRestUrl(substitutor.replace(reqElement.elementText("restUrl")));
            String requestMethod = reqElement.elementText("restRequestMethod");
            requestObject.setRestRequestMethod(requestMethod);
            requestObject.setRestParameters(ObjectRepository.parseProperties(reqElement.elements("restParameters")));
            requestObject.setHttpHeaderProperties(ObjectRepository.parseProperties(reqElement.elements("httpHeaderProperties"), substitutor));
            requestObject.setHttpBody(reqElement.elementText("httpBody"));
            String httpBodyType = reqElement.elementText("httpBodyType");
            if (StringUtils.isBlank((String)httpBodyType)) {
                httpBodyType = "text";
                String body = reqElement.elementText("httpBody");
                HttpTextBodyContent httpBodyContent = new HttpTextBodyContent(body);
                requestObject.setBodyContent(httpBodyContent);
            } else if (ObjectRepository.isBodySupported(requestObject)) {
                String httpBodyContent = reqElement.elementText("httpBodyContent");
                HttpBodyContent bodyContent = HttpBodyContentReader.fromSource(httpBodyType, httpBodyContent, projectDir, substitutor);
                requestObject.setBodyContent(bodyContent);
            }
        }
        requestObject.setVariables(variables);
        String verificationScript = reqElement.elementText("verificationScript");
        requestObject.setVerificationScript(verificationScript);
        return requestObject;
    }

    public static RequestObject findRequestObject(String requestObjectId, File objectFile) {
        try {
            Element reqElement = new SAXReader().read(objectFile).getRootElement();
            List variableElements = reqElement.elements("variables");
            Map<String, Object> variables = Collections.emptyMap();
            if (variableElements != null) {
                Map<String, String> rawVariables = ObjectRepository.parseRequestObjectVariables(variableElements);
                variables = ObjectRepository.evaluateVariables(rawVariables);
            }
            return ObjectRepository.findRequestObject(requestObjectId, reqElement, RunConfiguration.getProjectDir(), variables);
        }
        catch (Exception e) {
            logger.logWarning(MessageFormat.format(StringConstants.TO_LOG_WARNING_CANNOT_GET_TEST_OBJECT_X_BECAUSE_OF_Y, requestObjectId, ExceptionsUtil.getMessageForThrowable(e)));
            return null;
        }
    }

    private static Map<String, String> parseRequestObjectVariables(List<Object> elements) {
        Map<String, String> variableMap = elements.stream().collect(Collectors.toMap(element -> ((Element)element).elementText(PROPERTY_NAME), element -> ((Element)element).elementText("defaultValue")));
        return variableMap;
    }

    private static Map<String, Object> evaluateVariables(Map<String, String> rawVariables) throws IOException, ClassNotFoundException, ResourceException, ScriptException {
        ScriptEngine scriptEngine = ScriptEngine.getDefault(ObjectRepository.class.getClassLoader());
        HashMap<String, Object> evaluatedVariables = new HashMap<String, Object>();
        for (Map.Entry<String, String> variableEntry : rawVariables.entrySet()) {
            String variableName = variableEntry.getKey();
            String variableValue = variableEntry.getValue();
            Object evaluatedValue = scriptEngine.runScriptWithoutLogging(variableValue, new Binding());
            evaluatedVariables.put(variableName, evaluatedValue);
        }
        return evaluatedVariables;
    }

    private static boolean isBodySupported(RequestObject requestObject) {
        String restRequestMethod = requestObject.getRestRequestMethod();
        return !"GET".contains(restRequestMethod);
    }

    private static List<TestObjectProperty> parseProperties(List<Object> objects) {
        return ObjectRepository.parseProperties(objects, new StrSubstitutor());
    }

    private static List<TestObjectProperty> parseProperties(List<Object> objects, StrSubstitutor substitutor) {
        ArrayList<TestObjectProperty> props = new ArrayList<TestObjectProperty>();
        for (Object propertyElementObject : objects) {
            TestObjectProperty objectProperty = new TestObjectProperty();
            Element propertyElement = (Element)propertyElementObject;
            String propertyName = propertyElement.elementText(PROPERTY_NAME);
            ConditionType propertyCondition = ConditionType.fromValue(propertyElement.elementText(PROPERTY_CONDITION));
            String propertyValue = propertyElement.elementText(PROPERTY_VALUE);
            boolean isPropertySelected = Boolean.valueOf(propertyElement.elementText(PROPERTY_IS_SELECTED));
            objectProperty.setName(substitutor.replace(propertyName));
            objectProperty.setCondition(propertyCondition);
            objectProperty.setValue(substitutor.replace(propertyValue));
            objectProperty.setActive(isPropertySelected);
            props.add(objectProperty);
        }
        return props;
    }
}

