/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.testdata.reader;

import com.kms.katalon.core.logging.model.ILogRecord;
import com.kms.katalon.core.logging.model.TestStatus;
import com.kms.katalon.core.logging.model.TestSuiteLogRecord;
import com.kms.katalon.core.util.internal.DateUtil;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.supercsv.cellprocessor.Optional;
import org.supercsv.cellprocessor.constraint.NotNull;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.io.CsvListWriter;
import org.supercsv.io.ICsvListWriter;
import org.supercsv.prefs.CsvPreference;

public class CsvWriter {
    private static final CellProcessor[] SUMMARY_PROCESSORS = new CellProcessor[]{new NotNull(), new NotNull(), new Optional(), new Optional(), new NotNull(), new Optional(), new Optional(), new NotNull()};
    private static final CellProcessor[] DETAILS_PROCESSORS = new CellProcessor[]{new NotNull(), new Optional(), new Optional(), new NotNull(), new Optional(), new Optional(), new NotNull()};
    public static final String[] SUMMARY_HEADER = new String[]{"Suite Name", "Test Name", "Browser", "Description", "Start time", "End time", "Duration", "Status"};
    public static final String[] DETAILS_HEADER = new String[]{"Suite/Test/Step Name", "Browser", "Description", "Start time", "End time", "Duration", "Status"};

    public static void writeCsvReport(TestSuiteLogRecord suiteLog, File file, List<ILogRecord> filteredTestCaseRecords) throws IOException {
        CsvWriter.writeCsvReport(suiteLog, file, filteredTestCaseRecords, true);
    }

    public static void writeCsvReport(TestSuiteLogRecord suiteLog, File file, List<ILogRecord> filteredTestCaseRecords, boolean stepsIncluded) throws IOException {
        CsvListWriter csvWriter = new CsvListWriter((Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8), CsvPreference.STANDARD_PREFERENCE);
        try {
            String browser = suiteLog.getBrowser();
            csvWriter.writeHeader(DETAILS_HEADER);
            CsvWriter.writeRecord((ICsvListWriter)csvWriter, suiteLog, browser);
            for (ILogRecord testLog : filteredTestCaseRecords) {
                csvWriter.write(Arrays.asList("", "", "", "", "", "", ""), DETAILS_PROCESSORS);
                CsvWriter.writeRecord((ICsvListWriter)csvWriter, testLog, browser);
                if (!stepsIncluded) continue;
                ILogRecord[] iLogRecordArray = testLog.getChildRecords();
                int n = iLogRecordArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ILogRecord step = iLogRecordArray[n2];
                    CsvWriter.writeRecord((ICsvListWriter)csvWriter, step, browser);
                    ++n2;
                }
            }
        }
        finally {
            IOUtils.closeQuietly((Closeable)csvWriter);
        }
    }

    private static void writeRecord(ICsvListWriter csvWriter, ILogRecord logRecord, String browserName) throws IOException {
        TestStatus status = logRecord.getStatus();
        List<Object> writtenObjects = Arrays.asList(logRecord.getName(), browserName, logRecord.getDescription(), DateUtil.getDateTimeFormatted(logRecord.getStartTime()), DateUtil.getDateTimeFormatted(logRecord.getEndTime()), DateUtil.getElapsedTime(logRecord.getStartTime(), logRecord.getEndTime()), status != null ? status.getStatusValue().name() : TestStatus.TestStatusValue.INCOMPLETE.name());
        csvWriter.write(writtenObjects, DETAILS_PROCESSORS);
    }

    public static void writeArraysToCsv(String[] header, List<Object[]> datas, File csvFile) throws IOException {
        CsvListWriter csvWriter = null;
        try {
            csvWriter = new CsvListWriter((Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(csvFile), StandardCharsets.UTF_8), CsvPreference.STANDARD_PREFERENCE);
            csvWriter.writeHeader(header);
            for (Object[] arr : datas) {
                csvWriter.write(Arrays.asList(arr), SUMMARY_PROCESSORS);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(csvWriter);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)csvWriter);
    }
}

