/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.testdata;

import com.kms.katalon.core.constants.StringConstants;
import com.kms.katalon.core.testdata.TestData;
import com.kms.katalon.core.testdata.TestDataInfo;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractTestData
implements TestData {
    protected String sourceUrl;
    protected boolean hasHeaders;

    protected AbstractTestData(String sourceUrl, boolean hasHeaders) {
        this.sourceUrl = sourceUrl;
        this.hasHeaders = hasHeaders;
    }

    @Override
    public final String getSourceUrl() {
        return this.sourceUrl;
    }

    @Override
    public final boolean hasHeaders() {
        return this.hasHeaders;
    }

    protected void verifyRowIndex(int rowIndex) throws IOException {
        int rowNumber = this.getRowNumbers();
        if (rowIndex > rowNumber || rowIndex < 1) {
            throw new IllegalArgumentException(MessageFormat.format(StringConstants.TD_ROW_INDEX_X_FOR_TEST_DATA_Y_INVALID, rowIndex, this.getSourceUrl(), rowNumber));
        }
    }

    protected void verifyColumnIndex(int columnIndex) throws IOException {
        int columnNumber = this.getColumnNumbers();
        if (columnIndex > columnNumber || columnIndex < 1) {
            throw new IllegalArgumentException(MessageFormat.format(StringConstants.TD_COLUMN_INDEX_X_FOR_TEST_DATA_Y_INVALID, columnIndex, this.getSourceUrl(), columnNumber));
        }
    }

    protected void verifyColumnName(String columnName) throws IOException {
        boolean isPresent = false;
        String[] columnNames = this.getColumnNames();
        String[] stringArray = this.getColumnNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            if (name != null && name.equals(columnName)) {
                isPresent = true;
                break;
            }
            ++n2;
        }
        if (!isPresent) {
            throw new IllegalArgumentException(MessageFormat.format(StringConstants.TD_COLUMN_NAME_X_FOR_TEST_DATA_Y_INVALID, columnName, this.getSourceUrl(), this.getAvailableColumnNames(columnNames)));
        }
    }

    @Override
    public final String getValue(int columnIndex, int rowIndex) throws IOException {
        return ObjectUtils.toString((Object)this.getObjectValue(columnIndex, rowIndex));
    }

    @Override
    public final String getValue(String columnName, int rowIndex) throws IOException {
        return ObjectUtils.toString((Object)this.getObjectValue(columnName, rowIndex));
    }

    @Override
    public final Object getObjectValue(int columnIndex, int rowIndex) throws IOException {
        this.verifyColumnIndex(columnIndex);
        this.verifyRowIndex(rowIndex);
        return this.internallyGetValue(columnIndex - 1, rowIndex - 1);
    }

    @Override
    public final Object getObjectValue(String columnName, int rowIndex) throws IOException {
        this.verifyRowIndex(rowIndex);
        this.verifyColumnName(columnName);
        return this.internallyGetValue(columnName, rowIndex - 1);
    }

    protected abstract Object internallyGetValue(int var1, int var2) throws IOException;

    protected abstract Object internallyGetValue(String var1, int var2) throws IOException;

    protected int getHeaderRowIdx() {
        return this.hasHeaders ? 1 : 0;
    }

    @Override
    public void activeHeaders(boolean active) throws IOException {
        this.hasHeaders = active;
    }

    private String getAvailableColumnNames(String[] columnNames) {
        if (!this.hasHeaders || ArrayUtils.isEmpty((Object[])columnNames)) {
            return "{}";
        }
        ArrayList<String> validColumNames = new ArrayList<String>();
        String[] stringArray = columnNames;
        int n = columnNames.length;
        int n2 = 0;
        while (n2 < n) {
            String columnName = stringArray[n2];
            if (StringUtils.isNotEmpty((String)columnName)) {
                validColumNames.add(columnName);
            }
            ++n2;
        }
        return ArrayUtils.toString((Object)validColumNames.toArray(new String[validColumNames.size()]));
    }

    @Override
    public TestDataInfo getDataInfo() {
        return null;
    }
}

