/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.setting;

import com.kms.katalon.core.setting.LinkedProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringEscapeUtils;

public class PropertySettingStoreUtil {
    private static final String SETTING_ROOT_FOLDER_NAME = "settings";
    public static final String INTERNAL_SETTING_ROOT_FOLDER_NAME = "settings" + File.separator + "internal";
    public static final String EXTERNAL_SETTING_ROOT_FOLDER_NAME = "settings" + File.separator + "external";
    public static final String PROPERTY_FILE_EXENSION = ".properties";
    private static final String BOOLEAN_REGEX = "^(true|false)$";
    private static final String INTEGER_REGEX = "^(-)?\\d+$";
    private static final String STRING_REGEX = "^\".*\"$";
    private static final String PROPERTY_NAME_REGEX = "^[a-zA-Z0-9\\.\\-_@\\*]+$";

    public static void addNewProperty(String key, String value, File propertyFile) throws IOException {
        FileInputStream fileInput = null;
        FileOutputStream fileOutput = null;
        try {
            fileInput = new FileInputStream(propertyFile);
            LinkedProperties properties = new LinkedProperties();
            properties.load(new InputStreamReader((InputStream)fileInput, Charset.forName("UTF-8")));
            fileInput.close();
            fileInput = null;
            properties.put(key, value);
            fileOutput = new FileOutputStream(propertyFile);
            properties.store(new OutputStreamWriter((OutputStream)fileOutput, Charset.forName("UTF-8")), null);
            fileOutput.close();
            fileOutput = null;
        }
        finally {
            if (fileInput != null) {
                fileInput.close();
            }
            if (fileOutput != null) {
                fileOutput.close();
            }
        }
    }

    public static void clearAll(File propertyFile) throws IOException {
        FileInputStream fileInput = null;
        FileOutputStream fileOutput = null;
        try {
            fileInput = new FileInputStream(propertyFile);
            LinkedProperties properties = new LinkedProperties();
            properties.load(new InputStreamReader((InputStream)fileInput, Charset.forName("UTF-8")));
            fileInput.close();
            fileInput = null;
            ((Properties)properties).clear();
            fileOutput = new FileOutputStream(propertyFile);
            properties.store(new OutputStreamWriter((OutputStream)fileOutput, Charset.forName("UTF-8")), null);
            fileOutput.close();
            fileOutput = null;
        }
        finally {
            if (fileInput != null) {
                fileInput.close();
            }
            if (fileOutput != null) {
                fileOutput.close();
            }
        }
    }

    public static void removeAll(Collection<String> keys, File propertyFile) throws IOException {
        FileInputStream fileInput = null;
        FileOutputStream fileOutput = null;
        try {
            fileInput = new FileInputStream(propertyFile);
            LinkedProperties properties = new LinkedProperties();
            properties.load(new InputStreamReader((InputStream)fileInput, Charset.forName("UTF-8")));
            fileInput.close();
            fileInput = null;
            for (Object propertyKey : properties.orderedKeys()) {
                String rawEntryKey = propertyKey.toString();
                if (!keys.contains(rawEntryKey)) continue;
                properties.remove(propertyKey);
            }
            fileOutput = new FileOutputStream(propertyFile);
            properties.store(new OutputStreamWriter((OutputStream)fileOutput, Charset.forName("UTF-8")), null);
            fileOutput.close();
            fileOutput = null;
        }
        finally {
            if (fileInput != null) {
                fileInput.close();
            }
            if (fileOutput != null) {
                fileOutput.close();
            }
        }
    }

    public static String getPropertyValue(String key, File propertyFile) throws IOException {
        if (!propertyFile.exists()) {
            return null;
        }
        try (FileInputStream fileInput = new FileInputStream(propertyFile);){
            LinkedProperties properties = new LinkedProperties();
            properties.load(new InputStreamReader((InputStream)fileInput, Charset.forName("UTF-8")));
            String string = properties.getProperty(key);
            return string;
        }
    }

    public static Map<String, String> getPropertyValues(String parentKey, File propertyFile) throws IOException {
        if (!propertyFile.exists()) {
            return Collections.emptyMap();
        }
        try (FileInputStream fileInput = new FileInputStream(propertyFile);){
            LinkedProperties properties = new LinkedProperties();
            properties.load(new InputStreamReader((InputStream)fileInput, Charset.forName("UTF-8")));
            LinkedHashMap<String, String> mapProperties = new LinkedHashMap<String, String>();
            for (Object propertyKey : properties.orderedKeys()) {
                String rawEntryKey = propertyKey.toString();
                if (!rawEntryKey.startsWith(String.valueOf(parentKey) + ".")) continue;
                String entryKey = rawEntryKey.substring(parentKey.length() + 1);
                String entryValue = properties.getProperty(rawEntryKey);
                mapProperties.put(entryKey, entryValue);
            }
            LinkedHashMap<String, String> linkedHashMap = mapProperties;
            return linkedHashMap;
        }
    }

    public static Object getValue(String rawValue) {
        if (rawValue == null || rawValue.isEmpty()) {
            return null;
        }
        if (rawValue.matches(BOOLEAN_REGEX)) {
            return Boolean.valueOf(rawValue);
        }
        if (rawValue.matches(INTEGER_REGEX)) {
            return Integer.valueOf(rawValue);
        }
        if (rawValue.matches(STRING_REGEX)) {
            return StringEscapeUtils.unescapeJava((String)rawValue.substring(1, rawValue.length() - 1));
        }
        return rawValue;
    }

    public static String getRawValue(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return "\"" + StringEscapeUtils.escapeJava((String)((String)value)) + "\"";
        }
        return String.valueOf(value);
    }

    public static boolean isValidPropertyName(String name) {
        if (name == null || name.isEmpty()) {
            return false;
        }
        return name.matches(PROPERTY_NAME_REGEX);
    }

    public static Properties getExternalSettings(String projectFolderLocation, String settingName) throws IOException {
        return PropertySettingStoreUtil.getSettings(String.valueOf(projectFolderLocation) + File.separator + EXTERNAL_SETTING_ROOT_FOLDER_NAME + File.separator + settingName + PROPERTY_FILE_EXENSION);
    }

    public static Properties getInternalSettings(String projectFolderLocation, String settingName) throws IOException {
        return PropertySettingStoreUtil.getSettings(String.valueOf(projectFolderLocation) + File.separator + INTERNAL_SETTING_ROOT_FOLDER_NAME + File.separator + settingName + PROPERTY_FILE_EXENSION);
    }

    public static void saveExternalSettings(String projectFolderLocation, String settingName, Properties settings, String comment) throws IOException {
        PropertySettingStoreUtil.saveSettings(settings, String.valueOf(projectFolderLocation) + File.separator + EXTERNAL_SETTING_ROOT_FOLDER_NAME + File.separator + settingName + PROPERTY_FILE_EXENSION, comment);
    }

    public static void saveInternalSettings(String projectFolderLocation, String settingName, Properties settings, String comment) throws IOException {
        PropertySettingStoreUtil.saveSettings(settings, String.valueOf(projectFolderLocation) + File.separator + INTERNAL_SETTING_ROOT_FOLDER_NAME + File.separator + settingName + PROPERTY_FILE_EXENSION, comment);
    }

    private static Properties getSettings(String filePath) throws IOException {
        File settingFile = new File(filePath);
        if (!settingFile.exists()) {
            settingFile.createNewFile();
        }
        try (FileInputStream fis = null;){
            fis = new FileInputStream(settingFile);
            Properties settings = new Properties();
            settings.load(new InputStreamReader((InputStream)fis, Charset.forName("UTF-8")));
            Properties properties = settings;
            return properties;
        }
    }

    private static void saveSettings(Properties settings, String filePath, String comment) throws IOException {
        File settingFile = new File(filePath);
        if (!settingFile.exists()) {
            settingFile.createNewFile();
        }
        try (FileOutputStream fos = null;){
            fos = new FileOutputStream(settingFile);
            settings.store(new OutputStreamWriter((OutputStream)fos, Charset.forName("UTF-8")), comment);
        }
    }
}

