/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.main;

import com.kms.katalon.core.constants.StringConstants;
import com.kms.katalon.core.context.internal.ExecutionEventManager;
import com.kms.katalon.core.logging.ErrorCollector;
import com.kms.katalon.core.logging.KeywordLogger;
import com.kms.katalon.core.logging.model.TestStatus;
import com.kms.katalon.core.main.DoSetContextAction;
import com.kms.katalon.core.main.ScriptEngine;
import com.kms.katalon.core.main.TestResult;
import com.kms.katalon.core.model.FailureHandling;
import com.kms.katalon.core.testcase.TestCaseBinding;
import com.kms.katalon.core.util.internal.ExceptionsUtil;
import groovy.lang.Binding;
import groovy.util.ResourceException;
import groovy.util.ScriptException;
import java.io.IOException;
import java.security.AccessController;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.List;
import java.util.Stack;

public class WSVerificationExecutor {
    private final KeywordLogger logger = KeywordLogger.getInstance(this.getClass());
    private static ErrorCollector errorCollector = ErrorCollector.getCollector();
    private String script;
    protected TestResult testResult;
    private Stack<KeywordLogger.KeywordStackElement> keywordStack;
    private List<Throwable> parentErrors;
    protected ScriptEngine engine;
    private boolean doCleanUp;
    private TestCaseBinding testCaseBinding;

    public WSVerificationExecutor(String verificationScript, ScriptEngine engine, ExecutionEventManager eventManager, boolean doCleanUp) {
        this.engine = engine;
        this.doCleanUp = doCleanUp;
        this.script = verificationScript;
    }

    public WSVerificationExecutor(TestCaseBinding testCaseBinding, String verificationScript, ScriptEngine engine, ExecutionEventManager eventManager, boolean doCleanUp) {
        this.engine = engine;
        this.doCleanUp = doCleanUp;
        this.script = verificationScript;
        this.testCaseBinding = testCaseBinding;
    }

    private void preExecution() {
        this.testResult = TestResult.getDefault();
        this.keywordStack = new Stack();
        this.parentErrors = errorCollector.getCoppiedErrors();
        errorCollector.clearErrors();
    }

    private void onExecutionComplete() {
        this.endAllUnfinishedKeywords(this.keywordStack);
        this.logger.logPassed(StringConstants.WS_VERIFICATION_SUCCESS);
    }

    private void onExecutionError(Throwable t) {
        if (!this.keywordStack.isEmpty()) {
            this.endAllUnfinishedKeywords(this.keywordStack);
        }
        this.testResult.getTestStatus().setStatusValue(this.getResultByError(t));
        String message = MessageFormat.format(StringConstants.MAIN_LOG_MSG_FAILED_BECAUSE_OF, "Verification", ExceptionsUtil.getStackTraceForThrowable(t));
        this.testResult.setMessage(message);
        this.logError(t, message);
    }

    private void postExecution() {
        errorCollector.getErrors().addAll(0, this.parentErrors);
    }

    public TestResult execute(FailureHandling flowControl) {
        try {
            this.preExecution();
            this.logger.startTest("Verification", Collections.emptyMap(), this.keywordStack);
            this.accessMainPhase();
            TestResult testResult = this.testResult;
            return testResult;
        }
        finally {
            this.logger.endTest("Verification", Collections.emptyMap());
            this.postExecution();
        }
    }

    private void accessMainPhase() {
        this.processExecutionPhase();
    }

    private void processExecutionPhase() {
        try {
            this.engine.changeConfigForExecutingScript();
            this.setupContextClassLoader();
            this.doExecute();
        }
        catch (ExceptionInInitializerError e) {
            errorCollector.addError(e.getCause());
        }
        catch (Throwable e) {
            errorCollector.addError(e);
        }
        if (errorCollector.containsErrors()) {
            this.onExecutionError(errorCollector.getFirstError());
        } else {
            this.onExecutionComplete();
        }
    }

    protected void doExecute() throws ResourceException, ScriptException, IOException, ClassNotFoundException {
        this.testResult.setScriptResult(this.runScript(this.script));
    }

    private Object runScript(String script) throws ResourceException, ScriptException, IOException, ClassNotFoundException {
        return this.engine.runScriptAsRawText(script, "WSVerification" + System.currentTimeMillis(), this.testCaseBinding != null ? new Binding(this.testCaseBinding.getBindedValues()) : new Binding(), this.testCaseBinding != null ? this.testCaseBinding.getTestCaseName() : null);
    }

    private void logError(Throwable t, String message) {
        this.logger.logMessage(ErrorCollector.fromError(t), message, t);
    }

    private TestStatus.TestStatusValue getResultByError(Throwable t) {
        return TestStatus.TestStatusValue.valueOf(ErrorCollector.fromError(t).name());
    }

    private void endAllUnfinishedKeywords(Stack<KeywordLogger.KeywordStackElement> keywordStack) {
        while (!keywordStack.isEmpty()) {
            KeywordLogger.KeywordStackElement keywordStackElement = keywordStack.pop();
            this.logger.endKeyword(keywordStackElement.getKeywordName(), null, keywordStackElement.getNestedLevel());
        }
    }

    public void setupContextClassLoader() {
        AccessController.doPrivileged(new DoSetContextAction(Thread.currentThread(), (ClassLoader)this.engine.getGroovyClassLoader()));
    }
}

