/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.main;

import com.kms.katalon.core.annotation.SetUp;
import com.kms.katalon.core.annotation.SetupTestCase;
import com.kms.katalon.core.annotation.TearDown;
import com.kms.katalon.core.annotation.TearDownTestCase;
import com.kms.katalon.core.configuration.RunConfiguration;
import com.kms.katalon.core.constants.StringConstants;
import com.kms.katalon.core.context.internal.ExecutionEventManager;
import com.kms.katalon.core.context.internal.ExecutionListenerEvent;
import com.kms.katalon.core.context.internal.InternalTestCaseContext;
import com.kms.katalon.core.context.internal.InternalTestSuiteContext;
import com.kms.katalon.core.context.internal.VideoRecorderService;
import com.kms.katalon.core.driver.internal.DriverCleanerCollector;
import com.kms.katalon.core.logging.ErrorCollector;
import com.kms.katalon.core.logging.KeywordLogger;
import com.kms.katalon.core.main.AnnotatedMethodCollector;
import com.kms.katalon.core.main.ScriptEngine;
import com.kms.katalon.core.main.TestCaseExecutor;
import com.kms.katalon.core.model.FailureHandling;
import com.kms.katalon.core.testcase.TestCaseBinding;
import groovy.lang.Binding;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.apache.commons.io.FileUtils;
import org.codehaus.groovy.ast.MethodNode;

public class TestSuiteExecutor {
    private final KeywordLogger logger = KeywordLogger.getInstance(this.getClass());
    private final String testSuiteId;
    private final ScriptEngine scriptEngine;
    private InternalTestSuiteContext testSuiteContext;
    private ExecutionEventManager eventManger;
    private ScriptCache scriptCache;
    private static final Set<String> TEST_SUITE_ANNOTATION_METHODS = new HashSet<String>();

    static {
        TEST_SUITE_ANNOTATION_METHODS.add(SetUp.class.getName());
        TEST_SUITE_ANNOTATION_METHODS.add(TearDown.class.getName());
        TEST_SUITE_ANNOTATION_METHODS.add(SetupTestCase.class.getName());
        TEST_SUITE_ANNOTATION_METHODS.add(TearDownTestCase.class.getName());
    }

    public TestSuiteExecutor(String testSuiteId, ScriptEngine scriptEngine, ExecutionEventManager eventManger) {
        this.testSuiteId = testSuiteId;
        this.scriptEngine = scriptEngine;
        this.eventManger = eventManger;
        this.testSuiteContext = new InternalTestSuiteContext();
        this.testSuiteContext.setTestSuiteId(testSuiteId);
        VideoRecorderService videoRecorderService = new VideoRecorderService(RunConfiguration.getReportFolder(), RunConfiguration.getRecorderSetting());
        eventManger.addListenerEventHandle(videoRecorderService);
    }

    public void execute(Map<String, String> suiteProperties, List<TestCaseBinding> testCaseBindings) {
        this.logger.startSuite(this.testSuiteId, suiteProperties);
        this.eventManger.publicEvent(ExecutionListenerEvent.BEFORE_TEST_SUITE, new Object[]{this.testSuiteContext});
        this.accessTestSuiteMainPhase(testCaseBindings);
        String status = "COMPLETE";
        if (ErrorCollector.getCollector().containsErrors()) {
            status = "ERROR";
        }
        this.testSuiteContext.setStatus(status);
        this.eventManger.publicEvent(ExecutionListenerEvent.AFTER_TEST_SUITE, new Object[]{this.testSuiteContext});
        if (RunConfiguration.shouldTerminateDriverAfterTestSuite()) {
            DriverCleanerCollector.getInstance().cleanDrivers();
        }
        this.logger.endSuite(this.testSuiteId, Collections.emptyMap());
    }

    private void accessTestSuiteMainPhase(List<TestCaseBinding> testCaseBindings) {
        ErrorCollector errorCollector = ErrorCollector.getCollector();
        try {
            this.scriptCache = new ScriptCache(this.testSuiteId);
        }
        catch (IOException e) {
            errorCollector.addError(e);
            return;
        }
        this.invokeTestSuiteMethod(SetUp.class.getName(), "setup action", false);
        if (errorCollector.containsErrors()) {
            return;
        }
        int i = 0;
        while (i < testCaseBindings.size()) {
            this.accessTestCaseMainPhase(i, testCaseBindings.get(i));
            ++i;
        }
        this.invokeTestSuiteMethod(TearDown.class.getName(), "tear down", true);
    }

    private void accessTestCaseMainPhase(int index, TestCaseBinding tcBinding) {
        ErrorCollector errorCollector = ErrorCollector.getCollector();
        List<Throwable> coppiedErrors = errorCollector.getCoppiedErrors();
        errorCollector.clearErrors();
        try {
            InternalTestCaseContext testCaseContext = new InternalTestCaseContext(tcBinding.getTestCaseId(), index);
            TestCaseExecutor testCaseExecutor = new TestCaseExecutor(tcBinding, this.scriptEngine, this.eventManger, testCaseContext);
            testCaseExecutor.setTestSuiteExecutor(this);
            testCaseExecutor.execute(FailureHandling.STOP_ON_FAILURE);
        }
        finally {
            errorCollector.clearErrors();
            errorCollector.getErrors().addAll(coppiedErrors);
        }
    }

    public void invokeEachTestCaseMethod(String methodName, String actionType, boolean ignoredIfFailed) {
        this.invokeTestSuiteMethod(methodName, actionType, ignoredIfFailed);
    }

    private void invokeTestSuiteMethod(String annotatedMethodName, String actionType, boolean ignoredIfFailed) {
        if (!this.scriptCache.hasScriptContent()) {
            return;
        }
        try {
            List<MethodNode> annotatedMethods = this.scriptCache.getMethodNodes(annotatedMethodName);
            if (annotatedMethods.isEmpty()) {
                return;
            }
            this.scriptEngine.changeConfigForExecutingScript();
            annotatedMethods.forEach(methodNode -> this.runMethod(methodNode.getName(), actionType, ignoredIfFailed));
        }
        catch (IOException e) {
            if (!ignoredIfFailed) {
                ErrorCollector.getCollector().addError(e);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {}
    }

    private void runMethod(String methodName, String actionType, boolean ignoredIfFailed) {
        Stack<KeywordLogger.KeywordStackElement> keywordStack = new Stack<KeywordLogger.KeywordStackElement>();
        HashMap<String, String> startKeywordAttributeMap = new HashMap<String, String>();
        startKeywordAttributeMap.put("isIgnoredIfFailed", String.valueOf(ignoredIfFailed));
        this.logger.startKeyword(methodName, actionType, startKeywordAttributeMap, keywordStack);
        ErrorCollector errorCollector = ErrorCollector.getCollector();
        List<Throwable> oldErrors = errorCollector.getCoppiedErrors();
        try {
            errorCollector.clearErrors();
            this.scriptEngine.runScriptMethodAsRawText(this.scriptCache.scriptContent, this.scriptCache.className, methodName, new Binding());
            this.endAllUnfinishedKeywords(keywordStack);
        }
        catch (Throwable e) {
            errorCollector.getErrors().add(e);
        }
        if (errorCollector.containsErrors()) {
            this.endAllUnfinishedKeywords(keywordStack);
            String errorMessage = errorCollector.getFirstError().getMessage();
            if (ignoredIfFailed) {
                this.logger.logWarning(errorMessage);
            } else {
                oldErrors.add(errorCollector.getFirstError());
                this.logger.logError(errorMessage);
            }
        } else {
            this.logger.logPassed(MessageFormat.format(StringConstants.MAIN_LOG_PASSED_METHOD_COMPLETED, methodName));
        }
        errorCollector.clearErrors();
        errorCollector.getErrors().addAll(oldErrors);
        this.logger.endKeyword(methodName, Collections.emptyMap(), keywordStack);
    }

    private void endAllUnfinishedKeywords(Stack<KeywordLogger.KeywordStackElement> keywordStack) {
        while (!keywordStack.isEmpty()) {
            KeywordLogger.KeywordStackElement keywordStackElement = keywordStack.pop();
            this.logger.endKeyword(keywordStackElement.getKeywordName(), null, keywordStackElement.getNestedLevel());
        }
    }

    private class ScriptCache {
        private File scriptFile;
        private AnnotatedMethodCollector annotatedMethodCollector;
        private String className;
        private String scriptContent;

        private ScriptCache(String testSuiteId) throws IOException {
            this.scriptFile = this.getTestSuiteScriptFile(testSuiteId);
            if (this.scriptFile != null && this.scriptFile.exists()) {
                this.scriptContent = FileUtils.readFileToString((File)this.scriptFile, (String)"UTF-8");
                this.className = this.scriptFile.toURI().toURL().toExternalForm();
                this.annotatedMethodCollector = new AnnotatedMethodCollector(TEST_SUITE_ANNOTATION_METHODS);
            }
        }

        public List<MethodNode> getMethodNodes(String annotatedMethodName) throws IOException {
            Map<String, List<MethodNode>> methodNodeCollection = this.annotatedMethodCollector.getMethodNodes(this.scriptContent);
            if (!methodNodeCollection.containsKey(annotatedMethodName)) {
                return Collections.emptyList();
            }
            return methodNodeCollection.get(annotatedMethodName);
        }

        public boolean hasScriptContent() {
            return this.scriptFile != null && this.scriptFile.exists();
        }

        private File getTestSuiteScriptFile(String testSuiteId) {
            return new File(RunConfiguration.getProjectDir(), String.valueOf(testSuiteId) + ".groovy");
        }
    }
}

