/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.main;

import com.kms.katalon.core.annotation.SetUp;
import com.kms.katalon.core.annotation.SetupTestCase;
import com.kms.katalon.core.annotation.TearDown;
import com.kms.katalon.core.annotation.TearDownIfError;
import com.kms.katalon.core.annotation.TearDownIfFailed;
import com.kms.katalon.core.annotation.TearDownIfPassed;
import com.kms.katalon.core.annotation.TearDownTestCase;
import com.kms.katalon.core.constants.StringConstants;
import com.kms.katalon.core.context.internal.ExecutionEventManager;
import com.kms.katalon.core.context.internal.ExecutionListenerEvent;
import com.kms.katalon.core.context.internal.InternalTestCaseContext;
import com.kms.katalon.core.driver.internal.DriverCleanerCollector;
import com.kms.katalon.core.logging.ErrorCollector;
import com.kms.katalon.core.logging.KeywordLogger;
import com.kms.katalon.core.logging.LogLevel;
import com.kms.katalon.core.logging.model.TestStatus;
import com.kms.katalon.core.main.DoSetContextAction;
import com.kms.katalon.core.main.ScriptEngine;
import com.kms.katalon.core.main.TestCaseMethodNodeCollector;
import com.kms.katalon.core.main.TestCaseMethodNodeWrapper;
import com.kms.katalon.core.main.TestResult;
import com.kms.katalon.core.main.TestSuiteExecutor;
import com.kms.katalon.core.model.FailureHandling;
import com.kms.katalon.core.testcase.TestCase;
import com.kms.katalon.core.testcase.TestCaseBinding;
import com.kms.katalon.core.testcase.TestCaseFactory;
import com.kms.katalon.core.util.BrowserMobProxyManager;
import com.kms.katalon.core.util.internal.ExceptionsUtil;
import groovy.lang.Binding;
import groovy.util.ResourceException;
import groovy.util.ScriptException;
import java.io.File;
import java.io.IOException;
import java.security.AccessController;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Stack;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.control.CompilationFailedException;

public class TestCaseExecutor {
    private final KeywordLogger logger = KeywordLogger.getInstance(this.getClass());
    private static ErrorCollector errorCollector = ErrorCollector.getCollector();
    protected TestResult testCaseResult;
    private TestCase testCase;
    private Stack<KeywordLogger.KeywordStackElement> keywordStack;
    private TestCaseMethodNodeCollector methodNodeCollector;
    private List<Throwable> parentErrors;
    protected ScriptEngine engine;
    protected Binding variableBinding;
    private TestCaseBinding testCaseBinding;
    private ExecutionEventManager eventManager;
    private boolean doCleanUp;
    private InternalTestCaseContext testCaseContext;
    private TestSuiteExecutor testSuiteExecutor;

    public void setTestSuiteExecutor(TestSuiteExecutor testSuiteExecutor) {
        this.testSuiteExecutor = testSuiteExecutor;
    }

    public TestCaseExecutor(TestCaseBinding testCaseBinding, ScriptEngine engine, ExecutionEventManager eventManager, InternalTestCaseContext testCaseContext, boolean doCleanUp) {
        this.testCaseBinding = testCaseBinding;
        this.engine = engine;
        this.testCase = TestCaseFactory.findTestCase(testCaseBinding.getTestCaseId());
        this.doCleanUp = doCleanUp;
        this.eventManager = eventManager;
        this.testCaseContext = testCaseContext;
    }

    public TestCaseExecutor(TestCaseBinding testCaseBinding, ScriptEngine engine, ExecutionEventManager eventManager, InternalTestCaseContext testCaseContext) {
        this(testCaseBinding, engine, eventManager, testCaseContext, false);
    }

    private void preExecution() {
        this.testCaseResult = TestResult.getDefault();
        this.keywordStack = new Stack();
        this.parentErrors = errorCollector.getCoppiedErrors();
        errorCollector.clearErrors();
    }

    private void onExecutionComplete() {
        this.endAllUnfinishedKeywords(this.keywordStack);
        this.internallyRunMethods(this.methodNodeCollector.getMethodNodeWrapper(TearDownIfPassed.class));
        this.internallyRunMethods(this.methodNodeCollector.getMethodNodeWrapper(TearDown.class));
        this.logger.logPassed(this.testCase.getTestCaseId());
    }

    private void onExecutionError(Throwable t) {
        String message;
        String stackTraceForThrowable;
        if (!this.keywordStack.isEmpty()) {
            stackTraceForThrowable = ExceptionsUtil.getStackTraceForThrowable(t);
            message = MessageFormat.format(StringConstants.MAIN_LOG_MSG_FAILED_BECAUSE_OF, ((KeywordLogger.KeywordStackElement)this.keywordStack.firstElement()).getKeywordName(), stackTraceForThrowable);
            this.logError(t, message);
            this.endAllUnfinishedKeywords(this.keywordStack);
        }
        this.testCaseResult.setCause(t);
        this.testCaseResult.getTestStatus().setStatusValue(this.getResultByError(t));
        try {
            stackTraceForThrowable = ExceptionsUtil.getStackTraceForThrowable(t);
        }
        catch (Exception exception) {
            stackTraceForThrowable = ExceptionsUtil.getStackTraceForThrowable(t);
        }
        message = MessageFormat.format(StringConstants.MAIN_LOG_MSG_FAILED_BECAUSE_OF, this.testCase.getTestCaseId(), stackTraceForThrowable);
        this.testCaseResult.setMessage(message);
        this.logError(t, message);
        this.runTearDownMethodByError(t);
    }

    private boolean processScriptPreparationPhase() {
        try {
            this.methodNodeCollector = new TestCaseMethodNodeCollector(this.testCase);
        }
        catch (IOException e) {
            this.onSetupError(e);
            return false;
        }
        try {
            this.variableBinding = this.collectTestCaseVariables();
        }
        catch (CompilationFailedException e) {
            this.onSetupError(e);
            return false;
        }
        return true;
    }

    private boolean processSetupPhase() {
        this.internallyRunMethods(this.methodNodeCollector.getMethodNodeWrapper(SetUp.class));
        boolean setupFailed = errorCollector.containsErrors();
        if (setupFailed) {
            this.internallyRunMethods(this.methodNodeCollector.getMethodNodeWrapper(TearDownIfError.class));
            this.internallyRunMethods(this.methodNodeCollector.getMethodNodeWrapper(TearDown.class));
            this.onSetupError(errorCollector.getFirstError());
        }
        return !setupFailed;
    }

    protected File getScriptFile() throws IOException {
        return new File(this.testCase.getGroovyScriptPath());
    }

    private void onSetupError(Throwable t) {
        String message = MessageFormat.format(StringConstants.MAIN_LOG_MSG_ERROR_BECAUSE_OF, this.testCase.getTestCaseId(), ExceptionsUtil.getMessageForThrowable(t));
        this.testCaseResult.setMessage(message);
        this.testCaseResult.getTestStatus().setStatusValue(TestStatus.TestStatusValue.ERROR);
        this.logger.logError(message);
    }

    private void postExecution() {
        errorCollector.clearErrors();
        errorCollector.getErrors().addAll(0, this.parentErrors);
        if (this.testCaseContext.isMainTestCase()) {
            BrowserMobProxyManager.shutdownProxy();
        }
    }

    /*
     * Unable to fully structure code
     */
    public TestResult execute(FailureHandling flowControl) {
        block20: {
            block21: {
                block18: {
                    block19: {
                        block16: {
                            block17: {
                                try {
                                    this.preExecution();
                                    if (this.testCaseContext.isMainTestCase()) {
                                        this.logger.startTest(this.testCase.getTestCaseId(), this.getTestCaseProperties(this.testCaseBinding, this.testCase, flowControl), this.keywordStack);
                                    } else {
                                        this.logger.startCalledTest(this.testCase.getTestCaseId(), this.getTestCaseProperties(this.testCaseBinding, this.testCase, flowControl), this.keywordStack);
                                    }
                                    if (this.processScriptPreparationPhase()) break block16;
                                    var4_2 = this.testCaseResult;
                                    this.testCaseContext.setTestCaseStatus(this.testCaseResult.getTestStatus().getStatusValue().name());
                                    this.testCaseContext.setMessage(this.testCaseResult.getMessage());
                                    if (!this.testCaseContext.isMainTestCase()) break block17;
                                }
                                catch (Throwable var3_6) {
                                    this.testCaseContext.setTestCaseStatus(this.testCaseResult.getTestStatus().getStatusValue().name());
                                    this.testCaseContext.setMessage(this.testCaseResult.getMessage());
                                    if (this.testCaseContext.isMainTestCase()) {
                                        this.eventManager.publicEvent(ExecutionListenerEvent.AFTER_TEST_CASE, new Object[]{this.testCaseContext});
                                    }
                                    if (this.testCaseContext.isMainTestCase()) {
                                        this.logger.endTest(this.testCase.getTestCaseId(), null);
                                    } else {
                                        this.logger.endCalledTest(this.testCase.getTestCaseId(), null);
                                    }
                                    this.postExecution();
                                    throw var3_6;
                                }
                                this.eventManager.publicEvent(ExecutionListenerEvent.AFTER_TEST_CASE, new Object[]{this.testCaseContext});
                            }
                            if (this.testCaseContext.isMainTestCase()) {
                                this.logger.endTest(this.testCase.getTestCaseId(), null);
                            } else {
                                this.logger.endCalledTest(this.testCase.getTestCaseId(), null);
                            }
                            this.postExecution();
                            return var4_2;
                        }
                        this.testCaseContext.setTestCaseStatus(this.testCaseResult.getTestStatus().getStatusValue().name());
                        this.testCaseContext.setTestCaseVariables(this.variableBinding.getVariables());
                        if (this.testCaseContext.isMainTestCase()) {
                            this.eventManager.publicEvent(ExecutionListenerEvent.BEFORE_TEST_CASE, new Object[]{this.testCaseContext});
                        }
                        if (this.testCaseContext.isSkipped()) ** GOTO lbl60
                        this.testCaseResult = this.invokeTestSuiteMethod(SetupTestCase.class.getName(), "setup action", false, this.testCaseResult);
                        if (!ErrorCollector.getCollector().containsErrors()) break block18;
                        this.testCaseResult.setMessage(ExceptionsUtil.getStackTraceForThrowable(ErrorCollector.getCollector().getFirstError()));
                        this.logger.logError(this.testCaseResult.getMessage());
                        var4_3 = this.testCaseResult;
                        this.testCaseContext.setTestCaseStatus(this.testCaseResult.getTestStatus().getStatusValue().name());
                        this.testCaseContext.setMessage(this.testCaseResult.getMessage());
                        if (!this.testCaseContext.isMainTestCase()) break block19;
                        this.eventManager.publicEvent(ExecutionListenerEvent.AFTER_TEST_CASE, new Object[]{this.testCaseContext});
                    }
                    if (this.testCaseContext.isMainTestCase()) {
                        this.logger.endTest(this.testCase.getTestCaseId(), null);
                    } else {
                        this.logger.endCalledTest(this.testCase.getTestCaseId(), null);
                    }
                    this.postExecution();
                    return var4_3;
                }
                this.accessMainPhase();
                this.invokeTestSuiteMethod(TearDownTestCase.class.getName(), "tear down", true, this.testCaseResult);
                break block21;
lbl60:
                // 1 sources

                testStatus = new TestStatus();
                testStatus.setStatusValue(TestStatus.TestStatusValue.SKIPPED);
                testStatus.setStackTrace(StringConstants.TEST_CASE_SKIPPED);
                this.testCaseResult.setTestStatus(testStatus);
            }
            var4_4 = this.testCaseResult;
            this.testCaseContext.setTestCaseStatus(this.testCaseResult.getTestStatus().getStatusValue().name());
            this.testCaseContext.setMessage(this.testCaseResult.getMessage());
            if (!this.testCaseContext.isMainTestCase()) break block20;
            this.eventManager.publicEvent(ExecutionListenerEvent.AFTER_TEST_CASE, new Object[]{this.testCaseContext});
        }
        if (this.testCaseContext.isMainTestCase()) {
            this.logger.endTest(this.testCase.getTestCaseId(), null);
        } else {
            this.logger.endCalledTest(this.testCase.getTestCaseId(), null);
        }
        this.postExecution();
        return var4_4;
    }

    private TestResult invokeTestSuiteMethod(String methodName, String actionType, boolean ignoredIfFailed, TestResult testCaseResult) {
        if (this.testSuiteExecutor != null) {
            ErrorCollector errorCollector = ErrorCollector.getCollector();
            List<Throwable> coppiedError = errorCollector.getCoppiedErrors();
            errorCollector.clearErrors();
            this.testSuiteExecutor.invokeEachTestCaseMethod(methodName, actionType, ignoredIfFailed);
            if (!ignoredIfFailed && errorCollector.containsErrors()) {
                coppiedError.add(errorCollector.getFirstError());
            }
            errorCollector.clearErrors();
            errorCollector.getErrors().addAll(coppiedError);
            if (errorCollector.containsErrors() && ignoredIfFailed) {
                Throwable firstError = errorCollector.getFirstError();
                TestStatus testStatus = new TestStatus();
                TestStatus.TestStatusValue errorType = ErrorCollector.isErrorFailed(firstError) ? TestStatus.TestStatusValue.FAILED : TestStatus.TestStatusValue.ERROR;
                testStatus.setStatusValue(errorType);
                String errorMessage = ExceptionsUtil.getMessageForThrowable(firstError);
                testStatus.setStackTrace(errorMessage);
                testCaseResult.setTestStatus(testStatus);
                return testCaseResult;
            }
        }
        return testCaseResult;
    }

    private void accessMainPhase() {
        if (!this.processSetupPhase()) {
            return;
        }
        this.processExecutionPhase();
    }

    private void processExecutionPhase() {
        try {
            this.engine.changeConfigForExecutingScript();
            this.setupContextClassLoader();
            this.doExecute();
        }
        catch (ExceptionInInitializerError e) {
            errorCollector.addError(e.getCause());
        }
        catch (Throwable e) {
            errorCollector.addError(e);
        }
        if (errorCollector.containsErrors()) {
            this.onExecutionError(errorCollector.getFirstError());
        } else {
            this.onExecutionComplete();
        }
        if (this.doCleanUp) {
            this.cleanUp();
        }
    }

    protected void doExecute() throws ResourceException, ScriptException, IOException, ClassNotFoundException {
        this.testCaseResult.setScriptResult(this.runScript(this.getScriptFile()));
    }

    private void cleanUp() {
        DriverCleanerCollector.getInstance().cleanDrivers();
    }

    private Object runScript(File scriptFile) throws ResourceException, ScriptException, IOException, ClassNotFoundException {
        return this.engine.runScriptAsRawText(FileUtils.readFileToString((File)scriptFile, (String)"UTF-8"), scriptFile.toURI().toURL().toExternalForm(), this.variableBinding, this.getTestCase().getName());
    }

    protected void runMethod(File scriptFile, String methodName) throws ResourceException, ScriptException, ClassNotFoundException, IOException {
        this.engine.changeConfigForExecutingScript();
        this.engine.runScriptMethodAsRawText(FileUtils.readFileToString((File)scriptFile, (String)"UTF-8"), scriptFile.toURI().toURL().toExternalForm(), methodName, this.variableBinding);
    }

    private Map<String, String> getTestCaseProperties(TestCaseBinding testCaseBinding, TestCase testCase, FailureHandling flowControl) {
        HashMap<String, String> testProperties = new HashMap<String, String>();
        testProperties.put("name", testCaseBinding.getTestCaseId());
        testProperties.put("description", testCase.getDescription());
        testProperties.put("id", testCase.getTestCaseId());
        testProperties.put("source", testCase.getMetaFilePath());
        testProperties.put("isOptional", String.valueOf(flowControl == FailureHandling.OPTIONAL));
        return testProperties;
    }

    private Map<String, Object> getBindedValues() {
        Map<String, Object> bindedValues = this.testCaseBinding.getBindedValues();
        return bindedValues != null ? bindedValues : Collections.emptyMap();
    }

    private Binding collectTestCaseVariables() {
        Binding variableBinding = new Binding(this.testCaseBinding != null ? this.testCaseBinding.getBindedValues() : Collections.emptyMap());
        this.engine.changeConfigForCollectingVariable();
        this.logger.logDebug(StringConstants.MAIN_LOG_INFO_START_EVALUATE_VARIABLE);
        this.testCase.getVariables().stream().forEach(testCaseVariable -> {
            String variableName = testCaseVariable.getName();
            if (this.getBindedValues().containsKey(variableName)) {
                Object variableValue = this.testCaseBinding.getBindedValues().get(variableName);
                this.logVariableValue(variableName, variableValue, testCaseVariable.isMasked(), StringConstants.MAIN_LOG_INFO_VARIABLE_NAME_X_IS_SET_TO_Y);
                variableBinding.setVariable(variableName, variableValue);
                return;
            }
            try {
                String defaultValue = StringUtils.defaultIfEmpty((String)testCaseVariable.getDefaultValue(), (String)"null");
                Object defaultValueObject = this.engine.runScriptWithoutLogging(defaultValue, null);
                this.logVariableValue(variableName, defaultValueObject, testCaseVariable.isMasked(), StringConstants.MAIN_LOG_INFO_VARIABLE_NAME_X_IS_SET_TO_Y_AS_DEFAULT);
                variableBinding.setVariable(variableName, defaultValueObject);
            }
            catch (ExceptionInInitializerError e) {
                this.logger.logWarning(MessageFormat.format(StringConstants.MAIN_LOG_MSG_SET_TEST_VARIABLE_ERROR_BECAUSE_OF, variableName, e.getCause().getMessage()));
            }
            catch (Exception e) {
                this.logger.logWarning(MessageFormat.format(StringConstants.MAIN_LOG_MSG_SET_TEST_VARIABLE_ERROR_BECAUSE_OF, variableName, e.getMessage()));
            }
        });
        this.getBindedValues().entrySet().stream().filter(entry -> !variableBinding.hasVariable((String)entry.getKey())).forEach(entry -> {
            String variableName = (String)entry.getKey();
            Object variableValue = entry.getValue();
            variableBinding.setProperty(variableName, variableValue);
            this.logVariableValue(variableName, variableValue, false, StringConstants.MAIN_LOG_INFO_VARIABLE_NAME_X_IS_SET_TO_Y);
        });
        return variableBinding;
    }

    private void logVariableValue(String variableName, Object value, boolean isMasked, String message) {
        String objectAsString = Objects.toString(value);
        String loggedText = isMasked ? StringUtils.repeat((String)"*", (int)objectAsString.length()) : Objects.toString(objectAsString);
        this.logger.logInfo(MessageFormat.format(message, variableName, loggedText));
    }

    private void logError(Throwable t, String message) {
        this.logger.logMessage(ErrorCollector.fromError(t), message, t);
    }

    private TestStatus.TestStatusValue getResultByError(Throwable t) {
        return TestStatus.TestStatusValue.valueOf(ErrorCollector.fromError(t).name());
    }

    private void endAllUnfinishedKeywords(Stack<KeywordLogger.KeywordStackElement> keywordStack) {
        while (!keywordStack.isEmpty()) {
            KeywordLogger.KeywordStackElement keywordStackElement = keywordStack.pop();
            this.logger.endKeyword(keywordStackElement.getKeywordName(), null, keywordStackElement.getNestedLevel());
        }
    }

    private void internallyRunMethods(TestCaseMethodNodeWrapper methodNodeWrapper) {
        List<MethodNode> methodList = methodNodeWrapper.getMethodNodes();
        if (methodList == null || methodList.isEmpty()) {
            return;
        }
        this.logger.logDebug(methodNodeWrapper.getStartMessage());
        int count = 1;
        for (MethodNode method : methodList) {
            this.runMethod(method.getName(), methodNodeWrapper.getActionType(), count++, methodNodeWrapper.isIgnoredIfFailed());
        }
    }

    private void runMethod(String methodName, String actionType, int index, boolean ignoreIfFailed) {
        Stack<KeywordLogger.KeywordStackElement> keywordStack = new Stack<KeywordLogger.KeywordStackElement>();
        HashMap<String, String> startKeywordAttributeMap = new HashMap<String, String>();
        startKeywordAttributeMap.put("stepIndex", String.valueOf(index));
        if (ignoreIfFailed) {
            startKeywordAttributeMap.put("isIgnoredIfFailed", String.valueOf(ignoreIfFailed));
        }
        this.logger.startKeyword(methodName, actionType, startKeywordAttributeMap, keywordStack);
        try {
            try {
                this.runMethod(this.getScriptFile(), methodName);
                this.endAllUnfinishedKeywords(keywordStack);
                this.logger.logPassed(MessageFormat.format(StringConstants.MAIN_LOG_PASSED_METHOD_COMPLETED, methodName));
            }
            catch (Throwable e) {
                this.endAllUnfinishedKeywords(keywordStack);
                String message = MessageFormat.format(StringConstants.MAIN_LOG_WARNING_ERROR_OCCURRED_WHEN_RUN_METHOD, methodName, e.getClass().getName(), ExceptionsUtil.getMessageForThrowable(e));
                if (ignoreIfFailed) {
                    this.logger.logWarning(message);
                    this.logger.endKeyword(methodName, actionType, Collections.emptyMap(), keywordStack);
                    return;
                }
                this.logger.logError(message);
                errorCollector.addError(e);
                this.logger.endKeyword(methodName, actionType, Collections.emptyMap(), keywordStack);
            }
        }
        finally {
            this.logger.endKeyword(methodName, actionType, Collections.emptyMap(), keywordStack);
        }
    }

    private void runTearDownMethodByError(Throwable t) {
        LogLevel errorLevel = ErrorCollector.fromError(t);
        TestCaseMethodNodeWrapper failedMethodWrapper = this.methodNodeCollector.getMethodNodeWrapper(TearDownIfFailed.class);
        if (errorLevel == LogLevel.ERROR) {
            failedMethodWrapper = this.methodNodeCollector.getMethodNodeWrapper(TearDownIfError.class);
        }
        this.internallyRunMethods(failedMethodWrapper);
        this.internallyRunMethods(this.methodNodeCollector.getMethodNodeWrapper(TearDown.class));
    }

    public void setupContextClassLoader() {
        AccessController.doPrivileged(new DoSetContextAction(Thread.currentThread(), (ClassLoader)this.engine.getGroovyClassLoader()));
    }

    public TestCase getTestCase() {
        return this.testCase;
    }
}

