/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.main;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import com.kms.katalon.core.configuration.RunConfiguration;
import java.io.File;
import java.io.FileInputStream;
import java.util.Collection;
import java.util.Optional;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.LoggerFactory;

public class LogbackConfigurator {
    private static final String CONFIG_PROPERTY_FILE = "log.properties";
    private static final String CONFIG_FOLDER = "Include/config";
    private static final String LOG_LEVEL_PROPERTY_PREFIX = "logging.level.";

    public static void init() {
        LogbackConfigurator.initDefaultLogConfiguration();
        Properties configProps = LogbackConfigurator.loadCustomConfigProperties();
        LogbackConfigurator.overrideLogLevels(configProps);
    }

    private static void initDefaultLogConfiguration() {
        String logbackConfigFileLocation = RunConfiguration.getLogbackConfigFileLocation();
        if (!StringUtils.isBlank((CharSequence)logbackConfigFileLocation)) {
            System.setProperty("logback.configurationFile", logbackConfigFileLocation);
        }
    }

    private static Properties loadCustomConfigProperties() {
        Properties configProps = new Properties();
        try {
            File propFile = LogbackConfigurator.findCustomConfigPropertyFile();
            if (propFile != null) {
                configProps.load(new FileInputStream(propFile));
            }
        }
        catch (Exception exception) {}
        return configProps;
    }

    private static void overrideLogLevels(Properties configProps) {
        LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
        for (Object key : configProps.keySet()) {
            String loggerName;
            String propKey = (String)key;
            if (!propKey.startsWith(LOG_LEVEL_PROPERTY_PREFIX) || StringUtils.isBlank((CharSequence)(loggerName = propKey.substring(LOG_LEVEL_PROPERTY_PREFIX.length())))) continue;
            String levelValue = configProps.getProperty(propKey);
            Level logLevel = Level.toLevel((String)levelValue);
            Logger logger = loggerContext.getLogger(loggerName);
            logger.setLevel(logLevel);
        }
    }

    private static File findCustomConfigPropertyFile() {
        Collection propertyFiles;
        Optional<File> propFileOptional;
        String configFolderPath = String.valueOf(RunConfiguration.getProjectDir()) + File.separator + CONFIG_FOLDER;
        File configFolder = new File(configFolderPath);
        if (configFolder.exists() && (propFileOptional = (propertyFiles = FileUtils.listFiles((File)configFolder, (String[])new String[]{"properties"}, (boolean)true)).stream().filter(f -> CONFIG_PROPERTY_FILE.equals(f.getName())).findFirst()).isPresent()) {
            return propFileOptional.get();
        }
        return null;
    }
}

