/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.logging.model;

import com.kms.katalon.core.logging.model.AbstractLogRecord;
import com.kms.katalon.core.logging.model.ILogRecord;
import com.kms.katalon.core.logging.model.TestCaseLogRecord;
import com.kms.katalon.core.logging.model.TestStatus;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;

public class TestSuiteLogRecord
extends AbstractLogRecord {
    private String devicePlatform;
    private String logFolder;
    private Map<String, String> runData;

    public TestSuiteLogRecord(String name, String logFolder) {
        super(name);
        this.logFolder = logFolder;
        this.runData = new HashMap<String, String>();
        this.setType("TEST_SUITE");
    }

    public String getBrowser() {
        return this.getRunData().containsKey("browser") ? this.getRunData().get("browser") : "";
    }

    public String getLogFolder() {
        return this.logFolder;
    }

    public int getTotalTestCases() {
        return this.getTotalTestCasesWithTestStatusValue(null);
    }

    public int getTotalPassedTestCases() {
        return this.getTotalTestCasesWithTestStatusValue(TestStatus.TestStatusValue.PASSED);
    }

    public int getTotalFailedTestCases() {
        return this.getTotalTestCasesWithTestStatusValue(TestStatus.TestStatusValue.FAILED);
    }

    public int getTotalErrorTestCases() {
        return this.getTotalTestCasesWithTestStatusValue(TestStatus.TestStatusValue.ERROR);
    }

    public int getTotalIncompleteTestCases() {
        return this.getTotalTestCasesWithTestStatusValue(TestStatus.TestStatusValue.INCOMPLETE);
    }

    private int getTotalTestCasesWithTestStatusValue(TestStatus.TestStatusValue testStatusValue) {
        ILogRecord[] childLogRecords = this.getChildRecords();
        int total = 0;
        ILogRecord[] iLogRecordArray = childLogRecords;
        int n = childLogRecords.length;
        int n2 = 0;
        while (n2 < n) {
            ILogRecord childLogRecord = iLogRecordArray[n2];
            if (childLogRecord instanceof TestCaseLogRecord) {
                TestCaseLogRecord testCaseLog = (TestCaseLogRecord)childLogRecord;
                if (testStatusValue == null || testCaseLog.getStatus().statusValue == testStatusValue) {
                    ++total;
                }
            }
            ++n2;
        }
        return total;
    }

    public String getDeviceName() {
        return this.getRunData().containsKey("deviceName") ? this.getRunData().get("deviceName") : "";
    }

    public String getDeviceId() {
        return this.getRunData().containsKey("deviceId") ? this.getRunData().get("deviceId") : "";
    }

    public String getDevicePlatform() {
        return this.devicePlatform;
    }

    public void setDevicePlatform(String devicePlatform) {
        this.devicePlatform = devicePlatform;
    }

    public String getOs() {
        return this.getRunData().containsKey("os") ? this.getRunData().get("os") : "";
    }

    public String getHostName() {
        return this.getRunData().containsKey("hostName") ? this.getRunData().get("hostName") : "";
    }

    public String getAppVersion() {
        return this.getRunData().containsKey("katalonVersion") ? this.getRunData().get("katalonVersion") : "";
    }

    public Map<String, String> getRunData() {
        return this.runData;
    }

    public void addRunData(Map<String, String> runData) {
        this.runData.putAll(runData);
    }

    public <T extends ILogRecord> int getChildIndex(T child) {
        return Arrays.asList(this.getChildRecords()).indexOf(child);
    }

    public List<String> getLogFiles() {
        ArrayList<String> logFiles = new ArrayList<String>();
        String[] stringArray = new File(this.getLogFolder()).list();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String childFile = stringArray[n2];
            if (FilenameUtils.getExtension((String)childFile).equals("log")) {
                logFiles.add(childFile);
            }
            ++n2;
        }
        return logFiles;
    }

    @Override
    public String getSystemOutMsg() {
        return this.getJUnitMessage();
    }

    @Override
    public String getSystemErrorMsg() {
        TestStatus status = this.getStatus();
        String stackTrace = status.getStackTrace();
        if (status.getStatusValue().isError()) {
            return String.valueOf(this.getJUnitMessage()) + stackTrace;
        }
        return stackTrace;
    }
}

