/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.logging.model;

import com.kms.katalon.core.logging.model.AbstractLogRecord;
import com.kms.katalon.core.logging.model.ILogRecord;
import com.kms.katalon.core.logging.model.TestStatus;
import com.kms.katalon.core.logging.model.TestStepLogRecord;
import java.util.ArrayList;
import org.apache.commons.lang3.StringEscapeUtils;

public class TestCaseLogRecord
extends AbstractLogRecord {
    private boolean isOptional;

    public TestCaseLogRecord(String name) {
        super(name);
        this.setType("TEST_CASE");
    }

    public boolean isOptional() {
        return this.isOptional;
    }

    public void setOptional(boolean isOptional) {
        this.isOptional = isOptional;
    }

    @Override
    public ILogRecord[] getChildRecords() {
        ArrayList<ILogRecord> resultRecords = new ArrayList<ILogRecord>();
        for (ILogRecord logRecord : this.childRecords) {
            if (!(logRecord instanceof TestStepLogRecord)) continue;
            logRecord.setDescription(StringEscapeUtils.unescapeJava((String)logRecord.getDescription()));
            resultRecords.add(logRecord);
        }
        return resultRecords.toArray(new ILogRecord[resultRecords.size()]);
    }

    @Override
    public TestStatus getStatus() {
        TestStatus testStatus = super.getStatus();
        if (this.isInterrupted()) {
            testStatus.setStatusValue(TestStatus.TestStatusValue.INCOMPLETE);
            return testStatus;
        }
        if (this.getChildRecords().length == 0) {
            testStatus.setStatusValue(TestStatus.TestStatusValue.PASSED);
            if (this.childRecords.size() > 0) {
                ILogRecord logRecord = (ILogRecord)this.childRecords.get(this.childRecords.size() - 1);
                this.setMessage(logRecord.getMessage());
                return logRecord.getStatus();
            }
        }
        return testStatus;
    }
}

