/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.logging.logback;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.pattern.CompositeConverter;

public class ColorConverter
extends CompositeConverter<ILoggingEvent> {
    private static final String SET_DEFAULT_COLOR = "\u001b[0;39m";

    protected String transform(ILoggingEvent event, String in) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        String[] stringArray = in.split("\\r\\n|\\r|\\n");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (first) {
                first = false;
            } else {
                sb.append("\n");
            }
            sb.append("\u001b[");
            sb.append(this.getForegroundColorCode(event));
            sb.append("m");
            sb.append(line);
            sb.append(SET_DEFAULT_COLOR);
            ++n2;
        }
        return sb.toString();
    }

    private String getForegroundColorCode(ILoggingEvent event) {
        Level level = event.getLevel();
        switch (level.toInt()) {
            case 40000: {
                return "31";
            }
        }
        return "39";
    }
}

