/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.logging;

import com.kms.katalon.core.logging.XmlLogRecordException;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class XmlLogRecord
extends LogRecord
implements Serializable {
    private static final String LOG_TIME_FORMAT = "MM-dd-yyyy hh:mm:ss a";
    private static final long serialVersionUID = 1L;
    private String method;
    private int nestedLevel;
    private String startTime;
    private String endTime;
    private List<XmlLogRecordException> exceptions;
    private Map<String, String> properties;

    public XmlLogRecord(Level level, String message) {
        super(level, message);
        this.setLevel(level);
        this.setMessage(message);
    }

    public XmlLogRecord(Level level, String message, int nestedLevel) {
        this(level, message);
        this.setNestedLevel(nestedLevel);
    }

    public XmlLogRecord(Level level, String message, int nestedLevel, Map<String, String> properties) {
        this(level, message, nestedLevel);
        if (properties != null) {
            this.setProperties(properties);
        }
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public int getNestedLevel() {
        return this.nestedLevel;
    }

    public void setNestedLevel(int nestedLevel) {
        this.nestedLevel = nestedLevel;
    }

    public String getStartTime() {
        return this.startTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public String getEndTime() {
        return this.endTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public Map<String, String> getProperties() {
        if (this.properties == null) {
            this.properties = new HashMap<String, String>();
        }
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public String toString() {
        String logMess = this.getMessage();
        String logLevel = this.getLevel().getName();
        return String.valueOf(this.getLogTimeString()) + " - " + logLevel + " - " + logMess;
    }

    public String getLogTimeString() {
        SimpleDateFormat format = new SimpleDateFormat(LOG_TIME_FORMAT);
        String logTime = format.format(new Date(this.getMillis()));
        return logTime;
    }

    public List<XmlLogRecordException> getExceptions() {
        return this.exceptions;
    }

    public void setExceptions(List<XmlLogRecordException> exceptions) {
        this.exceptions = exceptions;
    }

    public int getIndex() {
        String indexPropertyValue = this.getProperties().get("stepIndex");
        if (indexPropertyValue == null) {
            return -1;
        }
        try {
            return Integer.valueOf(indexPropertyValue);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }
}

