/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.logging;

import com.kms.katalon.core.configuration.RunConfiguration;
import com.kms.katalon.core.logging.LogLevel;
import com.kms.katalon.core.logging.XmlKeywordLogger;
import com.kms.katalon.core.main.ScriptEngine;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeywordLogger {
    private static final int HR_LENGTH = 20;
    private static final String TEST_CASE_HR = String.join((CharSequence)"", Collections.nCopies(20, "-"));
    private static final String TEST_SUITE_HR = String.join((CharSequence)"", Collections.nCopies(20, "="));
    private static final String PASSED = "\u2713";
    private static final String FAILED = "\u274c";
    private static final Logger selfLogger = LoggerFactory.getLogger(KeywordLogger.class);
    private static final Map<String, KeywordLogger> keywordLoggerLookup = new ConcurrentHashMap<String, KeywordLogger>();
    private final Logger logger;
    private final XmlKeywordLogger xmlKeywordLogger;

    public static KeywordLogger getInstance(Class<?> clazz) {
        if (clazz == null) {
            selfLogger.error("Logger name is null. This should be a bug of Katalon Studio.");
            clazz = KeywordLogger.class;
        }
        return KeywordLogger.getInstance(clazz.getName());
    }

    private static KeywordLogger getInstance(String name) {
        KeywordLogger keywordLogger = keywordLoggerLookup.get(name);
        if (keywordLogger == null) {
            String testCaseName = ScriptEngine.getTestCaseName(name);
            if (testCaseName == null) {
                keywordLogger = new KeywordLogger(name, null);
            } else {
                String fullTestCaseName = "testcase." + testCaseName;
                keywordLogger = new KeywordLogger(fullTestCaseName, null);
            }
            keywordLoggerLookup.put(name, keywordLogger);
        }
        return keywordLogger;
    }

    private KeywordLogger(String className, String dummy) {
        this.logger = LoggerFactory.getLogger((String)className);
        this.xmlKeywordLogger = XmlKeywordLogger.getInstance();
    }

    public KeywordLogger(String className) {
        selfLogger.warn("Please use \"KeywordUtil.logInfo()\" instead of \"new KeywordLogger()\" constructor. \"KeywordLogger\" is an internal API and might be changed in the future.");
        if (StringUtils.isBlank((CharSequence)className)) {
            className = KeywordLogger.class.getName();
        }
        this.logger = LoggerFactory.getLogger((String)className);
        this.xmlKeywordLogger = XmlKeywordLogger.getInstance();
    }

    public KeywordLogger() {
        this(null);
    }

    public void close() {
        this.xmlKeywordLogger.close();
    }

    public String getLogFolderPath() {
        return this.xmlKeywordLogger.getLogFolderPath();
    }

    public void startSuite(String name, Map<String, String> attributes) {
        this.logger.info("START {}", (Object)name);
        this.xmlKeywordLogger.startSuite(name, attributes);
        this.logRunData("hostName", RunConfiguration.getHostName());
        this.logRunData("os", RunConfiguration.getOS());
        this.logRunData("hostAddress", RunConfiguration.getHostAddress());
        this.logRunData("katalonVersion", RunConfiguration.getAppVersion());
        RunConfiguration.getCollectedTestDataProperties().entrySet().stream().forEach(collectedDataInfo -> this.logRunData((String)collectedDataInfo.getKey(), (String)collectedDataInfo.getValue()));
    }

    public void endSuite(String name, Map<String, String> attributes) {
        this.logger.info(TEST_CASE_HR);
        this.logger.info("END {}", (Object)name);
        this.logger.info(TEST_SUITE_HR);
        this.xmlKeywordLogger.endSuite(name, attributes);
    }

    public void startTest(String name, Map<String, String> attributes, Stack<KeywordStackElement> keywordStack) {
        this.logger.info(TEST_CASE_HR);
        this.logger.info("START {}", (Object)name);
        this.xmlKeywordLogger.startTest(name, attributes, keywordStack);
    }

    public void endTest(String name, Map<String, String> attributes) {
        this.logger.info("END {}", (Object)name);
        this.xmlKeywordLogger.endTest(name, attributes);
    }

    public void startCalledTest(String name, Map<String, String> attributes, Stack<KeywordStackElement> keywordStack) {
        this.logger.info(TEST_CASE_HR);
        this.logger.info("CALL {}", (Object)name);
        this.xmlKeywordLogger.startTest(name, attributes, keywordStack);
    }

    public void endCalledTest(String name, Map<String, String> attributes) {
        this.logger.info("END CALL {}", (Object)name);
        this.logger.info(TEST_CASE_HR);
        this.xmlKeywordLogger.endTest(name, attributes);
    }

    public void startListenerKeyword(String name, Map<String, String> attributes, Stack<KeywordStackElement> keywordStack) {
        this.logStartKeyword(name, attributes);
        this.xmlKeywordLogger.startListenerKeyword(name, attributes, keywordStack);
    }

    public void startKeyword(String name, String actionType, Map<String, String> attributes, Stack<KeywordStackElement> keywordStack) {
        this.logStartKeyword(name, attributes);
        this.xmlKeywordLogger.startKeyword(name, actionType, attributes, keywordStack);
    }

    private void logStartKeyword(String name, Map<String, String> attributes) {
        String stepIndex = this.getStepIndex(attributes);
        if (stepIndex == null) {
            this.logger.debug("STEP {}", (Object)name);
        } else {
            this.logger.debug("{}: {}", (Object)stepIndex, (Object)name);
        }
    }

    private String getStepIndex(Map<String, String> attributes) {
        String stepIndex = null;
        if (attributes != null) {
            stepIndex = attributes.get("stepIndex");
        }
        return stepIndex;
    }

    public void startKeyword(String name, Map<String, String> attributes, Stack<KeywordStackElement> keywordStack) {
        this.logStartKeyword(name, attributes);
        this.xmlKeywordLogger.startKeyword(name, attributes, keywordStack);
    }

    public void startKeyword(String name, Map<String, String> attributes, int nestedLevel) {
        this.logStartKeyword(name, attributes);
        this.xmlKeywordLogger.startKeyword(name, attributes, nestedLevel);
    }

    public void endKeyword(String name, Map<String, String> attributes, int nestedLevel) {
        this.logEndKeyword(name, attributes);
        this.xmlKeywordLogger.endKeyword(name, attributes, nestedLevel);
    }

    private void logEndKeyword(String name, Map<String, String> attributes) {
        String stepIndex = this.getStepIndex(attributes);
        if (stepIndex == null) {
            this.logger.trace("END {}: {}", (Object)stepIndex, (Object)name);
        } else {
            this.logger.trace("END STEP {}", (Object)name);
        }
    }

    public void endListenerKeyword(String name, Map<String, String> attributes, Stack<KeywordStackElement> keywordStack) {
        this.logEndKeyword(name, attributes);
        this.xmlKeywordLogger.endListenerKeyword(name, attributes, keywordStack);
    }

    public void endKeyword(String name, String keywordType, Map<String, String> attributes, Stack<KeywordStackElement> keywordStack) {
        this.logEndKeyword(name, attributes);
        this.xmlKeywordLogger.endKeyword(name, keywordType, attributes, keywordStack);
    }

    public void endKeyword(String name, Map<String, String> attributes, Stack<KeywordStackElement> keywordStack) {
        this.logEndKeyword(name, attributes);
        this.xmlKeywordLogger.endKeyword(name, attributes, keywordStack);
    }

    public void logFailed(String message) {
        this.logFailed(message, null);
    }

    public void logFailed(String message, Map<String, String> attributes) {
        this.logger.error("{} {}", (Object)FAILED, (Object)message);
        this.xmlKeywordLogger.logFailed(message, attributes);
    }

    public void logWarning(String message) {
        this.logWarning(message, null);
    }

    public void logWarning(String message, Map<String, String> attributes) {
        this.logger.warn(message);
        this.xmlKeywordLogger.logWarning(message, attributes);
    }

    public void logPassed(String message) {
        this.logPassed(message, null);
    }

    public void logPassed(String message, Map<String, String> attributes) {
        this.logger.debug("{} {}", (Object)PASSED, (Object)message);
        this.xmlKeywordLogger.logPassed(message, attributes);
    }

    public void logInfo(String message) {
        this.logInfo(message, null);
    }

    public void logInfo(String message, Map<String, String> attributes) {
        this.logger.info(message);
        this.xmlKeywordLogger.logInfo(this, message, attributes);
    }

    public void logRunData(String dataKey, String dataValue) {
        this.logger.info("{} = {}", (Object)dataKey, (Object)dataValue);
        this.xmlKeywordLogger.logRunData(dataKey, dataValue);
    }

    public void logError(String message) {
        this.logError(message, null);
    }

    public void logError(String message, Map<String, String> attributes) {
        this.logger.error("{} {}", (Object)FAILED, (Object)message);
        this.xmlKeywordLogger.logError(message, attributes);
    }

    public void logMessage(LogLevel level, String message) {
        this.logMessage(level, message, new HashMap<String, String>());
    }

    public void logMessage(LogLevel level, String message, Map<String, String> attributes) {
        this.log(level, message);
        this.xmlKeywordLogger.logMessage(this, level, message, attributes);
    }

    private void log(LogLevel level, String message) {
        switch (level) {
            case WARNING: {
                this.logger.warn(message);
                break;
            }
            case NOT_RUN: {
                this.logger.warn("SKIP {}", (Object)message);
                break;
            }
            case FAILED: 
            case ERROR: 
            case ABORTED: 
            case INCOMPLETE: {
                this.logger.error("{} {}", (Object)FAILED, (Object)message);
                break;
            }
            default: {
                this.logger.info(message);
            }
        }
    }

    public void logMessage(LogLevel level, String message, Throwable thrown) {
        this.log(level, message);
        this.xmlKeywordLogger.logMessage(level, message, thrown);
    }

    public void setPendingDescription(String stepDescription) {
        this.xmlKeywordLogger.setPendingDescription(stepDescription);
    }

    public void logNotRun(String message) {
        this.logNotRun(message, null);
    }

    public void logNotRun(String message, Map<String, String> attributes) {
        this.logger.warn("SKIPPED {}", (Object)message);
        this.xmlKeywordLogger.logNotRun(message, attributes);
    }

    public void logDebug(String message) {
        this.logger.debug(message);
        this.xmlKeywordLogger.logDebug(this, message, null);
    }

    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    public static class KeywordStackElement {
        private String keywordName;
        private int nestedLevel;

        public KeywordStackElement(String keywordName, int nestedLevel) {
            this.setKeywordName(keywordName);
            this.setNestedLevel(nestedLevel);
        }

        public String getKeywordName() {
            return this.keywordName;
        }

        public void setKeywordName(String keywordName) {
            this.keywordName = keywordName;
        }

        public int getNestedLevel() {
            return this.nestedLevel;
        }

        public void setNestedLevel(int nestedLevel) {
            this.nestedLevel = nestedLevel;
        }
    }
}

