/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.logging;

import com.kms.katalon.core.exception.StepFailedException;
import com.kms.katalon.core.logging.LogLevel;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.groovy.runtime.InvokerInvocationException;

public class ErrorCollector {
    private List<Throwable> errors = new ArrayList<Throwable>();
    private boolean isKeywordPassed;
    private static ErrorCollector _instance;

    private ErrorCollector() {
    }

    public List<Throwable> getErrors() {
        return this.errors;
    }

    public List<Throwable> getCoppiedErrors() {
        return new ArrayList<Throwable>(this.errors);
    }

    public static ErrorCollector getCollector() {
        if (_instance == null) {
            _instance = new ErrorCollector();
        }
        return _instance;
    }

    public void clearErrors() {
        this.errors.clear();
    }

    public void addError(Throwable t) {
        if (!this.getErrors().contains(t)) {
            this.errors.add(t);
        }
    }

    public boolean containsErrors() {
        return this.errors.size() > 0;
    }

    public boolean isFirstErrorFailed() {
        if (this.containsErrors()) {
            Throwable error = this.errors.get(0);
            return ErrorCollector.isErrorFailed(error);
        }
        return false;
    }

    public static boolean isErrorFailed(Throwable error) {
        if (error instanceof StepFailedException || error instanceof AssertionError) {
            return true;
        }
        if (error instanceof InvokerInvocationException && error.getCause() != null) {
            return ErrorCollector.isErrorFailed(error.getCause());
        }
        return false;
    }

    public boolean isLastErrorFailed() {
        if (this.containsErrors()) {
            Throwable error = this.errors.get(this.errors.size() - 1);
            return ErrorCollector.isErrorFailed(error);
        }
        return false;
    }

    public Throwable getLastError() {
        if (this.containsErrors()) {
            return this.errors.get(this.errors.size() - 1);
        }
        return null;
    }

    public Throwable getFirstError() {
        if (this.containsErrors()) {
            return this.errors.get(0);
        }
        return null;
    }

    public static LogLevel fromError(Throwable t) {
        Class<?> throwableClass = t.getClass();
        return StepFailedException.class == throwableClass || AssertionError.class.isAssignableFrom(throwableClass) ? LogLevel.FAILED : LogLevel.ERROR;
    }

    public boolean isKeywordPassed() {
        return this.isKeywordPassed;
    }

    public void setKeywordPassed(boolean isKeywordPassed) {
        this.isKeywordPassed = isKeywordPassed;
    }
}

