/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.logging;

import com.kms.katalon.core.logging.XmlLogRecord;
import java.util.Map;
import java.util.logging.LogRecord;
import java.util.logging.XMLFormatter;
import org.apache.commons.lang3.StringEscapeUtils;

public class CustomXmlFormatter
extends XMLFormatter {
    @Override
    public String format(LogRecord record) {
        int nestedLevel = 0;
        Map<String, String> attributes = null;
        if (record instanceof XmlLogRecord) {
            XmlLogRecord logRecord = (XmlLogRecord)record;
            nestedLevel = logRecord.getNestedLevel();
            attributes = logRecord.getProperties();
            for (Map.Entry<String, String> pair : logRecord.getProperties().entrySet()) {
                pair.setValue(this.formatString(pair.getValue()));
            }
        }
        if (record.getMessage() != null) {
            record.setMessage(this.formatString(record.getMessage()));
        }
        String formattedText = super.format(record);
        StringBuilder sbFormattedText = new StringBuilder(formattedText.substring(0, formattedText.length() - "</record>\n".length()));
        sbFormattedText.append("  <nestedLevel>" + nestedLevel + "</nestedLevel>\n");
        if (attributes != null) {
            for (String key : attributes.keySet()) {
                sbFormattedText.append(String.format("  <property name=\"%s\">%s</property>\n", key, attributes.get(key)));
            }
        }
        sbFormattedText.append("</record>");
        sbFormattedText.append("\n");
        return sbFormattedText.toString();
    }

    protected String formatString(String text) {
        return StringEscapeUtils.escapeXml((String)StringEscapeUtils.escapeJava((String)text));
    }
}

