/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.db;

import com.kms.katalon.core.db.DatabaseConnection;
import com.kms.katalon.core.setting.PropertySettingStoreUtil;
import com.kms.katalon.core.util.internal.Base64;
import java.io.IOException;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;

public class DatabaseSettings {
    public static final String URL = "URL";
    public static final String SECURE_USER_ACCOUNT = "SECURE_USER_ACCOUNT";
    public static final String USER = "USER";
    public static final String PASSWORD = "PASSWORD";
    private Properties settings;

    public DatabaseSettings(String projectDirLocation) throws IOException {
        this.setSettings(PropertySettingStoreUtil.getExternalSettings(projectDirLocation, DatabaseSettings.class.getName()));
    }

    public DatabaseConnection getDatabaseConnection() {
        if (StringUtils.isBlank((String)this.getUrl())) {
            return null;
        }
        if (this.isSecureUserAccount()) {
            return new DatabaseConnection(this.getUrl(), this.getUser(), this.getPassword());
        }
        return new DatabaseConnection(this.getUrl());
    }

    public void setSettings(Properties settings) {
        if (settings == null) {
            settings = new Properties();
        }
        this.settings = settings;
    }

    public Properties getSettings() {
        return this.settings;
    }

    public String getUrl() {
        return this.settings.getProperty(URL);
    }

    public void setUrl(String url) {
        this.settings.setProperty(URL, StringUtils.trimToEmpty((String)url));
    }

    public boolean isSecureUserAccount() {
        return Boolean.parseBoolean(this.settings.getProperty(SECURE_USER_ACCOUNT));
    }

    public void setSecureUserAccount(boolean isSecureUserAccount) {
        this.settings.setProperty(SECURE_USER_ACCOUNT, String.valueOf(isSecureUserAccount));
    }

    public String getUser() {
        return this.settings.getProperty(USER);
    }

    public void setUser(String user) {
        this.settings.setProperty(USER, StringUtils.trimToEmpty((String)user));
    }

    public String getPassword() {
        return Base64.decode(this.settings.getProperty(PASSWORD));
    }

    public void setPassword(String plainTextPassword) {
        this.settings.setProperty(PASSWORD, Base64.encode(StringUtils.trimToEmpty((String)plainTextPassword)));
    }
}

