/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.db;

import com.kms.katalon.core.logging.KeywordLogger;
import com.kms.katalon.core.testdata.TestDataInfo;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.commons.dbutils.DbUtils;
import org.apache.commons.lang.StringUtils;

public class DatabaseConnection {
    private final KeywordLogger logger = KeywordLogger.getInstance(DatabaseConnection.class);
    private static final String PASSWORD_PROPERTY = "password";
    private static final String USER_PROPERTY = "user";
    private String connectionUrl;
    private Connection connection;
    private String user;
    private String password;
    private TestDataInfo dbDataInfo;

    public DatabaseConnection(String connectionUrl) {
        this.connectionUrl = connectionUrl;
    }

    public DatabaseConnection(String connectionUrl, String user, String password) {
        this(connectionUrl);
        this.user = user;
        this.password = password;
    }

    public String getConnectionUrl() {
        return this.connectionUrl;
    }

    public Connection getConnection() throws SQLException {
        Properties properties = new Properties();
        if (this.user != null) {
            properties.setProperty(USER_PROPERTY, this.user);
        }
        if (this.password != null) {
            properties.setProperty(PASSWORD_PROPERTY, this.password);
        }
        return this.getConnection(properties);
    }

    private Connection getConnection(Properties properties) throws SQLException {
        if (this.isAlive()) {
            return this.connection;
        }
        this.loadSuitableDatabaseDriver();
        this.connection = DriverManager.getConnection(this.connectionUrl, properties);
        this.connection.setAutoCommit(false);
        this.connection.setReadOnly(true);
        this.logNewConnection();
        return this.connection;
    }

    private void logNewConnection() {
        this.dbDataInfo = DatabaseConnection.newDBDataInfo(this.connection);
        this.logger.logRunData(this.dbDataInfo.getKey(), this.dbDataInfo.getInfo());
    }

    private void loadSuitableDatabaseDriver() {
        try {
            if (StringUtils.startsWith((String)this.connectionUrl, (String)"jdbc:mysql")) {
                Class.forName("com.mysql.jdbc.Driver");
                return;
            }
            if (StringUtils.startsWith((String)this.connectionUrl, (String)"jdbc:sqlserver")) {
                Class.forName("com.microsoft.sqlserver.jdbc.SQLServerDriver");
                return;
            }
            if (StringUtils.startsWith((String)this.connectionUrl, (String)"jdbc:oracle")) {
                Class.forName("oracle.jdbc.OracleDriver");
                return;
            }
            if (StringUtils.startsWith((String)this.connectionUrl, (String)"jdbc:postgresql")) {
                Class.forName("org.postgresql.Driver");
                return;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {}
    }

    public boolean isAlive() {
        try {
            return this.connection != null && !this.connection.isClosed();
        }
        catch (SQLException sQLException) {
            return false;
        }
    }

    public void close() {
        DbUtils.closeQuietly((Connection)this.connection);
    }

    public TestDataInfo getDBDataInfo() {
        return this.dbDataInfo;
    }

    public static TestDataInfo newDBDataInfo(Connection connection) {
        if (connection == null) {
            return null;
        }
        try {
            DatabaseMetaData connectionMetaData = connection.getMetaData();
            return new TestDataInfo("dbServerInfo", String.valueOf(connectionMetaData.getDatabaseProductName()) + " " + connectionMetaData.getDatabaseProductVersion());
        }
        catch (SQLException sQLException) {
            return null;
        }
    }
}

