/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.context.internal;

import com.kms.katalon.core.constants.CoreMessageConstants;
import com.kms.katalon.core.context.internal.ExecutionListenerEvent;
import com.kms.katalon.core.context.internal.ExecutionListenerEventHandler;
import com.kms.katalon.core.context.internal.InternalTestCaseContext;
import com.kms.katalon.core.helper.screenrecorder.VideoRecorder;
import com.kms.katalon.core.helper.screenrecorder.VideoRecorderBuilder;
import com.kms.katalon.core.helper.screenrecorder.VideoRecorderException;
import com.kms.katalon.core.helper.screenrecorder.VideoSubtitleWriter;
import com.kms.katalon.core.setting.VideoRecorderSetting;
import com.kms.katalon.core.util.internal.ExceptionsUtil;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import org.apache.commons.lang.StringUtils;

public class VideoRecorderService
implements ExecutionListenerEventHandler {
    private String reportFolder;
    private VideoRecorderSetting videoRecorderSetting;
    private long videoStartTime;
    private long actionStartTime;
    private VideoRecorder videoRecorder;
    private VideoSubtitleWriter videoSubtitleWriter;
    private InternalTestCaseContext lastestTestCaseContext;

    public VideoRecorderService(String reportFolder, VideoRecorderSetting videoRecorderSetting) {
        this.reportFolder = reportFolder;
        this.videoRecorderSetting = videoRecorderSetting;
    }

    private boolean shouldRecord() {
        return this.videoRecorderSetting.isEnable() && (this.videoRecorderSetting.isAllowedRecordIfPassed() || this.videoRecorderSetting.isAllowedRecordIfFailed());
    }

    @Override
    public void handleListenerEvent(ExecutionListenerEvent listenerEvent, Object[] testContext) {
        if (!this.shouldRecord()) {
            return;
        }
        switch (listenerEvent) {
            case BEFORE_TEST_CASE: {
                this.lastestTestCaseContext = (InternalTestCaseContext)testContext[0];
                if (!this.lastestTestCaseContext.isMainTestCase()) {
                    return;
                }
                System.out.println(MessageFormat.format(CoreMessageConstants.EXEC_LOG_START_RECORDING_VIDEO, this.lastestTestCaseContext.getTestCaseId()));
                int testCaseIndex = this.lastestTestCaseContext.getTestCaseIndex();
                try {
                    String videoFolderName = String.valueOf(this.reportFolder) + "/videos";
                    String videoFileName = String.format("test_%d", testCaseIndex + 1);
                    this.videoRecorder = VideoRecorderBuilder.get().setVideoConfig(this.videoRecorderSetting.toVideoConfiguration()).setOutputDirLocation(videoFolderName).setOutputVideoName(videoFileName).create();
                    this.videoSubtitleWriter = new VideoSubtitleWriter(new File(videoFolderName, videoFileName).getAbsolutePath());
                    this.videoStartTime = this.actionStartTime = System.currentTimeMillis();
                    this.videoRecorder.start();
                }
                catch (VideoRecorderException e) {
                    System.err.println(ExceptionsUtil.getStackTraceForThrowable(e));
                }
                break;
            }
            case AFTER_TEST_CASE: {
                this.lastestTestCaseContext = (InternalTestCaseContext)testContext[0];
                if (!this.lastestTestCaseContext.isMainTestCase()) {
                    return;
                }
                try {
                    if (this.videoRecorder == null || !this.videoRecorder.isStarted()) {
                        return;
                    }
                    this.stopVideoRecording();
                    String testCaseStatus = this.lastestTestCaseContext.getTestCaseStatus();
                    if ("PASSED".equals(testCaseStatus) && !this.videoRecorderSetting.isAllowedRecordIfPassed() || "FAILED".equals(testCaseStatus) && !this.videoRecorderSetting.isAllowedRecordIfFailed()) {
                        this.deleteVideo();
                        break;
                    }
                    System.out.println(MessageFormat.format(CoreMessageConstants.EXEC_LOG_VIDEO_RECORDING_COMPLETED, this.lastestTestCaseContext.getTestCaseId()));
                }
                catch (VideoRecorderException e) {
                    System.err.println(ExceptionsUtil.getStackTraceForThrowable(e));
                }
                break;
            }
            case AFTER_TEST_STEP: {
                if (this.lastestTestCaseContext == null || !this.lastestTestCaseContext.isMainTestCase()) {
                    return;
                }
                try {
                    this.writeSub((Integer)testContext[0], (String)testContext[1], (String)testContext[2]);
                }
                catch (IOException e) {
                    System.err.println(ExceptionsUtil.getStackTraceForThrowable(e));
                }
            }
            case BEFORE_TEST_STEP: {
                if (this.lastestTestCaseContext == null || !this.lastestTestCaseContext.isMainTestCase()) {
                    return;
                }
                this.actionStartTime = System.currentTimeMillis();
            }
        }
    }

    protected void stopVideoRecording() throws VideoRecorderException {
        if (this.videoRecorder == null || !this.videoRecorder.isStarted()) {
            return;
        }
        this.videoRecorder.stop();
    }

    private void deleteVideo() {
        if (this.videoRecorder != null) {
            this.videoRecorder.delete();
        }
        if (this.videoSubtitleWriter != null) {
            this.videoSubtitleWriter.delete();
        }
    }

    private void writeSub(int stepIndex, String stepDescription, String stepName) throws IOException {
        String description = StringUtils.defaultIfEmpty((String)stepDescription, (String)stepName);
        if (StringUtils.isEmpty((String)description) || this.videoSubtitleWriter == null) {
            return;
        }
        this.videoSubtitleWriter.writeSub(this.actionStartTime - this.videoStartTime, System.currentTimeMillis() - this.videoStartTime, String.format("%d. %s", stepIndex + 1, description));
    }
}

